/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import android.content.SharedPreferences;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.wallet.ad.AdStatisHelper;
import com.yy.hiyo.wallet.ad.b;
import com.yy.hiyo.wallet.ad.config.AdPlatform;
import com.yy.hiyo.wallet.ad.config.m;
import com.yy.hiyo.wallet.ad.config.o;
import com.yy.hiyo.wallet.ad.data.a;
import com.yy.socialplatformbase.data.AdvertiseType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public enum AdConfigureManager {
    INSTANCE;

    private static final String TAG = "FTAdv_AdConfigureManager";
    private static final int AD_CACHE_EXPIRED_TIME = 3600000;
    private static final int AD_TIME_BACKGROUND = 40000;
    private static final int AD_TIME_INTERSTITIAL_INTERVAL = 3000;
    private static final int AD_TIME_PK_GAME_CONSUMED_LIMIT = 6000000;
    private static final String TIME_PK_GAME_CONSUME = "pk_game_time";
    private final Map<Integer, a> mLocalAdPlacementMap = new ConcurrentHashMap<Integer, a>();
    private final Map<Integer, a> mOriginLocalAdPlacementMap = new ConcurrentHashMap<Integer, a>();
    private Map<Integer, Long> mRequestTimestampMap = new HashMap<Integer, Long>();
    private final Map<Integer, Long> mAdCacheTimestampMap = new HashMap<Integer, Long>();
    private long mGameStartTime = 0L;
    private long mGameEndTime = 0L;
    private long mBackgroundTime = 0L;
    private long mInterstitialAdDismissTimeStamp = 0L;
    private boolean isBackToFrontInterstitialAdShow = false;
    private boolean isBackFromImAndGamePage = false;
    private int mGameWinStreakTime = 0;
    private long mPkGameConsumedTotalTime = 0L;
    private SharedPreferences mSharedPreferences;
    private Set<AdPlatform> mInitAdPlatformList = new CopyOnWriteArraySet<AdPlatform>();
    private List<AdPlatform> mAllowedAdPlatformConfigList = new CopyOnWriteArrayList<AdPlatform>();

    public void updateConfigBean() {
        if (RuntimeContext.sIsDebuggable && FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"updateConfigBean mAllowedAdPlatformConfigList=%s", (Object[])new Object[]{this.mAllowedAdPlatformConfigList});
        }
        YYTaskExecutor.execute((Runnable)new b(this));
    }

    public boolean updateAdIdConfig(int n2, int n3) {
        if (this.mLocalAdPlacementMap.containsKey(n2)) {
            List<o> list;
            a a2 = this.mLocalAdPlacementMap.get(n2);
            if (a2 == null) {
                return false;
            }
            m m2 = com.yy.hiyo.wallet.ad.a.a().a(n2);
            if (m2 != null && (list = m2.k()) != null) {
                int n4 = -1;
                UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (!a2.a().equals(list.get(i2).a())) continue;
                    n4 = i2;
                    break;
                }
                if (n4 >= 0) {
                    ++n4;
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager updateAdIdConfig index=%d,localAdId=%d", (Object[])new Object[]{n4, n2});
                    }
                    while (n4 < list.size()) {
                        o o2 = list.get(n4);
                        if (this.mAllowedAdPlatformConfigList.contains((Object)o2.c()) && !this.isLimitFbAd(o2.c(), o2.b(), userInfoKS)) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager updateAdIdConfig index=%d", (Object[])new Object[]{n4});
                            }
                            AdStatisHelper.a(n2, a2, o2, n3);
                            a2.a(o2.a());
                            a2.a(o2.b().getValue());
                            a2.b(this.getConstDefPlatformId(o2.c()));
                            return true;
                        }
                        ++n4;
                    }
                }
            }
        }
        return false;
    }

    public void refreshAdConfig(int n2) {
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager refreshAdConfig localAdId=%s", (Object[])new Object[]{n2});
        a a2 = this.mLocalAdPlacementMap.get(n2);
        a a3 = this.mOriginLocalAdPlacementMap.get(n2);
        if (!(a2 == null || a3 == null || StringUtils.isEmpty((String)a2.a()) || StringUtils.isEmpty((String)a3.a()) || a2.a().equals(a3.a()))) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager refreshAdConfig originAdConfigBean.getPlacementId()=%s", (Object[])new Object[]{a3.a()});
            }
            a a4 = a.a(a3);
            this.mLocalAdPlacementMap.put(n2, a4);
        }
    }

    public void setAllowedAdPlatformConfigList(List<AdPlatform> list) {
        this.mAllowedAdPlatformConfigList.clear();
        this.mAllowedAdPlatformConfigList.addAll(list);
    }

    public List<AdPlatform> getAllowedAdPlatformConfigList() {
        return this.mAllowedAdPlatformConfigList;
    }

    public void setAdCacheTimestamp(int n2, long l2) {
        this.mAdCacheTimestampMap.put(n2, l2);
    }

    public long getAdCacheTimestamp(int n2) {
        Long l2 = this.mAdCacheTimestampMap.get(n2);
        return l2 == null ? 0L : l2;
    }

    public long removeCacheTimestamp(int n2) {
        if (this.mAdCacheTimestampMap.containsKey(n2)) {
            return this.mAdCacheTimestampMap.remove(n2);
        }
        return 0L;
    }

    public boolean isAdCacheExpired(int n2) {
        if (this.mAdCacheTimestampMap.containsKey(n2)) {
            long l2 = SystemClock.elapsedRealtime() - this.mAdCacheTimestampMap.get(n2);
            if (l2 > 3600000L) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager isAdCacheExpired %d=yes", (Object[])new Object[]{n2});
                }
                return true;
            }
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager isAdCacheExpired %d=no", (Object[])new Object[]{n2});
            }
            return false;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isAdCacheExpired %d=false, no cache", (Object[])new Object[]{n2});
        }
        return true;
    }

    public void clearAdCacheTimestampMap() {
        this.mAdCacheTimestampMap.clear();
    }

    public boolean needCacheAfterShowAd(int n2) {
        if (!this.isRewardVideoAd(n2)) {
            return false;
        }
        return n2 != 100 && n2 != 201 && n2 != 300;
    }

    public boolean canRequestAd(int n2) {
        m m2 = com.yy.hiyo.wallet.ad.a.a().a(n2);
        if (m2 == null) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canRequestAd AdvertiseConfigInfo=null, localAdId=%d", (Object[])new Object[]{n2});
            }
            return false;
        }
        if (this.canShowAdAfterInstalled(m2.c()) && this.canRequestAdByInterval(n2, m2.d())) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canRequestAd %d", (Object[])new Object[]{n2});
            }
            return true;
        }
        return false;
    }

    public boolean canShowAdByGameConsumedTime(int n2) {
        m m2 = com.yy.hiyo.wallet.ad.a.a().a(n2);
        if (m2 == null) {
            return false;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canShowAdByGameConsumedTime localAdId=%d, info.getGameMins()=%d, mGameEndTime - mGameStartTime=%d", (Object[])new Object[]{n2, m2.g(), this.mGameEndTime - this.mGameStartTime});
        }
        return this.mGameEndTime - this.mGameStartTime > (long)(m2.g() * 60 * 1000);
    }

    public boolean canShowAdByPKGameWinStreakTime(int n2) {
        m m2 = com.yy.hiyo.wallet.ad.a.a().a(n2);
        if (m2 == null) {
            return false;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canShowAdByPKGameWinStreakTime localAdId=%s, info.getWinStreakTime()=%d, mGameWinStreakTime=%d", (Object[])new Object[]{n2, m2.m(), this.mGameWinStreakTime});
        }
        return this.mGameWinStreakTime >= m2.m();
    }

    public boolean canShowAdByPkGameConsumedTime(int n2) {
        m m2 = com.yy.hiyo.wallet.ad.a.a().a(n2);
        if (m2 == null) {
            return false;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canShowAdByGameConsumedTime localAdId=%d, info.getGameMins()=%d, mPkGameConsumedTotalTime=%d", (Object[])new Object[]{n2, m2.g() * 60 * 1000, this.mPkGameConsumedTotalTime});
        }
        return this.mPkGameConsumedTotalTime > (long)(m2.g() * 60 * 1000);
    }

    public boolean isShowPkGameAd(int n2) {
        return n2 == 300;
    }

    public boolean canShowGameAd(int n2) {
        return this.canShowAdByPkGameConsumedTime(n2) && this.canShowAdByPKGameWinStreakTime(n2);
    }

    public boolean canAdClose(int n2) {
        m m2 = com.yy.hiyo.wallet.ad.a.a().a(n2);
        if (m2 == null) {
            return false;
        }
        boolean bl = m2.h();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)("AdConfigureManager canAdClose\uff1a" + n2 + "  canAdClose\uff1a" + bl), (Object[])new Object[0]);
        }
        return bl;
    }

    public int getAdUiType(int n2) {
        m m2 = com.yy.hiyo.wallet.ad.a.a().a(n2);
        if (m2 == null) {
            return 1;
        }
        return StringUtils.parseInt((String)m2.e());
    }

    public boolean canShowAdAfterInstalled(long l2) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canShowAdAfterInstalled timeInterval=%d\uff0c%d", (Object[])new Object[]{l2, RuntimeContext.sStartAtFirstInstalledTime});
        }
        if (RuntimeContext.sStartAtFirstInstalledTime == 0L) {
            return true;
        }
        return System.currentTimeMillis() - RuntimeContext.sStartAtFirstInstalledTime > l2 * 60L * 1000L;
    }

    public void setRequestTimestamp(int n2, long l2) {
        this.mRequestTimestampMap.put(n2, l2);
    }

    public boolean canRequestAdByInterval(int n2, long l2) {
        if (this.mRequestTimestampMap.containsKey(n2)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canRequestAdByInterval mRequestTimestampMap.get(localAdId)=%d", (Object[])new Object[]{this.mRequestTimestampMap.get(n2)});
            }
            if (System.currentTimeMillis() - this.mRequestTimestampMap.get(n2) > l2 * 60L * 1000L) {
                if (RuntimeContext.sIsDebuggable && FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTAdv", (String)"canRequestAdByInterval >timeInterval", (Object[])new Object[0]);
                }
                return true;
            }
            if (RuntimeContext.sIsDebuggable && FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"canRequestAdByInterval <timeInterval", (Object[])new Object[0]);
            }
            return false;
        }
        if (RuntimeContext.sIsDebuggable && FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"canRequestAdByInterval no", (Object[])new Object[0]);
        }
        return true;
    }

    public int getAdLineNumber(int n2) {
        m m2 = com.yy.hiyo.wallet.ad.a.a().a(n2);
        if (m2 == null) {
            return -1;
        }
        return m2.f();
    }

    public boolean canAdvertiseTypeCache(int n2) {
        a a2;
        if (this.mLocalAdPlacementMap.containsKey(n2) && (a2 = this.mLocalAdPlacementMap.get(n2)) != null) {
            return a2.b() != AdvertiseType.smallBanner.getValue() && a2.b() != AdvertiseType.bigBanner.getValue();
        }
        return false;
    }

    public boolean canNativeInflate(int n2) {
        a a2;
        if (this.mLocalAdPlacementMap.containsKey(n2) && (a2 = this.mLocalAdPlacementMap.get(n2)) != null) {
            return a2.b() == AdvertiseType.nativeAd.getValue() || a2.b() == AdvertiseType.nativeBanner.getValue();
        }
        return false;
    }

    public boolean isNativeFullScreenAd(int n2) {
        a a2;
        if (this.mLocalAdPlacementMap.containsKey(n2) && (a2 = this.mLocalAdPlacementMap.get(n2)) != null) {
            return (n2 == 100 || n2 == 201 || n2 == 300) && a2.b() == AdvertiseType.nativeAd.getValue();
        }
        return false;
    }

    public int dealWithGoogleRewardVideoAd(int n2) {
        if (n2 == 103 && INSTANCE.isGoogleRewardVideoAd(n2) && INSTANCE.isGoogleRewardVideoAd(102)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTAdv", (String)"AdManager dealWithGoogleRewardVideoAd=%s", (Object[])new Object[]{n2});
            }
            return 102;
        }
        return n2;
    }

    public void setBackFromImAndGamePage(boolean bl) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager backFromImAndGamePage=%b", (Object[])new Object[]{bl});
        }
        this.isBackFromImAndGamePage = bl;
    }

    public boolean isBackFromImAndGamePage() {
        return this.isBackFromImAndGamePage;
    }

    public void setGameWinStreakTime(int n2) {
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager gameWinStreakTime=%d", (Object[])new Object[]{n2});
        this.mGameWinStreakTime = n2;
    }

    public int getAdContentTypeByLocalId(int n2) {
        a a2;
        if (this.mLocalAdPlacementMap.containsKey(n2) && (a2 = this.mLocalAdPlacementMap.get(n2)) != null) {
            return a2.b();
        }
        return -1;
    }

    public void setGameStartTime(long l2) {
        this.mGameStartTime = l2;
    }

    public void setGameEndTime(long l2) {
        this.mGameEndTime = l2;
    }

    public boolean isBackToFrontInterstitialAdShow() {
        return this.isBackToFrontInterstitialAdShow;
    }

    public void setBackToFrontInterstitialAdShow(boolean bl) {
        this.isBackToFrontInterstitialAdShow = bl;
    }

    public void setAppBackgroundTime(long l2) {
        this.mBackgroundTime = l2;
    }

    public long getPkGameConsumedTotalTime() {
        return this.mPkGameConsumedTotalTime;
    }

    public void setPkGameConsumedTotalTime(int n2) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"setPkGameConsumedTotalTime pkGameConsumedTotalTime=%d", (Object[])new Object[]{n2});
        }
        this.mPkGameConsumedTotalTime = n2;
        this.savePkGameConsumedTotalTime(this.mPkGameConsumedTotalTime);
    }

    public void addPkGameConsumedTotalTime() {
        this.mPkGameConsumedTotalTime = this.mPkGameConsumedTotalTime + this.mGameEndTime - this.mGameStartTime;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"addPkGameConsumedTotalTime=%d", (Object[])new Object[]{this.mPkGameConsumedTotalTime});
        }
        if (this.mPkGameConsumedTotalTime > 6000000L) {
            this.mPkGameConsumedTotalTime = 6000000L;
        }
        this.savePkGameConsumedTotalTime(this.mPkGameConsumedTotalTime);
    }

    private void savePkGameConsumedTotalTime(long l2) {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, TIME_PK_GAME_CONSUME, 0);
        }
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putLong(TIME_PK_GAME_CONSUME + AccountUtil.getUid(), l2);
        editor.apply();
    }

    public void getPkGameConsumedTotalTimeFromPref() {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, TIME_PK_GAME_CONSUME, 0);
        }
        this.mPkGameConsumedTotalTime = this.mSharedPreferences.getLong(TIME_PK_GAME_CONSUME + AccountUtil.getUid(), 0L);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"getPkGameConsumedTotalTimeFromPref AccountUtil.getUid()=%d, mPkGameConsumedTotalTime=%d", (Object[])new Object[]{AccountUtil.getUid(), this.mPkGameConsumedTotalTime});
        }
    }

    public boolean canShowBackToFrontInterstitialAd() {
        if (RuntimeContext.sIsDebuggable && FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTAdv", (String)"canShowBackToFrontInterstitialAd %d, %d", (Object[])new Object[]{SystemClock.elapsedRealtime() - this.mBackgroundTime, SystemClock.elapsedRealtime() - this.mInterstitialAdDismissTimeStamp});
        }
        return SystemClock.elapsedRealtime() - this.mBackgroundTime > 40000L && SystemClock.elapsedRealtime() - this.mInterstitialAdDismissTimeStamp > 3000L;
    }

    public boolean isGoogleRewardVideoAd(int n2) {
        a a2;
        if (this.mLocalAdPlacementMap.containsKey(n2) && (a2 = this.mLocalAdPlacementMap.get(n2)) != null) {
            return a2.b() == AdvertiseType.motivation.getValue() && a2.c() == 6;
        }
        return false;
    }

    public boolean isUnityRewardVideoAd(int n2) {
        a a2;
        if (this.mLocalAdPlacementMap.containsKey(n2) && (a2 = this.mLocalAdPlacementMap.get(n2)) != null) {
            return a2.b() == AdvertiseType.motivation.getValue() && a2.c() == 102;
        }
        return false;
    }

    public boolean isVungleRewardVideoAd(int n2) {
        a a2;
        if (this.mLocalAdPlacementMap.containsKey(n2) && (a2 = this.mLocalAdPlacementMap.get(n2)) != null) {
            return a2.b() == AdvertiseType.motivation.getValue() && a2.c() == 101;
        }
        return false;
    }

    public boolean isRewardVideoAd(int n2) {
        a a2;
        if (this.mLocalAdPlacementMap.containsKey(n2) && (a2 = this.mLocalAdPlacementMap.get(n2)) != null) {
            return a2.b() == AdvertiseType.motivation.getValue();
        }
        return false;
    }

    public void setInterstitialAdDismissTimeStamp(long l2) {
        this.mInterstitialAdDismissTimeStamp = l2;
    }

    public Set<AdPlatform> getInitAdPlatformList() {
        return this.mInitAdPlatformList;
    }

    public boolean canShowToast(int n2) {
        return n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 101;
    }

    private boolean isLimitFbAd(AdPlatform adPlatform, AdvertiseType advertiseType, UserInfoKS userInfoKS) {
        if (adPlatform == AdPlatform.facebook && Build.VERSION.SDK_INT < 21 && advertiseType == AdvertiseType.motivation) {
            return true;
        }
        if (userInfoKS != null) {
            int n2 = DateUtils.getAge((String)userInfoKS.getBirthday());
            return adPlatform == AdPlatform.facebook && n2 < 18;
        }
        return false;
    }

    @NonNull
    public Map<Integer, a> getLocalAdPlacementMap() {
        return this.mLocalAdPlacementMap;
    }

    public int getConstDefPlatformId(AdPlatform adPlatform) {
        switch (adPlatform) {
            case facebook: {
                return 5;
            }
            case google: {
                return 6;
            }
            case vungle: {
                return 101;
            }
            case unity: {
                return 102;
            }
        }
        return 0;
    }

    static /* synthetic */ Map access$000(AdConfigureManager adConfigureManager) {
        return adConfigureManager.mLocalAdPlacementMap;
    }

    static /* synthetic */ Set access$100(AdConfigureManager adConfigureManager) {
        return adConfigureManager.mInitAdPlatformList;
    }

    static /* synthetic */ List access$200(AdConfigureManager adConfigureManager) {
        return adConfigureManager.mAllowedAdPlatformConfigList;
    }

    static /* synthetic */ boolean access$300(AdConfigureManager adConfigureManager, AdPlatform adPlatform, AdvertiseType advertiseType, UserInfoKS userInfoKS) {
        return adConfigureManager.isLimitFbAd(adPlatform, advertiseType, userInfoKS);
    }

    static /* synthetic */ Map access$400(AdConfigureManager adConfigureManager) {
        return adConfigureManager.mOriginLocalAdPlacementMap;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdUiType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdPlatformId {
    }
}

