/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.redpacket.room.bean;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketBehavior;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RedPacketParam {
    private final IRedPacketBehavior mBehavior;
    private final String mRoomId;
    private Map<String, Object> extend;

    public RedPacketParam(@NonNull String roomId, @NonNull IRedPacketBehavior behavior) {
        this.mBehavior = behavior;
        this.mRoomId = roomId;
        this.checkIllegal();
    }

    @NonNull
    public IRedPacketBehavior getBehavior() {
        return this.mBehavior;
    }

    public String getRoomId() {
        return this.mRoomId;
    }

    public synchronized void putExtend(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        if (this.extend == null) {
            this.extend = new HashMap<String, Object>();
        }
        this.extend.put(key, value);
    }

    @Nullable
    public synchronized Object removeExtend(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || FP.empty(this.extend)) {
            return null;
        }
        return this.extend.remove(key);
    }

    @Nullable
    public synchronized Object getExtend(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || FP.empty(this.extend)) {
            return null;
        }
        return this.extend.get(key);
    }

    @Nullable
    public synchronized Map<String, Object> getExtendAll() {
        if (!FP.empty(this.extend)) {
            return new HashMap<String, Object>(this.extend);
        }
        return null;
    }

    private void checkIllegal() {
        if (this.mBehavior == null) {
            throw new IllegalArgumentException("red packet behavior can not be null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            throw new IllegalArgumentException("red packet room can not be empty");
        }
    }

    public String toString() {
        return "RedPacketParam{mBehavior=" + this.mBehavior.hashCode() + ", mRoomId='" + this.mRoomId + '\'' + ", extend=" + this.extend + '}';
    }
}

