/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.gift.bean;

import androidx.annotation.NonNull;
import com.yy.base.utils.SystemUtils;

public class GiftComboInfo
implements Comparable<GiftComboInfo> {
    private int comboHits;
    private long intervalTime;
    private boolean isFinishCombo;
    private long firstSendTime;
    private long useTimeMs;

    public GiftComboInfo(int comboHits, long intervalTime, boolean isFinishCombo, long firstSendTime, long useTimeMs) {
        this.comboHits = comboHits;
        this.intervalTime = intervalTime;
        this.isFinishCombo = isFinishCombo;
        this.firstSendTime = firstSendTime;
        this.useTimeMs = useTimeMs;
    }

    public int getComboHits() {
        return this.comboHits;
    }

    public long getIntervalTime() {
        return this.intervalTime;
    }

    public boolean getIsFinishCombo() {
        return this.isFinishCombo;
    }

    public long getFirstSendTime() {
        return this.firstSendTime;
    }

    public long getUseTimeMs() {
        return this.useTimeMs;
    }

    public void increaseCombo(int add) {
        if (!SystemUtils.isShowEnvSetting()) {
            return;
        }
        this.useTimeMs = System.currentTimeMillis();
        this.comboHits += add;
    }

    public String toString() {
        return "GiftComboInfo{comboHits=" + this.comboHits + ", useTimeMs=" + this.useTimeMs + ", isFinishCombo=" + this.isFinishCombo + ", firstSendTime=" + this.firstSendTime + ", intervalTime=" + this.intervalTime + '}';
    }

    @Override
    public int compareTo(@NonNull GiftComboInfo o) {
        if (this.comboHits == o.comboHits) {
            if (!this.isFinishCombo && o.isFinishCombo) {
                return -1;
            }
            if (this.isFinishCombo && !o.isFinishCombo) {
                return 1;
            }
        }
        return this.comboHits - o.comboHits;
    }
}

