/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.pay.bean;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.data.RechargeDbBean;
import com.yy.base.utils.FP;
import com.yy.billing.base.RechargeResult;
import java.util.HashMap;
import java.util.Map;

public class RechargeParam {
    @SerializedName(value="quantity")
    private int quantity = 1;
    @SerializedName(value="unitPrice")
    private double unitPrice;
    @SerializedName(value="product_id")
    private String productId;
    @SerializedName(value="srcCurrencySymbol")
    private String srcCurrencySymbol;
    @SerializedName(value="chargeConfigId")
    private int chargeConfigId;
    @SerializedName(value="usedChannel")
    private int useChannel;
    @SerializedName(value="currencyAmount")
    private long diamond;
    @SerializedName(value="productType")
    private int productType;
    @SerializedName(value="currencyCodeDisable")
    private int currencyCodeDisable = 0;
    @SerializedName(value="expand")
    private String expand;
    @SerializedName(value="msgIntercept")
    private boolean msgIntercept;
    @SerializedName(value="pageId")
    private String pageId;
    private long userCouponId;
    private int from;
    private boolean needRechargeSuccessBro = true;
    private Map<String, Object> svcExpand;

    private RechargeParam(Builder builder) {
        this.quantity = builder.quantity;
        this.unitPrice = builder.unitPrice;
        this.productId = builder.productId;
        this.srcCurrencySymbol = builder.srcCurrencySymbol;
        this.chargeConfigId = builder.chargeConfigId;
        this.useChannel = builder.useChannel;
        this.diamond = builder.diamond;
        this.userCouponId = builder.userCouponId;
        this.productType = builder.productType;
        this.currencyCodeDisable = builder.isCurrencyCodeEnable ? 0 : 1;
        this.msgIntercept = builder.msgIntercept;
        this.pageId = builder.pageId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getQuantity() {
        return this.quantity;
    }

    public double getUnitPrice() {
        return this.unitPrice;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSrcCurrencySymbol() {
        return this.srcCurrencySymbol;
    }

    public int getChargeConfigId() {
        return this.chargeConfigId;
    }

    public int getProductType() {
        return this.productType;
    }

    public int getUseChannel() {
        return this.useChannel;
    }

    public int getFrom() {
        return this.from;
    }

    public long getDiamond() {
        return this.diamond;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public long getUserCouponId() {
        return this.userCouponId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public boolean isCurrencyCodeEnable() {
        return this.currencyCodeDisable != 1;
    }

    public boolean isNeedRechargeSuccessBro() {
        return this.productType != 1 && this.needRechargeSuccessBro;
    }

    public boolean msgIntercept() {
        return this.msgIntercept;
    }

    public void setNeedRechargeSuccessBro(boolean needRechargeSuccessBro) {
        this.needRechargeSuccessBro = needRechargeSuccessBro;
    }

    public synchronized void addExpand(Map<String, Object> map) {
        if (FP.empty(map)) {
            return;
        }
        if (this.svcExpand == null) {
            this.svcExpand = new HashMap<String, Object>();
        }
        this.svcExpand.putAll(map);
    }

    public synchronized void addExpand(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        if (this.svcExpand == null) {
            this.svcExpand = new HashMap<String, Object>();
        }
        this.svcExpand.put(key, value);
    }

    public synchronized Object getExpand(String key) {
        if (this.svcExpand != null && !TextUtils.isEmpty((CharSequence)key)) {
            return this.svcExpand.get(key);
        }
        return null;
    }

    public Map<String, Object> getExpand() {
        if (this.svcExpand != null) {
            return new HashMap<String, Object>(this.svcExpand);
        }
        return null;
    }

    public String getH5Expand() {
        return this.expand;
    }

    public static RechargeParam getRechargeParam(RechargeDbBean dbBean) {
        RechargeParam param = RechargeParam.newBuilder().productId(dbBean.getProductId()).chargeConfigId(dbBean.getChargeConfigId()).quantity(1).unitPrice(dbBean.getPrice()).srcCurrencySymbol(dbBean.getSrcCurrencySymbol()).useChannel(dbBean.getUseChannel()).diamond(dbBean.getDiamond()).productType(dbBean.getProductType()).msgIntercept(dbBean.msgIntercept()).build();
        param.setFrom(103);
        param.setNeedRechargeSuccessBro(true);
        if (!TextUtils.isEmpty((CharSequence)dbBean.getGameId())) {
            param.addExpand("gameId", dbBean.getGameId());
        }
        return param;
    }

    public static RechargeResult getRechargeResult(RechargeDbBean dbBean) {
        return new RechargeResult(dbBean.getPurchaseData(), dbBean.getPurchaseSign(), dbBean.getGpOrderId(), dbBean.getOrderId(), dbBean.getPurchaseToken());
    }

    public String toString() {
        return "RechargeParam{quantity=" + this.quantity + ", unitPrice=" + this.unitPrice + ", productId='" + this.productId + '\'' + ", srcCurrencySymbol='" + this.srcCurrencySymbol + '\'' + ", chargeConfigId=" + this.chargeConfigId + ", useChannel=" + this.useChannel + ", userCouponId=" + this.userCouponId + ", productType=" + this.productType + '}';
    }

    public static final class Builder {
        private int quantity = 1;
        private double unitPrice;
        private String productId;
        private String srcCurrencySymbol;
        private int chargeConfigId;
        private int useChannel;
        private long diamond;
        private long userCouponId;
        private int productType;
        private boolean isCurrencyCodeEnable = true;
        private boolean msgIntercept = false;
        private String pageId = "";

        private Builder() {
        }

        public Builder quantity(int val) {
            this.quantity = val;
            return this;
        }

        public Builder unitPrice(double val) {
            this.unitPrice = val;
            return this;
        }

        public Builder productId(String val) {
            this.productId = val;
            return this;
        }

        public Builder srcCurrencySymbol(String val) {
            this.srcCurrencySymbol = val;
            return this;
        }

        public Builder chargeConfigId(int val) {
            this.chargeConfigId = val;
            return this;
        }

        public Builder useChannel(int val) {
            this.useChannel = val;
            return this;
        }

        public Builder diamond(long val) {
            this.diamond = val;
            return this;
        }

        public Builder userCouponId(long val) {
            this.userCouponId = val;
            return this;
        }

        public Builder productType(int val) {
            this.productType = val;
            return this;
        }

        public Builder isCurrencyCodeEnable(boolean val) {
            this.isCurrencyCodeEnable = val;
            return this;
        }

        public Builder msgIntercept(boolean val) {
            this.msgIntercept = val;
            return this;
        }

        public Builder pageId(String val) {
            this.pageId = val;
            return this;
        }

        public RechargeParam build() {
            return new RechargeParam(this);
        }
    }
}

