/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.pay.bean;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import org.json.JSONException;
import org.json.JSONObject;

public class RechargeInfo {
    @SerializedName(value="uid")
    private long uid;
    @SerializedName(value="amount")
    private double amount;
    @SerializedName(value="currencyType")
    private int currencyType;
    @SerializedName(value="currencyAmount")
    private long currencyAmount;
    @SerializedName(value="chOrderId")
    private String orderId = "";
    @SerializedName(value="expand")
    private String expand = "";
    @SerializedName(value="usedChannel")
    private int usedChannel;
    @SerializedName(value="payChannel")
    private String payChannel = "";
    @SerializedName(value="payMethod")
    private String payMethod = "";
    @SerializedName(value="appid")
    private int appid;
    @SerializedName(value="bonusCurrencyAmount")
    private long bonusCurrencyAmount;
    @SerializedName(value="productType")
    private int productType;
    @SerializedName(value="msgIntercept")
    private boolean msgIntercept;
    @SerializedName(value="gpOrder")
    private String gpOrder = "";
    private String pageId = "";
    private String traceId = "";
    private JSONObject expandJson;

    private RechargeInfo(Builder builder) {
        this.uid = builder.uid;
        this.amount = builder.amount;
        this.currencyType = builder.currencyType;
        this.currencyAmount = builder.currencyAmount;
        this.orderId = builder.orderId;
        this.expand = builder.expand;
        this.usedChannel = builder.usedChannel;
        this.appid = builder.appid;
        this.bonusCurrencyAmount = builder.bonusCurrencyAmount;
        this.productType = builder.productType;
        this.payChannel = builder.payChannel;
        this.payMethod = builder.payMethod;
        this.msgIntercept = builder.msgIntercept;
        this.gpOrder = builder.gpOrder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getUid() {
        return this.uid;
    }

    public double getAmount() {
        return this.amount;
    }

    public int getCurrencyType() {
        return this.currencyType;
    }

    public long getCurrencyAmount() {
        return this.currencyAmount;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getGPOrder() {
        return this.gpOrder;
    }

    public int getProductType() {
        return this.productType;
    }

    public String getExpand() {
        return this.expand;
    }

    public int getUsedChannel() {
        return this.usedChannel;
    }

    public int getAppid() {
        return this.appid;
    }

    public long getBonusCurrencyAmount() {
        return this.bonusCurrencyAmount;
    }

    public String getPayChannel() {
        return this.payChannel;
    }

    public String getPayMethod() {
        return this.payMethod;
    }

    public String getPageId() {
        if (!StringUtils.isEmpty((String)this.pageId)) {
            return this.pageId;
        }
        if (!this.ensureExpandJson()) {
            return "";
        }
        this.pageId = this.expandJson.optString("pageId");
        return this.pageId;
    }

    public String getTraceId() {
        if (!StringUtils.isEmpty((String)this.traceId)) {
            return this.traceId;
        }
        if (!this.ensureExpandJson()) {
            return "";
        }
        this.traceId = this.expandJson.optString("traceId");
        return this.traceId;
    }

    public boolean msgIntercept() {
        return this.msgIntercept;
    }

    public synchronized double getChargeAmount() {
        if (!this.ensureExpandJson()) {
            return 0.0;
        }
        return this.expandJson.optDouble("chargeAmount");
    }

    private boolean ensureExpandJson() {
        if (TextUtils.isEmpty((CharSequence)this.expand)) {
            return false;
        }
        if (this.expandJson == null) {
            try {
                this.expandJson = JsonParser.obtainJSONObject((String)this.expand);
                return true;
            }
            catch (JSONException e) {
                MLog.error((Object)"RechargeInfo", (Throwable)e);
            }
        } else {
            return true;
        }
        return false;
    }

    public String toString() {
        return "RechargeInfo{uid=" + this.uid + ", amount=" + this.amount + ", currencyType=" + this.currencyType + ", currencyAmount=" + this.currencyAmount + ", orderId='" + this.orderId + '\'' + ", bonusCurrencyAmount='" + this.bonusCurrencyAmount + '\'' + ", payChannel='" + this.payChannel + '\'' + '}';
    }

    public static final class Builder {
        private long uid;
        private double amount;
        private int currencyType;
        private long currencyAmount;
        private String orderId;
        private String expand;
        private int usedChannel;
        private int appid;
        private long bonusCurrencyAmount;
        private int productType;
        private String payChannel;
        private String payMethod;
        private boolean msgIntercept = false;
        private String gpOrder;

        private Builder() {
        }

        public Builder uid(long val) {
            this.uid = val;
            return this;
        }

        public Builder amount(double val) {
            this.amount = val;
            return this;
        }

        public Builder currencyType(int val) {
            this.currencyType = val;
            return this;
        }

        public Builder currencyAmount(long val) {
            this.currencyAmount = val;
            return this;
        }

        public Builder orderId(String val) {
            this.orderId = val;
            return this;
        }

        public Builder expand(String val) {
            this.expand = val;
            return this;
        }

        public Builder usedChannel(int val) {
            this.usedChannel = val;
            return this;
        }

        public Builder appid(int val) {
            this.appid = val;
            return this;
        }

        public Builder bonusCurrencyAmount(long val) {
            this.bonusCurrencyAmount = val;
            return this;
        }

        public Builder productType(int val) {
            this.productType = val;
            return this;
        }

        public Builder payChannel(String val) {
            this.payChannel = val;
            return this;
        }

        public Builder payMethod(String val) {
            this.payMethod = val;
            return this;
        }

        public Builder msgIntercept(Boolean val) {
            this.msgIntercept = val;
            return this;
        }

        public Builder gpOrder(String gpOrder) {
            this.gpOrder = gpOrder;
            return this;
        }

        public RechargeInfo build() {
            return new RechargeInfo(this);
        }
    }
}

