/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.pay.bean;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.CouponDiscountBean;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemExpand;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@DontProguardClass
public class ProductItemInfo {
    public int cid;
    public String offersTips;
    public String name;
    public int level;
    public double srcAmount;
    public String srcCurrencySymbol;
    public long destAmount;
    public int offersType;
    public int offersRate;
    @SerializedName(value="offers_currency_same")
    public boolean mOffersCurrencySame;
    @SerializedName(value="offers_currency_type")
    public int mOffersCurrencyType;
    @SerializedName(value="offers_currency_name")
    public String mOffersCurrencyName;
    public boolean hasAct;
    public boolean hasCurrencyAct;
    public boolean hasDestCurrencyAct;
    public long spAmount;
    public long spSumAmount;
    public boolean hasOtherCurrencyAct;
    public int otherCurrenciesSum;
    public List<CurrencyInfo> otherCurrencies = new ArrayList<CurrencyInfo>();
    public boolean hasFirstRush;
    public long firstRushAmount;
    public boolean hasPropsAct;
    public int propsSum;
    public List<PropsInfo> props = new ArrayList<PropsInfo>();
    public double chargeRate;
    public String productId;
    public String expand;
    public int productType = 0;
    public CouponDiscountBean couponDiscountBean;
    public CouponBean couponBean;
    private ProductItemExpand mProductItemExpand;
    public String payChannel;

    @Nullable
    public ProductItemExpand getProductItemExpand() {
        return this.mProductItemExpand;
    }

    public boolean isCurrencyCodeEnable() {
        return this.mProductItemExpand == null || this.mProductItemExpand.isCurrencyCodeEnable();
    }

    public void parseProductItemExpand() {
        if (this.mProductItemExpand == null && !TextUtils.isEmpty((CharSequence)this.expand)) {
            try {
                JSONObject jsonObject = JsonParser.obtainJSONObject((String)this.expand);
                this.mProductItemExpand = ProductItemExpand.newBuilder().flatCornerIcon(jsonObject.optString("flatCornerIcon", "")).couponMutex(jsonObject.optBoolean("couponMutex", false)).slashCornerIcon(jsonObject.optString("slashCornerIcon", "")).iconText(jsonObject.optString("iconText", "")).currentMode(jsonObject.optInt("currentMode", 0)).currencyCodeEnable(jsonObject.optInt("currencyCodeDisable", 0) != 1).localCurrencyDisplay(jsonObject.optString("localCurrencyDisplay", "")).currencyUnitDisplay(jsonObject.optInt("currencyUnitDisplay", 0)).isRearDisplayCurrency(jsonObject.optBoolean("isRearDisplayCurrency", false)).build();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getIsRearDisplayCurrency() {
        if (this.mProductItemExpand != null) {
            return this.mProductItemExpand.getIsRearDisplayCurrency();
        }
        return false;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isFilter() {
        if (this.mProductItemExpand != null) {
            return this.mProductItemExpand.getCurrentMode() == 1;
        }
        return false;
    }

    public String getSrcCurrencySymbol() {
        if (this.couponDiscountBean != null && this.couponDiscountBean.couponEnabled) {
            return this.couponDiscountBean.srcCurrencySymbol;
        }
        if (this.mProductItemExpand != null && !TextUtils.isEmpty((CharSequence)this.mProductItemExpand.getSrcCurrencySymbol())) {
            return this.mProductItemExpand.getSrcCurrencySymbol();
        }
        return this.srcCurrencySymbol;
    }

    public double getSrcAmount() {
        if (this.couponDiscountBean != null && this.couponDiscountBean.couponEnabled) {
            return this.couponDiscountBean.discountAmount;
        }
        if (this.mProductItemExpand != null && this.mProductItemExpand.getSrcAmount() > 0.0) {
            return this.mProductItemExpand.getSrcAmount();
        }
        return this.srcAmount;
    }

    public String getProductId() {
        if (this.couponDiscountBean != null && this.couponDiscountBean.couponEnabled && !TextUtils.isEmpty((CharSequence)this.couponDiscountBean.discountProductId)) {
            return this.couponDiscountBean.discountProductId;
        }
        return this.productId;
    }

    public String getPayChannel() {
        return this.payChannel;
    }

    public String toString() {
        return "ProductItemInfo{cid=" + this.cid + ", offersTips='" + this.offersTips + '\'' + ", name='" + this.name + '\'' + ", level=" + this.level + ", srcAmount=" + this.srcAmount + ", srcCurrencySymbol='" + this.srcCurrencySymbol + '\'' + ", destAmount=" + this.destAmount + ", offersType=" + this.offersType + ", offersRate=" + this.offersRate + ", mOffersCurrencySame=" + this.mOffersCurrencySame + ", mOffersCurrencyType=" + this.mOffersCurrencyType + ", mOffersCurrencyName='" + this.mOffersCurrencyName + '\'' + ", hasAct=" + this.hasAct + ", hasCurrencyAct=" + this.hasCurrencyAct + ", hasDestCurrencyAct=" + this.hasDestCurrencyAct + ", spAmount=" + this.spAmount + ", spSumAmount=" + this.spSumAmount + ", hasOtherCurrencyAct=" + this.hasOtherCurrencyAct + ", otherCurrenciesSum=" + this.otherCurrenciesSum + ", otherCurrencies=" + this.otherCurrencies + ", hasFirstRush=" + this.hasFirstRush + ", firstRushAmount=" + this.firstRushAmount + ", hasPropsAct=" + this.hasPropsAct + ", propsSum=" + this.propsSum + ", props=" + this.props + ", chargeRate=" + this.chargeRate + ", productId='" + this.productId + '\'' + '}';
    }

    public static class CurrencyInfo {
        @SerializedName(value="offers_currency_type")
        public int mOffersCurrencyType;
        @SerializedName(value="offers_currency_amount")
        public long mOffersCurrencyAmount;
        @SerializedName(value="offers_currency_name")
        public String mOffersCurrencyName;

        public String toString() {
            return "CurrencyInfo{mOffersCurrencyType=" + this.mOffersCurrencyType + ", mOffersCurrencyAmount=" + this.mOffersCurrencyAmount + ", mOffersCurrencyName='" + this.mOffersCurrencyName + '\'' + '}';
        }
    }

    public static class PropsInfo {
        public int propid;
        public int count;
        public int type;

        public String toString() {
            return "PropsInfo{propid=" + this.propid + ", count=" + this.count + ", type=" + this.type + '}';
        }
    }
}

