/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.pay;

import com.yy.base.utils.StringUtils;

public enum PayPlatform {
    GOOGLE_PLAY("Google", "Balance", true),
    CATAPPULT("Catappult", "Balance", true),
    HUAWEI("Huawei", "Balance", false);

    final String channel;
    final String method;
    final boolean useGp;

    private PayPlatform(String channel, String method, boolean useGp) {
        this.channel = channel;
        this.method = method;
        this.useGp = useGp;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isUseGp() {
        return this.useGp;
    }

    public static boolean needImMsg(PayPlatform platform) {
        return platform != CATAPPULT;
    }

    public static boolean isLocalPayChannel(String payChannel) {
        for (PayPlatform platform : PayPlatform.values()) {
            if (!StringUtils.equals((String)payChannel, (String)platform.channel)) continue;
            return true;
        }
        return false;
    }
}

