/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.giftbox;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYImageView;

public class GiftSweepImageView
extends YYImageView {
    public static final int INFINITE = -1;
    private int repeatTransTimes = 0;
    private ObjectAnimator translationAnim;
    private int repeatCount;
    private int instance;
    private boolean isNeedAlpha;
    private boolean started = false;
    private boolean stopedByDetach = false;

    public GiftSweepImageView(Context context) {
        super(context);
    }

    public GiftSweepImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.started && this.stopedByDetach) {
            this.initAndStartRepeatTranslation(this.repeatCount, this.instance, this.isNeedAlpha);
        }
        this.stopedByDetach = false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelTransAnimInner();
        this.stopedByDetach = true;
    }

    public void cancelTransAnim() {
        this.started = false;
        this.cancelTransAnimInner();
    }

    private void cancelTransAnimInner() {
        if (this.translationAnim != null) {
            this.setTranslationX(0.0f);
            this.translationAnim.cancel();
            this.translationAnim.removeAllListeners();
        }
        this.translationAnim = null;
    }

    public void initAndStartRepeatTranslation(final int repeatCount, int instance) {
        this.repeatTransTimes = 0;
        this.started = true;
        this.repeatCount = repeatCount;
        this.instance = instance;
        this.isNeedAlpha = false;
        if (this.translationAnim == null) {
            this.translationAnim = this.getTranslationAnim((View)this, instance, false);
            this.translationAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    GiftSweepImageView.this.setVisibility(0);
                }

                public void onAnimationEnd(Animator animation) {
                    if ((GiftSweepImageView.this.repeatTransTimes <= repeatCount || repeatCount == -1) && GiftSweepImageView.this.isAttachToWindow()) {
                        GiftSweepImageView.this.startTransAnim();
                        GiftSweepImageView.this.setVisibility(4);
                    }
                }
            });
            this.translationAnim.setStartDelay(500L);
            this.translationAnim.setDuration(1200L);
            this.startTransAnim();
        }
    }

    public void initAndStartRepeatTranslation(final int repeatCount, int instance, boolean isNeedAlpha) {
        this.repeatTransTimes = 0;
        this.started = true;
        this.isNeedAlpha = isNeedAlpha;
        if (this.translationAnim == null) {
            this.translationAnim = this.getTranslationAnim((View)this, instance, isNeedAlpha);
            this.translationAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    GiftSweepImageView.this.setVisibility(0);
                }

                public void onAnimationEnd(Animator animation) {
                    if ((GiftSweepImageView.this.repeatTransTimes <= repeatCount || repeatCount == -1) && GiftSweepImageView.this.isAttachToWindow()) {
                        GiftSweepImageView.this.startTransAnim();
                        GiftSweepImageView.this.setVisibility(4);
                    }
                }
            });
            this.translationAnim.setStartDelay(500L);
            this.translationAnim.setDuration(1200L);
            this.startTransAnim();
        }
    }

    private void startTransAnim() {
        if (this.translationAnim == null) {
            return;
        }
        ++this.repeatTransTimes;
        this.translationAnim.start();
    }

    @NonNull
    private ObjectAnimator getTranslationAnim(View giftIv, int instance, boolean isNeedAlpha) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)giftIv.getLayoutParams();
        int leftMargin = marginLayoutParams.leftMargin;
        PropertyValuesHolder trans = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{leftMargin, instance});
        if (isNeedAlpha) {
            PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f, 0.0f});
            return ObjectAnimator.ofPropertyValuesHolder((Object)giftIv, (PropertyValuesHolder[])new PropertyValuesHolder[]{trans, alpha});
        }
        return ObjectAnimator.ofPropertyValuesHolder((Object)giftIv, (PropertyValuesHolder[])new PropertyValuesHolder[]{trans});
    }
}

