/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.action;

import android.os.Message;
import com.yy.appbase.R;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.webservice.WebEnvSettings;

public class ActionManager {
    private static final String TAG = "ActionManager";

    private ActionManager() {
    }

    public static ActionManager obtain() {
        return new ActionManager();
    }

    public void onAction(ActivityAction action) {
        if (!FP.empty((CharSequence)action.linkUrl)) {
            if (action.linkUrl.startsWith("hago://") || action.linkUrl.startsWith("olaparty://")) {
                ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(action.linkUrl);
            } else {
                switch (action.linkType) {
                    case DIALOG: {
                        this.openWebDialog(action);
                        break;
                    }
                    case NEW_WINDOW: {
                        this.openWebWindow(action);
                        break;
                    }
                    case TRANSPARENT_H5: {
                        this.openTransparentWebView(action);
                        break;
                    }
                    case NOTHING: {
                        break;
                    }
                }
            }
        }
    }

    private void openWebWindow(ActivityAction action) {
        MLog.info((Object)TAG, (String)"openWebWindow %s", (Object[])new Object[]{action});
        if (action.linkUrl.startsWith("http")) {
            WebEnvSettings settings = new WebEnvSettings();
            settings.url = action.linkUrl;
            settings.title = action.title;
            settings.type = action.originType;
            ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(settings);
        } else {
            ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(action.linkUrl);
        }
    }

    private void openWebDialog(ActivityAction action) {
        MLog.info((Object)TAG, (String)"openWebDialog %s", (Object[])new Object[]{action});
        Message message = Message.obtain();
        message.what = BaseMsgDef.SHOW_PANEL_DIALOG_WEB_VIEW;
        message.obj = action.linkUrl;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    private void openTransparentWebView(ActivityAction action) {
        MLog.info((Object)TAG, (String)"openTransparentWebView %s", (Object[])new Object[]{action});
        WebEnvSettings settings = new WebEnvSettings();
        settings.url = action.linkUrl;
        settings.isShowBackBtn = true;
        settings.isFullScreen = true;
        settings.disablePullRefresh = true;
        settings.usePageTitle = false;
        settings.webViewBackgroundColor = ResourceUtils.getColor((int)R.color.common_pressed);
        settings.webWindowAnimator = false;
        settings.hideLastWindow = false;
        settings.type = action.originType;
        ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(settings);
    }
}

