/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.mediav1impl;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import tv.athena.live.player.statistics.threadpool.IQueueTaskExecutor;
import tv.athena.live.player.statistics.threadpool.IYYTaskExecutor;

public class MediaExecutor
implements IYYTaskExecutor {
    private static final String Tag = "MediaExecutor";
    private static int MAX_CONCURRENCY_TASKS = HardwareUtils.getCpuCoreCount() > 4 ? 12 : 8;
    private AtomicInteger mCurrentActiveTasks = new AtomicInteger(0);
    private ArrayList<PushRunnable> mRunnablesToPost = new ArrayList();

    private void onTaskFinished(PushRunnable runnable2) {
        this.mCurrentActiveTasks.decrementAndGet();
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext() {
        PushRunnable myRunnable = null;
        MediaExecutor mediaExecutor = this;
        synchronized (mediaExecutor) {
            if (this.mRunnablesToPost.size() > 0 && this.mCurrentActiveTasks.get() < MAX_CONCURRENCY_TASKS) {
                myRunnable = this.mRunnablesToPost.get(0);
                this.mRunnablesToPost.remove(0);
                if (myRunnable != null) {
                    this.mCurrentActiveTasks.incrementAndGet();
                }
            }
        }
        if (myRunnable != null) {
            myRunnable.postRunnable();
        }
    }

    public void postToMainThread(Runnable var1, long var2) {
        YYTaskExecutor.postToMainThread((Runnable)var1, (long)var2);
    }

    public void postIdleRunnableToMainThread(Runnable var1) {
        YYTaskExecutor.postIdleRunnableToMainThread((Runnable)var1);
    }

    public void removeRunnableFromMainThread(Runnable var1) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)var1);
    }

    public boolean isMainThread() {
        return YYTaskExecutor.isMainThread();
    }

    public void execute(Runnable var1, long var2) {
        this.execute(var1, null, -1L, 10);
    }

    public void execute(Runnable var1, long var2, int var4) {
        this.execute(var1, null, var2, 10);
    }

    public void execute(Runnable var1, Runnable var2, long var3) {
        this.execute(var1, var2, var3, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable var1, Runnable var2, long var3, int var5) {
        MediaExecutor mediaExecutor = this;
        synchronized (mediaExecutor) {
            this.mRunnablesToPost.add(new PushRunnable(var1, var2, var3, var5));
        }
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Runnable var1) {
        PushRunnable runnableFind = null;
        MediaExecutor mediaExecutor = this;
        synchronized (mediaExecutor) {
            if (this.mRunnablesToPost.size() > 0) {
                for (PushRunnable runnable2 : this.mRunnablesToPost) {
                    if (runnable2 == null || runnable2.mRunnable != var1) continue;
                    runnableFind = runnable2;
                    break;
                }
            }
            if (runnableFind != null) {
                this.mRunnablesToPost.remove(runnableFind);
                this.mCurrentActiveTasks.decrementAndGet();
            }
        }
        if (runnableFind != null) {
            runnableFind.removeRunnable();
        }
    }

    @Nullable
    public IQueueTaskExecutor createAQueueExcuter() {
        return new MediaAQueueExcuter();
    }

    private static class MediaAQueueExcuter
    implements IQueueTaskExecutor {
        com.yy.base.taskexecutor.IQueueTaskExecutor mTaskExecutor = YYTaskExecutor.createAQueueExcuter();

        public void execute(Runnable var1, long var2) {
            this.mTaskExecutor.execute(var1, var2);
        }

        public void execute(Runnable var1, long var2, int var4) {
            this.mTaskExecutor.execute(var1, var2, var4);
        }

        public void execute(Runnable var1, Runnable var2, long var3) {
            this.mTaskExecutor.execute(var1, var2, var3);
        }

        public void execute(Runnable var1, Runnable var2, long var3, int var5) {
            this.mTaskExecutor.execute(var1, var2, var3, var5);
        }

        public void removeTask(Runnable var1) {
            this.mTaskExecutor.removeTask(var1);
        }
    }

    private class PushRunnable
    implements Runnable {
        Runnable mRunnable;
        private Runnable mMainRunnable;
        private long mDelayTime = -1L;
        private int mThePriority;

        public PushRunnable(Runnable runnable2, Runnable mainRunnable, long delayTime, int thePriority) {
            this.mRunnable = runnable2;
            this.mMainRunnable = mainRunnable;
            this.mDelayTime = delayTime;
            this.mThePriority = thePriority;
        }

        void postRunnable() {
            YYTaskExecutor.execute((Runnable)this.mRunnable, (Runnable)this.mMainRunnable, (long)this.mDelayTime, (int)this.mThePriority);
        }

        void removeRunnable() {
            YYTaskExecutor.removeTask((Runnable)this.mRunnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (this.mRunnable != null) {
                        this.mRunnable.run();
                    }
                    MediaExecutor.this.onTaskFinished(this);
                    if (!RuntimeContext.sIsDebuggable || this.mRunnable == null) break block6;
                    MediaExecutor mediaExecutor = MediaExecutor.this;
                    synchronized (mediaExecutor) {
                        MLog.info((Object)MediaExecutor.Tag, (String)("onTaskFinished:" + this.mRunnable + "  RunnablesToPost" + MediaExecutor.this.mRunnablesToPost.size()), (Object[])new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    MediaExecutor.this.onTaskFinished(this);
                    MLog.info((Object)MediaExecutor.Tag, (String)("onTaskFinished:" + this.mRunnable + " error:" + throwable), (Object[])new Object[0]);
                    throw throwable;
                }
            }
        }
    }
}

