/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.officialvoice.record;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.voice.base.offlinevoice.VoiceScene;
import com.yy.voice.R;
import com.yy.voice.officialvoice.record.IRecordViewCallback;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0012\u0010'\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0006\u0010*\u001a\u00020\u001dJ\b\u0010+\u001a\u00020\u001dH\u0002J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\fJ\u0016\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0018J\b\u00102\u001a\u00020\u001dH\u0002J\b\u00103\u001a\u00020\u001dH\u0002J\b\u00104\u001a\u00020\u001dH\u0003J\u000e\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/yy/voice/officialvoice/record/RecordView;", "Lcom/yy/base/memoryrecycle/views/YYFrameLayout;", "context", "Landroid/content/Context;", "scene", "Lcom/yy/hiyo/voice/base/offlinevoice/VoiceScene;", "(Landroid/content/Context;Lcom/yy/hiyo/voice/base/offlinevoice/VoiceScene;)V", "TAG", "", "actionUpTime", "", "changePosition", "", "delayStartTask", "Ljava/lang/Runnable;", "disableTips", "endMove", "", "isCanceling", "", "isEnable", "lastState", "Ljava/lang/Boolean;", "mViewCallback", "Lcom/yy/voice/officialvoice/record/IRecordViewCallback;", "needCancel", "startMove", "startTime", "cancel", "", "changeState", "create", "finishRecord", "getRecordRect", "Landroid/graphics/Rect;", "hideAnimator", "Landroid/animation/AnimatorSet;", "moveTimer", "offset", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "resetAll", "resetTimer", "setBarHeight", "height", "setEnable", "enable", "setViewCallback", "viewCallback", "startRecord", "startUI", "startVibrator", "updateTime", "time", "voice_debug"})
public final class RecordView
extends YYFrameLayout {
    private final String TAG = "RecordView";
    private float startMove;
    private float endMove;
    private int changePosition;
    private Boolean lastState;
    private boolean isCanceling;
    private boolean needCancel;
    private long startTime;
    private long actionUpTime;
    private boolean isEnable;
    private String disableTips;
    private VoiceScene scene;
    private IRecordViewCallback mViewCallback;
    private final Runnable delayStartTask;
    private HashMap _$_findViewCache;

    private final void create() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.voice_chat_record, (ViewGroup)this, true);
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.changePosition = ResolutionUtils.getScreenWidth((Context)context.getApplicationContext()) / 2;
        this.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ RecordView this$0;

            public final void onClick(View it) {
                MLog.debug((Object)RecordView.access$getTAG$p(this.this$0), (String)"setOnClickListener", (Object[])new Object[0]);
            }
            {
                this.this$0 = recordView;
            }
        });
    }

    public final void setBarHeight(int height) {
        if ((YYView)this._$_findCachedViewById(R.id.barBg) != null) {
            YYView yYView = (YYView)this._$_findCachedViewById(R.id.barBg);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYView, (String)"barBg");
            if (height > yYView.getMinimumHeight()) {
                Intrinsics.checkExpressionValueIsNotNull((Object)((YYView)this._$_findCachedViewById(R.id.barBg)), (String)"barBg");
                ((YYView)this._$_findCachedViewById(R.id.barBg)).getLayoutParams().height = height - 2;
                ((YYView)this._$_findCachedViewById(R.id.barBg)).requestLayout();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        Integer n;
        boolean intercept = false;
        MotionEvent motionEvent = event;
        int x = motionEvent != null ? (int)motionEvent.getRawX() : 0;
        MotionEvent motionEvent2 = event;
        int y = motionEvent2 != null ? (int)motionEvent2.getRawY() : 0;
        MotionEvent motionEvent3 = event;
        Integer n2 = n = motionEvent3 != null ? Integer.valueOf(motionEvent3.getAction()) : null;
        int n3 = 0;
        if (n2 != null && n2 == 0) {
            YYConstraintLayout yYConstraintLayout = (YYConstraintLayout)this._$_findCachedViewById(R.id.container);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYConstraintLayout, (String)"container");
            if (yYConstraintLayout.getVisibility() == 0) {
                return true;
            }
            Rect rect = this.getRecordRect();
            intercept = rect.contains(x, y);
            MLog.debug((Object)this.TAG, (String)("ACTION_DOWN x: " + x + ", y: " + y + ", rect: " + rect + ", isCanceling: " + this.isCanceling + ',' + "intercept: " + intercept), (Object[])new Object[0]);
            if (!intercept) return intercept;
            if (this.mViewCallback != null) {
                IRecordViewCallback iRecordViewCallback = this.mViewCallback;
                if (iRecordViewCallback == null) {
                    Intrinsics.throwNpe();
                }
                this.isEnable = iRecordViewCallback.canRecord();
            }
            if (!this.isEnable) {
                if (StringUtils.isEmpty((String)this.disableTips) && this.mViewCallback != null) {
                    IRecordViewCallback iRecordViewCallback = this.mViewCallback;
                    if (iRecordViewCallback == null) {
                        Intrinsics.throwNpe();
                    }
                    if (iRecordViewCallback.isOpenMic()) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_mic_open_can_not_record), (int)0);
                        return intercept;
                    }
                }
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)this.disableTips, (int)0);
                return intercept;
            }
            if (this.isCanceling) return intercept;
            long dif = System.currentTimeMillis() - this.actionUpTime;
            MLog.debug((Object)this.TAG, (String)("ACTION_DOWN " + dif), (Object[])new Object[0]);
            this.startUI();
            if (dif < (long)1000) {
                YYTaskExecutor.postToMainThread((Runnable)this.delayStartTask, (long)((long)1000 - dif));
                return intercept;
            }
            this.startRecord();
            return intercept;
        }
        Integer n4 = n;
        n3 = 2;
        if (n4 != null && n4 == n3) {
            MLog.debug((Object)this.TAG, (String)("ACTION_MOVE x: " + x + ", startMove: " + this.startMove + ", isEnable: " + this.isEnable), (Object[])new Object[0]);
            if (!this.isEnable) return intercept;
            if (this.isCanceling) return intercept;
            if (!((float)x < this.startMove)) return intercept;
            if (!((float)x > this.endMove)) return intercept;
            this.moveTimer((float)x - this.startMove);
            this.needCancel = x < this.changePosition;
            this.changeState(this.needCancel);
            return intercept;
        }
        Integer n5 = n;
        n3 = 1;
        if (n5 == null) {
            return intercept;
        }
        if (n5 != n3) return intercept;
        MLog.debug((Object)this.TAG, (String)("ACTION_UP x: " + x + ", startMove: " + this.startMove + ", isEnable: " + this.isEnable), (Object[])new Object[0]);
        if (!this.isEnable) return intercept;
        YYTaskExecutor.removeTask((Runnable)this.delayStartTask);
        this.actionUpTime = System.currentTimeMillis();
        if (this.needCancel) {
            this.cancel();
            return intercept;
        }
        this.finishRecord();
        return intercept;
    }

    public final void setViewCallback(@NotNull IRecordViewCallback viewCallback) {
        Intrinsics.checkParameterIsNotNull((Object)viewCallback, (String)"viewCallback");
        this.mViewCallback = viewCallback;
        this.isEnable = !viewCallback.isOpenMic();
    }

    public final void updateTime(long time) {
        YYTextView yYTextView = (YYTextView)this._$_findCachedViewById(R.id.timerText);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYTextView, (String)"timerText");
        yYTextView.setText((CharSequence)StringUtils.format((String)"%d:%02d", (Object[])new Object[]{time / (long)60, time % (long)60}));
    }

    public final void setEnable(boolean enable, @NotNull String disableTips) {
        Intrinsics.checkParameterIsNotNull((Object)disableTips, (String)"disableTips");
        MLog.debug((Object)this.TAG, (String)("setEnable enable: " + enable + ", disableTips: " + disableTips), (Object[])new Object[0]);
        this.isEnable = enable;
        this.disableTips = disableTips;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void startRecord() {
        IRecordViewCallback iRecordViewCallback = this.mViewCallback;
        if (iRecordViewCallback != null) {
            if (iRecordViewCallback.startRecord()) {
                this.startVibrator();
                return;
            }
        }
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_record_open), (int)0);
        this.resetAll();
    }

    private final void startUI() {
        YYConstraintLayout yYConstraintLayout = (YYConstraintLayout)this._$_findCachedViewById(R.id.container);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYConstraintLayout, (String)"container");
        yYConstraintLayout.setVisibility(0);
        this.changeState(false);
        ((YYLinearLayout)this._$_findCachedViewById(R.id.timerContent)).post(new Runnable(this){
            final /* synthetic */ RecordView this$0;

            public final void run() {
                YYLinearLayout yYLinearLayout = (YYLinearLayout)this.this$0._$_findCachedViewById(R.id.timerContent);
                Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout, (String)"timerContent");
                float f = yYLinearLayout.getX();
                YYLinearLayout yYLinearLayout2 = (YYLinearLayout)this.this$0._$_findCachedViewById(R.id.timerContent);
                Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout2, (String)"timerContent");
                RecordView.access$setStartMove$p(this.this$0, f + (float)(yYLinearLayout2.getMeasuredWidth() / 2));
                YYLinearLayout yYLinearLayout3 = (YYLinearLayout)this.this$0._$_findCachedViewById(R.id.timerContent);
                Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout3, (String)"timerContent");
                RecordView.access$setEndMove$p(this.this$0, yYLinearLayout3.getMeasuredWidth());
            }
            {
                this.this$0 = recordView;
            }
        });
        this.startTime = System.currentTimeMillis();
        this.updateTime(0L);
    }

    private final void moveTimer(float offset) {
        MLog.debug((Object)this.TAG, (String)("moveTimer offset: " + offset), (Object[])new Object[0]);
        YYLinearLayout yYLinearLayout = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout, (String)"timerContent");
        yYLinearLayout.setTranslationX(offset);
    }

    private final void changeState(boolean cancel2) {
        if (this.lastState != null && Intrinsics.areEqual((Object)this.lastState, (Object)cancel2)) {
            return;
        }
        this.lastState = cancel2;
        if (cancel2) {
            ((YYLinearLayout)this._$_findCachedViewById(R.id.timerContent)).setBackgroundResource(R.drawable.record_timer_cancel_bg);
            ((YYImageView)this._$_findCachedViewById(R.id.deleteIcon)).setImageResource(R.drawable.input_voice_delete_cancel);
            if (this.scene == VoiceScene.CHANNEL) {
                ((YYImageView)this._$_findCachedViewById(R.id.recordIcon)).setImageResource(R.drawable.input_record_icon_disable);
            } else {
                ((YYImageView)this._$_findCachedViewById(R.id.recordIcon)).setImageResource(R.drawable.input_record_icon_disable_im);
            }
            YYImageView yYImageView = (YYImageView)this._$_findCachedViewById(R.id.timerIcon);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYImageView, (String)"timerIcon");
            yYImageView.setVisibility(0);
            SVGAImageView sVGAImageView = (SVGAImageView)this._$_findCachedViewById(R.id.timerSvga);
            Intrinsics.checkExpressionValueIsNotNull((Object)sVGAImageView, (String)"timerSvga");
            sVGAImageView.setVisibility(8);
        } else {
            ((YYLinearLayout)this._$_findCachedViewById(R.id.timerContent)).setBackgroundResource(R.drawable.record_timer_bg);
            ((YYImageView)this._$_findCachedViewById(R.id.deleteIcon)).setImageResource(R.drawable.input_voice_delete_icon);
            ((YYImageView)this._$_findCachedViewById(R.id.recordIcon)).setImageResource(R.drawable.input_record_icon_pressed);
            if (this.scene == VoiceScene.CHANNEL) {
                ((YYImageView)this._$_findCachedViewById(R.id.recordIcon)).setImageResource(R.drawable.input_record_icon_pressed);
            } else {
                ((YYImageView)this._$_findCachedViewById(R.id.recordIcon)).setImageResource(R.drawable.input_record_icon_pressed_im);
            }
            YYImageView yYImageView = (YYImageView)this._$_findCachedViewById(R.id.timerIcon);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYImageView, (String)"timerIcon");
            yYImageView.setVisibility(8);
            SVGAImageView sVGAImageView = (SVGAImageView)this._$_findCachedViewById(R.id.timerSvga);
            Intrinsics.checkExpressionValueIsNotNull((Object)sVGAImageView, (String)"timerSvga");
            sVGAImageView.setVisibility(0);
            SvgaLoader.load((SVGAImageView)((SVGAImageView)this._$_findCachedViewById(R.id.timerSvga)), (String)"record_wave.svga", (boolean)true);
        }
    }

    private final void cancel() {
        this.isCanceling = true;
        IRecordViewCallback iRecordViewCallback = this.mViewCallback;
        if (iRecordViewCallback != null) {
            iRecordViewCallback.cancelRecord(false);
        }
        AnimatorSet animator = this.hideAnimator();
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ RecordView this$0;

            public void onAnimationEnd(@Nullable Animator animation) {
                this.this$0.resetAll();
            }
            {
                this.this$0 = $outer;
            }
        });
        animator.start();
    }

    private final AnimatorSet hideAnimator() {
        YYLinearLayout yYLinearLayout = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        float[] fArray = new float[2];
        YYLinearLayout yYLinearLayout2 = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout2, (String)"timerContent");
        fArray[0] = yYLinearLayout2.getTranslationX();
        YYImageView yYImageView = (YYImageView)this._$_findCachedViewById(R.id.deleteIcon);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYImageView, (String)"deleteIcon");
        float f = yYImageView.getX();
        YYImageView yYImageView2 = (YYImageView)this._$_findCachedViewById(R.id.deleteIcon);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYImageView2, (String)"deleteIcon");
        fArray[1] = f + (float)(yYImageView2.getMeasuredWidth() / 2) - this.startMove;
        ObjectAnimator ax = ObjectAnimator.ofFloat((Object)yYLinearLayout, (String)"translationX", (float[])fArray);
        YYLinearLayout yYLinearLayout3 = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        float[] fArray2 = new float[2];
        YYLinearLayout yYLinearLayout4 = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout4, (String)"timerContent");
        fArray2[0] = yYLinearLayout4.getTranslationY();
        YYImageView yYImageView3 = (YYImageView)this._$_findCachedViewById(R.id.deleteIcon);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYImageView3, (String)"deleteIcon");
        float f2 = yYImageView3.getY();
        YYLinearLayout yYLinearLayout5 = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout5, (String)"timerContent");
        fArray2[1] = f2 - yYLinearLayout5.getY();
        ObjectAnimator ay = ObjectAnimator.ofFloat((Object)yYLinearLayout3, (String)"translationY", (float[])fArray2);
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((YYLinearLayout)this._$_findCachedViewById(R.id.timerContent)), (String)"scaleX", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((YYLinearLayout)this._$_findCachedViewById(R.id.timerContent)), (String)"scaleY", (float[])new float[]{1.0f, 0.0f});
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{(Animator)ax, (Animator)ay, (Animator)scaleX, (Animator)scaleY});
        set.setDuration(300L);
        return set;
    }

    private final void finishRecord() {
        if (System.currentTimeMillis() - this.startTime < (long)1000) {
            IRecordViewCallback iRecordViewCallback = this.mViewCallback;
            if (iRecordViewCallback != null) {
                iRecordViewCallback.cancelRecord(false);
            }
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_record_open), (int)0);
        } else {
            IRecordViewCallback iRecordViewCallback = this.mViewCallback;
            if (iRecordViewCallback != null) {
                iRecordViewCallback.finishRecord();
            }
        }
        this.resetAll();
    }

    public final void resetAll() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
            final /* synthetic */ RecordView this$0;

            public final void run() {
                RecordView.access$setCanceling$p(this.this$0, false);
                RecordView.access$setNeedCancel$p(this.this$0, false);
                YYConstraintLayout yYConstraintLayout = (YYConstraintLayout)this.this$0._$_findCachedViewById(R.id.container);
                Intrinsics.checkExpressionValueIsNotNull((Object)yYConstraintLayout, (String)"container");
                yYConstraintLayout.setVisibility(8);
                RecordView.access$resetTimer(this.this$0);
            }
            {
                this.this$0 = recordView;
            }
        });
    }

    private final Rect getRecordRect() {
        Rect rect;
        IRecordViewCallback iRecordViewCallback = this.mViewCallback;
        Object object = rect = iRecordViewCallback != null ? iRecordViewCallback.getRecordIconRect() : null;
        if (rect == null) {
            rect = new Rect();
        }
        return rect;
    }

    @SuppressLint(value={"MissingPermission"})
    private final void startVibrator() {
        Vibrator vibrator = SystemServiceUtils.getVibrator((Context)this.getContext());
        if (vibrator != null) {
            long duration = 150L;
            if (Build.VERSION.SDK_INT >= 26) {
                vibrator.vibrate(VibrationEffect.createOneShot((long)duration, (int)-1));
            } else {
                vibrator.vibrate(duration);
            }
        }
    }

    private final void resetTimer() {
        YYLinearLayout yYLinearLayout = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout, (String)"timerContent");
        yYLinearLayout.setTranslationX(0.0f);
        YYLinearLayout yYLinearLayout2 = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout2, (String)"timerContent");
        yYLinearLayout2.setTranslationY(0.0f);
        YYLinearLayout yYLinearLayout3 = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout3, (String)"timerContent");
        yYLinearLayout3.setScaleX(1.0f);
        YYLinearLayout yYLinearLayout4 = (YYLinearLayout)this._$_findCachedViewById(R.id.timerContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYLinearLayout4, (String)"timerContent");
        yYLinearLayout4.setScaleY(1.0f);
    }

    public RecordView(@Nullable Context context, @NotNull VoiceScene scene) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        super(context);
        this.TAG = "RecordView";
        this.isEnable = true;
        this.disableTips = "";
        this.scene = VoiceScene.CHANNEL;
        this.delayStartTask = new Runnable(this){
            final /* synthetic */ RecordView this$0;

            public final void run() {
                RecordView.access$startRecord(this.this$0);
            }
            {
                this.this$0 = recordView;
            }
        };
        this.create();
        this.scene = scene;
    }

    public static final /* synthetic */ String access$getTAG$p(RecordView $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ float access$getStartMove$p(RecordView $this) {
        return $this.startMove;
    }

    public static final /* synthetic */ void access$setStartMove$p(RecordView $this, float f) {
        $this.startMove = f;
    }

    public static final /* synthetic */ float access$getEndMove$p(RecordView $this) {
        return $this.endMove;
    }

    public static final /* synthetic */ void access$setEndMove$p(RecordView $this, float f) {
        $this.endMove = f;
    }

    public static final /* synthetic */ boolean access$isCanceling$p(RecordView $this) {
        return $this.isCanceling;
    }

    public static final /* synthetic */ void access$setCanceling$p(RecordView $this, boolean bl) {
        $this.isCanceling = bl;
    }

    public static final /* synthetic */ boolean access$getNeedCancel$p(RecordView $this) {
        return $this.needCancel;
    }

    public static final /* synthetic */ void access$setNeedCancel$p(RecordView $this, boolean bl) {
        $this.needCancel = bl;
    }

    public static final /* synthetic */ void access$resetTimer(RecordView $this) {
        $this.resetTimer();
    }

    public static final /* synthetic */ void access$startRecord(RecordView $this) {
        $this.startRecord();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

