/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.voice.base.roomvoice;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import common.Header;
import ikxd.room.HeartbeatReq;
import ikxd.room.HeartbeatRes;
import ikxd.room.JoinRoomReq;
import ikxd.room.JoinRoomRes;
import ikxd.room.LeaveRoomReq;
import ikxd.room.LeaveRoomRes;
import ikxd.room.MicOperateReq;
import ikxd.room.MicOperateRes;
import ikxd.room.Room;
import ikxd.room.StatusNotify;
import ikxd.room.Uri;
import java.util.concurrent.ConcurrentHashMap;

public class RoomDataModel
implements IProtoNotify<Room> {
    private static final String TAG = "RoomDataModel";
    private final ConcurrentHashMap<String, AbsVoiceRoom> mRooms;

    public RoomDataModel(ConcurrentHashMap<String, AbsVoiceRoom> mRooms) {
        this.mRooms = mRooms;
        ProtoManager.getInstance().registerNotify((IProtoNotify)this);
    }

    public void joinRoomReq(final AbsVoiceRoom singleRoom, boolean micOpen) {
        if (singleRoom == null) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"join room req,room:%s, mic:%b", (Object[])new Object[]{singleRoom.mSessionId, micOpen});
        }
        Header header = ProtoManager.getInstance().getHeader("ikxd_room_d");
        JoinRoomReq req = new JoinRoomReq.Builder().mic(Boolean.valueOf(micOpen)).build();
        Room room = new Room.Builder().header(header).uri(Uri.kUriJoinRoomReq).session(singleRoom.mSessionId).join_room_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)room, (IProtoCallback)new IProtoCallback<Room>(){

            public void onResponse(@Nullable Room room) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"join room req,onResponse:%s", (Object[])new Object[]{room});
                }
                RoomDataModel.this.onJoinRoomRes(singleRoom, room);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"join room req,retryWhenTimeout:%b", (Object[])new Object[]{canRetry});
                }
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)RoomDataModel.TAG, (String)"join room req,retryWhenTimeout:%b, reason:%s, code;%d", (Object[])new Object[]{canRetry, reason, code});
                return true;
            }
        });
    }

    public void leaveRoomReq(final AbsVoiceRoom singleRoom) {
        if (singleRoom == null) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"leave room req,room:%s", (Object[])new Object[]{singleRoom});
        }
        Header header = ProtoManager.getInstance().getHeader("ikxd_room_d");
        LeaveRoomReq req = new LeaveRoomReq.Builder().build();
        Room room = new Room.Builder().header(header).uri(Uri.kUriLeaveRoomReq).session(singleRoom.mSessionId).leave_room_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)room, (IProtoCallback)new IProtoCallback<Room>(){

            public void onResponse(@Nullable Room message) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"leave room req, onResponse room:%s", (Object[])new Object[]{singleRoom});
                }
                RoomDataModel.this.onLeaveRoomRes(singleRoom, message);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"leave room req, timeout room:%s", (Object[])new Object[]{singleRoom.mSessionId});
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"leave room req, error room:%s", (Object[])new Object[]{singleRoom.mSessionId});
                }
                return false;
            }
        });
    }

    public void micOperateReq(final AbsVoiceRoom singleRoom, boolean micOpen) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"micOperateReq:%s!", (Object[])new Object[]{singleRoom.mSessionId});
        }
        Header header = ProtoManager.getInstance().getHeader("ikxd_room_d");
        MicOperateReq req = new MicOperateReq.Builder().mic(Boolean.valueOf(micOpen)).build();
        Room room = new Room.Builder().header(header).uri(Uri.kUriMicOperateReq).session(singleRoom.mSessionId).mic_operate_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)room, (IProtoCallback)new IProtoCallback<Room>(){

            public void onResponse(@Nullable Room message) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"micOperate req, onResponse room:%s", (Object[])new Object[]{singleRoom.mSessionId});
                }
                RoomDataModel.this.onMicOperateRes(singleRoom, message);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"micOperate req, error room:%s", (Object[])new Object[]{singleRoom.mSessionId});
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"micOperate req, error room:%s", (Object[])new Object[]{singleRoom.mSessionId});
                }
                return false;
            }
        });
    }

    public void roomHeartbeatReq(final AbsVoiceRoom absSingleRoom) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"roomHeartbeatReq:%s!", (Object[])new Object[]{absSingleRoom.mSessionId});
        }
        Header header = ProtoManager.getInstance().getHeader("ikxd_room_d");
        HeartbeatReq req = new HeartbeatReq.Builder().build();
        Room room = new Room.Builder().header(header).uri(Uri.kUriHeartbeatReq).session(absSingleRoom.mSessionId).heartbeat_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)room, (IProtoCallback)new IProtoCallback<Room>(){

            public void onResponse(@Nullable Room message) {
                RoomDataModel.this.onRoomHeartbeatRes(absSingleRoom, message);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"Heartbeat req, error room:%s", (Object[])new Object[]{absSingleRoom.mSessionId});
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)RoomDataModel.TAG, (String)"Heartbeat req, error room:%s", (Object[])new Object[]{absSingleRoom.mSessionId});
                }
                return false;
            }
        });
    }

    private void onRoomNotify(Room room) {
        String sessionId = room.session;
        if (room.uri == Uri.kUriStatusNotify) {
            StatusNotify status = room.status_notify;
            AbsVoiceRoom voiceRoom = null;
            if (!TextUtils.isEmpty((CharSequence)sessionId) && (voiceRoom = this.mRooms.get(sessionId)) != null) {
                voiceRoom.onRoomNotify(status, room.version);
            } else {
                MLog.error((Object)TAG, (String)"onRoomNotify can not found room for session id: %s", (Object[])new Object[]{sessionId});
            }
        } else {
            MLog.error((Object)TAG, (String)"onRoomNotify proto response error uri:%d, room: %s", (Object[])new Object[]{room.uri, room});
        }
    }

    private void onJoinRoomRes(AbsVoiceRoom singleRoom, Room room) {
        if (room == null || singleRoom == null) {
            MLog.error((Object)TAG, (String)"onJoinRoomRes proto response error", (Object[])new Object[0]);
            return;
        }
        String sessionId = room.session;
        if (room.uri == Uri.kUriJoinRoomRes) {
            JoinRoomRes res = room.join_room_res;
            if (this.mRooms.get(sessionId) == singleRoom) {
                singleRoom.onJoinRoomRes(res, room.version);
            }
        } else {
            MLog.error((Object)TAG, (String)"onJoinRoomRes proto response error uri:%d, room: %s", (Object[])new Object[]{room.uri, room});
        }
    }

    private void onLeaveRoomRes(AbsVoiceRoom singleRoom, Room room) {
        if (room == null || singleRoom == null) {
            MLog.error((Object)TAG, (String)"onJoinRoomRes proto response error, room is null", (Object[])new Object[0]);
            return;
        }
        String sessionId = room.session;
        if (room.uri == Uri.kUriLeaveRoomRes) {
            LeaveRoomRes res = room.leave_room_res;
            if (!TextUtils.isEmpty((CharSequence)sessionId) && this.mRooms.containsKey(sessionId) && this.mRooms.get(sessionId) != null) {
                if (this.mRooms.get(sessionId) == singleRoom) {
                    singleRoom.onLeaveRoomRes(res, room.version);
                }
            } else {
                MLog.error((Object)TAG, (String)"onJoinRoomRes can not found room for session id: %s", (Object[])new Object[]{sessionId});
            }
        } else {
            MLog.error((Object)TAG, (String)"onJoinRoomRes proto response error uri:%d, room: %s", (Object[])new Object[]{room.uri, room});
        }
    }

    private void onMicOperateRes(AbsVoiceRoom singleRoom, Room room) {
        if (room == null || singleRoom == null) {
            MLog.error((Object)TAG, (String)"onMicOperateRes proto response error, room is null", (Object[])new Object[0]);
            return;
        }
        String sessionId = room.session;
        if (room.uri == Uri.kUriMicOperateRes) {
            MicOperateRes res = room.mic_operate_res;
            if (!TextUtils.isEmpty((CharSequence)sessionId) && this.mRooms.containsKey(sessionId) && this.mRooms.get(sessionId) != null) {
                if (this.mRooms.get(sessionId) == singleRoom) {
                    singleRoom.onMicOperateRes(res, room.version);
                }
            } else {
                MLog.error((Object)TAG, (String)"onJoinRoomRes can not found room for session id: %s", (Object[])new Object[]{sessionId});
            }
        } else {
            MLog.error((Object)TAG, (String)"onJoinRoomRes proto response error uri:%d, room: %s", (Object[])new Object[]{room.uri, room});
        }
    }

    private void onRoomHeartbeatRes(AbsVoiceRoom singleRoom, Room room) {
        if (room == null || singleRoom == null) {
            MLog.error((Object)TAG, (String)"onRoomHeartbeatRes proto response error, room is null", (Object[])new Object[0]);
            return;
        }
        String sessionId = room.session;
        if (room.uri == Uri.kUriHeartbeatRes) {
            HeartbeatRes res = room.heartbeat_res;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoice", (String)("onRoomHeartbeatRes Voice Sdk = " + res.voice_sdk), (Object[])new Object[0]);
            }
            if (!TextUtils.isEmpty((CharSequence)sessionId) && this.mRooms.containsKey(sessionId) && this.mRooms.get(sessionId) != null) {
                if (this.mRooms.get(sessionId) == singleRoom) {
                    singleRoom.onRoomHeartbeatRes(res, room.version);
                }
            } else {
                MLog.error((Object)TAG, (String)"onRoomHeartbeatRes can not found room for session id: %s", (Object[])new Object[]{sessionId});
            }
        } else {
            MLog.error((Object)TAG, (String)"onRoomHeartbeatRes proto response error uri, room: %s", (Object[])new Object[]{room});
        }
    }

    public String serviceName() {
        return "ikxd_room_d";
    }

    public void onNotify(@NonNull Room notify) {
        this.onRoomNotify(notify);
    }
}

