/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.voice.base.roomvoice;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.model.RoomUserMicStatus;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.ISingleRoomCallbackNew;
import com.yy.hiyo.voice.base.roomvoice.RoomDef;
import ikxd.room.MicOperateRes;
import java.util.List;

public class BaseVoiceRoom
extends AbsVoiceRoom {
    private static final String TAG = "SingleRoom";
    public static final int DEF_CLOSE_MIC_TIME = 60000;

    public BaseVoiceRoom(@Nullable String sessionId, @NonNull ISingleRoomCallbackNew callback) {
        super(sessionId, callback);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"newRoom sessionId: %s", (Object[])new Object[]{sessionId});
        }
    }

    @Override
    public void onCreate(int scene) {
        this.mCallback.initMicStatus();
        boolean myMicStatus = this.mCallback.getMicStatus(this.mSessionId);
        if (myMicStatus && this.mCallback.micOperate(this.mSessionId, true, false, this.mCurVoiceType) != 0) {
            myMicStatus = false;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"myMicStatus = %s", (Object[])new Object[]{myMicStatus});
        }
        this.mMyStatus = new RoomUserMicStatus(AccountUtil.getUid(), myMicStatus);
        this.mCallback.joinRoomReq(this, myMicStatus);
        this.getRoomUserMicStatusList().add(this.mMyStatus);
        super.onCreate(scene);
    }

    @Override
    public void onPause(@RoomDef.RoomScene int scene) {
        boolean myMicStatus = this.mMyStatus.isMicOpen();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoice", (String)"App switch background onPause", (Object[])new Object[0]);
        }
        switch (scene) {
            case 4: {
                if (!myMicStatus) break;
                YYTaskExecutor.execute((Runnable)this.backCloseMicRunnable, (long)60000L);
                break;
            }
            default: {
                if (!myMicStatus) break;
                YYTaskExecutor.removeTask((Runnable)this.backCloseMicRunnable);
                this.pauseCloseMic();
            }
        }
        super.onPause(scene);
    }

    @Override
    public void onResume(int scene) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoice", (String)"App switch background onResume remove backCloseMicRunnable", (Object[])new Object[0]);
        }
        YYTaskExecutor.removeTask((Runnable)this.backCloseMicRunnable);
        this.resumeMic();
        super.onResume(scene);
    }

    @Override
    public void onDestory(int scene) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)(this.mSessionId + "onDestory"), (Object[])new Object[0]);
        }
        if (this.mMyStatus.isMicOpen()) {
            this.mCallback.micOperate(this.mSessionId, false, false, this.mCurVoiceType);
        }
        this.mCallback.micOperateReq(this, false);
        this.mCallback.leaveRoomReq(this);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoice", (String)"App switch background onDestory remove backCloseMicRunnable", (Object[])new Object[0]);
        }
        YYTaskExecutor.removeTask((Runnable)this.backCloseMicRunnable);
        super.onDestory(scene);
    }

    @Override
    public void onNetValidChanged(boolean lastStatus, boolean newStatus) {
        if (!lastStatus && newStatus && this.mMyStatus != null) {
            this.mCallback.joinRoomReq(this, this.mMyStatus.isMicOpen());
        }
    }

    @Override
    public synchronized void updateUserStatus(List<RoomUserMicStatus> list) {
        if (this.state == 2) {
            return;
        }
        boolean needRejoin = false;
        if (FP.empty(list)) {
            needRejoin = true;
        }
        if (!FP.empty(list) && list.size() == 1) {
            if (list.get(0).getUid() == AccountUtil.getUid()) {
                if (this.mOtherStatus.getUid() > 0L) {
                    this.mOtherStatus.reset();
                    this.getRoomUserMicStatusList().remove(this.mOtherStatus);
                }
            } else {
                needRejoin = true;
            }
        }
        boolean isContainsMe = false;
        if (!FP.empty(list)) {
            for (RoomUserMicStatus roomUserMicStatus : list) {
                if (roomUserMicStatus.getUid() == AccountUtil.getUid()) {
                    isContainsMe = true;
                    if (roomUserMicStatus.isMicOpen() == this.mMyStatus.isMicOpen()) continue;
                    needRejoin = true;
                    continue;
                }
                if (this.mOtherStatus.getUid() == 0L) {
                    this.mOtherStatus.setUid(roomUserMicStatus.getUid());
                    this.mOtherStatus.setMicOpen(roomUserMicStatus.isMicOpen());
                    this.getRoomUserMicStatusList().add(this.mOtherStatus);
                    continue;
                }
                if (roomUserMicStatus.getUid() != this.mOtherStatus.getUid()) continue;
                this.mOtherStatus.setMicOpen(roomUserMicStatus.isMicOpen());
            }
        }
        if (!isContainsMe) {
            needRejoin = true;
        }
        this.mUpdateDataTrace.trace();
        boolean traceUnNormal = this.mUpdateDataTrace.isTraceUnNormal();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"need rejoin room,need:%b, uid:%d, unnormal:%b", (Object[])new Object[]{needRejoin, AccountUtil.getUid(), traceUnNormal});
        }
        if (needRejoin && AccountUtil.getUid() > 0L && this.mCallback != null && !traceUnNormal) {
            this.mCallback.joinRoomReq(this, this.mMyStatus.isMicOpen());
        }
    }

    @Override
    public synchronized void onMicOperateRes(MicOperateRes res, long version) {
        if (res.mic.booleanValue()) {
            long voiceSdk = res.voice_sdk;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTVoice", (String)("onMicOperateRes res.getMic() = true voiceSdk_ = " + voiceSdk), (Object[])new Object[0]);
            }
            this.handleVoiceType(voiceSdk, false);
        }
        if (res.mic.booleanValue() != this.mMyStatus.isMicOpen()) {
            this.mCallback.joinRoomReq(this, this.mMyStatus.isMicOpen());
            return;
        }
    }

    @Override
    public void selectVoiceType(IKtvLiveServiceExtend.VoiceType type) {
        boolean isOpenMic = this.mMyStatus.isMicOpen();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTVoice", (String)("selectVoiceType is open mic = " + isOpenMic), (Object[])new Object[0]);
        }
        if (isOpenMic) {
            this.mCallback.selectVoiceType(type);
        }
    }
}

