/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.widget;

import android.content.Context;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.bbs.base.BBSBaseTrack;
import com.yy.hiyo.user.R;

public class ProfilePostAnimator {
    private View mPostView;
    private float mY;
    private Animation showAnim;
    private Animation dismissAnim;
    private boolean isPostViewShow = false;

    public ProfilePostAnimator(View postView, Context context) {
        this.mPostView = postView;
        this.showAnim = AnimationUtils.loadAnimation((Context)context, (int)R.anim.bottom_show);
        this.dismissAnim = AnimationUtils.loadAnimation((Context)context, (int)R.anim.bottom_dismiss);
        this.mPostView.setOnClickListener(v -> {
            Message message = Message.obtain();
            message.what = AppbaseMsgDef.MSG_OPEN_PUBLISH_WINDOW;
            message.arg1 = 10;
            message.arg2 = -1;
            MsgDispatcher.getInstance().sendMessage(message);
            BBSBaseTrack.INSTANCE.reportSendPostBtnClick("3", "");
        });
    }

    public void dispatchEvent(MotionEvent ev) {
        if (!this.isPostViewShow) {
            return;
        }
        switch (ev.getAction()) {
            case 0: {
                this.mY = ev.getRawY();
                break;
            }
            case 2: {
                float moveY = ev.getRawY();
                float offsetY = moveY - this.mY;
                this.mY = moveY;
                if (offsetY < 0.0f && Math.abs(offsetY) > 10.0f) {
                    this.onScrollToBottom();
                    break;
                }
                if (!(Math.abs(offsetY) > 10.0f)) break;
                this.onScrollToTop();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void onScrollToTop() {
        if (!this.mPostView.isShown()) {
            this.mPostView.clearAnimation();
            this.mPostView.startAnimation(this.showAnim);
            this.mPostView.setVisibility(0);
        }
    }

    private void onScrollToBottom() {
        if (this.mPostView.isShown()) {
            this.mPostView.clearAnimation();
            this.mPostView.startAnimation(this.dismissAnim);
            this.mPostView.setVisibility(8);
        }
    }

    public void setPostViewShow(boolean postViewShow) {
        this.isPostViewShow = postViewShow;
        if (this.mPostView == null) {
            return;
        }
        if (this.isPostViewShow) {
            this.mPostView.setVisibility(0);
        } else {
            this.mPostView.setVisibility(8);
        }
    }
}

