/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.appbar.AppBarLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.user.R;

public class ProfileHeaderAnimator
implements AppBarLayout.OnOffsetChangedListener {
    private static final float DAMP_RATIO = 0.2f;
    private static final float REFRESH_HEIGHT = ResolutionUtils.dip2Px((float)40.0f);
    private AppBarLayout mAppBarLayout;
    private YYImageView mImageRefresh;
    private Context mContext;
    private boolean isScrollHeader;
    private int scaledSlop;
    private float downX;
    private float downY;
    private float lastX;
    private float lastY;
    private ViewGroup mRlytHeader;
    private int height;
    private float distanceY;
    private boolean isInterceptor;
    private boolean isHorizon;
    private float pullHeight;
    private float pullRatio;
    private PullRefreshListener mPullRefreshListener;
    private boolean isRefreshing;
    private boolean isRecovering;
    private Animation animation;
    private int refreshTop;
    private float rotation;

    public ProfileHeaderAnimator(AppBarLayout appBarLayout, YYImageView imageRefresh, Context context, ViewGroup rlytHeader) {
        this.mAppBarLayout = appBarLayout;
        this.mImageRefresh = imageRefresh;
        this.mRlytHeader = rlytHeader;
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.scaledSlop = ViewConfiguration.get((Context)this.mContext).getScaledTouchSlop();
        this.mAppBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        this.animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.rotate_anim);
        this.animation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mImageRefresh.post(() -> {
            this.refreshTop = this.mImageRefresh.getTop();
            this.rotation = this.mImageRefresh.getRotation();
        });
        this.updateHeaderHeight();
    }

    public void updateHeaderHeight() {
        this.mRlytHeader.post(() -> {
            this.height = this.mRlytHeader.getHeight();
        });
    }

    public boolean dispatchHandler(MotionEvent event) {
        if (!this.isRecovering && !this.isRefreshing) {
            float x = event.getRawX();
            float y = event.getRawY();
            switch (event.getAction()) {
                case 0: {
                    if (!this.isScrollHeader) break;
                    this.downX = event.getRawX();
                    this.downY = event.getRawY();
                    this.distanceY = event.getRawY();
                    break;
                }
                case 2: {
                    if (this.isScrollHeader) {
                        this.lastX = x;
                        this.lastY = y;
                        float dx = Math.abs(this.lastX - this.downX);
                        float dy = Math.abs(this.lastY - this.downY);
                        if (dy - dx > 0.0f) {
                            float moveY;
                            if (this.distanceY == 0.0f) {
                                this.distanceY = event.getRawY();
                            }
                            if ((moveY = event.getRawY() - this.distanceY) > (float)this.scaledSlop) {
                                this.pullHeight = moveY * 0.2f;
                                this.mRlytHeader.getLayoutParams().height = (int)((float)this.height + this.pullHeight);
                                this.mRlytHeader.requestLayout();
                                float f = this.pullRatio = (double)(this.pullHeight / REFRESH_HEIGHT) > 1.0 ? 1.0f : this.pullHeight / REFRESH_HEIGHT;
                                if (!this.isRefreshing) {
                                    this.handlePull();
                                }
                                return true;
                            }
                        }
                        this.downX = this.lastX;
                        this.downY = this.lastY;
                        break;
                    }
                    this.distanceY = 0.0f;
                    break;
                }
                case 1: {
                    if (!(this.pullHeight > 0.0f) || this.isRecovering || this.isRefreshing) break;
                    this.isRecovering = true;
                    if (this.pullHeight >= REFRESH_HEIGHT && !this.isRefreshing) {
                        this.mPullRefreshListener.refresh();
                        this.isRefreshing = true;
                        this.refreshAnimal();
                    }
                    this.recover();
                    return true;
                }
            }
            this.lastX = x;
            this.lastY = y;
        }
        return false;
    }

    private void refreshAnimal() {
        this.mImageRefresh.startAnimation(this.animation);
    }

    private void recover() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(200L);
        animator.addUpdateListener(animation -> {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            if (this.isRecovering) {
                this.mRlytHeader.getLayoutParams().height = (int)((float)this.height + this.pullHeight - this.pullHeight * value);
                this.mRlytHeader.requestLayout();
                if (!this.isRefreshing) {
                    this.pullRatio *= 1.0f - value;
                    this.handlePull();
                }
            }
        });
        animator.addListener((Animator.AnimatorListener)new PullAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ProfileHeaderAnimator.this.pullHeight = 0.0f;
                ProfileHeaderAnimator.this.isRecovering = false;
            }
        });
        animator.start();
    }

    private void refreshed() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(200L);
        animator.addUpdateListener(animation -> {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            this.pullRatio *= 1.0f - value;
            this.rotation = this.mImageRefresh.getRotation();
            this.handlePull();
        });
        animator.addListener((Animator.AnimatorListener)new PullAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ProfileHeaderAnimator.this.isRefreshing = false;
            }
        });
        animator.start();
    }

    private void handlePull() {
        this.mImageRefresh.setScaleX((double)this.pullRatio < 0.2 ? 0.0f : this.pullRatio);
        this.mImageRefresh.setScaleY((double)this.pullRatio < 0.2 ? 0.0f : this.pullRatio);
        this.mImageRefresh.setRotation(this.rotation + 180.0f * this.pullRatio);
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)this.mImageRefresh.getLayoutParams();
        params.topMargin = (int)((float)(this.refreshTop - 30) + 30.0f * this.pullRatio);
    }

    public void finishRefresh() {
        if (this.isRefreshing) {
            this.mImageRefresh.clearAnimation();
            this.refreshed();
        }
    }

    public void setPullRefreshListener(PullRefreshListener pullRefreshListener) {
        this.mPullRefreshListener = pullRefreshListener;
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int i) {
        this.isScrollHeader = i >= 0;
    }

    private class PullAnimatorListener
    implements Animator.AnimatorListener {
        private PullAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface PullRefreshListener {
        public void refresh();
    }
}

