/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import androidx.core.widget.NestedScrollView;

public class ElasticScrollView
extends NestedScrollView {
    private View mView;
    private Rect mRect = new Rect();
    private int y;
    private boolean isFirst = true;
    private boolean isScrollerBottom;

    public ElasticScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        if (this.getChildCount() > 0) {
            this.mView = this.getChildAt(0);
        }
        super.onFinishInflate();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        int cy = (int)ev.getY();
        switch (action) {
            case 0: {
                break;
            }
            case 2: {
                int dy = cy - this.y;
                if (this.isFirst) {
                    dy = 0;
                    this.isFirst = false;
                }
                this.y = cy;
                if (!this.isScrollerBottom) break;
                if (this.mRect.isEmpty()) {
                    this.mRect.set(this.mView.getLeft(), this.mView.getTop(), this.mView.getRight(), this.mView.getBottom());
                }
                if (dy / 2 + this.mView.getTop() > this.mRect.top) {
                    this.mView.layout(this.mView.getLeft(), this.mView.getTop() + this.mView.getTop() - this.mRect.top, this.mView.getRight(), this.mView.getBottom() + this.mView.getTop() - this.mRect.top);
                    return super.onTouchEvent(ev);
                }
                this.mView.layout(this.mView.getLeft(), this.mView.getTop() + dy / 2, this.mView.getRight(), this.mView.getBottom() + dy / 2);
                return true;
            }
            case 1: {
                if (this.mRect.isEmpty()) break;
                this.resetPosition();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    private void resetPosition() {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, (float)this.mView.getTop(), (float)this.mRect.top);
        animation.setDuration(200L);
        animation.setFillAfter(true);
        this.mView.startAnimation((Animation)animation);
        this.mView.layout(this.mRect.left, this.mRect.top, this.mRect.right, this.mRect.bottom);
        this.mRect.setEmpty();
        this.isFirst = true;
    }

    public void setScrollerBottom(boolean isScrollerBottom) {
        this.isScrollerBottom = isScrollerBottom;
    }
}

