/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.adapter.ProfileGiftAdapter;
import com.yy.hiyo.user.profile.bean.CharismaBean;

public class CharismaView
extends YYRelativeLayout {
    private Context mContext;
    private RecyclerView recyclerView;
    private ProfileGiftAdapter profileGiftAdapter;
    private YYTextView charismaNum;
    private YYTextView mCharismaTitle;

    public CharismaView(Context context) {
        super(context);
        this.mContext = context;
        this.createView();
    }

    public CharismaView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.createView();
    }

    private void createView() {
        CharismaView.inflate((Context)this.mContext, (int)R.layout.layout_profile_gift, (ViewGroup)this);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)70.0f)));
        this.charismaNum = (YYTextView)this.findViewById(R.id.profile_charisma_num_tv);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.charisma_recycle);
        this.mCharismaTitle = (YYTextView)this.findViewById(R.id.profile_charisma_tv);
        this.mCharismaTitle.setText((CharSequence)(ResourceUtils.getString((int)R.string.short_tips_charisma) + ":"));
        this.profileGiftAdapter = new ProfileGiftAdapter();
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.mContext, 0, false);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.profileGiftAdapter);
        this.recyclerView.setLayoutFrozen(true);
        this.setBackgroundResource(R.drawable.select_f3f3f3_bg);
    }

    public void setCharismaBean(CharismaBean charismaBean) {
        this.profileGiftAdapter.setData(charismaBean.getList());
        String value = StringUtils.getFormatedNumber((long)charismaBean.getCharmValue(), (int)1);
        this.charismaNum.setText((CharSequence)value);
    }
}

