/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.BounceInterpolator;
import com.yy.base.memoryrecycle.views.YYImageView;

public class BottomSwitchView
extends YYImageView {
    private static final float DRAG_MAX_SCALE = 1.1f;
    private static final float DRAG_MIN_SCALE = 1.0f;
    private static final float DRAG_DEFAULT_SCALE = 1.0f;
    private static final float DRAG_SCALE_RANGE = 0.100000024f;
    private static final float CLICK_MIN_SCALE = 0.8f;
    private static final float CLICK_DEFAULT_SCALE = 1.0f;
    private ValueAnimator mDownAnimator;
    private ValueAnimator mUpAnimator;
    private ValueAnimator mTempAnimator;

    public BottomSwitchView(Context context) {
        this(context, null);
    }

    public BottomSwitchView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomSwitchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
    }

    public void onDrag(float scrollProgressPercent) {
        float per = Math.abs(scrollProgressPercent);
        float scale = 1.0f + 0.100000024f * per;
        this.setScale(scale);
    }

    public void onDragEnded() {
        ValueAnimator anim2 = this.buildAnimator(this.getScaleX(), 1.0f, 200, false);
        anim2.start();
    }

    private void setScale(float frac) {
        this.setScaleX(frac);
        this.setScaleY(frac);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled() && this.isClickable()) {
            switch (event.getAction() & event.getActionMasked()) {
                case 0: {
                    this.startDownAnimator(this.getScaleX(), 0.8f, 200);
                    break;
                }
                case 1: 
                case 3: {
                    this.startUpAnimator(this.getScaleX(), 1.0f, 350);
                    break;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private void startDownAnimator(float startValue, float endValue, int duration) {
        this.mDownAnimator = this.buildAnimator(startValue, endValue, duration, true);
        this.mDownAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (BottomSwitchView.this.mTempAnimator != null && !BottomSwitchView.this.mTempAnimator.isRunning()) {
                    BottomSwitchView.this.mTempAnimator.setFloatValues(new float[]{BottomSwitchView.this.getScaleX(), 1.0f});
                    BottomSwitchView.this.mTempAnimator.start();
                    BottomSwitchView.this.mTempAnimator = null;
                }
            }
        });
        this.mDownAnimator.start();
    }

    private void startUpAnimator(float startValue, float endValue, int duration) {
        if (this.mDownAnimator != null) {
            this.mUpAnimator = this.buildAnimator(startValue, endValue, duration, false);
            if (this.mDownAnimator.isRunning()) {
                this.mTempAnimator = this.mUpAnimator;
            } else {
                this.mUpAnimator.start();
            }
        }
    }

    private void startUpAnimatorNew(float startValue, float endValue, int duration) {
        this.mUpAnimator = this.buildAnimator(startValue, endValue, duration, false);
        this.mUpAnimator.start();
    }

    public void startDownAndUpAnimator() {
        this.mDownAnimator = this.buildAnimator(this.getScaleX(), 0.8f, 200, true);
        this.mDownAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BottomSwitchView.this.startUpAnimatorNew(BottomSwitchView.this.getScaleX(), 1.0f, 350);
            }
        });
        this.mDownAnimator.start();
    }

    private ValueAnimator buildAnimator(float startValue, float endValue, int duration, boolean isDown) {
        ValueAnimator anim2 = ValueAnimator.ofFloat((float[])new float[]{startValue, endValue});
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float frac = ((Float)animation.getAnimatedValue()).floatValue();
                BottomSwitchView.this.setScale(frac);
            }
        });
        anim2.setDuration((long)duration);
        if (!isDown) {
            anim2.setInterpolator((TimeInterpolator)new BounceInterpolator());
        }
        return anim2;
    }
}

