/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.textedit;

import android.content.Context;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.callback.OnTextEditSaveListener;
import com.yy.appbase.core.DefaultController;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.profile.textedit.ITextEditCallback;
import com.yy.hiyo.user.profile.textedit.TextEditWindow;

public class TextEditWindowController
extends DefaultController
implements ITextEditCallback {
    private TextEditWindow mWindow;
    private OnTextEditSaveListener callback = null;
    private boolean isNickname;
    private boolean needCheckSync;

    public TextEditWindowController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == UserMsgDef.OPEN_WINDOW_HOMETOWN_EDIT) {
            this.openWindow(ResourceUtils.getString((int)R.string.profile_hometown), ResourceUtils.getString((int)R.string.profile_edit_hint_hometown), 28, msg, false);
        } else if (msg.what == UserMsgDef.OPEN_WINDOW_NICKNAME_EDIT) {
            this.openWindow(ResourceUtils.getString((int)R.string.login_profile_nickname), ResourceUtils.getString((int)R.string.profile_edit_hint_nickname), 35, msg, true);
        } else if (msg.what == UserMsgDef.OPEN_WINDOW_CAREER_EDIT) {
            this.openWindow(ResourceUtils.getString((int)R.string.profile_career), ResourceUtils.getString((int)R.string.profile_edit_hint_career), 28, msg, false);
        } else if (msg.what == UserMsgDef.OPEN_WINDOW_BIO_EDIT) {
            this.openWindow(ResourceUtils.getString((int)R.string.edit_sign), ResourceUtils.getString((int)R.string.profile_edit_hint_bio), 140, msg, false);
        } else if (msg.what == UserMsgDef.CLOSE_WINDOW_TEXT_EDIT || msg.what == BaseMsgDef.CLOSE_WINDOW_TEXT_EDIT) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_EDIT_GROUP_NAME) {
            this.openWindow(ResourceUtils.getString((int)R.string.title_channel_name), ResourceUtils.getString((int)R.string.title_enter_channel_name), 30, msg, true);
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_EDIT_GROUP_NOTICE) {
            this.openWindow(ResourceUtils.getString((int)R.string.title_channel_notice), ResourceUtils.getString((int)R.string.title_enter_channel_notice), 500, msg, true);
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.OPEN_CHANNEL_NICK_EDIT) {
            this.openWindow(ResourceUtils.getString((int)R.string.title_channel_group_my_group_nick), "", 35, msg, true);
        }
    }

    private void openWindow(String title, String hintStr, int textLength, Message msg, boolean isNickname) {
        this.isNickname = isNickname;
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
        this.mWindow = new TextEditWindow(this.mContext, this);
        if (msg.obj instanceof OnTextEditSaveListener) {
            this.callback = (OnTextEditSaveListener)msg.obj;
        }
        this.needCheckSync = msg.getData().getBoolean("checkContentSync");
        this.mWindow.initTitle(textLength, title);
        if (msg.what == AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_EDIT_GROUP_NOTICE) {
            this.mWindow.initInputFilter(true, textLength);
        } else {
            this.mWindow.initInputFilter(false, textLength);
        }
        this.mWindow.setContentHintText(hintStr);
        if (this.callback != null) {
            this.mWindow.setContentText(this.callback.getText());
            this.callback.onInitExtraView(this.mWindow.getExtraContainer());
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
    }

    @Override
    public void onBack() {
        if (this.needCheckSync && this.mWindow != null && this.callback != null) {
            this.callback.onBack(this.mWindow.getContentText());
        } else {
            this.sendMessage(UserMsgDef.CLOSE_WINDOW_TEXT_EDIT);
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
            this.callback = null;
        }
    }

    @Override
    public void onSave() {
        if (this.callback != null && this.mWindow != null) {
            if (this.isNickname) {
                String nickname = StringUtils.clearWhite((Context)this.mContext, (String)this.mWindow.getContentText());
                if (TextUtils.isEmpty((CharSequence)nickname)) {
                    return;
                }
                this.callback.onTextSave(nickname);
            } else {
                this.callback.onTextSave(this.mWindow.getContentText());
            }
        }
        if (!this.needCheckSync) {
            this.sendMessage(UserMsgDef.CLOSE_WINDOW_TEXT_EDIT);
        }
    }
}

