/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.textedit;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import com.yy.appbase.inputfilter.NoticeInputFilter;
import com.yy.appbase.room.INoRoomMiniWindow;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.textedit.ITextEditCallback;

public class TextEditWindow
extends DefaultWindow
implements INoRoomMiniWindow {
    private int maxTextLength;
    private Context mContext;
    private ITextEditCallback mCallback;
    private SimpleTitleBar mTitleBar;
    private YYEditText mEtContent;
    private YYTextView mTvLimit;
    private YYFrameLayout mExtraContainer;
    InputFilter mFilter = new InputFilter(){

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (source.toString().contentEquals("\n")) {
                return "";
            }
            if (source.toString().startsWith(" ") && dstart == 0) {
                return TextEditWindow.this.deleteStartSpace(source.toString());
            }
            return null;
        }
    };

    public TextEditWindow(Context context, ITextEditCallback callback) {
        super(context, (UICallBacks)callback, "ProfileTextEdit");
        this.mContext = context;
        this.mCallback = callback;
        this.createView();
    }

    private void createView() {
        View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.window_profile_text_edit, null);
        this.mTitleBar = (SimpleTitleBar)rootView.findViewById(R.id.stb_title);
        this.mEtContent = (YYEditText)rootView.findViewById(R.id.et_content);
        this.mTvLimit = (YYTextView)rootView.findViewById(R.id.tv_limit);
        this.mExtraContainer = (YYFrameLayout)rootView.findViewById(R.id.fl_extra);
        this.getBaseLayer().addView(rootView);
        this.mEtContent.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                TextEditWindow.this.updateLimitText();
            }

            public void afterTextChanged(Editable s) {
                if (s.length() <= 0) {
                    TextEditWindow.this.mEtContent.setBackgroundResource(R.drawable.bg_hago_edit);
                } else if (s.length() < TextEditWindow.this.maxTextLength) {
                    TextEditWindow.this.mEtContent.setBackgroundResource(R.drawable.bg_profile_edit);
                } else {
                    TextEditWindow.this.mEtContent.setBackgroundResource(R.drawable.bg_profile_edit_invalid);
                }
            }
        });
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                TextEditWindow.this.mCallback.onBack();
            }
        });
    }

    public String getContentText() {
        String text = this.mEtContent.getText().toString();
        return text;
    }

    public void setContentHintText(String text) {
        this.mEtContent.setHint((CharSequence)text);
    }

    public void setContentText(String text) {
        this.mEtContent.setText((CharSequence)text);
        this.updateLimitText();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TextEditWindow.this.mEtContent.requestFocus();
                InputMethodManager inputMethodManager = (InputMethodManager)TextEditWindow.this.mEtContent.getContext().getSystemService("input_method");
                inputMethodManager.showSoftInput((View)TextEditWindow.this.mEtContent, 0);
                TextEditWindow.this.mEtContent.setSelection(TextEditWindow.this.mEtContent.getText().toString().length());
            }
        }, (long)500L);
    }

    public FrameLayout getExtraContainer() {
        return this.mExtraContainer;
    }

    private void updateLimitText() {
        int length;
        String text = this.mEtContent.getText().toString();
        this.mTvLimit.setText((CharSequence)(text.length() + "/" + this.maxTextLength));
        int n = length = FP.empty((CharSequence)text) ? 0 : text.length();
        if (length >= this.maxTextLength) {
            this.mTvLimit.setTextColor(ResourceUtils.getColor((int)R.color.color_ff4a6d));
        } else if (length > 0) {
            this.mTvLimit.setTextColor(ResourceUtils.getColor((int)R.color.edit_bottom_active));
        } else {
            this.mTvLimit.setTextColor(ResourceUtils.getColor((int)R.color.color_bbbbbb));
        }
    }

    public void initTitle(int textlength, String title) {
        this.maxTextLength = textlength;
        this.mTitleBar.setLeftTitle(title);
        this.mTitleBar.setRightBtn(R.drawable.selector_edit_profile_ok, new View.OnClickListener(){

            public void onClick(View v) {
                if (TextEditWindow.this.mEtContent != null) {
                    InputMethodManager imm = (InputMethodManager)TextEditWindow.this.mContext.getSystemService("input_method");
                    imm.hideSoftInputFromWindow(TextEditWindow.this.mEtContent.getWindowToken(), 0);
                }
                TextEditWindow.this.mCallback.onSave();
            }
        });
    }

    public void initInputFilter(boolean isChannelNotice, int textLength) {
        if (isChannelNotice) {
            this.mEtContent.setFilters(new InputFilter[]{new NoticeInputFilter()});
        } else {
            InputFilter.LengthFilter lengthInputFilter = new InputFilter.LengthFilter(textLength);
            this.mEtContent.setFilters(new InputFilter[]{this.mFilter, lengthInputFilter});
        }
    }

    private String deleteStartSpace(String content) {
        if (!content.startsWith(" ")) {
            return content;
        }
        for (int i = 0; i < content.length(); ++i) {
            if (content.charAt(i) == ' ') continue;
            return content.substring(i);
        }
        return "";
    }
}

