/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.sevice;

import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.callback.IQueryOnlineCallBack;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.Header;
import ikxd.online.GetUserStatusReq;
import ikxd.online.IKXDOnlineProto;
import ikxd.online.Uri;
import ikxd.online.UserOnlineStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OnlineService
extends DefaultController {
    private static final String TAG = "OnlineService";
    private static final int REQUEST_TIME_GAP = 1500;
    private final HashMap<Long, Boolean> mStatus = new HashMap();
    private final ArrayList<RequestItem> mWaitToRequestItem = new ArrayList();
    private volatile long mLastrequestTime = System.currentTimeMillis();
    private Runnable mRequestRunnable = new Runnable(){

        @Override
        public void run() {
            OnlineService.this.handleRequest();
        }
    };

    public OnlineService(Environment env) {
        super(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, Boolean> getOnlineStatus(ArrayList<Long> ids, IQueryOnlineCallBack callBack) {
        if (ids == null || ids.size() < 0) {
            if (callBack != null) {
                callBack.onError("11113", (Exception)new RuntimeException());
            }
            return new HashMap<Long, Boolean>(0);
        }
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(ids.size());
        Boolean stateResult = null;
        HashMap<Long, Boolean> hashMap = this.mStatus;
        synchronized (hashMap) {
            for (Long id2 : ids) {
                if (id2 == null) {
                    result.put(id2, false);
                    continue;
                }
                if (SystemUtils.isAI((long)id2)) {
                    result.put(id2, true);
                    continue;
                }
                stateResult = this.mStatus.get(id2);
                if (stateResult == null) {
                    result.put(id2, false);
                    continue;
                }
                result.put(id2, stateResult);
            }
        }
        long timeGap = System.currentTimeMillis() - this.mLastrequestTime;
        ArrayList<RequestItem> arrayList = this.mWaitToRequestItem;
        synchronized (arrayList) {
            this.mWaitToRequestItem.add(new RequestItem(ids, callBack));
        }
        YYTaskExecutor.removeTask((Runnable)this.mRequestRunnable);
        if (timeGap > 1500L || timeGap < 0L && timeGap < -1500L) {
            YYTaskExecutor.execute((Runnable)this.mRequestRunnable);
        } else {
            YYTaskExecutor.execute((Runnable)this.mRequestRunnable, (long)timeGap);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest() {
        this.mLastrequestTime = System.currentTimeMillis();
        ArrayList<RequestItem> arrayList = this.mWaitToRequestItem;
        synchronized (arrayList) {
            if (this.mWaitToRequestItem.size() == 0) {
                return;
            }
        }
        final ArrayList<RequestItem> requestItems = new ArrayList<RequestItem>();
        ArrayList<RequestItem> arrayList2 = this.mWaitToRequestItem;
        synchronized (arrayList2) {
            requestItems.addAll(this.mWaitToRequestItem);
            this.mWaitToRequestItem.clear();
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (RequestItem item : requestItems) {
            ArrayList<Long> ids;
            if (item == null || (ids = item.getUserIds()) == null) continue;
            for (Long uid : ids) {
                if (uid >= 900000000L && uid <= 900099999L || (uid & 0xFFFFFFFFFFFFFFFFL) < 65535L) continue;
                userIds.add(uid);
            }
        }
        if (userIds.size() <= 0) {
            this.handleData(requestItems, new ArrayList<UserOnlineStatus>(0));
            return;
        }
        GetUserStatusReq req = new GetUserStatusReq.Builder().uids(userIds).from_type(Long.valueOf(1L)).build();
        Long sendtime = System.currentTimeMillis();
        MLog.info((Object)TAG, (String)("sendtime" + sendtime), (Object[])new Object[0]);
        Header header = new Header.Builder().sname("ikxd_online_d").code(Long.valueOf(0L)).back_ground(Boolean.valueOf(!RuntimeContext.sIsForeground)).lang(SystemUtils.getLangAndCountry()).build();
        IKXDOnlineProto proto = new IKXDOnlineProto.Builder().header(header).uri(Uri.kUriGetUserStatusReq).user_online_status_req(req).build();
        final Object[] reTryTimes = new Object[]{3};
        ProtoManager.getInstance().send((AndroidMessage)proto, (IProtoCallback)new IProtoCallback<IKXDOnlineProto>(){

            public void onResponse(@Nullable IKXDOnlineProto response) {
                if (response == null) {
                    OnlineService.this.notifyError(requestItems, "11112", new RuntimeException("11112"));
                    return;
                }
                if (response.uri == Uri.kUriGetUserStatusRes) {
                    List items = response.user_online_status_res.user_list;
                    OnlineService.this.handleData(requestItems, items);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if ((Integer)reTryTimes[0] > 0) {
                    reTryTimes[0] = (Integer)reTryTimes[0] - 1;
                    return true;
                }
                OnlineService.this.notifyError(requestItems, "TimeOut", new RuntimeException("timeOut!"));
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if ((Integer)reTryTimes[0] > 0) {
                    reTryTimes[0] = (Integer)reTryTimes[0] - 1;
                    return true;
                }
                OnlineService.this.notifyError(requestItems, reason, new RuntimeException(reason));
                return false;
            }
        });
    }

    private void notifyError(final ArrayList<RequestItem> requestItems, final String errorCode, final RuntimeException e) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (RequestItem item : requestItems) {
                    if (item == null || item.callBack == null) continue;
                    item.callBack.onError(errorCode, (Exception)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(ArrayList<RequestItem> requestItems, List<UserOnlineStatus> onlineItems) {
        if (onlineItems != null && onlineItems.size() > 0) {
            HashMap<Long, Boolean> hashMap = this.mStatus;
            synchronized (hashMap) {
                for (UserOnlineStatus onlineItem : onlineItems) {
                    this.mStatus.put(onlineItem.uid, onlineItem.online);
                }
            }
        }
        HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
        for (RequestItem item : requestItems) {
            ArrayList<Long> ids;
            if (item == null || FP.empty(ids = item.getUserIds())) continue;
            hashMap = new HashMap();
            Boolean stateResult = null;
            HashMap<Long, Boolean> hashMap2 = this.mStatus;
            synchronized (hashMap2) {
                for (Long id2 : ids) {
                    if (SystemUtils.isAI((long)id2)) {
                        hashMap.put(id2, true);
                        continue;
                    }
                    stateResult = this.mStatus.get(id2);
                    if (stateResult == null) {
                        hashMap.put(id2, false);
                        continue;
                    }
                    hashMap.put(id2, stateResult);
                }
            }
            final HashMap<Long, Boolean> fResult = hashMap;
            final IQueryOnlineCallBack fCallBack = item.callBack;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (fCallBack != null) {
                        fCallBack.onSuccess(fResult);
                    }
                }
            });
        }
    }

    class RequestItem {
        private ArrayList<Long> userIds;
        IQueryOnlineCallBack callBack;

        RequestItem(ArrayList<Long> userIds, IQueryOnlineCallBack callBack) {
            if (!FP.empty(userIds)) {
                this.userIds = new ArrayList<Long>(userIds);
                this.userIds.remove(null);
            }
            this.callBack = callBack;
        }

        public ArrayList<Long> getUserIds() {
            if (FP.empty(this.userIds)) {
                return null;
            }
            return new ArrayList<Long>(this.userIds);
        }
    }
}

