/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.sevice;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IQueryUserBy3rdAccountCallBack;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.hiyo.user.profile.UserInfoKSConverter;
import com.yy.hiyo.user.profile.sevice.ProfileListBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountTransformService
extends DefaultController {
    private static final String TAG = "AccountTransformService";
    private final HashMap<String, UserInfoKS> mUserInfos = new HashMap(10);

    public AccountTransformService(Environment env) {
        super(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUserInfoByThirdPartyAccount(ArrayList<String> ids, final IQueryUserBy3rdAccountCallBack callBack) {
        if (ids == null || ids.size() <= 0) {
            if (callBack != null) {
                callBack.onError("11113", (Exception)new RuntimeException());
            }
            return;
        }
        final HashMap<String, UserInfoKS> result = new HashMap<String, UserInfoKS>();
        ArrayList<String> needRequest = new ArrayList<String>();
        UserInfoKS itemUser = null;
        for (String id2 : ids) {
            if (StringUtils.isEmpty((String)id2)) continue;
            HashMap<String, UserInfoKS> hashMap = this.mUserInfos;
            synchronized (hashMap) {
                itemUser = this.mUserInfos.get(id2);
            }
            if (itemUser != null) {
                result.put(id2, itemUser);
                continue;
            }
            needRequest.add(id2);
        }
        if (needRequest.size() == 0) {
            if (callBack != null) {
                callBack.onSuccess(result);
            }
            return;
        }
        String paramsData = this.createQureyParams(needRequest);
        if (StringUtils.isEmpty((String)paramsData)) {
            if (callBack != null) {
                callBack.onError("11113", (Exception)new RuntimeException("create request params error!"));
            }
            return;
        }
        String url = UriProvider.getIkxdSvrHost() + UriProvider.GET_USERINFO_BY_THIRDPARTY_ACCOUNT_PATH + "&token=" + String.valueOf(AccountUtil.getUid());
        HttpUtil.httpReqPostString((String)url, (String)paramsData, null, (INetRespCallback)new INetRespCallback<ProfileListBean>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)AccountTransformService.TAG, (String)("error =" + e), (Object[])new Object[0]);
                if (callBack != null) {
                    callBack.onError("11111", e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(String response, BaseResponseBean<ProfileListBean> parseData, int id2) {
                block15: {
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)AccountTransformService.TAG, (String)("success = " + response), (Object[])new Object[0]);
                    }
                    String resultCode = null;
                    String resultDescrip = null;
                    List<ProfileListBean.ProfileListUserItem> items = null;
                    boolean success = false;
                    try {
                        if (!parseData.isSuccess()) {
                            resultCode = String.valueOf(parseData.code);
                            resultDescrip = parseData.message;
                        } else {
                            success = true;
                            resultCode = String.valueOf(parseData.code);
                            if (parseData.data != null) {
                                items = ((ProfileListBean)parseData.data).user_info;
                            }
                        }
                    }
                    catch (Exception e) {
                        resultCode = "11112";
                        resultDescrip = "";
                    }
                    if (!success) {
                        if (callBack != null) {
                            callBack.onError(resultCode, (Exception)new RuntimeException(resultDescrip));
                        }
                        return;
                    }
                    try {
                        if (items == null || items.size() <= 0) break block15;
                        HashMap e = AccountTransformService.this.mUserInfos;
                        synchronized (e) {
                            for (ProfileListBean.ProfileListUserItem item : items) {
                                if (item == null || item.uid == null || StringUtils.isEmpty((String)item.bind_account) || item.ver == null) continue;
                                UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(item.uid.longValue());
                                UserInfoKSConverter.convertFrom(item, userInfoKS);
                                ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).saveUserInfo(userInfoKS);
                                result.put(item.bind_account, userInfoKS);
                                AccountTransformService.this.mUserInfos.put(item.bind_account, userInfoKS);
                            }
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)AccountTransformService.TAG, (String)("getUserInfoByThirdPartyAccount error: " + e.toString()), (Object[])new Object[0]);
                    }
                }
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }
        });
    }

    private String createQureyParams(ArrayList<String> ids) {
        JSONObject result = JsonParser.obtainJSONObject();
        JSONArray idsJosn = new JSONArray(ids);
        try {
            result.put("account", (Object)idsJosn);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            return "";
        }
        return result.toString();
    }
}

