/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.profilecard;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.R;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.user.profile.profilecard.MyRecycleImageView;
import com.yy.hiyo.user.profile.profilecard.OnVpItemClickListener;
import java.util.ArrayList;
import java.util.List;

public class ProfilePhotosVPAdapter
extends PagerAdapter {
    private static final String TAG = "ProfilePhotosVPAdapter";
    private final SparseArray<MyRecycleImageView> mPhotos = new SparseArray();
    private final List<String> mUrls = new ArrayList<String>();
    private OnVpItemClickListener mOnVpItemClickListener;
    private int mWidth;
    private int mHeight;
    private boolean mFirstPage = true;

    public ProfilePhotosVPAdapter(List<String> urls) {
        if (!FP.empty(urls)) {
            this.setData(urls);
        }
    }

    public void setData(List<String> urls) {
        if (FP.empty(urls)) {
            return;
        }
        boolean change = false;
        int size = urls.size();
        int oldSize = this.mUrls.size();
        while (this.mUrls.size() > size) {
            int position = this.mUrls.size() - 1;
            this.mUrls.remove(position);
            if (this.mPhotos.size() > position && this.mPhotos.get(position) != null) {
                this.mPhotos.remove(position);
            }
            change = true;
        }
        for (int i = 0; i < size; ++i) {
            String url = urls.get(i);
            if (i < oldSize) {
                String oldUrl = this.mUrls.get(i);
                if (!TextUtils.isEmpty((CharSequence)oldUrl) && oldUrl.equals(url)) continue;
                this.mUrls.set(i, url);
                if (this.mPhotos.size() > i && this.mPhotos.get(i) != null) {
                    ((MyRecycleImageView)((Object)this.mPhotos.get(i))).setTag(null);
                }
                change = true;
                continue;
            }
            this.mUrls.add(url);
            change = true;
        }
        if (change) {
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.mUrls.size();
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (object instanceof View) {
            MLog.info((Object)TAG, (String)"destroyItem", (Object[])new Object[0]);
            ((ViewPager)container).removeView((View)object);
            ((View)object).setTag(null);
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        String oldIconUrl = null;
        if (this.mPhotos.get(position) == null) {
            MyRecycleImageView imageView = new MyRecycleImageView(container.getContext(), this.mUrls.get(position));
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            imageView.setCornerRadius(ResolutionUtils.dip2Px((float)3.0f), ResolutionUtils.dip2Px((float)3.0f), 0.0f, 0.0f);
            this.mPhotos.put(position, (Object)imageView);
        } else {
            oldIconUrl = ((MyRecycleImageView)((Object)this.mPhotos.get((int)position))).iconUrl;
        }
        final MyRecycleImageView ivPhoto = (MyRecycleImageView)((Object)this.mPhotos.get(position));
        if (ivPhoto.getTag() instanceof Integer && (Integer)ivPhoto.getTag() == position) {
            container.addView((View)ivPhoto);
            return ivPhoto;
        }
        if (this.mFirstPage) {
            if (position == 0) {
                ivPhoto.setTag(position);
                if (!StringUtils.equal((String)oldIconUrl, (String)this.mUrls.get(position))) {
                    if (StringUtils.isNotEmpty((String)oldIconUrl)) {
                        MLog.info((Object)TAG, (String)"\u52a0\u8f7d\u7b2c\u4e00\u5f20\u56fe\u7247\uff0c\u51fa\u73b0\u591a\u6b21\u52a0\u8f7d %s new %s", (Object[])new Object[]{oldIconUrl, this.mUrls.get(position)});
                    }
                    ivPhoto.iconUrl = this.mUrls.get(position);
                    final Drawable defaultDrawable = ResourceUtils.getDrawable((int)R.drawable.icon_default_photo);
                    ImageLoader.with((ImageView)ivPhoto, (String)this.mUrls.get(position)).useHeif(true).placeholder(R.drawable.icon_default_photo).setOverride(false).setSize(this.mWidth, this.mHeight).load();
                    ImageLoader.loadBitmap((Context)ivPhoto.getContext(), (String)this.thumPhotoUrl(this.mUrls.get(position)), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                        public void onLoadFailed(Exception e) {
                        }

                        public void onResourceReady(Bitmap bitmap) {
                            if (ivPhoto.getBackground() == null || ivPhoto.getBackground() == defaultDrawable) {
                                ivPhoto.setImageDrawable((Drawable)new BitmapDrawable(bitmap));
                                MLog.info((Object)ProfilePhotosVPAdapter.TAG, (String)"\u7b2c\u4e00\u5f20\u56fe\u7247\u7f29\u7565\u56fe\u751f\u6548\uff01", (Object[])new Object[0]);
                            }
                        }
                    });
                }
            }
        } else {
            ImageLoader.with((ImageView)ivPhoto, (String)this.mUrls.get(position)).useHeif(true).placeholder(R.drawable.icon_default_photo).setOverride(false).setSize(this.mWidth, this.mHeight).load();
        }
        ((ViewPager)container).addView((View)ivPhoto);
        ivPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ProfilePhotosVPAdapter.this.mOnVpItemClickListener != null) {
                    int position = v.getTag() instanceof Integer ? (Integer)v.getTag() : 0;
                    ProfilePhotosVPAdapter.this.mOnVpItemClickListener.onItemClick(v, position);
                }
            }
        });
        return ivPhoto;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (positionOffset > 0.0f) {
            this.mFirstPage = false;
        }
    }

    public void onPageSelected(int position) {
        RecycleImageView ivPhoto;
        this.mFirstPage = false;
        if (FP.size(this.mPhotos) > position && (ivPhoto = (RecycleImageView)this.mPhotos.get(position)).getTag() == null && FP.size(this.mUrls) > position) {
            ImageLoader.with((ImageView)ivPhoto, (String)this.mUrls.get(position)).useHeif(true).placeholder(R.drawable.icon_default_photo).setOverride(false).setSize(this.mWidth, this.mHeight).load();
            ivPhoto.setTag((Object)position);
        }
    }

    private String thumPhotoUrl(String url) {
        return url + YYImageUtils.getThumbnailPostfix((int)75);
    }

    private String resizePhotoUrl(String url) {
        if (this.mWidth == 0 || this.mHeight == 0) {
            return url;
        }
        boolean useWebp = NAB.B.equals((Object)NewABDefine.ALBUM_WEBP.getTest());
        return url + YYImageUtils.getThumbnailPostfixPx((int)this.mWidth, (int)this.mHeight, (boolean)useWebp);
    }

    public int getItemPosition(@NonNull Object object) {
        return -2;
    }

    public void setOnVpItemClickListener(OnVpItemClickListener listener) {
        this.mOnVpItemClickListener = listener;
    }

    public void setPhotoSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }
}

