/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.profilecard;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IProfileDialogCallback;
import com.yy.appbase.service.callback.IProfileOperationCallback;
import com.yy.appbase.service.callback.OnAlbumCallback;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.user.profile.profilecard.ProfileCardDialog;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

public class ProfileCardManager {
    private static final String TAG = "ProfileCardManager";
    private ProfileCardDialog mProfileCardDialog;
    private IServiceManager mServiceManager;
    private List<String> mAlbumList = new ArrayList<String>();
    private KvoBinder mBinder;
    private IProfileDialogCallback mProfileCardDialogCallback = new IProfileDialogCallback(){

        public void onDismiss() {
            if (ProfileCardManager.this.mBinder != null) {
                ProfileCardManager.this.mBinder.clearAllKvoConnections();
            }
        }
    };

    public static ProfileCardManager newInstance() {
        return new ProfileCardManager();
    }

    public ProfileCardManager() {
        this.mBinder = new KvoBinder((Object)this);
    }

    public ProfileCardDialog create(Context context, IProfileOperationCallback callback, int direction, boolean isDefaultStyle) {
        this.mProfileCardDialog = new ProfileCardDialog(context, callback, this.mProfileCardDialogCallback, direction, isDefaultStyle, isDefaultStyle);
        this.mServiceManager = ServiceManagerProxy.getServiceManager();
        return this.mProfileCardDialog;
    }

    public void initData(final long targetUid) {
        if (this.mServiceManager != null) {
            ((IUserInfoService)this.mServiceManager.getService(IUserInfoService.class)).requestAlbum(targetUid, new OnAlbumCallback(){

                public void onUISuccess(List<String> list, long uid) {
                    if (targetUid == uid) {
                        MLog.info((Object)ProfileCardManager.TAG, (String)"onUISuccess", (Object[])new Object[0]);
                        if (list != null) {
                            ProfileCardManager.this.mAlbumList.addAll(list);
                        }
                        ProfileCardManager.this.updateUserInfo(targetUid);
                    }
                }

                public void onError(Call call, Exception e, int id2) {
                    MLog.info((Object)ProfileCardManager.TAG, (String)"onError:%s", (Object[])new Object[]{e});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProfileCardManager.this.updateUserInfo(targetUid);
                        }
                    });
                }

                public void onResponseError(int id2, String message, String response) {
                    MLog.info((Object)ProfileCardManager.TAG, (String)"onResponseError:%s", (Object[])new Object[]{message});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProfileCardManager.this.updateUserInfo(targetUid);
                        }
                    });
                }
            });
        }
    }

    @KvoMethodAnnotation(name="sign", sourceClass=UserInfoKS.class)
    public void onSignUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (userInfo != null && this.mProfileCardDialog != null) {
            this.mProfileCardDialog.updateSign(userInfo.sign);
        }
    }

    @KvoMethodAnnotation(name="hideLocation", sourceClass=UserInfoKS.class)
    public void onHideLocationUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (userInfo != null && this.mProfileCardDialog != null) {
            this.mProfileCardDialog.updateHideLocation(userInfo.hideLocation, userInfo.lastLoginLocation);
        }
    }

    @KvoMethodAnnotation(name="birthday", sourceClass=UserInfoKS.class)
    public void onBirthdayUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (userInfo != null && this.mProfileCardDialog != null) {
            this.mProfileCardDialog.updateAge(userInfo.birthday);
        }
    }

    @KvoMethodAnnotation(name="sex", sourceClass=UserInfoKS.class)
    public void onSexUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (userInfo != null && this.mProfileCardDialog != null) {
            this.mProfileCardDialog.updateSex(userInfo.sex);
        }
    }

    @KvoMethodAnnotation(name="nick", sourceClass=UserInfoKS.class)
    public void onNickUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (userInfo != null && this.mProfileCardDialog != null) {
            this.mProfileCardDialog.updateNick(userInfo.nick);
        }
    }

    private void updateUserInfo(long targetUid) {
        UserInfoKS cacheUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(targetUid, null);
        if (!this.checkUserInfo(cacheUserInfo)) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(targetUid, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    UserInfoKS userInfoKS;
                    if (!FP.empty(userInfoKSList) && (userInfoKS = userInfoKSList.get(0)) != null && ProfileCardManager.this.mProfileCardDialog != null) {
                        ProfileCardManager.this.mAlbumList.add(userInfoKS.avatar);
                        ProfileCardManager.this.mProfileCardDialog.updateUserInfo(userInfoKS, ProfileCardManager.this.mAlbumList);
                    }
                }

                public void onFail(int id2, String msg, String response) {
                }

                public int id() {
                    return 0;
                }
            });
        } else if (this.mProfileCardDialog != null) {
            this.mAlbumList.add(cacheUserInfo.avatar);
            this.mProfileCardDialog.updateUserInfo(cacheUserInfo, this.mAlbumList);
        }
    }

    private boolean checkUserInfo(UserInfoKS userInfoKS) {
        return !TextUtils.isEmpty((CharSequence)userInfoKS.birthday) && !TextUtils.isEmpty((CharSequence)userInfoKS.nick);
    }

    public void setCustomView(View view) {
        try {
            if (this.mProfileCardDialog != null) {
                this.mProfileCardDialog.setCustomView(view);
            }
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"\u51fa\u9519:%s", (Object[])new Object[]{e});
        }
    }
}

