/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.profilecard;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.callback.IProfileDialogCallback;
import com.yy.appbase.service.callback.IProfileOperationCallback;
import com.yy.appbase.ui.widget.MoveSpotLayout;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.profilecard.OnVpItemClickListener;
import com.yy.hiyo.user.profile.profilecard.ProfilePhotosVPAdapter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProfileCardDialog
implements BaseDialog {
    private static final String TAG = "ProfileCardPopupWindow";
    private ViewPager mViewPagerPhotots;
    private ProfilePhotosVPAdapter mPhotosVpAdapter;
    private List<String> mPhotoUrls;
    private IProfileOperationCallback mCallback;
    private IProfileDialogCallback mProfileDialogCallback;
    private MoveSpotLayout mLlytSpotContainer;
    private List<String> mAlbum = new ArrayList<String>();
    private TextView mTvAge;
    private ImageView mIvSex;
    private TextView mTvLocation;
    private TextView mTvSign;
    private TextView mTvName;
    private LinearLayout mLlSexAge;
    private LinearLayout mLlLocation;
    private RelativeLayout mRlProfileCard;
    private FrameLayout mFlProfileCardPhoto;
    private FrameLayout mFlCustomRoot;
    private FrameLayout mFlLeftOperation;
    private LinearLayout mLlRoot;
    private static final long HIDE_LOCATION = 1L;
    private static final long SHOW_LOCATION = 0L;
    public static final int TYPE_HOR = 0;
    public static final int TYPE_VER = 1;
    private int mDirection = 1;
    private UserInfoKS mUserInfoKs;
    private boolean mIsDefaultStyle = false;
    private ImageView mIvClose;
    private View mRootView;
    private long mUid;
    private FollowView mFollowView;
    private boolean mIsShowDefaultAdd = false;

    public ProfileCardDialog(Context context, IProfileOperationCallback callback, IProfileDialogCallback profileDialogCallback, int directionType, boolean isDefaultStyleStyle, boolean mIsShowDefaultAdd) {
        this.mCallback = callback;
        this.mProfileDialogCallback = profileDialogCallback;
        this.mDirection = directionType;
        this.mIsShowDefaultAdd = mIsShowDefaultAdd;
        this.mIsDefaultStyle = isDefaultStyleStyle;
        this.mRootView = View.inflate((Context)context, (int)R.layout.layout_profile_card_view, null);
        this.initView(this.mRootView);
    }

    private void initView(View view) {
        this.mRlProfileCard = (RelativeLayout)view.findViewById(R.id.rl_profile_card);
        this.mFlProfileCardPhoto = (FrameLayout)view.findViewById(R.id.rlyt_card_header);
        if (this.mIsDefaultStyle) {
            LinearLayout.LayoutParams profileCardParams = (LinearLayout.LayoutParams)this.mRlProfileCard.getLayoutParams();
            RelativeLayout.LayoutParams profileCardPhotoParams = (RelativeLayout.LayoutParams)this.mFlProfileCardPhoto.getLayoutParams();
            if (this.mDirection == 1) {
                profileCardParams.width = ResolutionUtils.dip2Px((float)275.0f);
                profileCardPhotoParams.height = ResolutionUtils.dip2Px((float)275.0f);
                profileCardPhotoParams.width = ResolutionUtils.dip2Px((float)275.0f);
            } else if (this.mDirection == 0) {
                int widthPix = this.getWidth();
                profileCardParams.width = ResolutionUtils.dip2Px((float)widthPix);
                profileCardPhotoParams.height = ResolutionUtils.dip2Px((float)widthPix);
                profileCardPhotoParams.width = ResolutionUtils.dip2Px((float)widthPix);
            }
            this.mRlProfileCard.setLayoutParams((ViewGroup.LayoutParams)profileCardParams);
            this.mFlProfileCardPhoto.setLayoutParams((ViewGroup.LayoutParams)profileCardPhotoParams);
        }
        this.mLlLocation = (LinearLayout)view.findViewById(R.id.llyt_profile_card_location);
        this.mViewPagerPhotots = (ViewPager)view.findViewById(R.id.vp_card_photos);
        this.mLlytSpotContainer = (MoveSpotLayout)view.findViewById(R.id.llyt_card_spots_container);
        this.mLlSexAge = (LinearLayout)view.findViewById(R.id.ll_profile_card_sex_age);
        this.mTvAge = (TextView)view.findViewById(R.id.tv_profile_card_age);
        this.mTvSign = (TextView)view.findViewById(R.id.tv_profile_card_sign);
        this.mTvLocation = (TextView)view.findViewById(R.id.tv_profile_card_location);
        this.mTvName = (TextView)view.findViewById(R.id.tv_profile_card_name);
        this.mIvSex = (ImageView)view.findViewById(R.id.iv_profile_card_sex);
        this.mFollowView = (FollowView)view.findViewById(R.id.follow_view);
        this.mIvClose = (ImageView)view.findViewById(R.id.iv_profile_card_close);
        this.mFlLeftOperation = (FrameLayout)view.findViewById(R.id.fl_left_operation);
        this.mTvAge.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mTvLocation.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mFlCustomRoot = (FrameLayout)view.findViewById(R.id.fl_profile_card_custom);
        this.mRlProfileCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ProfileCardDialog.this.mCallback != null) {
                    ProfileCardDialog.this.mCallback.onProfileClicked();
                }
            }
        });
        this.mViewPagerPhotots.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (ProfileCardDialog.this.mPhotosVpAdapter != null) {
                    ProfileCardDialog.this.mPhotosVpAdapter.onPageScrolled(position, positionOffset, positionOffsetPixels);
                }
                if (ProfileCardDialog.this.mLlytSpotContainer != null) {
                    ProfileCardDialog.this.mLlytSpotContainer.setMoveSpotPosition(position, positionOffset);
                }
            }

            public void onPageSelected(int position) {
                if (ProfileCardDialog.this.mPhotosVpAdapter != null) {
                    ProfileCardDialog.this.mPhotosVpAdapter.onPageSelected(position);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        if (this.mUserInfoKs != null) {
            MLog.info((Object)TAG, (String)"init\u65f6\u5019\u663e\u793a\u76f8\u518c", (Object[])new Object[0]);
            this.updateUserInfo(this.mUserInfoKs, this.mAlbum);
        }
        this.mLlRoot = (LinearLayout)view.findViewById(R.id.ll_profile_card_root);
        this.expandViewTouchDelegate((View)this.mIvClose);
    }

    private void initPhotos(List<String> albumList) {
        if (albumList == null) {
            MLog.info((Object)TAG, (String)"\u83b7\u53d6\u76f8\u518c\u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        if (this.mAlbum == null) {
            this.mAlbum = new ArrayList<String>();
        }
        this.mAlbum.clear();
        this.mAlbum.addAll(albumList);
        Collections.reverse(this.mAlbum);
        this.updateAlbum(this.mAlbum);
    }

    public void updateUserInfo(UserInfoKS userInfo, List<String> albumList) {
        if (userInfo == null) {
            return;
        }
        this.mUid = userInfo.uid;
        this.initPhotos(albumList);
        this.mUserInfoKs = userInfo;
        if (this.mTvName != null) {
            this.mTvName.setText((CharSequence)userInfo.nick);
        }
        if (this.mTvAge != null) {
            this.mTvAge.setText((CharSequence)(DateUtils.getAge((String)userInfo.birthday) + ""));
        }
        if (this.mTvSign != null) {
            if (TextUtils.isEmpty((CharSequence)userInfo.sign)) {
                this.mTvSign.setVisibility(8);
                this.updateLocationMargin(false);
            } else {
                this.mTvSign.setVisibility(0);
                this.mTvSign.setText((CharSequence)userInfo.sign);
                this.updateLocationMargin(true);
            }
        }
        if (this.mLlLocation != null && this.mTvLocation != null) {
            long isLocationShow = userInfo.hideLocation;
            if (isLocationShow == 1L) {
                this.mLlLocation.setVisibility(8);
            } else if (isLocationShow == 0L) {
                this.mLlLocation.setVisibility(0);
                if (!TextUtils.isEmpty((CharSequence)userInfo.lastLoginLocation)) {
                    this.mTvLocation.setText((CharSequence)userInfo.lastLoginLocation);
                } else {
                    this.mTvLocation.setText((CharSequence)ResourceUtils.getString((int)R.string.profile_no_location));
                }
            }
        }
        if (this.mLlSexAge != null && this.mIvSex != null) {
            if (userInfo.sex == 0) {
                this.mLlSexAge.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_profile_sex_female));
                this.mIvSex.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_female));
            } else {
                this.mIvSex.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_male));
                this.mLlSexAge.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_profile_sex_male));
            }
        }
        if (this.mIsShowDefaultAdd) {
            this.mFollowView.setFollowStatusListener((followStatus, oldStatus) -> this.mFollowView.setVisibility(followStatus.isFollow() ? 8 : 0));
            final String enterType = String.valueOf(25);
            this.mFollowView.setClickInterceptor(new IFollowClickInterceptor(){

                public boolean interceptor(RelationInfo followStatus) {
                    if (!followStatus.isFollow()) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "follow_click").put("follow_enter_type", enterType));
                    } else {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "no_follow_click").put("follow_enter_type", enterType));
                    }
                    return false;
                }
            });
            this.mFollowView.setVisibility(0);
            this.mFollowView.bindFollowStatus(this.mUid, FollowerUtils.INSTANCE.enterType2ePath(enterType));
        } else {
            this.mFollowView.setVisibility(8);
        }
    }

    private void updateAlbum(List<String> list) {
        this.mAlbum = list;
        this.updatePhotosVp(this.mAlbum);
    }

    private void updatePhotosVp(List<String> photoUrls) {
        if (this.mViewPagerPhotots == null) {
            return;
        }
        if (this.mPhotoUrls == null) {
            this.mPhotoUrls = photoUrls;
        } else {
            this.mPhotoUrls.clear();
            this.mPhotoUrls.addAll(photoUrls);
        }
        if (this.mPhotosVpAdapter == null) {
            this.mPhotosVpAdapter = new ProfilePhotosVPAdapter(this.mPhotoUrls);
            this.mPhotosVpAdapter.setPhotoSize(ResolutionUtils.dip2Px((float)this.getWidth()), ResolutionUtils.dip2Px((float)this.getWidth()));
            this.mViewPagerPhotots.setAdapter((PagerAdapter)this.mPhotosVpAdapter);
        } else {
            this.mPhotosVpAdapter.setData(this.mPhotoUrls);
        }
        this.mPhotosVpAdapter.setOnVpItemClickListener(new OnVpItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                if (ProfileCardDialog.this.mCallback != null) {
                    ProfileCardDialog.this.mCallback.onVpClicked();
                }
            }
        });
        int size = this.getPhotoesSize();
        this.mLlytSpotContainer.setSpots(size, this.mViewPagerPhotots.getCurrentItem());
    }

    private int getPhotoesSize() {
        int size = 0;
        size = this.mPhotoUrls == null ? 0 : this.mPhotoUrls.size();
        return size;
    }

    public void init(final Dialog dialog2) {
        if (this.mRootView != null && dialog2 != null && dialog2.getWindow() != null) {
            dialog2.getWindow().setLayout(-1, -1);
            dialog2.setContentView(this.mRootView, new ViewGroup.LayoutParams(-1, -1));
            dialog2.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    if (ProfileCardDialog.this.mProfileDialogCallback != null) {
                        ProfileCardDialog.this.mProfileDialogCallback.onDismiss();
                    }
                }
            });
            if (this.mIvClose != null) {
                this.mIvClose.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        dialog2.dismiss();
                    }
                });
            }
            if (this.mLlRoot != null) {
                this.mLlRoot.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        dialog2.dismiss();
                    }
                });
            }
        }
    }

    private void expandViewTouchDelegate(final View view) {
        ((View)view.getParent()).post(new Runnable(){

            @Override
            public void run() {
                Rect bounds = new Rect();
                view.setEnabled(true);
                view.getHitRect(bounds);
                bounds.top = view.getTop() + ResolutionUtils.dip2Px((float)150.0f);
                bounds.bottom = view.getBottom() + ResolutionUtils.dip2Px((float)150.0f);
                bounds.left = view.getLeft() + ResolutionUtils.dip2Px((float)150.0f);
                bounds.right = view.getRight() + ResolutionUtils.dip2Px((float)150.0f);
                TouchDelegate touchDelegate = new TouchDelegate(bounds, view);
                if (View.class.isInstance(view.getParent())) {
                    ((View)view.getParent()).setTouchDelegate(touchDelegate);
                }
            }
        });
    }

    private int getWidth() {
        int widthPixels = ScreenUtils.getInstance().getWidthPixels();
        if (widthPixels >= 720) {
            return 225;
        }
        return 275 * widthPixels / 720;
    }

    public int getId() {
        return DialogId.ProfileCardDialog;
    }

    public void setCustomView(View view) {
        if (view != null && this.mFlCustomRoot != null) {
            this.mFlCustomRoot.addView(view);
        }
    }

    public void setCustomLeftView(View view) {
        if (view != null && this.mFlLeftOperation != null) {
            this.mFlLeftOperation.addView(view);
        }
    }

    public void updateSign(String sign) {
        if (this.mTvSign != null) {
            if (TextUtils.isEmpty((CharSequence)sign)) {
                this.mTvSign.setVisibility(8);
                this.updateLocationMargin(false);
            } else {
                this.mTvSign.setVisibility(0);
                this.mTvSign.setText((CharSequence)sign);
                this.updateLocationMargin(true);
            }
        }
    }

    private void updateLocationMargin(boolean isSignVisible) {
        if (isSignVisible) {
            if (this.mLlSexAge != null && this.mLlLocation != null) {
                RelativeLayout.LayoutParams sexAgeLayoutParams = (RelativeLayout.LayoutParams)this.mLlSexAge.getLayoutParams();
                RelativeLayout.LayoutParams locationLayoutParams = (RelativeLayout.LayoutParams)this.mLlLocation.getLayoutParams();
                sexAgeLayoutParams.bottomMargin = ResolutionUtils.dip2Px((float)6.0f);
                locationLayoutParams.bottomMargin = ResolutionUtils.dip2Px((float)6.0f);
                this.mLlSexAge.setLayoutParams((ViewGroup.LayoutParams)sexAgeLayoutParams);
                this.mLlLocation.setLayoutParams((ViewGroup.LayoutParams)locationLayoutParams);
            }
        } else if (this.mLlSexAge != null && this.mLlLocation != null) {
            RelativeLayout.LayoutParams sexAgeLayoutParams = (RelativeLayout.LayoutParams)this.mLlSexAge.getLayoutParams();
            RelativeLayout.LayoutParams locationLayoutParams = (RelativeLayout.LayoutParams)this.mLlLocation.getLayoutParams();
            sexAgeLayoutParams.bottomMargin = ResolutionUtils.dip2Px((float)13.0f);
            locationLayoutParams.bottomMargin = ResolutionUtils.dip2Px((float)13.0f);
            this.mLlSexAge.setLayoutParams((ViewGroup.LayoutParams)sexAgeLayoutParams);
            this.mLlLocation.setLayoutParams((ViewGroup.LayoutParams)locationLayoutParams);
        }
    }

    public void updateAge(String birthday) {
        if (this.mTvAge != null) {
            this.mTvAge.setText((CharSequence)(DateUtils.getAge((String)birthday) + ""));
        }
    }

    public void updateSex(int sex) {
        if (this.mLlSexAge != null && this.mIvSex != null) {
            if (sex == 0) {
                this.mLlSexAge.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_profile_sex_female));
                this.mIvSex.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_female));
            } else {
                this.mIvSex.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_male));
                this.mLlSexAge.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_profile_sex_male));
            }
        }
    }

    public void updateNick(String nick) {
        if (this.mTvName != null) {
            this.mTvName.setText((CharSequence)nick);
        }
    }

    public void updateHideLocation(long hideLocation, String lastLoginLocation) {
        if (this.mLlLocation != null && this.mTvLocation != null) {
            if (hideLocation == 1L) {
                this.mLlLocation.setVisibility(8);
            } else if (hideLocation == 0L) {
                this.mLlLocation.setVisibility(0);
                if (!TextUtils.isEmpty((CharSequence)lastLoginLocation)) {
                    this.mTvLocation.setText((CharSequence)lastLoginLocation);
                } else {
                    this.mTvLocation.setText((CharSequence)ResourceUtils.getString((int)R.string.profile_no_location));
                }
            }
        }
    }
}

