/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.leaderboard;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.leaderboard.ILeaderboardCallback;
import com.yy.hiyo.user.profile.leaderboard.bean.GameHistoryLikeBean;
import com.yy.hiyo.user.profile.leaderboard.bean.GameHistoryOtherBean;
import com.yy.hiyo.user.profile.leaderboard.viewholder.ProfileGameHistoryLikeViewHolder;
import com.yy.hiyo.user.profile.leaderboard.viewholder.ProfileGameHistoryOtherViewHolder;
import com.yy.hiyo.user.profile.leaderboard.viewholder.ProfileGameHistoryViewHolder;
import java.util.ArrayList;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;

public class NewLeaderboardWindow
extends DefaultWindow {
    private Context mContext;
    private ILeaderboardCallback mCallback;
    private SimpleTitleBar mTitleBar;
    private RecyclerView mRvGame;
    private MultiTypeAdapter mAdapter;

    public NewLeaderboardWindow(Context context, ILeaderboardCallback callback) {
        super(context, (UICallBacks)callback, "NewLeaderboard");
        this.mContext = context;
        this.mCallback = callback;
        this.createView();
    }

    private void createView() {
        View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.window_profile_leaderboard, null);
        this.mTitleBar = (SimpleTitleBar)rootView.findViewById(R.id.stb_title);
        this.mRvGame = (RecyclerView)rootView.findViewById(R.id.recycler_view_game);
        this.initTitle();
        this.mAdapter = new MultiTypeAdapter();
        this.mAdapter.register(GameHistoryBean.class, (ItemViewBinder)new ItemViewBinder<GameHistoryBean, ProfileGameHistoryViewHolder>(){

            @NonNull
            protected ProfileGameHistoryViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                View view = inflater.inflate(R.layout.view_leaderboard_item, parent, false);
                return new ProfileGameHistoryViewHolder(view);
            }

            protected void onBindViewHolder(@NonNull ProfileGameHistoryViewHolder holder, final @NonNull GameHistoryBean gameHistoryBean) {
                ImageLoader.loadImage((ImageView)holder.ivIcon, (String)gameHistoryBean.iconUrl, (int)R.drawable.ico_profile_default_avatar, (int)R.drawable.ico_profile_default_avatar);
                holder.tvGameName.setText((CharSequence)gameHistoryBean.gameName);
                holder.tvGamePlayCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.game_history_play) + " " + gameHistoryBean.totalCount));
                switch (gameHistoryBean.gameMode) {
                    case 1: {
                        holder.tvGameType.setVisibility(8);
                        holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_game_win) + " " + gameHistoryBean.winCount));
                        break;
                    }
                    case 2: {
                        holder.tvGameType.setVisibility(8);
                        break;
                    }
                    case 3: {
                        holder.tvGameType.setVisibility(0);
                        holder.tvGameType.setText((CharSequence)ResourceUtils.getString((int)R.string.game_mode_stand_alone));
                        holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_best_record) + " " + gameHistoryBean.historyBestScore));
                        break;
                    }
                    case 4: {
                        if (!TextUtils.isEmpty((CharSequence)gameHistoryBean.tag)) {
                            holder.tvGameType.setVisibility(0);
                            holder.tvGameType.setText((CharSequence)gameHistoryBean.tag);
                        } else {
                            holder.tvGameType.setVisibility(8);
                        }
                        holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_game_win) + " " + gameHistoryBean.winCount));
                        break;
                    }
                    case 5: {
                        holder.tvGameType.setVisibility(0);
                        holder.tvGameType.setText((CharSequence)ResourceUtils.getString((int)R.string.team_game_room_player_count_tips, (Object[])new Object[]{gameHistoryBean.playerCount}));
                        holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_best_record) + " " + gameHistoryBean.historyBestScore));
                        break;
                    }
                    case 6: {
                        if (!TextUtils.isEmpty((CharSequence)gameHistoryBean.tag)) {
                            holder.tvGameType.setVisibility(0);
                            holder.tvGameType.setText((CharSequence)gameHistoryBean.tag);
                        } else {
                            holder.tvGameType.setVisibility(8);
                        }
                        if (gameHistoryBean.subMode == 1000) {
                            holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_best_record) + " " + gameHistoryBean.historyBestScore));
                            break;
                        }
                        if (gameHistoryBean.subMode == 1001) {
                            holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_game_win) + " " + gameHistoryBean.winCount));
                            break;
                        }
                        holder.tvGameWinCount.setText((CharSequence)"");
                        break;
                    }
                    default: {
                        holder.tvGameType.setVisibility(8);
                    }
                }
                if (NewLeaderboardWindow.this.isSwitchOn()) {
                    holder.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByGid(gameHistoryBean.gameId);
                            String url = "";
                            url = gameInfo != null && gameInfo.fromSource == GameInfoSource.FLOAT_PLAY ? "hago://float/play?type=1&playId=" + gameHistoryBean.gameId : "hago://game/jumpGame?scrollTo=true&gameId=" + gameHistoryBean.gameId;
                            ((IYYUriService)ServiceManagerProxy.getInstance().getService(IYYUriService.class)).handleUriString(url);
                        }
                    });
                }
            }
        });
        this.mAdapter.register(GameHistoryLikeBean.class, (ItemViewBinder)new ItemViewBinder<GameHistoryLikeBean, ProfileGameHistoryLikeViewHolder>(){

            @NonNull
            protected ProfileGameHistoryLikeViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                View view = inflater.inflate(R.layout.litem_game_new_history, parent, false);
                return new ProfileGameHistoryLikeViewHolder(view);
            }

            protected void onBindViewHolder(@NonNull ProfileGameHistoryLikeViewHolder holder, @NonNull GameHistoryLikeBean item) {
                holder.mTextView.setText((CharSequence)(item.likeNume + " games you both like"));
            }
        });
        this.mAdapter.register(GameHistoryOtherBean.class, (ItemViewBinder)new ItemViewBinder<GameHistoryOtherBean, ProfileGameHistoryOtherViewHolder>(){

            @NonNull
            protected ProfileGameHistoryOtherViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                View view = inflater.inflate(R.layout.litem_game_new_history, parent, false);
                return new ProfileGameHistoryOtherViewHolder(view);
            }

            protected void onBindViewHolder(@NonNull ProfileGameHistoryOtherViewHolder holder, @NonNull GameHistoryOtherBean item) {
                holder.mTextView.setText((CharSequence)"Other Game");
            }
        });
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.mContext);
        this.mRvGame.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.getBaseLayer().addView(rootView);
    }

    private boolean isSwitchOn() {
        CommonConfigData data;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig && (data = ((CommonConfig)config).getData()) != null) {
            return data.favouriteGameJumpSwitch;
        }
        return true;
    }

    private void initTitle() {
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.profile_games));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                NewLeaderboardWindow.this.mCallback.onBack();
            }
        });
    }

    public void setWindowAdapter(List<GameHistoryBean> likeGame, List<GameHistoryBean> otherGame) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        if (likeGame != null && likeGame.size() > 0) {
            GameHistoryLikeBean gameHistoryLikeBean = new GameHistoryLikeBean();
            gameHistoryLikeBean.likeNume = likeGame.size();
            dataList.add(gameHistoryLikeBean);
            dataList.addAll(likeGame);
            dataList.add(new GameHistoryOtherBean());
        }
        dataList.addAll(otherGame);
        this.mAdapter.setItems(dataList);
        this.mRvGame.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }
}

