/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.leaderboard;

import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.LanguageUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.profile.leaderboard.ILeaderboardCallback;
import com.yy.hiyo.user.profile.leaderboard.LeaderboardWindow;
import com.yy.hiyo.user.profile.leaderboard.NewLeaderboardWindow;
import com.yy.hiyo.user.profile.leaderboard.bean.NewGameHistoryBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Call;

public class LeaderboardWindowController
extends DefaultController
implements ILeaderboardCallback {
    private LeaderboardWindow mWindow;
    private NewLeaderboardWindow mNewWindow;
    private List<GameHistoryBean> mGameHistoryList;

    public LeaderboardWindowController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == UserMsgDef.OPEN_WINDOW_LEADERBOARD) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            List tempList = new ArrayList();
            if (msg.obj instanceof List) {
                tempList = (List)msg.obj;
                this.mGameHistoryList = tempList;
            }
            this.mWindow = new LeaderboardWindow(this.mContext, this);
            this.mWindow.setWindowAdapter(this.mGameHistoryList);
            if (msg.obj instanceof Bundle && tempList.isEmpty()) {
                long uid = ((Bundle)msg.obj).getLong("uid");
                if (uid != 0L) {
                    this.getGameHistory(uid);
                } else {
                    MLog.error((Object)"LeaczderboardWindowController", (String)"uid is 0", (Object[])new Object[0]);
                }
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        } else if (msg.what == UserMsgDef.CLOSE_WINDOW_LEADERBOARD) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        } else if (msg.what == UserMsgDef.OPEN_WINDOW_NEW_LEADERBOARD) {
            if (this.mNewWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mNewWindow);
            }
            if (msg.obj instanceof NewGameHistoryBean) {
                NewGameHistoryBean gameHistoryBean = (NewGameHistoryBean)msg.obj;
                this.mNewWindow = new NewLeaderboardWindow(this.mContext, this);
                this.mNewWindow.setWindowAdapter(gameHistoryBean.likeGame, gameHistoryBean.otherGame);
                this.mWindowMgr.pushWindow((AbstractWindow)this.mNewWindow, true);
            }
        } else if (msg.what == UserMsgDef.CLOSE_WINDOW_NEW_LEADERBOARD) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mNewWindow);
            this.mNewWindow = null;
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
        if (this.mNewWindow == abstractWindow) {
            this.mNewWindow = null;
        }
    }

    @Override
    public void onBack() {
        this.sendMessage(UserMsgDef.CLOSE_WINDOW_LEADERBOARD);
        this.sendMessage(UserMsgDef.CLOSE_WINDOW_NEW_LEADERBOARD);
    }

    public void getGameHistory(long uid) {
        MLog.info((Object)"LeaderboardWindowController", (String)"start to get game history", (Object[])new Object[0]);
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getGameHistory(uid, new OnGameHistoryCallback(){

            public void onUISuccess(List<GameHistoryBean> list, int id2) {
                if (LanguageUtils.isRtl()) {
                    Collections.reverse(list);
                }
                LeaderboardWindowController.this.mGameHistoryList = list;
                if (LeaderboardWindowController.this.mWindow != null) {
                    LeaderboardWindowController.this.mWindow.setWindowAdapter(LeaderboardWindowController.this.mGameHistoryList);
                }
            }

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)"getGameHistory", (String)"onError e=%s", (Throwable)e, (Object[])new Object[0]);
            }

            public void onResponseError(int id2, String message, String response) {
                MLog.error((Object)"getGameHistory", (String)"onResponseError message=%s, reponse =%s", (Object[])new Object[]{message, response});
            }
        });
    }
}

