/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.leaderboard;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.leaderboard.ILeaderboardCallback;
import com.yy.hiyo.user.profile.leaderboard.LeaderboardAdapter;
import java.util.List;

public class LeaderboardWindow
extends DefaultWindow {
    private Context mContext;
    private ILeaderboardCallback mCallback;
    private SimpleTitleBar mTitleBar;
    private RecyclerView mRvGame;

    public LeaderboardWindow(Context context, ILeaderboardCallback callback) {
        super(context, (UICallBacks)callback, "ProfileLeaderboard");
        this.mContext = context;
        this.mCallback = callback;
        this.createView();
    }

    private void createView() {
        View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.window_profile_leaderboard, null);
        this.mTitleBar = (SimpleTitleBar)rootView.findViewById(R.id.stb_title);
        this.mRvGame = (RecyclerView)rootView.findViewById(R.id.recycler_view_game);
        this.initTitle();
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.mContext);
        this.mRvGame.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.getBaseLayer().addView(rootView);
    }

    private void initTitle() {
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.profile_games));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                LeaderboardWindow.this.mCallback.onBack();
            }
        });
    }

    public void setWindowAdapter(List<GameHistoryBean> list) {
        this.mRvGame.setAdapter((RecyclerView.Adapter)new LeaderboardAdapter(list));
    }
}

