/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.leaderboard;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.user.R;
import java.util.List;

public class LeaderboardAdapter
extends RecyclerView.Adapter<LeaderboardViewholder> {
    private List<GameHistoryBean> mData;

    public LeaderboardAdapter(List<GameHistoryBean> list) {
        this.mData = list;
    }

    @NonNull
    public LeaderboardViewholder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new LeaderboardViewholder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.view_leaderboard_item, parent, false));
    }

    public void onBindViewHolder(@NonNull LeaderboardViewholder holder, int position) {
        final GameHistoryBean gameHistoryBean = this.mData.get(position);
        ImageLoader.loadImage((ImageView)holder.ivIcon, (String)gameHistoryBean.iconUrl, (int)R.drawable.ico_profile_default_avatar, (int)R.drawable.ico_profile_default_avatar);
        holder.tvGameName.setText((CharSequence)gameHistoryBean.gameName);
        holder.tvGamePlayCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.game_history_play) + " " + gameHistoryBean.totalCount));
        switch (gameHistoryBean.gameMode) {
            case 1: {
                holder.tvGameType.setVisibility(8);
                holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_game_win) + " " + gameHistoryBean.winCount));
                break;
            }
            case 2: {
                holder.tvGameType.setVisibility(8);
                break;
            }
            case 3: {
                holder.tvGameType.setVisibility(0);
                holder.tvGameType.setText((CharSequence)ResourceUtils.getString((int)R.string.game_mode_stand_alone));
                holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_best_record) + " " + gameHistoryBean.historyBestScore));
                break;
            }
            case 4: {
                if (!TextUtils.isEmpty((CharSequence)gameHistoryBean.tag)) {
                    holder.tvGameType.setVisibility(0);
                    holder.tvGameType.setText((CharSequence)gameHistoryBean.tag);
                } else {
                    holder.tvGameType.setVisibility(8);
                }
                holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_game_win) + " " + gameHistoryBean.winCount));
                break;
            }
            case 5: {
                holder.tvGameType.setVisibility(0);
                holder.tvGameType.setText((CharSequence)ResourceUtils.getString((int)R.string.team_game_room_player_count_tips, (Object[])new Object[]{gameHistoryBean.playerCount}));
                holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_best_record) + " " + gameHistoryBean.historyBestScore));
                break;
            }
            case 6: {
                if (!TextUtils.isEmpty((CharSequence)gameHistoryBean.tag)) {
                    holder.tvGameType.setVisibility(0);
                    holder.tvGameType.setText((CharSequence)gameHistoryBean.tag);
                } else {
                    holder.tvGameType.setVisibility(8);
                }
                if (gameHistoryBean.subMode == 1000) {
                    holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_best_record) + " " + gameHistoryBean.historyBestScore));
                    break;
                }
                if (gameHistoryBean.subMode == 1001) {
                    holder.tvGameWinCount.setText((CharSequence)(ResourceUtils.getString((int)R.string.profile_game_win) + " " + gameHistoryBean.winCount));
                    break;
                }
                holder.tvGameWinCount.setText((CharSequence)"");
                break;
            }
            default: {
                holder.tvGameType.setVisibility(8);
            }
        }
        if (this.isSwitchOn()) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByGid(gameHistoryBean.gameId);
                    String url = "";
                    url = gameInfo != null && gameInfo.fromSource == GameInfoSource.FLOAT_PLAY ? "hago://float/play?type=1&playId=" + gameHistoryBean.gameId : "hago://game/jumpGame?scrollTo=true&gameId=" + gameHistoryBean.gameId;
                    ((IYYUriService)ServiceManagerProxy.getInstance().getService(IYYUriService.class)).handleUriString(url);
                }
            });
        }
    }

    private boolean isSwitchOn() {
        CommonConfigData data;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig && (data = ((CommonConfig)config).getData()) != null) {
            return data.favouriteGameJumpSwitch;
        }
        return true;
    }

    public int getItemCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    class LeaderboardViewholder
    extends RecyclerView.ViewHolder {
        public RoundConerImageView ivIcon;
        public YYTextView tvGameName;
        public YYTextView tvGameType;
        public YYTextView tvGamePlayCount;
        public YYTextView tvGameWinCount;

        LeaderboardViewholder(View itemView) {
            super(itemView);
            this.ivIcon = (RoundConerImageView)itemView.findViewById(R.id.rciv_game_cover);
            this.tvGameName = (YYTextView)itemView.findViewById(R.id.tv_game_name);
            this.tvGameType = (YYTextView)itemView.findViewById(R.id.tv_game_type);
            this.tvGamePlayCount = (YYTextView)itemView.findViewById(R.id.tv_game_play_count);
            this.tvGameWinCount = (YYTextView)itemView.findViewById(R.id.tv_game_win_count);
        }
    }
}

