/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.instagramphotos;

import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.view.View;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.ViewDimension;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnGetInsPhotosCallback;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.camera.base.ImageOpenLargeHelper;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.profile.instagramphotos.IInstagramPhotosCallback;
import com.yy.hiyo.user.profile.instagramphotos.InstagramPhotosWindow;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

public class InstagramPhotosWindowController
extends DefaultController
implements IInstagramPhotosCallback {
    private InstagramPhotosWindow mWindow;
    private long uid;

    public InstagramPhotosWindowController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == UserMsgDef.OPEN_WINDOW_INSTAGRAM_PHOTOS) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            if (msg.obj instanceof Long) {
                this.uid = (Long)msg.obj;
            }
            this.mWindow = new InstagramPhotosWindow(this.mContext, this);
            this.getInstagramPhotos();
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        } else if (msg.what == UserMsgDef.CLOSE_WINDOW_INSTAGRAM_PHOTOS) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
    }

    private void getInstagramPhotos() {
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getInstagramPhotos(this.uid, new OnGetInsPhotosCallback(){

            public void onGetInsStatusSuccess(List<String> thumbnail, List<String> standard) {
                if (InstagramPhotosWindowController.this.mWindow != null) {
                    InstagramPhotosWindowController.this.mWindow.setAdapter(thumbnail, standard);
                }
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    @Override
    public void displayLargePhoto(View v, List<String> photoUrls, int index) {
        if (photoUrls == null || photoUrls.size() < 1) {
            return;
        }
        ImageOpenLargeHelper.INSTANCE.setFromDrawable(v);
        Message message = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putLong("uid", this.uid);
        bundle.putInt("index", index);
        bundle.putStringArrayList("photo_list", new ArrayList<String>(photoUrls));
        bundle.putParcelable("view_dimension", (Parcelable)new ViewDimension(v));
        message.what = BaseMsgDef.OPEN_WINDOW_PHOTO;
        message.setData(bundle);
        this.sendMessage(message);
    }

    @Override
    public void onBack() {
        this.sendMessage(UserMsgDef.CLOSE_WINDOW_INSTAGRAM_PHOTOS);
    }
}

