/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.instagramphotos;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.instagramphotos.IInstagramPhotosCallback;
import com.yy.hiyo.user.profile.instagramphotos.InsPhotosItemDecoration;
import com.yy.hiyo.user.profile.instagramphotos.InstagramPhotosAdapter;
import java.util.List;

public class InstagramPhotosWindow
extends DefaultWindow {
    private Context mContext;
    private IInstagramPhotosCallback mCallback;
    private SimpleTitleBar mTitleBar;
    private RecyclerView mRvPhotos;

    public InstagramPhotosWindow(Context context, IInstagramPhotosCallback callback) {
        super(context, (UICallBacks)callback, "InstagramPhotos");
        this.mContext = context;
        this.mCallback = callback;
        this.createView();
    }

    private void createView() {
        View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.window_instagram_photos, null);
        this.mTitleBar = (SimpleTitleBar)rootView.findViewById(R.id.stb_title);
        this.mRvPhotos = (RecyclerView)rootView.findViewById(R.id.recycler_view_ins_photo);
        this.initTitle();
        this.mRvPhotos.addItemDecoration((RecyclerView.ItemDecoration)new InsPhotosItemDecoration(this.mContext));
        GridLayoutManager gridLayoutManager = new GridLayoutManager(this.mContext, 4);
        this.mRvPhotos.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.getBaseLayer().addView(rootView);
    }

    public void setAdapter(List<String> thumbnail, final List<String> standard) {
        InstagramPhotosAdapter instagramPhotosAdapter = new InstagramPhotosAdapter(thumbnail);
        this.mRvPhotos.setAdapter((RecyclerView.Adapter)instagramPhotosAdapter);
        instagramPhotosAdapter.setOnInsPhotosItemClickListener(new InstagramPhotosAdapter.OnInsPhotosItemClickListener(){

            @Override
            public void onItemClick(View v, int position) {
                InstagramPhotosWindow.this.mCallback.displayLargePhoto(v, standard, position);
            }
        });
    }

    private void initTitle() {
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.profile_ins_photos_title));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                InstagramPhotosWindow.this.mCallback.onBack();
            }
        });
    }
}

