/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.instagram;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.LoadingStatusLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.instagram.IInsAuthCallback;

public class InstagramAuthWindow
extends DefaultWindow {
    private WebView mWebView;
    private LoadingStatusLayout mLoadingView;
    private IInsAuthCallback mCallback;
    private SimpleTitleBar mTitleBar;

    public InstagramAuthWindow(Context context, IInsAuthCallback callBacks) {
        super(context, (UICallBacks)callBacks, "InstagramAuth");
        this.mCallback = callBacks;
        View root = LayoutInflater.from((Context)context).inflate(R.layout.window_ins_auth, (ViewGroup)this, false);
        this.mTitleBar = (SimpleTitleBar)root.findViewById(R.id.stb_title);
        this.mWebView = (WebView)root.findViewById(R.id.web_view_ins);
        this.mLoadingView = (LoadingStatusLayout)root.findViewById(R.id.layout_loading_ins);
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.connect_to_instagram));
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                InstagramAuthWindow.this.showLoadingView();
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (url.contains(InstagramAuthWindow.this.mCallback.getRedirectUrl() + "?code=")) {
                    InstagramAuthWindow.this.mCallback.closeInsAuthWindow();
                    return;
                }
                InstagramAuthWindow.this.hideLoadingView();
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith(InstagramAuthWindow.this.mCallback.getRedirectUrl())) {
                    InstagramAuthWindow.this.mCallback.getCodeFromRedirectUrl(Uri.parse((String)url));
                    return true;
                }
                return false;
            }
        });
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                InstagramAuthWindow.this.mCallback.onBack();
            }
        });
        this.getBarLayer().addView(root, -1, -1);
    }

    public void loadUrl(String url) {
        this.mWebView.loadUrl(url);
    }

    public void showLoadingView() {
        this.mLoadingView.setVisibility(0);
        this.mWebView.setVisibility(8);
    }

    public void hideLoadingView() {
        this.mLoadingView.setVisibility(8);
        this.mWebView.setVisibility(0);
    }
}

