/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.instagram;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetOriginRespStringCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.INetRespOriginJsonParseCallback;
import com.yy.appbase.service.IUserInfoService;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.profile.instagram.IInsAuthCallback;
import com.yy.hiyo.user.profile.instagram.InstagramAuthWindow;
import com.yy.hiyo.user.profile.instagram.InstagramMeidaBean;
import com.yy.hiyo.user.profile.instagram.SocialUser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class InstagramAuthController
extends DefaultController
implements IInsAuthCallback {
    private static final String TAG = "InstagramAuthController";
    private static final String clientId = "6b702ad016ea429dbb6739b15c67946d";
    private static final String clientSecret = "34b6caf005154052adcab8740ef5d07e";
    private static final String redirectUrl = "https://www.kaixindou.net/";
    private static final String AUTH_URL = "https://api.instagram.com/oauth/authorize/?client_id=%1$s&redirect_uri=%2$s&response_type=code&scope=%3$s";
    private static final String TOKEN_URL = "https://api.instagram.com/oauth/access_token";
    private static final String PAGE_LINK = "https://www.instagram.com/%1$s/";
    private static final String MEDIA_LINK = "https://api.instagram.com/v1/users/self/media/recent/?access_token=";
    private InstagramAuthWindow mWindow;
    private static final long UNBIND_CLOSE_DELAY_TIME = 1500L;
    private long mCurrentTime;
    private Runnable hideLoadingTask = new Runnable(){

        @Override
        public void run() {
            if (System.currentTimeMillis() - InstagramAuthController.this.mCurrentTime >= 1500L) {
                if (InstagramAuthController.this.mWindow != null) {
                    InstagramAuthController.this.mWindow.hideLoadingView();
                }
                InstagramAuthController.this.sendMessage(UserMsgDef.CLOSE_WINDOW_INS_AUTH);
            }
        }
    };

    public InstagramAuthController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == UserMsgDef.CONNECT_INS_AUTH) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.clearCookies();
            this.mWindow = new InstagramAuthWindow(this.mContext, this);
            this.mWindow.loadUrl(this.getLoadUrl());
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        } else if (msg.what == UserMsgDef.DISCONNECT_INS_AUTH) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.mWindow = new InstagramAuthWindow(this.mContext, this);
            this.mWindow.showLoadingView();
            this.mCurrentTime = System.currentTimeMillis();
            this.disconnectInstagram();
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (InstagramAuthController.this.mWindow != null) {
                        InstagramAuthController.this.mWindow.hideLoadingView();
                    }
                    InstagramAuthController.this.sendMessage(UserMsgDef.CLOSE_WINDOW_INS_AUTH);
                }
            }, (long)1500L);
        } else if (msg.what == UserMsgDef.CLOSE_WINDOW_INS_AUTH) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        } else if (msg.what == UserMsgDef.UPDATE_INS_PHOTOS && msg.obj instanceof String) {
            this.getPhotosFromIns((String)msg.obj);
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
    }

    @Override
    public void onBack() {
        this.sendMessage(UserMsgDef.CLOSE_WINDOW_INS_AUTH);
    }

    @Override
    public String getRedirectUrl() {
        return redirectUrl;
    }

    @Override
    public String getLoadUrl() {
        List<String> scopeList = Arrays.asList("public_content");
        String scopes = TextUtils.join((CharSequence)"+", scopeList);
        String url = String.format(AUTH_URL, clientId, redirectUrl, scopes);
        return url;
    }

    @Override
    public void getCodeFromRedirectUrl(Uri uri) {
        String code = uri.getQueryParameter("code");
        if (code != null) {
            this.getAccessToken(code);
        } else if (uri.getQueryParameter("error") != null) {
            String errorMsg = uri.getQueryParameter("error_description");
            this.handleError(new Throwable(errorMsg));
        }
    }

    @Override
    public void getAccessToken(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", redirectUrl);
        params.put("code", code);
        HttpUtil.httpReq((String)TOKEN_URL, params, (int)2, (INetRespCallback)new INetRespOriginJsonParseCallback<IgUser>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)InstagramAuthController.TAG, (String)("Ins getAccessToken error\uff1a" + e.toString()), (Object[])new Object[0]);
                if (InstagramAuthController.this.mWindow != null) {
                    InstagramAuthController.this.mWindow.hideLoadingView();
                }
                InstagramAuthController.this.handleError(e);
            }

            public void onResponse(String response, BaseResponseBean<IgUser> res, int id2) {
                MLog.info((Object)InstagramAuthController.TAG, (String)("Ins getAccessToken Json\uff1a" + response), (Object[])new Object[0]);
                SocialUser user = new SocialUser();
                user.accessToken = ((IgUser)res.data).accessToken;
                user.userId = ((IgUser)res.data).user.id;
                user.username = ((IgUser)res.data).user.username;
                user.fullName = ((IgUser)res.data).user.fullName;
                user.pageLink = String.format(InstagramAuthController.PAGE_LINK, user.username);
                user.profilePictureUrl = ((IgUser)res.data).user.profilePicture;
                InstagramAuthController.this.handleSuccess(user);
            }
        });
    }

    private void handleSuccess(SocialUser user) {
        this.bindInstagram(user.accessToken, user.username);
    }

    private void bindInstagram(final String token, String nickName) {
        String url = UriProvider.getIkxdSvrHost() + "/ualbum/ins_album/bind";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("token", token);
        jsonObject.addProperty("nick", nickName);
        HttpUtil.httpReqPostString((String)url, (String)jsonObject.toString(), null, (INetRespCallback)new INetOriginRespStringCallback(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)InstagramAuthController.TAG, (String)("Instagram bind err:" + e.getMessage()), (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                MLog.info((Object)InstagramAuthController.TAG, (String)("Instagram bind resp:" + response), (Object[])new Object[0]);
                InstagramAuthController.this.getPhotosFromIns(token);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.INSTAGRAM_AUTH_STATUS_CHANGE, (Object)true));
                InstagramAuthController.this.sendMessage(UserMsgDef.CLOSE_WINDOW_INS_AUTH);
            }
        });
    }

    public void getPhotosFromIns(String accessToken) {
        MLog.info((Object)TAG, (String)"Ins getPhotos  start to get photos from ins", (Object[])new Object[0]);
        String url = MEDIA_LINK + accessToken + "&count+" + 50;
        HttpUtil.httpReq((String)url, null, (int)1, (INetRespCallback)new INetOriginRespStringCallback(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)InstagramAuthController.TAG, (String)("Ins getPhotos err\uff1a" + e.toString()), (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                MLog.info((Object)InstagramAuthController.TAG, (String)("Ins getPhotos Json\uff1a" + response), (Object[])new Object[0]);
                InstagramMeidaBean instagramMeidaBean = null;
                try {
                    instagramMeidaBean = (InstagramMeidaBean)new Gson().fromJson(response, InstagramMeidaBean.class);
                }
                catch (Exception e) {
                    MLog.error((Object)InstagramAuthController.TAG, (String)("getPhotosFromIns parse json error : " + Log.getStackTraceString((Throwable)e)), (Object[])new Object[0]);
                }
                if (instagramMeidaBean == null || instagramMeidaBean.data == null) {
                    MLog.info((Object)InstagramAuthController.TAG, (String)"Ins getPhotos data null!", (Object[])new Object[0]);
                    return;
                }
                MLog.info((Object)InstagramAuthController.TAG, (String)("Ins getPhotos \u5f00\u59cb\u4e0a\u4f20" + instagramMeidaBean.data.size()), (Object[])new Object[0]);
                ((IUserInfoService)InstagramAuthController.this.getServiceManager().getService(IUserInfoService.class)).uploadInstagramPhotos(instagramMeidaBean.data, new INetRespCallback(){

                    public void onError(Call call, Exception e, int id2) {
                        MLog.info((Object)InstagramAuthController.TAG, (String)("Ins getPhotos err\uff1a" + e.toString()), (Object[])new Object[0]);
                    }

                    public void onResponse(String response, BaseResponseBean res, int id2) {
                        MLog.info((Object)InstagramAuthController.TAG, (String)("Ins getPhotos Json\uff1a" + response), (Object[])new Object[0]);
                        YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.UPLODA_INSTAGRAM_PHOTOS_SUCCESS, (Object)true)));
                    }
                });
            }
        });
    }

    private void handleError(Throwable throwable) {
        this.sendMessage(UserMsgDef.CLOSE_WINDOW_INS_AUTH);
    }

    @Override
    public void disconnectInstagram() {
        this.clearCookies();
        this.unBindInstagram();
    }

    @Override
    public void closeInsAuthWindow() {
        this.sendMessage(UserMsgDef.CLOSE_WINDOW_INS_AUTH);
    }

    private void unBindInstagram() {
        HttpUtil.httpReq((String)(UriProvider.getIkxdSvrHost() + "/ualbum/ins_album/unbind"), null, (int)2, (INetRespCallback)new INetRespCallback<String>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)InstagramAuthController.TAG, (String)("Instagram unbind err:" + e.getMessage()), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)InstagramAuthController.this.hideLoadingTask);
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                MLog.info((Object)InstagramAuthController.TAG, (String)("Instagram unbind resp:" + response), (Object[])new Object[0]);
                ((IUserInfoService)InstagramAuthController.this.getServiceManager().getService(IUserInfoService.class)).deleteInstagramPhotosFromCache(AccountUtil.getUid());
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.INSTAGRAM_AUTH_STATUS_CHANGE, (Object)false));
                YYTaskExecutor.postToMainThread((Runnable)InstagramAuthController.this.hideLoadingTask);
            }
        });
    }

    private void clearCookies() {
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().removeAllCookies(null);
        } else {
            CookieSyncManager.createInstance((Context)this.mContext.getApplicationContext());
            CookieManager.getInstance().removeAllCookie();
        }
    }

    private static class IgUser {
        @SerializedName(value="access_token")
        String accessToken;
        @SerializedName(value="user")
        User user;

        private IgUser() {
        }

        static class User {
            @SerializedName(value="id")
            String id;
            @SerializedName(value="username")
            String username;
            @SerializedName(value="full_name")
            String fullName;
            @SerializedName(value="profile_picture")
            String profilePicture;

            User() {
            }
        }
    }
}

