/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.edit;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnAlbumCallback;
import com.yy.appbase.service.callback.OnCameraCallbak;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.service.callback.OnPhotoDeleteCallbak;
import com.yy.appbase.service.callback.OnUpdateCallback;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.featurelog.BDAConst;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.bbs.base.bean.PostPublishData;
import com.yy.hiyo.bbs.base.bean.postinfo.BasePostInfo;
import com.yy.hiyo.bbs.base.bean.sectioninfo.PostImage;
import com.yy.hiyo.bbs.base.callback.IPostPublishCallback;
import com.yy.hiyo.bbs.base.service.IPostService;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.profile.edit.IEditProfileCallback;
import com.yy.hiyo.user.profile.edit.NewEditProfileInfoWindow;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import okhttp3.Call;

public class EditProfileController
extends DefaultController
implements IEditProfileCallback {
    private static final String TAG = "EditProfileController";
    public static final String MESSAGE_PARAM_ERROR = "KReturnParamError";
    public static final int CODE_PARAM_ERROR = -1;
    private NewEditProfileInfoWindow mWindow;
    private UserInfoKS mUserInfo;
    private List<AlbumItem> mAlbum;
    private List<AlbumItem> mPreAlbum;
    private boolean isNeedToEditBio;
    private boolean isNeedToShowBirth;
    private boolean isNeedToShowGender;
    private boolean isNeedToHomeTown;
    private List<String> mBbsContentList = new ArrayList<String>();
    private OnCameraCallbak mOnCameraCallbak = new OnCameraCallbak(){

        public void onFinish(final String path) {
            if (TextUtils.isEmpty((CharSequence)path)) {
                BDAConst.bDAProfileAddAvatar((String)"onAddPhotoClick album photo path is null");
                FeatureLog.i((String)"FTAddAvatarProfile", (String)"onAddPhotoClick album photo path is null", (Object[])new Object[0]);
                ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                return;
            }
            EditProfileController.this.showLoading();
            final Point point = YYImageUtils.getBitmapSize((ContentResolver)EditProfileController.this.mContext.getContentResolver(), (Uri)Uri.fromFile((File)new File(path)));
            ((IUserInfoService)EditProfileController.this.getServiceManager().getService(IUserInfoService.class)).updateAlbum(path, new OnUpdateCallback(){

                public void onUISuccess(String imageUrl, int id2) {
                    BDAConst.bDAProfileAddAvatar((String)("onAddPhotoClick success path = " + path + " imageUrl = " + imageUrl));
                    MLog.info((Object)EditProfileController.TAG, (String)"onAddPhotoClick success path=%s\uff0cimageUrl=%s", (Object[])new Object[]{path, imageUrl});
                    EditProfileController.this.hideLoading();
                    EditProfileController.this.addAlbum(new AlbumItem(imageUrl, point.x, point.y));
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.UPDATE_ALBUM, (Object)true));
                    ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_success), (int)0);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "click").put("element_id", "10016"));
                }

                public void onError(Call call, Exception e, int id2) {
                    BDAConst.bDAProfileAddAvatar((String)("onAddPhotoClick onError = " + e));
                    FeatureLog.i((String)"FTAddAvatarProfile", (String)("onAddPhotoClick onError = " + e), (Object[])new Object[0]);
                    ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                    EditProfileController.this.hideLoading();
                }

                public void onResponseError(int id2, String message, String response) {
                    BDAConst.bDAProfileAddAvatar((String)("onAddPhotoClick onResponseError response = " + response));
                    FeatureLog.i((String)"FTAddAvatarProfile", (String)("onAddPhotoClick onResponseError response = " + response), (Object[])new Object[0]);
                    ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                    EditProfileController.this.hideLoading();
                }
            });
        }
    };
    private String mAlbumPhotoClickUrl = "";
    private int mAlbumPhotoClickPosition;
    private OnCameraCallbak mOnCameraCallbak2 = new OnCameraCallbak(){

        public void onFinish(String path) {
            BDAConst.bDAProfileEditAvatar((String)("onAlbumPhotoClick path = " + path));
            FeatureLog.i((String)"FTEditAvatarProfile", (String)("onAlbumPhotoClick path = " + path), (Object[])new Object[0]);
            if (TextUtils.isEmpty((CharSequence)path)) {
                return;
            }
            EditProfileController.this.showLoadingDialog();
            ((IUserInfoService)EditProfileController.this.getServiceManager().getService(IUserInfoService.class)).replaceFromAlbum(path, EditProfileController.this.mAlbumPhotoClickUrl, EditProfileController.this.mAlbumPhotoClickPosition, new OnUpdateCallback(){

                public void onUISuccess(String imageUrl, int id2) {
                    BDAConst.bDAProfileEditAvatar((String)("onAlbumPhotoClick replaceFromAlbum onUISuccess imageUrl = " + imageUrl));
                    FeatureLog.i((String)"FTEditAvatarProfile", (String)"onAlbumPhotoClick replaceFromAlbum onUISuccess", (Object[])new Object[0]);
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(imageUrl);
                    EditProfileController.this.setAlbum(list, true);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.UPDATE_ALBUM, (Object)EditProfileController.this.mAlbumPhotoClickUrl));
                    EditProfileController.this.dismissLoadingDialog();
                    ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_success), (int)0);
                }

                public void onError(Call call, Exception e, int id2) {
                    BDAConst.bDAProfileEditAvatar((String)("onAlbumPhotoClick onError = " + e));
                    FeatureLog.i((String)"FTEditAvatarProfile", (String)("onAlbumPhotoClick onError = " + e), (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.submission_failed), (int)0);
                        }
                    });
                    EditProfileController.this.dismissLoadingDialog();
                }

                public void onResponseError(int id2, String message, String response) {
                    BDAConst.bDAProfileEditAvatar((String)("onAlbumPhotoClick onResponseError response = " + response));
                    FeatureLog.i((String)"FTEditAvatarProfile", (String)("onAlbumPhotoClick onResponseError response = " + response), (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.submission_failed), (int)0);
                        }
                    });
                    EditProfileController.this.dismissLoadingDialog();
                }
            });
        }
    };
    private OnPhotoDeleteCallbak mOnPhotoDeleteCallbak = new OnPhotoDeleteCallbak(){

        public void onDelete() {
            BDAConst.bDAProfileEditAvatar((String)"onAlbumPhotoClick onDelete");
            FeatureLog.i((String)"FTEditAvatarProfile", (String)"onAlbumPhotoClick onDelete", (Object[])new Object[0]);
            ((IUserInfoService)EditProfileController.this.getServiceManager().getService(IUserInfoService.class)).deletePhoto(EditProfileController.this.mAlbumPhotoClickUrl, new OnUpdateCallback(){

                public void onUISuccess(String imageUrl, int id2) {
                    BDAConst.bDAProfileEditAvatar((String)("onAlbumPhotoClick onDelete onUISuccess imageUrl = " + imageUrl));
                    FeatureLog.i((String)"FTEditAvatarProfile", (String)"onAlbumPhotoClick onDelete onUISuccess", (Object[])new Object[0]);
                    ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_delete_success), (int)0);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.UPDATE_ALBUM, (Object)EditProfileController.this.mAlbumPhotoClickUrl));
                }

                public void onError(Call call, Exception e, int id2) {
                    BDAConst.bDAProfileEditAvatar((String)("onAlbumPhotoClick onDelete onError = " + e));
                    FeatureLog.i((String)"FTEditAvatarProfile", (String)("onAlbumPhotoClick onDelete onError = " + e), (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                        }
                    });
                }

                public void onResponseError(int id2, String message, String response) {
                    BDAConst.bDAProfileEditAvatar((String)("onAlbumPhotoClick onDelete onResponseError response = " + response));
                    FeatureLog.i((String)"FTEditAvatarProfile", (String)("onAlbumPhotoClick onDelete onResponseError response = " + response), (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_delete_failed), (int)0);
                        }
                    });
                }
            });
        }
    };

    public EditProfileController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationDef.INSTAGRAM_AUTH_STATUS_CHANGE, (INotify)this);
        this.initBbsContent();
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == UserMsgDef.OPEN_WINDOW_EDIT_PROFILE) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            if (msg.obj instanceof Bundle) {
                Bundle bundle = (Bundle)msg.obj;
                this.isNeedToEditBio = bundle.getBoolean("profile_bio");
                this.isNeedToHomeTown = bundle.getBoolean("profile_home_town");
                this.isNeedToShowBirth = bundle.getBoolean("showBirthday", false);
                this.isNeedToShowGender = bundle.getBoolean("showGender", false);
            }
            this.mWindow = new NewEditProfileInfoWindow(this.mContext, this);
            if (this.isNeedToEditBio) {
                this.mWindow.onBioClick();
            }
            if (this.isNeedToHomeTown) {
                this.mWindow.onHometownClick();
            }
            this.getUserInfo();
            if (this.isNeedToShowBirth) {
                this.mWindow.onBirthDayClick();
            }
            if (this.isNeedToShowGender) {
                this.mWindow.onChangeGenderClick();
            }
            this.setAlbum(null, false);
            this.getAlbum();
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            MLog.info((Object)TAG, (String)"show edit profile window", (Object[])new Object[0]);
            FeatureLog.i((String)"FTEditAvatarProfile", (String)"open edit profile window", (Object[])new Object[0]);
            BDAConst.bDAProfileEditAvatar((String)"open edit profile window");
            this.reportEditProfile(this.mUserInfo, 4);
        } else if (msg.what == UserMsgDef.CLOSE_WINDOW_EDIT_PROFILE) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        } else if (msg.what == BaseMsgDef.OPEN_WINDOW_EDIT_PROFILE_WHIE_OPEN_DIALOG) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.mWindow = new NewEditProfileInfoWindow(this.mContext, this);
            this.getUserInfo();
            this.setAlbum(null, false);
            this.getAlbum();
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            MLog.info((Object)TAG, (String)"show edit profile window", (Object[])new Object[0]);
            this.reportEditProfile(this.mUserInfo, 4);
            this.mWindow.onChangeAvatarClick();
        } else if (msg.what == UserMsgDef.UPDATE_ALBUM_TO_BBS) {
            MLog.debug((Object)TAG, (String)"UPDATE_ALBUM_TO_BBS", (Object[])new Object[0]);
            if (msg.obj instanceof PostImage) {
                this.uploadAvatarToBbsImpl(Arrays.asList((PostImage)msg.obj));
            }
        }
    }

    private void initBbsContent() {
        this.mBbsContentList.add(ResourceUtils.getString((int)R.string.short_tips_profile_bbs_tips_first));
        this.mBbsContentList.add(ResourceUtils.getString((int)R.string.short_tips_profile_bbs_tips_second));
        this.mBbsContentList.add(ResourceUtils.getString((int)R.string.short_tips_profile_bbs_tips_third));
    }

    private void reportEditProfile(UserInfoKS userInfo, int dataSourceId) {
        if (userInfo == null) {
            return;
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20025801");
        String sex = userInfo.sex == 0 ? "F" : "M";
        event.put("gender", sex);
        event.put("data_source_id", String.valueOf(dataSourceId));
        if (!TextUtils.isEmpty((CharSequence)userInfo.birthday)) {
            event.put("birthday", userInfo.birthday);
        }
        if (!TextUtils.isEmpty((CharSequence)userInfo.nick)) {
            event.put("nick_name", userInfo.nick);
        }
        if (!TextUtils.isEmpty((CharSequence)userInfo.job)) {
            event.put("job", userInfo.job);
        }
        if (!TextUtils.isEmpty((CharSequence)userInfo.hometown)) {
            event.put("hometown", userInfo.hometown);
        }
        if (!TextUtils.isEmpty((CharSequence)userInfo.sign)) {
            event.put("signature", userInfo.sign);
        }
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.UPDATE_ALBUM && notification.extObj != null && notification.extObj instanceof String && this.mUserInfo != null) {
            List albumList = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo((long)this.mUserInfo.uid).album;
            this.setAlbum(albumList, false);
        }
    }

    private void getUserInfo() {
        IUserInfoService service = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
        UserInfoKS userInfo = service.getUserInfo(AccountUtil.getUid());
        this.updateUiUserInfo(userInfo);
        service.requestUserInfoFromServer(AccountUtil.getUid(), new OnKSProfileListCallback(){

            public void onUISuccess(@NonNull List<UserInfoKS> list) {
                if (list != null && list.size() > 0) {
                    EditProfileController.this.updateUiUserInfo(list.get(0));
                }
            }

            public void onError(String reason, long code) {
                MLog.error((Object)EditProfileController.TAG, (String)"getUserInfo onError code %d, reason %s", (Object[])new Object[]{code, reason});
                if (EditProfileController.this.mUserInfo == null || ((EditProfileController)EditProfileController.this).mUserInfo.ver <= 0L) {
                    ToastUtils.showToast((Context)EditProfileController.this.mContext, (int)R.string.user_info_get_error);
                }
            }
        });
    }

    private void updateUiUserInfo(UserInfoKS userInfo) {
        if (this.mWindow != null && userInfo.ver > 0L) {
            this.mUserInfo = userInfo;
            this.mWindow.updateUI(this.mUserInfo);
        }
    }

    private void getAlbum() {
        if (this.mUserInfo == null) {
            return;
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).requestAlbum(this.mUserInfo.uid, new OnAlbumCallback(){

            public void onUISuccess(List<String> list, long uid) {
                if (EditProfileController.this.mUserInfo != null && ((EditProfileController)EditProfileController.this).mUserInfo.uid == uid) {
                    EditProfileController.this.setPreAlbum(list, false);
                    EditProfileController.this.setAlbum(list, false);
                }
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    private void setAlbum(List<String> list, boolean isAdd) {
        if (this.mUserInfo == null) {
            return;
        }
        if (!isAdd) {
            this.mAlbum = new ArrayList<AlbumItem>();
            this.mAlbum.add(new AlbumItem(""));
        }
        if (list != null && list.size() > 0) {
            for (String url : list) {
                this.mAlbum.add(1, new AlbumItem(url));
            }
        }
        if (this.mWindow != null) {
            this.mWindow.updateAlbum(this.convertAlbumItemToString(this.mAlbum));
        }
    }

    private void addAlbum(AlbumItem item) {
        if (null != this.mAlbum) {
            this.mAlbum.add(1, item);
        }
        if (this.mWindow != null) {
            this.mWindow.updateAlbum(this.convertAlbumItemToString(this.mAlbum));
        }
    }

    private ArrayList<String> convertAlbumItemToString(List<AlbumItem> albumItems) {
        ArrayList<String> listAlbum = new ArrayList<String>();
        for (AlbumItem item : albumItems) {
            listAlbum.add(item.url);
        }
        return listAlbum;
    }

    private void setPreAlbum(List<String> list, boolean isAdd) {
        if (!isAdd) {
            this.mPreAlbum = new ArrayList<AlbumItem>();
            this.mPreAlbum.add(new AlbumItem(""));
        }
        if (list != null && list.size() > 0) {
            for (String url : list) {
                this.mPreAlbum.add(1, new AlbumItem(url));
            }
        }
    }

    private void showLoadingDialog() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                EditProfileController.this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog("", true, false, null));
            }
        });
    }

    private void dismissLoadingDialog() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                EditProfileController.this.mDialogLinkManager.dismissDialog();
            }
        });
    }

    private void showLoading() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (EditProfileController.this.mWindow != null) {
                    EditProfileController.this.mWindow.showLoading();
                }
            }
        });
    }

    private void hideLoading() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (EditProfileController.this.mWindow != null) {
                    EditProfileController.this.mWindow.hideLoading();
                }
            }
        });
    }

    @Override
    public void onAddPhotoClick() {
        FeatureLog.i((String)"FTAddAvatarProfile", (String)"onAddPhotoClick", (Object[])new Object[0]);
        BDAConst.bDAProfileAddAvatar((String)"onAddPhotoClick");
        if (this.mAlbum != null && this.mAlbum.size() >= 10) {
            BDAConst.bDAProfileAddAvatar((String)("onAddPhotoClick album limit size = " + this.mAlbum.size()));
            FeatureLog.i((String)"FTAddAvatarProfile", (String)("onAddPhotoClick album limit size = " + this.mAlbum.size()), (Object[])new Object[0]);
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.toast_photo_up_limit), (int)0);
        } else {
            ((ICameraService)this.getServiceManager().getService(ICameraService.class)).pickPhotoWithClip("FTAddAvatarProfile", this.mOnCameraCallbak, 2, 1.2857143f);
        }
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.mWindow != null) {
            this.mWindow.onBack();
        }
        return true;
    }

    @Override
    public void onAlbumPhotoClick(String url, int position) {
        FeatureLog.i((String)"FTEditAvatarProfile", (String)"onAlbumPhotoClick", (Object[])new Object[0]);
        BDAConst.bDAProfileEditAvatar((String)"onAlbumPhotoClick");
        this.mAlbumPhotoClickUrl = url;
        this.mAlbumPhotoClickPosition = position;
        ((ICameraService)this.getServiceManager().getService(ICameraService.class)).pickPhotoOnAlbumPhotoWithClip("FTEditAvatarProfile", this.mOnCameraCallbak2, this.mOnPhotoDeleteCallbak, 1.2857143f);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.uploadAvatarToBbs();
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
        this.isNeedToEditBio = false;
        this.isNeedToHomeTown = false;
        this.isNeedToShowBirth = false;
        this.isNeedToShowGender = false;
    }

    private void uploadAvatarToBbs() {
        if (this.mWindow != null && !this.mWindow.isSyncBbs()) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "photo_album_release_click").put("if_synchronize_to_bbs", "2"));
            return;
        }
        MLog.debug((Object)TAG, (String)"uploadAvatarToBbs", (Object[])new Object[0]);
        List<AlbumItem> imageList = this.getAlbumChange();
        if (imageList == null || imageList.isEmpty()) {
            MLog.error((Object)TAG, (String)"uploadAvatarToBbs imageList empty", (Object[])new Object[0]);
            return;
        }
        ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_profile_bbs_uploading), (int)1);
        ArrayList<PostImage> postImages = new ArrayList<PostImage>();
        for (AlbumItem album : imageList) {
            if (FP.empty((CharSequence)album.url)) continue;
            PostImage postImage = new PostImage();
            postImage.setMUrl(album.url);
            postImage.setMHeight(Integer.valueOf(album.height));
            postImage.setMWidth(Integer.valueOf(album.width));
            postImages.add(postImage);
            MLog.debug((Object)TAG, (String)"uploadAvatarToBbs postImages size:%d,%d url:%s", (Object[])new Object[]{postImage.getMWidth(), postImage.getMHeight(), album});
        }
        this.uploadAvatarToBbsImpl(postImages);
    }

    private void uploadAvatarToBbsImpl(List<PostImage> postImages) {
        MLog.debug((Object)TAG, (String)"uploadAvatarToBbsImpl", (Object[])new Object[0]);
        YYTaskExecutor.execute(() -> {
            PostPublishData postPublishData = PostPublishData.newBuilder().imageList(postImages).text(this.getBbsContent(), null, 0).build();
            ((IPostService)ServiceManagerProxy.getService(IPostService.class)).publishPost(postPublishData, new IPostPublishCallback(){

                public void onSuccess(@org.jetbrains.annotations.Nullable BasePostInfo postInfo) {
                    ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_profile_bbs_upload_success), (int)1);
                    EditProfileController.this.sendMessage(UserMsgDef.ALBUM_UPDATE_POST);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "photo_album_release_click").put("if_synchronize_to_bbs", "1").put("post_id", postInfo.getPostId()));
                }

                public void onFail(@org.jetbrains.annotations.Nullable String reason, int code) {
                    ToastUtils.showToast((Context)EditProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_profile_bbs_upload_fail), (int)1);
                }
            });
        });
    }

    private String getBbsContent() {
        int index = new Random().nextInt(3);
        if (index >= this.mBbsContentList.size()) {
            return "";
        }
        return this.mBbsContentList.get(index);
    }

    private List<AlbumItem> getAlbumChange() {
        if (this.mPreAlbum == null || this.mAlbum == null) {
            return null;
        }
        ArrayList<AlbumItem> extraList = new ArrayList<AlbumItem>();
        for (AlbumItem album : this.mAlbum) {
            if (FP.empty((CharSequence)album.url) || this.mPreAlbum.contains(album)) continue;
            extraList.add(album);
        }
        return extraList;
    }

    class AlbumItem {
        private int width;
        private int height;
        private String url;

        AlbumItem(String url) {
            this.url = url;
            this.width = 0;
            this.height = 0;
        }

        AlbumItem(String url, int width, int height) {
            this.url = url;
            this.width = width;
            this.height = height;
        }

        public int hashCode() {
            return (this.url == null ? "" : this.url).hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == null || !(obj instanceof AlbumItem)) {
                return false;
            }
            AlbumItem inItem = (AlbumItem)obj;
            if (this.url == null) {
                return inItem.url == null;
            }
            return this.url.equals(inItem.url);
        }
    }
}

