/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.card;

import android.app.Dialog;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.NewProfileController;
import com.yy.hiyo.user.profile.card.IProfileCardUiCallback;
import com.yy.location.LocationHelper;
import com.yy.location.LocationUtils;
import com.yy.location.OnLocationCallback;

public class ProfileDialog
implements BaseDialog {
    private static final String TAG = "ProfileDialog";
    private RoundImageView mHeadIcon;
    private TextView mUserName;
    private TextView mAge;
    private TextView mZodiac;
    private TextView mLocation;
    private TextView mSignature;
    private FrameLayout mAddBtn;
    private TextView mAddTv;
    public UserInfoKS mUserInfo;
    private KvoBinder mBinder;
    private String mAvatar = "";
    private DialogInterface.OnDismissListener mListener;
    private IProfileCardUiCallback mUiCallback;
    private long mUid;
    private RelationInfo relationInfo;

    public ProfileDialog(long uid, DialogInterface.OnDismissListener listener, IProfileCardUiCallback cardUiCallback) {
        this.mUid = uid;
        this.mListener = listener;
        this.mUiCallback = cardUiCallback;
        this.mBinder = new KvoBinder((Object)this);
    }

    public void init(Dialog dialog2) {
        dialog2.setContentView(R.layout.layout_profile_card);
        if (this.mListener != null) {
            dialog2.setOnDismissListener(this.mListener);
        }
        this.mHeadIcon = (RoundImageView)dialog2.findViewById(R.id.head_icon);
        this.mUserName = (TextView)dialog2.findViewById(R.id.user_name);
        this.mAge = (TextView)dialog2.findViewById(R.id.card_age);
        this.mZodiac = (TextView)dialog2.findViewById(R.id.card_zodiac);
        this.mLocation = (TextView)dialog2.findViewById(R.id.card_location);
        this.mSignature = (TextView)dialog2.findViewById(R.id.signature);
        this.mAddBtn = (FrameLayout)dialog2.findViewById(R.id.fl_add);
        this.mAddTv = (TextView)dialog2.findViewById(R.id.tv_add_friend);
        this.mAddTv.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        if (this.mUid == AccountUtil.getUid()) {
            this.mAddBtn.setVisibility(8);
        } else {
            this.mAddBtn.setVisibility(0);
        }
        this.mAddBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ProfileDialog.this.mUiCallback != null) {
                    ProfileDialog.this.mUiCallback.onAddFriendClick(ProfileDialog.this.mUid, ProfileDialog.this.relationInfo);
                }
            }
        });
    }

    public void updateUserInfo(UserInfoKS userInfo) {
        if (userInfo == null || userInfo.uid != this.mUid) {
            return;
        }
        this.mUserInfo = userInfo;
        this.mBinder.clearAllKvoConnections();
        this.mBinder.singleBindSourceTo((KvoSource)this.mUserInfo);
        if (this.mUid != AccountUtil.getUid()) {
            this.relationInfo = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationLocal(this.mUid);
            this.mBinder.singleBindSourceTo((KvoSource)this.relationInfo);
        }
    }

    public void destroy() {
        this.mBinder.clearAllKvoConnections();
    }

    @KvoMethodAnnotation(name="sex", sourceClass=UserInfoKS.class, thread=1)
    public void onSexUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (userInfo.sex == 0) {
            this.setLeftDrawable(this.mAge, R.drawable.icon_female);
            this.mAge.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_bg_profile_label_age_female));
        } else {
            this.setLeftDrawable(this.mAge, R.drawable.icon_male);
            this.mAge.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_bg_profile_label_age_male));
        }
    }

    @KvoMethodAnnotation(name="nick", sourceClass=UserInfoKS.class, thread=1)
    public void onNickUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        this.mUserName.setText((CharSequence)userInfo.nick);
    }

    @KvoMethodAnnotation(name="avatar", sourceClass=UserInfoKS.class, thread=1)
    public void onAvatarUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (this.mAvatar == null || !this.mAvatar.equals(userInfo.avatar)) {
            ImageLoader.loadImage((ImageView)this.mHeadIcon, (String)userInfo.avatar, (int)AvatarUtils.getDefaultAvatar((int)userInfo.sex));
        }
        this.mAvatar = userInfo.avatar;
    }

    @KvoMethodAnnotation(name="birthday", sourceClass=UserInfoKS.class, thread=1)
    public void onBirthdayUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (TextUtils.isEmpty((CharSequence)userInfo.birthday)) {
            return;
        }
        this.mAge.setText((CharSequence)(DateUtils.getAge((String)userInfo.birthday) + ""));
        try {
            int index = DateUtils.getZodiac((String)userInfo.birthday);
            this.setLeftDrawable(this.mZodiac, NewProfileController.getZodiacIcon(index));
            this.mZodiac.setText((CharSequence)ResourceUtils.getString((int)NewProfileController.getZodiacText(index)));
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    @KvoMethodAnnotation(name="sign", sourceClass=UserInfoKS.class, thread=1)
    public void onSignUpdate(KvoEventIntent event) {
        UserInfoKS userInfo = (UserInfoKS)event.source();
        if (TextUtils.isEmpty((CharSequence)userInfo.sign)) {
            this.mSignature.setVisibility(8);
        } else {
            this.mSignature.setVisibility(0);
            this.mSignature.setText((CharSequence)userInfo.sign);
        }
    }

    @KvoMethodAnnotation(name="locationTude", sourceClass=UserInfoKS.class)
    public void onUpdateTarget(KvoEventIntent event) {
        if (this.mUserInfo != null && this.mUserInfo.hideLocation != 1L) {
            this.setLocation();
        }
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    public void updateFollowStatus(KvoEventIntent event) {
        switch (((RelationInfo)event.source()).getRelation()) {
            case NONE: 
            case FAN: {
                this.mAddBtn.setVisibility(0);
                this.mAddBtn.setEnabled(true);
                this.mAddTv.setText(R.string.add);
                this.setLeftDrawable(this.mAddTv, R.drawable.ico_add_white);
                break;
            }
            case FOLLOW: {
                this.mAddBtn.setVisibility(0);
                this.mAddBtn.setEnabled(false);
                this.mAddTv.setText(R.string.adding);
                this.mAddTv.setCompoundDrawables(null, null, null, null);
                break;
            }
            case FRIEND: {
                this.mAddBtn.setVisibility(8);
                break;
            }
        }
    }

    private void setLeftDrawable(TextView tv, @DrawableRes int id2) {
        if (tv == null) {
            return;
        }
        Drawable drawable2 = ResourceUtils.getDrawable((int)id2);
        drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        tv.setCompoundDrawables(drawable2, null, null, null);
    }

    private void setLocation() {
        if (this.mUserInfo != null && !TextUtils.isEmpty((CharSequence)this.mUserInfo.locationTude)) {
            final long uid = this.mUserInfo.uid;
            LocationUtils.getLocationStrFromLatAndLon((long)uid, (String)this.mUserInfo.locationTude, (OnLocationCallback)new OnLocationCallback(){

                public void onLocation(String location) {
                    if (ProfileDialog.this.mUserInfo == null || ProfileDialog.this.mUserInfo.uid != uid) {
                        MLog.info((Object)ProfileDialog.TAG, (String)"set location return", (Object[])new Object[0]);
                        return;
                    }
                    if (ProfileDialog.this.mUserInfo.uid == AccountUtil.getUid()) {
                        if (LocationHelper.checkLocationPermission()) {
                            if (!TextUtils.isEmpty((CharSequence)location)) {
                                MLog.info((Object)ProfileDialog.TAG, (String)("has permission set location :" + location), (Object[])new Object[0]);
                                ProfileDialog.this.updateLocation(location);
                            } else {
                                MLog.info((Object)ProfileDialog.TAG, (String)("has permission set lastLoginlocation :" + ProfileDialog.this.mUserInfo.lastLoginLocation), (Object[])new Object[0]);
                                ProfileDialog.this.updateLocation(ProfileDialog.this.mUserInfo.lastLoginLocation);
                            }
                        } else {
                            MLog.info((Object)ProfileDialog.TAG, (String)"has no permission set mars", (Object[])new Object[0]);
                            ProfileDialog.this.updateLocation("");
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)location)) {
                        ProfileDialog.this.updateLocation(location);
                        MLog.info((Object)ProfileDialog.TAG, (String)("not self set location :" + location), (Object[])new Object[0]);
                    } else {
                        ProfileDialog.this.updateLocation(ProfileDialog.this.mUserInfo.lastLoginLocation);
                        MLog.info((Object)ProfileDialog.TAG, (String)("not self set lastloginlocation :" + ProfileDialog.this.mUserInfo.lastLoginLocation), (Object[])new Object[0]);
                    }
                }
            });
        } else {
            this.updateLocation("");
            MLog.info((Object)TAG, (String)"locationTude null", (Object[])new Object[0]);
        }
    }

    private void updateLocation(String location) {
        if (!TextUtils.isEmpty((CharSequence)location)) {
            this.mLocation.setText((CharSequence)location);
        } else {
            this.mLocation.setText((CharSequence)ResourceUtils.getString((int)R.string.profile_no_location));
        }
    }

    public int getId() {
        return DialogId.ProfileDialog;
    }
}

