/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.card;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.push.tips.PushPermissionTipManager;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.card.IProfileCardUiCallback;
import com.yy.hiyo.user.profile.card.ProfileDialog;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import net.ihago.room.srv.follow.EPath;

public class ProfileCardController
extends DefaultController
implements IProfileCardUiCallback {
    private ProfileDialog mProfileDialog;
    private long mUid;
    private UserInfoKS mUserInfo;
    private int mFrom;
    private String mGameId;
    private int mid = -1;
    private long mLastShowTime;
    private GameLifeWrapper gameLifeWrapper = new GameLifeWrapper(){

        public void onGameExited(GamePlayContext context, int gameExitType) {
            super.onGameExited(context, gameExitType);
            ProfileCardController.this.hideDialog();
        }
    };
    private DialogInterface.OnDismissListener mListener = new DialogInterface.OnDismissListener(){

        public void onDismiss(DialogInterface dialog2) {
            ProfileCardController.this.dismissDialog();
        }
    };

    public ProfileCardController(Environment env) {
        super(env);
        this.registerMessage(BaseMsgDef.MSG_HIDE_PROFILE_DIALOG);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)this.gameLifeWrapper);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.MSG_SHOW_PROFILE_DIALOG) {
            long cur = System.currentTimeMillis();
            if (Math.abs(cur - this.mLastShowTime) < 500L) {
                return;
            }
            if (msg.obj instanceof Long) {
                long uid = (Long)msg.obj;
                if (uid <= 0L || uid == this.mUid) {
                    return;
                }
                this.mUid = uid;
                Bundle bundle = msg.getData();
                if (bundle != null) {
                    this.mGameId = bundle.getString("gameId");
                    this.mid = bundle.getInt("mid");
                }
                this.mLastShowTime = cur;
                this.showProfileDialog(this.mUid);
            }
            this.mFrom = msg.arg1;
        } else if (msg.what == BaseMsgDef.MSG_HIDE_PROFILE_DIALOG) {
            this.hideDialog();
        }
    }

    private void showProfileDialog(long uid) {
        if (this.mProfileDialog == null) {
            this.mProfileDialog = new ProfileDialog(uid, this.mListener, this);
        }
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.mContext);
        }
        this.mDialogLinkManager.showDialog((BaseDialog)this.mProfileDialog);
        this.getUserInfo(uid);
        String gameId = this.mGameId == null ? "" : this.mGameId;
        HiidoEvent event = HiidoEvent.obtain().eventId("20028013").put("function_id", "1").put("act_uid", String.valueOf(uid)).put("gid", gameId);
        if (this.mid != -1) {
            event.put("mid", String.valueOf(this.mid));
        }
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    private void hideDialog() {
        if (this.mProfileDialog != null && this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager.dismissDialog();
            this.mDialogLinkManager = null;
        }
    }

    private void dismissDialog() {
        if (this.mProfileDialog != null) {
            this.mProfileDialog.destroy();
        }
        this.mProfileDialog = null;
        this.mUserInfo = null;
        this.mid = -1;
        this.mUid = 0L;
    }

    private void getUserInfo(long uid) {
        this.mUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (!FP.empty(userInfoKSList)) {
                    UserInfoKS infoKS = userInfoKSList.get(0);
                    if (infoKS.uid == ProfileCardController.this.mUid && (ProfileCardController.this.mUserInfo == null || ((ProfileCardController)ProfileCardController.this).mUserInfo.uid != ProfileCardController.this.mUid)) {
                        ProfileCardController.this.mUserInfo = infoKS;
                        ProfileCardController.this.updateUserInfo();
                    }
                }
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
        this.updateUserInfo();
    }

    private void updateUserInfo() {
        if (this.mUserInfo != null && this.mProfileDialog != null) {
            this.mProfileDialog.updateUserInfo(this.mUserInfo);
        }
    }

    @Override
    public void onAddFriendClick(long uid, RelationInfo relationship) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (relationship == null || uid == AccountUtil.getUid()) {
            return;
        }
        if (this.isBlack(uid)) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.toast_block_already), (int)0);
        } else {
            String gameId = this.mGameId == null ? "" : this.mGameId;
            HiidoEvent event = HiidoEvent.obtain().eventId("20028013").put("function_id", "2").put("act_uid", String.valueOf(uid)).put("gid", gameId);
            if (this.mid != -1) {
                event.put("mid", String.valueOf(this.mid));
            }
            HiidoStatis.reportEvent((HiidoEvent)event);
            ((IRelationService)this.getServiceManager().getService(IRelationService.class)).requestFollow(relationship, EPath.PATH_OLD_FRIENDS.getValue());
            this.reportImOldAddFriends();
        }
    }

    private void reportImOldAddFriends() {
        ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("add_friend"));
        PushPermissionTipManager.checkToShowPushDialog((PushPermissionTipManager.Source)PushPermissionTipManager.Source.ADD_FRIEND);
    }

    private boolean isBlack(long uid) {
        return ((IBlacklistService)this.getServiceManager().getService(IBlacklistService.class)).isInBlacklist(uid).getInBlacklist();
    }
}

