/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.bbs;

import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.hiyo.user.profile.bbs.BBsPostDbListener;
import com.yy.hiyo.user.profile.bbs.IBBsPostDbService;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ihago.bbs.srv.mgr.GetUserPostInfoRes;

public class BBsPostDbService
extends DefaultController
implements IBBsPostDbService {
    private static final String TAG = "BBsPostDbService";
    private static final int MAX_SIZE = 16;
    private Map<Long, GetUserPostInfoRes> mListMap = new LinkedHashMap<Long, GetUserPostInfoRes>(16, 0.75f, true);

    public BBsPostDbService(Environment env) {
        super(env);
    }

    @Override
    public void savePostInfo(GetUserPostInfoRes infoRes, Long uid) {
        Long next;
        this.mListMap.put(uid, infoRes);
        if (this.mListMap.size() >= 9 && (next = this.mListMap.keySet().iterator().next()) != null) {
            this.mListMap.remove(next);
        }
    }

    @Override
    public void getPostInfo(Long uid, BBsPostDbListener listener) {
        if (this.containsPost(uid)) {
            listener.success(this.mListMap.get(uid));
        }
    }

    @Override
    public boolean containsPost(long uid) {
        try {
            GetUserPostInfoRes postInfoRes = this.mListMap.get(uid);
            return postInfoRes != null && !postInfoRes.posts.isEmpty();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)("containsPost uid: " + uid + ", error: " + e.toString()), (Object[])new Object[0]);
            return false;
        }
    }

    @Override
    public boolean isMusicPerson(long uid) {
        try {
            GetUserPostInfoRes infoRes = this.mListMap.get(uid);
            if (infoRes != null && infoRes.extra_user_data.music_count > 0L) {
                return true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)("isMusicPerson uid: " + uid + ", error: " + e.toString()), (Object[])new Object[0]);
        }
        return false;
    }
}

