/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.user.R;
import java.util.ArrayList;
import java.util.List;

public class ProfilePhotosVPAdapter
extends PagerAdapter {
    private static final String TAG = "ProfilePhotosVPAdapter";
    private final SparseArray<MyRecycleImageView> mPhotos = new SparseArray();
    private final List<String> mUrls = new ArrayList<String>();
    private OnVpItemClickListener mOnVpItemClickListener;
    private int mWidth;
    private int mHeight;
    private boolean mFirstPage = true;
    @DrawableRes
    private int mPlaceHolder = R.drawable.img_user_profile_no_album;
    @Nullable
    private OnFirstPhotoLoadedCallback mOnFirstPhotoLoadedCallback;

    public ProfilePhotosVPAdapter(List<String> urls) {
        if (!FP.empty(urls)) {
            this.setData(urls);
        }
    }

    public void setData(List<String> urls) {
        if (FP.empty(urls)) {
            return;
        }
        boolean change = false;
        int size = urls.size();
        int oldSize = this.mUrls.size();
        while (this.mUrls.size() > size) {
            int position = this.mUrls.size() - 1;
            this.mUrls.remove(position);
            if (this.mPhotos.size() > position && this.mPhotos.get(position) != null) {
                this.mPhotos.remove(position);
            }
            change = true;
        }
        for (int i = 0; i < size; ++i) {
            String url = urls.get(i);
            if (i < oldSize) {
                String oldUrl = this.mUrls.get(i);
                if (!TextUtils.isEmpty((CharSequence)oldUrl) && oldUrl.equals(url)) continue;
                this.mUrls.set(i, url);
                if (this.mPhotos.size() > i && this.mPhotos.get(i) != null) {
                    ((MyRecycleImageView)((Object)this.mPhotos.get(i))).setTag(null);
                }
                change = true;
                continue;
            }
            this.mUrls.add(url);
            change = true;
        }
        if (change) {
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.mUrls.size();
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (object instanceof View) {
            if (position != 0 || container.getChildAt(0) != object) {
                MLog.info((Object)TAG, (String)"destroyItem removeView", (Object[])new Object[0]);
                ((ViewPager)container).removeView((View)object);
            }
            ((View)object).setTag(null);
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        String oldIconUrl = null;
        if (this.mPhotos.get(position) == null) {
            MyRecycleImageView imageView = new MyRecycleImageView(container.getContext(), this.mUrls.get(position));
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.mPhotos.put(position, (Object)imageView);
        } else {
            oldIconUrl = ((MyRecycleImageView)((Object)this.mPhotos.get((int)position))).iconUrl;
        }
        MyRecycleImageView ivPhoto = (MyRecycleImageView)((Object)this.mPhotos.get(position));
        if (ivPhoto.getTag() instanceof Integer && (Integer)ivPhoto.getTag() == position) {
            boolean result = this.findView(container, (View)ivPhoto);
            if (!result) {
                container.addView((View)ivPhoto);
            }
            if (!StringUtils.equal((String)oldIconUrl, (String)this.mUrls.get(position))) {
                this.updateImageUrl(ivPhoto, this.mUrls.get(position));
            }
            return ivPhoto;
        }
        if (this.mFirstPage) {
            int avatarPos;
            int n = avatarPos = LanguageUtils.isRtl() ? this.mUrls.size() - 1 : 0;
            if (position == avatarPos) {
                ivPhoto.setTag(position);
                if (!StringUtils.equal((String)oldIconUrl, (String)this.mUrls.get(position))) {
                    if (StringUtils.isNotEmpty((String)oldIconUrl)) {
                        MLog.info((Object)TAG, (String)"\u52a0\u8f7d\u7b2c\u4e00\u5f20\u56fe\u7247\uff0c\u51fa\u73b0\u591a\u6b21\u52a0\u8f7d %s new %s", (Object[])new Object[]{oldIconUrl, this.mUrls.get(position)});
                    } else {
                        MLog.info((Object)TAG, (String)"\u52a0\u8f7d\u7b2c\u4e00\u5f20\u56fe\u7247\uff0c%s", (Object[])new Object[]{this.mUrls.get(position)});
                    }
                    this.updateImageUrl(ivPhoto, this.mUrls.get(position));
                }
            }
        } else {
            ImageLoader.with((ImageView)ivPhoto, (String)this.mUrls.get(position)).useHeif(true).placeholder(this.mPlaceHolder).setSize(this.mWidth, this.mHeight).load();
        }
        boolean result = this.findView(container, (View)ivPhoto);
        if (!result) {
            container.addView((View)ivPhoto);
        }
        ivPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ProfilePhotosVPAdapter.this.mOnVpItemClickListener != null) {
                    int position = v.getTag() instanceof Integer ? (Integer)v.getTag() : 0;
                    ProfilePhotosVPAdapter.this.mOnVpItemClickListener.onItemClick(v, position);
                }
            }
        });
        return ivPhoto;
    }

    private void updateImageUrl(final MyRecycleImageView ivPhoto, String url) {
        ivPhoto.iconUrl = url;
        final Drawable defaultDrawable = ResourceUtils.getDrawable((int)this.mPlaceHolder);
        ImageLoader.with((ImageView)ivPhoto, (String)url).useHeif(true).placeholder(this.mPlaceHolder).setSize(this.mWidth, this.mHeight).load();
        ImageLoader.loadBitmap((Context)ivPhoto.getContext(), (String)this.thumPhotoUrl(url), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Bitmap bitmap) {
                if (ivPhoto.getDrawable() == null || ivPhoto.getDrawable() == defaultDrawable) {
                    ivPhoto.setImageBitmap(bitmap);
                    MLog.info((Object)ProfilePhotosVPAdapter.TAG, (String)"\u7b2c\u4e00\u5f20\u56fe\u7247\u7f29\u7565\u56fe\u751f\u6548\uff01", (Object[])new Object[0]);
                }
                if (ProfilePhotosVPAdapter.this.mOnFirstPhotoLoadedCallback != null) {
                    ProfilePhotosVPAdapter.this.mOnFirstPhotoLoadedCallback.onPhotoLoaded();
                }
            }
        });
    }

    private boolean findView(ViewGroup container, View view) {
        int childCount = container.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                if (container.getChildAt(i) != view) continue;
                return true;
            }
        }
        return false;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (positionOffset > 0.0f) {
            this.mFirstPage = false;
        }
    }

    public void onPageSelected(int position) {
        RecycleImageView ivPhoto;
        this.mFirstPage = false;
        if (FP.size(this.mPhotos) > position && (ivPhoto = (RecycleImageView)this.mPhotos.get(position)) != null && ivPhoto.getTag() == null && FP.size(this.mUrls) > position) {
            ImageLoader.with((ImageView)ivPhoto, (String)this.mUrls.get(position)).useHeif(true).setCrossFade(true).placeholder(this.mPlaceHolder).setSize(this.mWidth, this.mHeight).load();
            ivPhoto.setTag((Object)position);
        }
    }

    private String thumPhotoUrl(String url) {
        return url + YYImageUtils.getThumbnailPostfix((int)75);
    }

    public int getItemPosition(@NonNull Object object) {
        return -2;
    }

    public void setOnVpItemClickListener(OnVpItemClickListener listener) {
        this.mOnVpItemClickListener = listener;
    }

    public void setOnFirstPhotoLoadedCallback(@Nullable OnFirstPhotoLoadedCallback onFirstPhotoLoadedCallback) {
        this.mOnFirstPhotoLoadedCallback = onFirstPhotoLoadedCallback;
    }

    public void setPhotoSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public void setPlaceHolder(@DrawableRes int placeHolder) {
        this.mPlaceHolder = placeHolder;
    }

    private static class MyRecycleImageView
    extends RecycleImageView {
        public String iconUrl;

        MyRecycleImageView(Context context, String iconUrl) {
            super(context);
            this.iconUrl = iconUrl;
        }
    }

    public static interface OnFirstPhotoLoadedCallback {
        public void onPhotoLoaded();
    }

    public static interface OnVpItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

