/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile.adapter;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.honor.HonorInfo;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.base.honor.HonorIntroPopupwindow;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class ProfileHonorTitleAdapter
extends RecyclerView.Adapter<HonorTitleViewHolder> {
    private List<HonorInfo> mData;
    private boolean isNewProfile = true;

    public ProfileHonorTitleAdapter(List<HonorInfo> titleIds) {
        this.mData = titleIds;
    }

    public int getItemCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    @NonNull
    public HonorTitleViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.isNewProfile) {
            return new HonorTitleViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_profile_honor_title_v2, parent, false));
        }
        return new HonorTitleViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_profile_honor_title, parent, false));
    }

    public void onBindViewHolder(@NonNull HonorTitleViewHolder holder, int position) {
        final HonorInfo honorInfo = this.mData.get(position);
        if (honorInfo == null) {
            return;
        }
        if (Build.VERSION.SDK_INT <= 17) {
            holder.ivIcon.setAutoTransformToWebpFlag(false);
        }
        ImageLoader.loadImage((ImageView)holder.ivIcon, (String)honorInfo.getSicon(), (int)R.drawable.icon_default_photo, (int)R.drawable.icon_default_photo);
        holder.ivIcon.setTag((Object)honorInfo);
        holder.ivIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HonorInfo infoTemp = (HonorInfo)v.getTag();
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023793").put("function_id", "honor_click ").put("title_id", String.valueOf(honorInfo.getId())));
                new HonorIntroPopupwindow(v.getContext()).showHonorPopup(v, infoTemp.getName(), infoTemp.getDesc(), true);
            }
        });
    }

    class HonorTitleViewHolder
    extends RecyclerView.ViewHolder {
        public RecycleImageView ivIcon;

        HonorTitleViewHolder(View itemView) {
            super(itemView);
            this.ivIcon = (RecycleImageView)itemView.findViewById(R.id.iv_icon);
        }
    }
}

