/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import biz.UserInfo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.OnGetInviteFriendStateCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IGetCharismaCallback;
import com.yy.appbase.service.callback.IGetMedalListCallback;
import com.yy.appbase.service.callback.IGetOnlineStatusCallback;
import com.yy.appbase.service.callback.IProfileOperationCallback;
import com.yy.appbase.service.callback.IQueryOnlineCallBack;
import com.yy.appbase.service.callback.IQueryUserBy3rdAccountCallBack;
import com.yy.appbase.service.callback.IUserDistanceInfoCallback;
import com.yy.appbase.service.callback.OnAlbumCallback;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.appbase.service.callback.OnGetAllHonorTitlesCallback;
import com.yy.appbase.service.callback.OnGetGuideTypeCallback;
import com.yy.appbase.service.callback.OnGetInsPhotosCallback;
import com.yy.appbase.service.callback.OnGetInsStatusCallback;
import com.yy.appbase.service.callback.OnGetLatestHonorCallback;
import com.yy.appbase.service.callback.OnGetShareForFriendCallback;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.service.callback.OnKSProfileSingleCallback;
import com.yy.appbase.service.callback.OnLikeClickCallback;
import com.yy.appbase.service.callback.OnLikeListCallback;
import com.yy.appbase.service.callback.OnUpdateCallback;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.user.UserBBSMedalInfo;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.core.EventIntent;
import com.yy.base.event.fw.FWEvent;
import com.yy.base.event.fw.FWEventActionKey;
import com.yy.base.event.fw.FWEventAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.list.KvoPageList;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.user.base.data.MyLikeListRes;
import com.yy.hiyo.user.base.data.MyLikeUserInfo;
import com.yy.hiyo.user.base.data.UserModuleData;
import com.yy.hiyo.user.profile.InstagramPhotoModel;
import com.yy.hiyo.user.profile.NewUserInfoModel;
import com.yy.hiyo.user.profile.PhotoModel;
import com.yy.hiyo.user.profile.UserInfoKSConverter;
import com.yy.hiyo.user.profile.UserInfoModel;
import com.yy.hiyo.user.profile.online.OnlineModel;
import com.yy.hiyo.user.profile.online.OnlineRequest;
import com.yy.hiyo.user.profile.profilecard.ProfileCardDialog;
import com.yy.hiyo.user.profile.profilecard.ProfileCardManager;
import com.yy.hiyo.user.profile.sevice.AccountTransformService;
import com.yy.hiyo.user.profile.sevice.OnlineService;
import common.Page;
import ikxd.pkgame.TeammateInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ihago.base.api.accessrecords.GetUserHomePageAccessRecordsReq;
import net.ihago.base.api.accessrecords.GetUserHomePageAccessRecordsRsp;
import net.ihago.base.srv.strategy.GetUserStatusReq;
import net.ihago.base.srv.strategy.GetUserStatusRes;
import net.ihago.bbs.srv.mgr.DiscoverUser;
import net.ihago.bbs.srv.mgr.LikeItem;
import net.ihago.medal.srv.mgr.BatchGetMedalReq;
import net.ihago.medal.srv.mgr.BatchGetMedalRes;
import net.ihago.medal.srv.mgr.UserMedalInfos;
import net.ihago.online.srv.online.GetOnlineStatusRes;
import net.ihago.online.srv.online.OnlineStatus;
import net.ihago.uinfo.api.uinfo.SetLabelReq;
import net.ihago.uinfo.api.uinfo.SetLabelRes;
import okhttp3.Call;

public class UserInfoService
extends DefaultController
implements IUserInfoService {
    public static final String TAG = "UserInfoService";
    private AccountTransformService mAccountTransformService;
    private OnlineService mOnlineService;
    private UserInfoModel mUserModel;
    private PhotoModel mPhotoModel;
    private NewUserInfoModel mNewUserInfoModel;
    private InstagramPhotoModel instagramPhotoModel;
    private OnlineModel mOnlineModel;
    private OnlineRequest mOnlineRequest;
    private long mLastRequestMyLikeListTime = 0L;
    private final UserModuleData mData;
    private Set<Long> mToSendUids = new HashSet<Long>();
    private final Object mBatchGetUserBBSMedalLock = new byte[0];
    private Runnable mScheduleBathGetUserBBSTask = () -> {
        ArrayList<Long> toSendUids;
        Object object = this.mBatchGetUserBBSMedalLock;
        synchronized (object) {
            toSendUids = new ArrayList<Long>(this.mToSendUids);
            this.mToSendUids.clear();
        }
        int size = toSendUids.size();
        if (size <= 100) {
            this.doBatchGet(toSendUids);
        } else {
            for (int i = 0; i < size; i += 100) {
                this.doBatchGet(toSendUids.subList(i, Math.min(i + 100, size)));
            }
        }
    };

    public UserInfoService(Environment env) {
        super(env);
        this.mData = new UserModuleData();
        FWEvent.bindMethodToEvent((Object)((Object)this), (String)"onVisitorIncrease");
        this.mAccountTransformService = new AccountTransformService(env);
        this.mOnlineService = new OnlineService(env);
        this.mOnlineRequest = new OnlineRequest();
        this.mUserModel = new UserInfoModel(() -> (IDBService)this.getServiceManager().getService(IDBService.class));
        this.mPhotoModel = new PhotoModel(this.getEnvironment());
        this.mNewUserInfoModel = new NewUserInfoModel();
        this.instagramPhotoModel = new InstagramPhotoModel();
        this.mOnlineModel = new OnlineModel();
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(() -> {
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
            });
        } else {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        }
        if (RuntimeContext.sIsAppStartFinished) {
            YYTaskExecutor.execute(this::transferDataFromUserBeanToKS);
            YYTaskExecutor.execute(() -> this.mNewUserInfoModel.trimTable());
        } else {
            MLog.info((Object)TAG, (String)"not start finished", (Object[])new Object[0]);
        }
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.mUserModel.clearCache();
        } else if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            YYTaskExecutor.execute(this::transferDataFromUserBeanToKS);
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED) {
            YYTaskExecutor.execute(() -> this.mNewUserInfoModel.trimTable());
        }
    }

    private void transferDataFromUserBeanToKS() {
        MyBox userInfoBox = ((IDBService)ServiceManagerProxy.getService(IDBService.class)).boxForCurUser(UserInfoBean.class);
        if (userInfoBox == null) {
            MLog.error((Object)TAG, (String)"transferDataFromUserBeanToKS box is null", (Object[])new Object[0]);
            return;
        }
        userInfoBox.getAll(datas -> {
            if (datas != null) {
                ArrayList<UserInfoKS> userInfoKSList = new ArrayList<UserInfoKS>();
                for (UserInfoBean bean : datas) {
                    UserInfoKS userInfoKS = this.getUserInfo(bean.getUid());
                    if (userInfoKS.ver > 0L) continue;
                    UserInfoKSConverter.convertFromUserInfoBean(bean, userInfoKS);
                    userInfoKSList.add(userInfoKS);
                }
                MLog.info((Object)TAG, (String)("transferDataFromUserBeanToKS bean size: " + datas.size() + ", saved size: " + userInfoKSList.size()), (Object[])new Object[0]);
                this.mNewUserInfoModel.batchSave(userInfoKSList);
            }
            userInfoBox.deleteAll();
        });
    }

    public void getFirstPageMyLikeList(ICommonCallback callback) {
        MyLikeListRes.Page page = new MyLikeListRes.Page();
        page.limit = 20L;
        page.offset = 0L;
        this.doGetMyLikeList(0L, page, callback);
    }

    public void getNextPageMyLikeList(ICommonCallback callback) {
        KvoPageList list = this.mData.myLikeUserList;
        MyLikeListRes.Page page = new MyLikeListRes.Page();
        page.limit = 20L;
        page.offset = list.offset;
        this.doGetMyLikeList(this.mLastRequestMyLikeListTime, page, callback);
    }

    private void doGetMyLikeList(Long lastRequestTime, final MyLikeListRes.Page page, final ICommonCallback callback) {
        JsonObject pageObject = new JsonObject();
        pageObject.addProperty("offset", (Number)page.offset);
        pageObject.addProperty("limit", (Number)page.limit);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("page", (JsonElement)pageObject);
        jsonObject.addProperty("last_time", (Number)lastRequestTime);
        UserInfoModel.httpReqEx(UriProvider.GET_MY_LIKE_LIST, jsonObject, null, new INetRespCallback<MyLikeListRes>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)UserInfoService.TAG, (String)("get like count error\uff1a" + e), (Object[])new Object[0]);
                if (callback != null) {
                    callback.onFail(id2, "", new Object[0]);
                }
            }

            public void onResponse(String response, BaseResponseBean<MyLikeListRes> parseData, int id2) {
                MLog.info((Object)UserInfoService.TAG, (String)("get my like list success\uff1a" + response), (Object[])new Object[0]);
                if (parseData.data == null) {
                    callback.onFail(parseData.code, parseData.message, new Object[0]);
                    return;
                }
                if (page.offset == 0L) {
                    UserInfoService.this.mLastRequestMyLikeListTime = ((MyLikeListRes)parseData.data).lastTime;
                }
                MyLikeListRes.Page resPage = ((MyLikeListRes)parseData.data).page;
                List list = ((MyLikeListRes)parseData.data).list == null ? new ArrayList() : ((MyLikeListRes)parseData.data).list;
                for (MyLikeUserInfo info : list) {
                    info.lastRequestTime = ((MyLikeListRes)parseData.data).lastTime;
                }
                ((UserInfoService)UserInfoService.this).mData.myLikeUserList.combineList(list, 0L, page.limit, resPage.total, page.offset, page.offset + (long)list.size());
                if (callback != null) {
                    callback.onSuccess(parseData.data, new Object[]{parseData.code});
                }
            }
        }, 1);
    }

    public KvoSource data() {
        return this.mData;
    }

    public void getFirstPageMyVisitList(IProtoCallback<GetUserHomePageAccessRecordsRsp> callback) {
        this.doGetMyVisitList(1L, new Page.Builder().limit(Long.valueOf(20L)).offset(Long.valueOf(0L)).snap(Long.valueOf(0L)).total(Long.valueOf(0L)).build(), callback);
    }

    public void getNextPageMyVisitList(IProtoCallback<GetUserHomePageAccessRecordsRsp> callback) {
        KvoPageList list = this.mData.myVisitUserList;
        this.doGetMyVisitList(1L, new Page.Builder().limit(Long.valueOf(20L)).offset(Long.valueOf(list.offset)).snap(Long.valueOf(list.snapshot)).total(Long.valueOf(list.total)).build(), callback);
    }

    private void doGetMyVisitList(long startTime, final Page page, final IProtoCallback<GetUserHomePageAccessRecordsRsp> callback) {
        GetUserHomePageAccessRecordsReq req = new GetUserHomePageAccessRecordsReq.Builder().page(page).start_time(Long.valueOf(startTime)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetUserHomePageAccessRecordsRsp>(){

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)UserInfoService.TAG, (String)"doGetMyVisitList timeout.", (Object[])new Object[0]);
                if (callback != null) {
                    return callback.retryWhenTimeout(canRetry);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)UserInfoService.TAG, (String)("doGetMyVisitList error: " + code + ", reason: " + reason), (Object[])new Object[0]);
                if (callback != null) {
                    return callback.retryWhenError(canRetry, reason, code);
                }
                return false;
            }

            public void onResponse(@NonNull GetUserHomePageAccessRecordsRsp message, long code, String msgTip) {
                MLog.debug((Object)UserInfoService.TAG, (String)"getAccessRecords onResponse, code:$code, msg:$msg, message:$message", (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    ((UserInfoService)UserInfoService.this).mData.myVisitUserList.combineList(message.items, message.page.snap.longValue(), page.limit.longValue(), message.page.total.longValue(), page.offset.longValue(), page.offset + (long)message.items.size());
                }
                if (callback != null) {
                    callback.onResponse((AndroidMessage)message, code, msgTip);
                }
            }
        });
    }

    public void onLeaveMyVisitPage() {
        String key = "my_visitors_unread_" + AccountUtil.getUid();
        this.mData.setValue("unreadCount", (Object)0);
        SettingFlags.setIntValue((String)key, (int)0);
    }

    @FWEventAnnotation(name=FWEventActionKey.FWAction_On_Visitor_Add)
    public void onVisitorIncrease(EventIntent eventIntent) {
        String key = "my_visitors_unread_" + AccountUtil.getUid();
        this.mData.setValue("unreadCount", (Object)(SettingFlags.getIntValue((String)key, (int)0) + (Integer)eventIntent.arg0()));
        SettingFlags.setIntValue((String)key, (int)this.mData.unreadCount);
    }

    public void queryOnlineStatus(long uid, IGetOnlineStatusCallback callback) {
        this.mUserModel.getOnlineStatus(uid, callback);
    }

    public void updateLikeInfo(long uid, OnLikeClickCallback callback) {
        boolean isBlack = ((IBlacklistService)this.getServiceManager().getService(IBlacklistService.class)).isInBlacklist(uid).getInBlacklist();
        if (isBlack) {
            callback.onIsBlock();
        } else {
            this.mUserModel.requestLikeClick(uid, callback);
        }
    }

    public void getLikeStatus(long uid, OnLikeListCallback callback) {
        ArrayList<Long> uidList = new ArrayList<Long>();
        uidList.add(uid);
        this.mUserModel.requestIfLiked(uidList, callback);
    }

    public void getLikeCount(long uid, OnLikeListCallback callback) {
        ArrayList<Long> uidList = new ArrayList<Long>();
        uidList.add(uid);
        this.mUserModel.requestGetLikeCount(uidList, callback);
    }

    public void updateAvatar(String path, OnUpdateCallback callback) {
        this.mPhotoModel.putPhoto(path, 2, callback);
    }

    public void updateAlbum(String path, final OnUpdateCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            String ext = YYFileUtils.getFileExtension((String)path);
            if (TextUtils.isEmpty((CharSequence)ext)) {
                ext = ".jpg";
            }
            String key = "album/" + AccountUtil.getUid() + "_" + System.currentTimeMillis() + ext;
            if (callback == null) {
                return;
            }
            ((IOOSService)this.getServiceManager().getService(IOOSService.class)).uploadFile(key, path, new IUploadObjectCallBack(){

                public void onSuccess(UploadObjectRequest request) {
                    String url = request.mUrl;
                    UserInfoService.this.mPhotoModel.addPhotoToAlbum(url, callback);
                }

                public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                    MLog.info((Object)UserInfoService.TAG, (String)("uploadFile err\uff1a" + exception.toString()), (Object[])new Object[0]);
                    callback.onError(null, exception, errorCode);
                }
            });
        }
    }

    public void replaceAllAlbum(List<String> list, OnUpdateCallback callback) {
        if (!list.isEmpty()) {
            this.mPhotoModel.replaceAllAlbum(list, callback);
        }
    }

    public void replaceFromAlbum(String addImageUrl, final String delImageUrl, final int position, final OnUpdateCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)addImageUrl)) {
            String ext = YYFileUtils.getFileExtension((String)addImageUrl);
            if (TextUtils.isEmpty((CharSequence)ext)) {
                ext = ".jpg";
            }
            final String key = "album/" + AccountUtil.getUid() + "_" + System.currentTimeMillis() + ext;
            if (callback == null) {
                return;
            }
            ((IOOSService)this.getServiceManager().getService(IOOSService.class)).uploadFile(key, addImageUrl, new IUploadObjectCallBack(){

                public void onSuccess(UploadObjectRequest request) {
                    String url = request.mUrl;
                    UserInfoService.this.mPhotoModel.replacePhotoFromAlbum(url, delImageUrl, position, callback);
                }

                public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                    MLog.info((Object)UserInfoService.TAG, (String)"replaceFromAlbum %s", (Object[])new Object[]{key});
                    callback.onError(null, exception, errorCode);
                }
            });
        }
    }

    public void deletePhoto(String url, OnUpdateCallback callback) {
        this.mPhotoModel.deletePhotoFromAlbum(url, callback);
    }

    public void requestAlbum(long uid, @Nullable OnAlbumCallback callback) {
        this.mPhotoModel.requestAlbum(uid, callback);
    }

    public void getGameHistory(long uid, OnGameHistoryCallback callback) {
        this.mUserModel.requestGetGameHistory(uid, 0, callback);
    }

    public void getMineGameHistoryCacheFirst(OnGameHistoryCallback callback) {
        this.mUserModel.requestMineGameHistoryCacheFirst(callback);
    }

    public void getGameHistoryWithLimit(long uid, int showcount, OnGameHistoryCallback callback) {
        this.mUserModel.requestGetGameHistory(uid, showcount, callback);
    }

    public void getShareForFriend(long uid, OnGetShareForFriendCallback callback) {
        this.mUserModel.requestShareFofriendCard(uid, callback);
    }

    public void getFindFriendGuideType(long uid, OnGetGuideTypeCallback callback) {
        this.mUserModel.requestGuideTypeFofriendCard(uid, callback);
    }

    public void getUserInfoByThirdPartyAccount(final ArrayList<String> ids, final IQueryUserBy3rdAccountCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                UserInfoService.this.mAccountTransformService.getUserInfoByThirdPartyAccount(ids, callBack);
            }
        });
    }

    public HashMap<Long, Boolean> getOnlineStatus(ArrayList<Long> ids, IQueryOnlineCallBack callBack) {
        return this.mOnlineService.getOnlineStatus(ids, callBack);
    }

    public void getInstagramBindStatus(OnGetInsStatusCallback callback) {
        this.instagramPhotoModel.getInstagramBindStatus(callback);
    }

    public void getInstagramPhotos(long uid, OnGetInsPhotosCallback callback) {
        this.instagramPhotoModel.getInstagramPhotos(uid, callback);
    }

    public void deleteInstagramPhotosFromCache(long uid) {
        this.instagramPhotoModel.deleteInstagramPhotosFromCache(uid);
    }

    public void uploadInstagramPhotos(Object obj, INetRespCallback callback) {
        this.instagramPhotoModel.uploadInsPhotos((List)obj, callback);
    }

    public void getLatestHonor(long uid, OnGetLatestHonorCallback callback) {
        this.mUserModel.getLasestHonorTitle(uid, callback);
    }

    public void getMedalList(long uid, IGetMedalListCallback callback) {
        this.mUserModel.getMedalList(uid, callback);
    }

    public void getAllHonorTitles(long uid, OnGetAllHonorTitlesCallback callback) {
        this.mUserModel.getHonorTitleList(uid, callback);
    }

    public void getHonorByTitleId(long titleId, OnGetLatestHonorCallback callback) {
        this.mUserModel.getLatestHonorInfo(titleId, callback);
    }

    public void getInviteFriendState(OnGetInviteFriendStateCallback callback) {
        this.mUserModel.getInviteFriendState(callback);
    }

    public int getInviteFriendIsActive() {
        return this.mUserModel.getInviteFriendIsActive();
    }

    public void showProfileCard(Context context, int direction, long uid, IProfileOperationCallback callback, boolean isDefaultStyle) {
        ProfileCardManager profileCardManager = ProfileCardManager.newInstance();
        ProfileCardDialog profileCardDialog = profileCardManager.create(this.mContext, callback, direction, isDefaultStyle);
        profileCardManager.initData(uid);
        this.mDialogLinkManager.showDialog((BaseDialog)profileCardDialog);
    }

    public void getCharisma(long uid, long seqid, int giftNum, IGetCharismaCallback callback) {
        this.mUserModel.requestCharismaData(uid, seqid, giftNum, callback);
    }

    @NonNull
    public List<UserInfoKS> getRandomTenUser() {
        return this.mNewUserInfoModel.getRandomTenUser();
    }

    public LiveData<UserOnlineDBBean> getOnlineStatus(long uid, boolean request) {
        return this.mOnlineModel.getUserStatus(uid, request);
    }

    public LiveData<Map<Long, UserOnlineDBBean>> getOnlineStatus(@NonNull List<Long> uid, boolean request) {
        return this.mOnlineModel.getUserStatus(uid, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchGetUserBBSMedals(Long ... uids) {
        Object object = this.mBatchGetUserBBSMedalLock;
        synchronized (object) {
            boolean isEmpty = this.mToSendUids.isEmpty();
            this.mToSendUids.addAll(Arrays.asList(uids));
            if (isEmpty) {
                YYTaskExecutor.execute((Runnable)this.mScheduleBathGetUserBBSTask, (long)1000L);
            }
        }
    }

    private void doBatchGet(List<Long> uids) {
        if (uids.size() == 0) {
            return;
        }
        BatchGetMedalReq req = new BatchGetMedalReq.Builder().uids(uids).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<BatchGetMedalRes>(){

            public void onResponse(@NonNull BatchGetMedalRes res, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    List userMedalInfosList = res.user_medal_infos_list;
                    for (UserMedalInfos userMedalInfos : userMedalInfosList) {
                        UserBBSMedalInfo.info((long)userMedalInfos.uid).fromProto(userMedalInfos);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)UserInfoService.TAG, (String)"baBatchGetMedalReqtchGet retryWhenError reason=%s, code=%s", (Object[])new Object[]{reason, code});
                return false;
            }
        });
    }

    public void requestUserDistancesWithMe(double myLatitude, double myLongitude, @NonNull List<Long> withUids, @NonNull IUserDistanceInfoCallback callback) {
        this.mNewUserInfoModel.requestUserDistancesWithMe(myLatitude, myLongitude, withUids, callback);
    }

    public void requestUserOnline(long uid, final SimpleProtoCallback<GetUserStatusRes> callback) {
        GetUserStatusReq req = new GetUserStatusReq.Builder().uids(Collections.singletonList(uid)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetUserStatusRes>(){

            public void onResponse(@NonNull GetUserStatusRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callback != null) {
                        callback.onResponse((AndroidMessage)res, code, msgTip);
                    }
                } else if (callback != null) {
                    callback.onError(msgTip, (int)code);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void requestUserOnlines(List<Long> uids, final SimpleProtoCallback<GetUserStatusRes> callback) {
        GetUserStatusReq req = new GetUserStatusReq.Builder().uids(uids).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetUserStatusRes>(){

            public void onResponse(@NonNull GetUserStatusRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callback != null) {
                        callback.onResponse((AndroidMessage)res, code, msgTip);
                    }
                } else if (callback != null) {
                    callback.onError(msgTip, (int)code);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    @NonNull
    public UserInfoKS getUserInfo(long uid) {
        return this.mNewUserInfoModel.getUserInfo(uid);
    }

    @NonNull
    public List<UserInfoKS> fromLikeItems(@NonNull List<LikeItem> likeItems) {
        ArrayList<UserInfoKS> userInfoKSList = new ArrayList<UserInfoKS>();
        for (LikeItem likeItem : likeItems) {
            userInfoKSList.add(UserInfoKSConverter.convertFrom(likeItem, this.getUserInfo(likeItem.liked_user.uid)));
        }
        this.mNewUserInfoModel.batchSave(userInfoKSList);
        return userInfoKSList;
    }

    @NonNull
    public UserInfoKS fromTeammateInfo(@NonNull TeammateInfo bean) {
        UserInfoKS userInfoKS = UserInfoKSConverter.update(bean, this.getUserInfo(bean.uid));
        this.mNewUserInfoModel.saveUserInfo(userInfoKS);
        return userInfoKS;
    }

    @NonNull
    public UserInfoKS fromDiscoverUser(@NonNull DiscoverUser bean) {
        UserInfoKS userInfoKS = UserInfoKSConverter.convertFrom(bean, this.getUserInfo(bean.user.uid));
        this.mNewUserInfoModel.saveUserInfo(userInfoKS);
        return userInfoKS;
    }

    @NonNull
    public List<UserInfoKS> fromDiscoverUsers(@NonNull List<DiscoverUser> beans) {
        ArrayList<UserInfoKS> userInfoKSList = new ArrayList<UserInfoKS>();
        for (DiscoverUser bean : beans) {
            userInfoKSList.add(UserInfoKSConverter.convertFrom(bean, this.getUserInfo(bean.user.uid)));
        }
        this.mNewUserInfoModel.batchSave(userInfoKSList);
        return userInfoKSList;
    }

    @NonNull
    public List<UserInfoKS> fromProtoInChannelAct(@NonNull List<UserInfo> beans) {
        ArrayList<UserInfoKS> userInfoKSList = new ArrayList<UserInfoKS>();
        for (UserInfo bean : beans) {
            userInfoKSList.add(UserInfoKSConverter.convertFromChannelAct(bean, this.getUserInfo(bean.uid)));
        }
        this.mNewUserInfoModel.batchSave(userInfoKSList);
        return userInfoKSList;
    }

    @NonNull
    public UserInfoKS updateFromShadowInfo(@Nullable UserInfoKS from, @NonNull UserInfoKS to) {
        return UserInfoKSConverter.updateFromShadowInfo(from, to);
    }

    public void requestUserInfoFromServer(long uid, @Nullable OnKSProfileListCallback callback) {
        this.mNewUserInfoModel.requestUserInfo(uid, callback);
    }

    public void requestUserInfoFromServerWithVer(long uid, long ver, @Nullable OnKSProfileListCallback callback) {
        this.mNewUserInfoModel.requestUserInfo(uid, ver, callback);
    }

    public void requestUserInfosFromServer(@NonNull List<Long> uids, @Nullable OnKSProfileListCallback callback) {
        this.mNewUserInfoModel.requestUserInfos(uids, callback);
    }

    public void updateRemote(@Nullable UserInfo selector, @NonNull UserInfo toUpdateInfo, @Nullable OnKSProfileSingleCallback callback) {
        this.mNewUserInfoModel.updateInfo(selector, toUpdateInfo, callback);
    }

    public void saveUserInfo(@NonNull UserInfoKS userInfoKS) {
        this.mNewUserInfoModel.saveUserInfo(userInfoKS);
    }

    public void batchSaveUserInfo(@NonNull List<UserInfoKS> userInfoKS) {
        this.mNewUserInfoModel.batchSave(userInfoKS);
    }

    public void updateLabels(final @NonNull List<Integer> labelIds, final @Nullable SimpleProtoCallback<SetLabelRes> callback) {
        SetLabelReq req = new SetLabelReq.Builder().label_ids(labelIds).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SetLabelRes>(){

            public void onResponse(@NonNull SetLabelRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                MLog.info((Object)UserInfoService.TAG, (String)"updateLabels onResponse code %d, msg %s", (Object[])new Object[]{code, msgTip});
                if (this.isSuccess(code)) {
                    UserInfoKS userInfoKS = UserInfoService.this.getUserInfo(AccountUtil.getUid());
                    userInfoKS.setValue("label", (Object)JsonParser.toJson((Object)labelIds));
                    UserInfoService.this.saveUserInfo(userInfoKS);
                    if (callback != null) {
                        callback.onResponse((AndroidMessage)res, code, msgTip);
                    }
                } else if (callback != null) {
                    callback.onError(msgTip, (int)code);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)UserInfoService.TAG, (String)"updateLabels onError code %d, msg %s", (Object[])new Object[]{code, reason});
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void getOnlineStatusWithCallback(@NonNull List<Long> uid, final ICommonCallback<Map<Long, UserOnlineDBBean>> callback) {
        MLog.info((Object)TAG, (String)"requestOnlineStatus", (Object[])new Object[0]);
        this.mOnlineRequest.requestOnlineStatus(uid, new ICommonCallback<GetOnlineStatusRes>(){

            public void onSuccess(GetOnlineStatusRes getOnlineStatusRes, Object ... ext) {
                if (getOnlineStatusRes != null && getOnlineStatusRes.online_list != null) {
                    List onlineStatusList = getOnlineStatusRes.online_list;
                    HashMap<Long, UserOnlineDBBean> res = new HashMap<Long, UserOnlineDBBean>(onlineStatusList.size());
                    long updateTimeStamp = System.currentTimeMillis();
                    for (OnlineStatus onlineStatus : onlineStatusList) {
                        UserOnlineDBBean userOnlineDBBean = new UserOnlineDBBean(0L, onlineStatus.uid.longValue(), onlineStatus.online.booleanValue(), onlineStatus.background.booleanValue(), onlineStatus.ingame.booleanValue(), onlineStatus.gid, onlineStatus.inroom.booleanValue(), onlineStatus.cid, onlineStatus.plugin, updateTimeStamp);
                        res.put(onlineStatus.uid, userOnlineDBBean);
                    }
                    callback.onSuccess(res, new Object[0]);
                } else {
                    callback.onFail(-1, "get online is null", new Object[0]);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                callback.onFail(errCode, msg, ext);
            }
        });
    }

    public static interface IModelCallBack {
        public IDBService getDBService();
    }
}

