/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.FindFriendShareBean;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.data.Like.LikeInfo;
import com.yy.appbase.data.Like.LikeListBean;
import com.yy.appbase.data.LikeDb;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.honor.HonorInfo;
import com.yy.appbase.honor.MedalInfo;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.OnGetHonorConfigCallback;
import com.yy.appbase.service.OnGetInviteFriendStateCallback;
import com.yy.appbase.service.callback.IGetCharismaCallback;
import com.yy.appbase.service.callback.IGetMedalListCallback;
import com.yy.appbase.service.callback.IGetOnlineStatusCallback;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.appbase.service.callback.OnGetAllHonorTitlesCallback;
import com.yy.appbase.service.callback.OnGetGuideTypeCallback;
import com.yy.appbase.service.callback.OnGetLatestHonorCallback;
import com.yy.appbase.service.callback.OnGetShareForFriendCallback;
import com.yy.appbase.service.callback.OnLikeClickCallback;
import com.yy.appbase.service.callback.OnLikeListCallback;
import com.yy.appbase.util.StatusUtil;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.user.profile.UserInfoService;
import com.yy.hiyo.user.profile.bean.CharismaBean;
import com.yy.hiyo.user.profile.bean.GiftRank;
import com.yy.hiyo.user.profile.bean.LikeClickParamBeam;
import com.yy.hiyo.user.profile.bean.UidParamBean;
import common.Header;
import ikxd.activity.Activity;
import ikxd.activity.GetInviteFriendTipsReq;
import ikxd.activity.Uri;
import ikxd.task.GetIconFrameConfigReq;
import ikxd.task.GetIconFrameConfigRes;
import ikxd.task.GetImTitleReq;
import ikxd.task.GetImTitleRes;
import ikxd.task.GetPageTitleReq;
import ikxd.task.GetPageTitleRes;
import ikxd.task.IconFrameConfig;
import ikxd.task.Task;
import ikxd.task.TaskUri;
import ikxd.task.TitleInfo;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.achievement.srv.mgr.AchievementMedal;
import net.ihago.achievement.srv.mgr.GetMedalMetaReq;
import net.ihago.achievement.srv.mgr.GetMedalMetaRes;
import net.ihago.achievement.srv.mgr.GetUserAchievementPageReq;
import net.ihago.achievement.srv.mgr.GetUserAchievementPageRes;
import net.ihago.achievement.srv.mgr.MedalMetaData;
import net.ihago.money.api.charm.GetCharmPropRankReq;
import net.ihago.money.api.charm.GetCharmPropRankRes;
import net.ihago.money.api.charm.PropRank;
import net.ihago.online.srv.online.GetOnlineStatusReq;
import net.ihago.online.srv.online.GetOnlineStatusRes;
import net.ihago.online.srv.online.OnlineStatus;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class UserInfoModel {
    private static final String TAG = "UserInfoModel";
    public static final int HTTP_GET = 1;
    public static final int HTTP_POST = 2;
    public static final int RESPONSE_OK = 1;
    public static final int RESPONSE_PARSE_ERROR = 0;
    private static final long GAME_HOSTORY_CACHE_STAY_TIME = 300000L;
    private long mGameHistoryLastCacheTime;
    private UserInfoService.IModelCallBack mCallBack;
    public int mIsInviteFriendActive = 0;
    private static final String DIR = "honor";
    private static final String CONFIG_FILE_NAME = "honorconfig.txt";
    private static final String MEDAL_CONFIG_FILE_NAME = "medalconfig.txt";
    private final List<HonorInfo> mHonorInfoList = new ArrayList<HonorInfo>();
    private final List<MedalInfo> mMedalInfoList = new ArrayList<MedalInfo>();
    private final List<GameHistoryBean> mOwnGameHistoryBeanList = new ArrayList<GameHistoryBean>();

    public UserInfoModel(UserInfoService.IModelCallBack callBack) {
        this.mCallBack = callBack;
    }

    private String getHttpUrl(String url, String paramJson) {
        return url + paramJson;
    }

    public void updateLikeListLocal(long uid) {
        MyBox box = null;
        IDBService idbService = this.mCallBack.getDBService();
        if (idbService != null) {
            box = idbService.boxForCurUser(LikeDb.class);
        }
        if (box != null) {
            box.updateItem((BaseDBBean)new LikeDb(uid), true);
        }
    }

    public void clearCache() {
        this.mMedalInfoList.clear();
    }

    public void requestLikeClick(long uid, final OnLikeClickCallback callback) {
        LikeClickParamBeam param = new LikeClickParamBeam();
        param.targetUid = uid;
        if (callback == null) {
            return;
        }
        UserInfoModel.httpReqEx(UriProvider.LIKE_CLICK, param, null, new INetRespCallback<LikeInfo>(){

            public void onError(Call call, Exception e, int id2) {
                callback.onError(call, e, id2);
            }

            public void onResponse(String response, BaseResponseBean<LikeInfo> parseData, int id2) {
                if (parseData.data != null) {
                    callback.onUISuccess((LikeInfo)parseData.data, parseData.code);
                    YYTaskExecutor.execute(() -> UserInfoModel.this.updateLikeListLocal(((LikeInfo)parseData.data).mTargetUid));
                } else {
                    callback.onResponseError(parseData.code, parseData.message, response);
                }
            }
        }, 1);
    }

    public void requestIfLiked(List<Long> uidList, final OnLikeListCallback callback) {
        UidParamBean bean = new UidParamBean();
        if (FP.empty(uidList)) {
            return;
        }
        bean.uids.addAll(uidList);
        if (callback == null) {
            return;
        }
        UserInfoModel.httpReqEx(UriProvider.GET_LIKE_STATUS, bean, null, new INetRespCallback<LikeListBean>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)UserInfoModel.TAG, (String)("get like status error\uff1a" + e), (Object[])new Object[0]);
                callback.onError(call, e, id2);
            }

            public void onResponse(String response, BaseResponseBean<LikeListBean> res, int id2) {
                if (res.data != null) {
                    callback.onUISuccess(((LikeListBean)res.data).list, res.code);
                } else {
                    callback.onResponseError(0, "parse error", response);
                }
            }
        }, 1);
    }

    public void requestGetLikeCount(List<Long> uidList, final OnLikeListCallback callback) {
        UidParamBean bean = new UidParamBean();
        if (uidList == null || uidList.size() <= 0) {
            return;
        }
        bean.uids.addAll(uidList);
        if (callback == null) {
            return;
        }
        UserInfoModel.httpReqEx(UriProvider.GET_LIKE_COUNT, bean, null, new INetRespCallback<LikeListBean>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)UserInfoModel.TAG, (String)("get like count error\uff1a" + e), (Object[])new Object[0]);
                callback.onError(call, e, id2);
            }

            public void onResponse(String response, BaseResponseBean<LikeListBean> parseData, int id2) {
                MLog.info((Object)UserInfoModel.TAG, (String)("get like count success\uff1a" + response), (Object[])new Object[0]);
                if (parseData.data != null) {
                    callback.onUISuccess(((LikeListBean)parseData.data).list, parseData.code);
                } else {
                    callback.onResponseError(parseData.code, parseData.message, response);
                }
            }
        }, 1);
    }

    public void requestGetGameHistory(final long uid, final int showcount, final OnGameHistoryCallback callback) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uid", String.valueOf(uid));
        param.put("showcount", String.valueOf(showcount));
        String url = this.getHttpUrl(UriProvider.GAME_HISTORY, "");
        if (callback == null) {
            return;
        }
        UserInfoModel.httpReq(url, "", param, new INetRespCallback<List<GameHistoryBean>>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)UserInfoModel.TAG, (String)("get game history onError" + e), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread(() -> callback.onError(call, e, id2));
            }

            public void onResponse(String response, BaseResponseBean<List<GameHistoryBean>> parseData, int id2) {
                MLog.info((Object)UserInfoModel.TAG, (String)"get game history success!", (Object[])new Object[0]);
                ArrayList data = (ArrayList)parseData.data;
                if (data == null) {
                    if (callback != null) {
                        data = new ArrayList();
                        callback.onUISuccess(data, parseData.code);
                    }
                    return;
                }
                if (showcount == 0 && AccountUtil.getUid() == uid) {
                    UserInfoModel.this.mOwnGameHistoryBeanList.clear();
                    UserInfoModel.this.mOwnGameHistoryBeanList.addAll(data);
                    UserInfoModel.this.mGameHistoryLastCacheTime = System.currentTimeMillis();
                }
                callback.onUISuccess(data, parseData.code);
            }
        }, 1);
    }

    public void requestMineGameHistoryCacheFirst(OnGameHistoryCallback callback) {
        if (callback == null) {
            return;
        }
        if (!this.mOwnGameHistoryBeanList.isEmpty() && System.currentTimeMillis() - this.mGameHistoryLastCacheTime <= 300000L) {
            callback.onUISuccess(this.mOwnGameHistoryBeanList, 0);
            return;
        }
        this.requestGetGameHistory(AccountUtil.getUid(), 0, callback);
    }

    public void requestShareFofriendCard(long uid, final OnGetShareForFriendCallback callback) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uid", String.valueOf(uid));
        String url = this.getHttpUrl(UriProvider.SHARE_FIND_FRIEND, "");
        if (callback == null) {
            return;
        }
        UserInfoModel.httpReq(url, "", param, new INetRespCallback<FindFriendShareBean>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)UserInfoModel.TAG, (String)("requestShareFofriendCard onError" + e), (Object[])new Object[0]);
                callback.onError(call, e, id2);
            }

            public void onResponse(String response, BaseResponseBean<FindFriendShareBean> parseData, int id2) {
                MLog.info((Object)UserInfoModel.TAG, (String)("requestShareFofriendCard success\uff1a" + response), (Object[])new Object[0]);
                if (parseData.data != null) {
                    callback.onGetSuccess((FindFriendShareBean)parseData.data);
                }
            }
        }, 1);
    }

    public void requestGuideTypeFofriendCard(long uid, final OnGetGuideTypeCallback callback) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uid", String.valueOf(uid));
        String url = this.getHttpUrl(UriProvider.SHARE_FIND_FRIEND_GUIDE_TYPE, "");
        if (callback == null) {
            return;
        }
        UserInfoModel.httpReq(url, "", param, new INetRespCallback<FindFriendShareBean>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)UserInfoModel.TAG, (String)("requestGuideTypeFofriendCard onError" + e), (Object[])new Object[0]);
                callback.onError(call, e, id2);
            }

            public void onResponse(String response, BaseResponseBean<FindFriendShareBean> parseData, int id2) {
                if (parseData.data != null) {
                    callback.onGetGuideTypeSuccess(((FindFriendShareBean)parseData.data).template);
                }
            }
        }, 1);
    }

    public void getHonorTitleList(long uid, final OnGetAllHonorTitlesCallback callback) {
        MLog.info((Object)TAG, (String)"start to get honor title list", (Object[])new Object[0]);
        GetPageTitleReq req = new GetPageTitleReq.Builder().uid(Long.valueOf(uid)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_task_d");
        Task unifo = new Task.Builder().header(header).uri(TaskUri.kUriTaskGetPageTitleReq).get_page_title_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)unifo, (IProtoCallback)new IProtoCallback<Task>(){

            public void onResponse(@Nullable Task result) {
                if (result != null && result.uri == TaskUri.kUriTaskGetPageTitleRes) {
                    GetPageTitleRes getPageTitleRes = result.get_page_title_res;
                    if (getPageTitleRes == null) {
                        callback.onResponseError(100, "GetPageTitleRes = null", "");
                        return;
                    }
                    List titleList = getPageTitleRes.title;
                    if (titleList == null) {
                        callback.onResponseError(100, "List<TitleInfo> = null", "");
                        return;
                    }
                    MLog.info((Object)UserInfoModel.TAG, (String)("get all honor success:" + titleList.size()), (Object[])new Object[0]);
                    UserInfoModel.this.getAllHonorInfo(titleList, callback);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)UserInfoModel.TAG, (String)"get all honor retryWhenTimeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)UserInfoModel.TAG, (String)"get all honor retryWhenError", (Object[])new Object[0]);
                return false;
            }
        });
    }

    private void getAllHonorInfo(final List<TitleInfo> titleList, final OnGetAllHonorTitlesCallback callback) {
        this.getHonorConfig(new OnGetHonorConfigCallback(){

            public void onGetHonorCofigSuccess(List<HonorInfo> list) {
                if (callback != null && list != null && titleList != null) {
                    ArrayList<HonorInfo> honorInfoList = new ArrayList<HonorInfo>();
                    for (int i = 0; i < titleList.size(); ++i) {
                        TitleInfo titleInfo = (TitleInfo)titleList.get(i);
                        long titleId = titleInfo.title_id;
                        HonorInfo fitHonorInfo = UserInfoModel.this.getFitHonorInfo(list, (int)titleId);
                        if (fitHonorInfo == null) continue;
                        honorInfoList.add(fitHonorInfo);
                    }
                    callback.onGetHonorTitlesSuccess(honorInfoList);
                }
            }

            public void onLatestHonorError() {
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    public void getLasestHonorTitle(long uid, final OnGetLatestHonorCallback callback) {
        GetImTitleReq req = new GetImTitleReq.Builder().uid(Long.valueOf(uid)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_task_d");
        Task unifo = new Task.Builder().header(header).uri(TaskUri.kUriTaskGetImTitleReq).get_im_title_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)unifo, (IProtoCallback)new IProtoCallback<Task>(){

            public void onResponse(@Nullable Task result) {
                if (result != null && result.uri == TaskUri.kUriTaskGetImTitleRes) {
                    GetImTitleRes getImTitleRes = result.get_im_title_res;
                    TitleInfo title = getImTitleRes.title;
                    if (callback != null && title != null) {
                        UserInfoModel.this.getLatestHonorInfo(title.title_id.intValue(), callback);
                        MLog.info((Object)UserInfoModel.TAG, (String)("get latest honor success:" + title.title_id), (Object[])new Object[0]);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)UserInfoModel.TAG, (String)"get latest honor retryWhenTimeout", (Object[])new Object[0]);
                if (callback != null) {
                    callback.onLatestHonorError();
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)UserInfoModel.TAG, (String)"get latest honor retryWhenError", (Object[])new Object[0]);
                if (callback != null) {
                    callback.onLatestHonorError();
                }
                return false;
            }
        });
    }

    public void getMedalList(long uid, final IGetMedalListCallback callback) {
        MLog.info((Object)TAG, (String)"getMedalList, uid %s", (Object[])new Object[]{uid});
        GetUserAchievementPageReq req = new GetUserAchievementPageReq.Builder().uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetUserAchievementPageRes>(){

            public void onResponse(final @NonNull GetUserAchievementPageRes res, long code, String msg) {
                MLog.info((Object)UserInfoModel.TAG, (String)"getMedalList, code: %d, msg: %s, res:%s", (Object[])new Object[]{code, msg, res});
                if (FP.empty((Collection)res.list)) {
                    if (callback != null) {
                        callback.onSuccess(new ArrayList());
                    }
                } else {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<MedalInfo> list = new ArrayList<MedalInfo>();
                            ArrayList<List> seqList = new ArrayList<List>();
                            try {
                                for (int i = 0; i < res.list.size(); ++i) {
                                    AchievementMedal achievementMedal = (AchievementMedal)res.list.get(i);
                                    MedalInfo medalInfo = new MedalInfo();
                                    medalInfo.setId(achievementMedal.id.longValue());
                                    medalInfo.setValid(achievementMedal.is_obtain.booleanValue());
                                    medalInfo.setObtainTime(achievementMedal.first_obtain.longValue());
                                    if (achievementMedal.extra != null) {
                                        JSONObject jsonObject;
                                        medalInfo.setExtra(achievementMedal.extra.guest_content);
                                        if (!TextUtils.isEmpty((CharSequence)achievementMedal.extra.content) && (jsonObject = JsonParser.obtainJSONObject((String)achievementMedal.extra.content)).has("sub_medal")) {
                                            List subList = (List)JsonParser.parseJsonObject((String)jsonObject.optString("sub_medal"), (Type)new TypeToken<List<MedalInfo>>(){}.getType());
                                            medalInfo.setSubMedalList(subList);
                                            seqList.add(subList);
                                        }
                                    }
                                    list.add(medalInfo);
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            UserInfoModel.this.notifyResult(list, seqList, callback);
                        }
                    });
                }
            }

            public void onError(String reason, int code) {
                MLog.info((Object)UserInfoModel.TAG, (String)"getMedalList, code: %d, reason: %s", (Object[])new Object[]{code, reason});
                if (callback != null) {
                    callback.onError(code, reason);
                }
            }
        });
    }

    public void getOnlineStatus(long uid, final IGetOnlineStatusCallback callback) {
        MLog.info((Object)TAG, (String)"getOnlineStatus, uid %s", (Object[])new Object[]{uid});
        ArrayList<Long> uids = new ArrayList<Long>();
        uids.add(uid);
        GetOnlineStatusReq req = new GetOnlineStatusReq.Builder().uids(uids).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetOnlineStatusRes>(){

            public void onResponse(@NonNull GetOnlineStatusRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                MLog.info((Object)UserInfoModel.TAG, (String)"getOnlineStatus, code: %d, msg: %s, res:%s", (Object[])new Object[]{code, msgTip, res});
                if (callback != null) {
                    final List onlineStatusList = res.online_list;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(StatusUtil.parseStatus((OnlineStatus)((OnlineStatus)onlineStatusList.get(0))));
                        }
                    });
                }
            }

            public void onError(String reason, int code) {
                MLog.info((Object)UserInfoModel.TAG, (String)"getOnlineStatus, code: %d, reason: %s", (Object[])new Object[]{code, reason});
                if (callback != null) {
                    callback.onError(code, reason);
                }
            }
        });
    }

    private void notifyResult(final List<MedalInfo> medalInfoList, List<List<MedalInfo>> seqList, final IGetMedalListCallback callback) {
        final Object[] successOnce = new Object[]{false};
        final Object[] notifyTotal = new Object[]{false};
        final Object[] notifySub = new Object[]{false};
        if (!FP.empty(seqList)) {
            final ArrayList<List<MedalInfo>> copyList = new ArrayList<List<MedalInfo>>(seqList);
            for (final List<MedalInfo> list : seqList) {
                this.combineMedalInfoList(list, new IGetMedalListCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(@NotNull List<MedalInfo> medalList) {
                        List list2 = copyList;
                        synchronized (list2) {
                            copyList.remove(list);
                            if (copyList.size() <= 0) {
                                notifySub[0] = true;
                            }
                        }
                        if (callback != null && ((Boolean)notifySub[0]).booleanValue() && ((Boolean)notifyTotal[0]).booleanValue() && ((Boolean)successOnce[0]).booleanValue()) {
                            callback.onSuccess(medalInfoList);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onError(int code, @org.jetbrains.annotations.Nullable String msg) {
                        List list2 = copyList;
                        synchronized (list2) {
                            copyList.remove(list);
                            if (copyList.size() <= 0) {
                                notifySub[0] = true;
                            }
                            if (callback != null && ((Boolean)notifySub[0]).booleanValue() && ((Boolean)notifyTotal[0]).booleanValue() && !((Boolean)successOnce[0]).booleanValue()) {
                                callback.onError(code, msg);
                            }
                        }
                    }
                });
            }
        } else {
            notifySub[0] = true;
        }
        this.combineMedalInfoList(medalInfoList, new IGetMedalListCallback(){

            public void onSuccess(@NotNull List<MedalInfo> medalList) {
                successOnce[0] = true;
                notifyTotal[0] = true;
                if (callback != null && ((Boolean)notifySub[0]).booleanValue()) {
                    callback.onSuccess(medalInfoList);
                }
            }

            public void onError(int code, @org.jetbrains.annotations.Nullable String msg) {
                notifyTotal[0] = true;
                if (callback != null && ((Boolean)notifySub[0]).booleanValue()) {
                    callback.onError(code, msg);
                }
            }
        });
    }

    private void combineMedalInfoList(final List<MedalInfo> list, final IGetMedalListCallback callback) {
        if (!FP.empty(list)) {
            this.getMedalConfig(new IGetMedalListCallback(){

                public void onSuccess(@NotNull List<MedalInfo> medalList) {
                    MLog.info((Object)UserInfoModel.TAG, (String)"combineMedalInfoList, medalList:%s", (Object[])new Object[]{medalList});
                    if (callback != null) {
                        if (!FP.empty(medalList)) {
                            for (int i = 0; i < list.size(); ++i) {
                                MedalInfo origin = (MedalInfo)list.get(i);
                                long medalId = origin.getId();
                                MedalInfo metaData = UserInfoModel.this.selectMedalInfo(medalList, medalId);
                                if (metaData == null) continue;
                                origin.setName(metaData.getName());
                                origin.setType(metaData.getType());
                                origin.setDesc(metaData.getDesc());
                                origin.setPriority(metaData.getPriority());
                                origin.setIcon(metaData.getIcon());
                                origin.setGrayIcon(metaData.getGrayIcon());
                            }
                        }
                        callback.onSuccess(list);
                    }
                }

                public void onError(int code, @org.jetbrains.annotations.Nullable String msg) {
                    if (callback != null) {
                        callback.onError(code, msg);
                    }
                }
            });
        } else if (callback != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess(list);
                }
            });
        }
    }

    private MedalInfo selectMedalInfo(List<MedalInfo> medalList, long medalId) {
        try {
            if (!FP.empty(medalList)) {
                for (int i = 0; i < medalList.size(); ++i) {
                    MedalInfo medalInfo = medalList.get(i);
                    if (medalInfo.getId() != medalId) continue;
                    return medalInfo;
                }
            }
        }
        catch (Exception ex) {
            MLog.info((Object)TAG, (String)"selectMedalInfo, exception:%s", (Object[])new Object[]{ex});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMedalConfig(final IGetMedalListCallback callback) {
        final ArrayList<MedalInfo> result = new ArrayList<MedalInfo>();
        List<MedalInfo> list = this.mMedalInfoList;
        synchronized (list) {
            if (!this.mMedalInfoList.isEmpty()) {
                result.addAll(this.mMedalInfoList);
            }
        }
        if (result.size() > 0 && callback != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess((List)result);
                }
            });
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List configFromFile = UserInfoModel.this.getMedalConfigFromFile();
                if (configFromFile == null || configFromFile.isEmpty()) {
                    SettingFlags.setLongValue((String)UserInfoModel.this.getMedalConfigVersionKey(), (long)0L);
                    UserInfoModel.this.getMedalConfigFromServer(callback);
                } else if (callback != null) {
                    List list = UserInfoModel.this.mMedalInfoList;
                    synchronized (list) {
                        UserInfoModel.this.mMedalInfoList.clear();
                        UserInfoModel.this.mMedalInfoList.addAll(configFromFile);
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ArrayList list = new ArrayList(UserInfoModel.this.mMedalInfoList);
                            callback.onSuccess(list);
                        }
                    });
                    UserInfoModel.this.getMedalConfigFromServer(null);
                }
            }
        });
    }

    private void getMedalConfigFromServer(final IGetMedalListCallback callback) {
        long configVersion = SettingFlags.getLongValue((String)this.getMedalConfigVersionKey(), (long)0L);
        MLog.info((Object)TAG, (String)"getMedalConfig, version=%s", (Object[])new Object[]{configVersion});
        GetMedalMetaReq req = new GetMedalMetaReq.Builder().version(Long.valueOf(configVersion)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetMedalMetaRes>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NonNull GetMedalMetaRes res, long code, String msg) {
                MLog.info((Object)UserInfoModel.TAG, (String)"getMedalConfig, code=%s, msg=%s, res=%s", (Object[])new Object[]{code, msg, res});
                List configList = res.list;
                SettingFlags.setLongValue((String)UserInfoModel.this.getMedalConfigVersionKey(), (long)res.version);
                ArrayList<MedalInfo> dataList = new ArrayList<MedalInfo>();
                if (!FP.empty((Collection)configList)) {
                    for (int i = 0; i < configList.size(); ++i) {
                        MedalMetaData configRes = (MedalMetaData)configList.get(i);
                        if (configRes == null) continue;
                        MedalInfo medalInfo = new MedalInfo();
                        medalInfo.setName(configRes.name);
                        medalInfo.setDesc(configRes.desc);
                        medalInfo.setType(configRes.m_type.intValue());
                        medalInfo.setPriority(configRes.level.intValue());
                        medalInfo.setIcon(configRes.icon);
                        medalInfo.setGrayIcon(configRes.unlit_icon);
                        medalInfo.setId(configRes.id.longValue());
                        dataList.add(medalInfo);
                    }
                }
                List i = UserInfoModel.this.mMedalInfoList;
                synchronized (i) {
                    if (UserInfoModel.this.mMedalInfoList != null && dataList != null && dataList.size() > 0) {
                        UserInfoModel.this.mMedalInfoList.clear();
                        UserInfoModel.this.mMedalInfoList.addAll(dataList);
                    }
                }
                if (callback != null) {
                    ArrayList data = null;
                    List list = UserInfoModel.this.mMedalInfoList;
                    synchronized (list) {
                        if (!UserInfoModel.this.mMedalInfoList.isEmpty()) {
                            data = new ArrayList(UserInfoModel.this.mMedalInfoList);
                        }
                    }
                    callback.onSuccess(data);
                }
                UserInfoModel.this.saveMedalConfig(dataList);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback != null) {
                    callback.onError(-1, "retryWhenTimeout");
                }
                return super.retryWhenTimeout(canRetry);
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (callback != null) {
                    callback.onError(code, "retryWhenError,reason:" + reason);
                }
                return super.retryWhenError(canRetry, reason, code);
            }
        });
    }

    public void getLatestHonorInfo(final long titleId, final OnGetLatestHonorCallback callback) {
        this.getHonorConfig(new OnGetHonorConfigCallback(){

            public void onGetHonorCofigSuccess(List<HonorInfo> list) {
                if (callback != null && list != null) {
                    HonorInfo fitHonorInfo = UserInfoModel.this.getFitHonorInfo(list, titleId);
                    callback.onLatestHonorSuccess(fitHonorInfo);
                }
            }

            public void onLatestHonorError() {
                if (callback != null) {
                    callback.onLatestHonorError();
                }
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    private HonorInfo getFitHonorInfo(List<HonorInfo> list, long titleId) {
        for (int i = 0; i < list.size(); ++i) {
            HonorInfo honorInfo = list.get(i);
            if (honorInfo.getId() != titleId) continue;
            return honorInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHonorConfig(final OnGetHonorConfigCallback callback) {
        ArrayList<HonorInfo> result = null;
        List<HonorInfo> list = this.mHonorInfoList;
        synchronized (list) {
            if (!this.mHonorInfoList.isEmpty()) {
                result = new ArrayList<HonorInfo>(this.mHonorInfoList);
            }
        }
        if (result != null && result.size() > 0 && callback != null) {
            callback.onGetHonorCofigSuccess(result);
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List configFromFile = UserInfoModel.this.getConfigFromFile();
                if (configFromFile == null || configFromFile.isEmpty()) {
                    SettingFlags.setLongValue((String)UserInfoModel.this.getHonorConfigVersionKey(), (long)0L);
                    UserInfoModel.this.getHonorConfigFromServer(callback);
                } else if (callback != null) {
                    ArrayList result = null;
                    List list = UserInfoModel.this.mHonorInfoList;
                    synchronized (list) {
                        UserInfoModel.this.mHonorInfoList.clear();
                        UserInfoModel.this.mHonorInfoList.addAll(configFromFile);
                        result = new ArrayList(UserInfoModel.this.mHonorInfoList);
                    }
                    callback.onGetHonorCofigSuccess(result);
                    UserInfoModel.this.getHonorConfigFromServer(null);
                }
            }
        });
    }

    private void getHonorConfigFromServer(final OnGetHonorConfigCallback callback) {
        MLog.info((Object)TAG, (String)"start to  getconfig from server", (Object[])new Object[0]);
        long configVersion = SettingFlags.getLongValue((String)this.getHonorConfigVersionKey());
        if (configVersion == -1L) {
            configVersion = 0L;
        }
        GetIconFrameConfigReq req = new GetIconFrameConfigReq.Builder().version(Long.valueOf(configVersion)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_task_d");
        Task unifo = new Task.Builder().header(header).uri(TaskUri.kUriTaskGetIconFrameConfigReq).get_icon_frame_config_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)unifo, (IProtoCallback)new IProtoCallback<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@Nullable Task result) {
                if (result != null && result.uri == TaskUri.kUriTaskGetIconFrameConfigRes) {
                    GetIconFrameConfigRes getIconFrameConfigRes = result.get_icon_frame_config_res;
                    List configList = getIconFrameConfigRes.config;
                    long configResVersion = getIconFrameConfigRes.version;
                    SettingFlags.setLongValue((String)UserInfoModel.this.getHonorConfigVersionKey(), (long)configResVersion);
                    ArrayList<HonorInfo> dataList = new ArrayList<HonorInfo>();
                    MLog.info((Object)UserInfoModel.TAG, (String)"getconfig from server success", (Object[])new Object[0]);
                    if (configList != null) {
                        MLog.info((Object)UserInfoModel.TAG, (String)("getconfig from server success" + configList.size()), (Object[])new Object[0]);
                        for (int i = 0; i < configList.size(); ++i) {
                            IconFrameConfig configRes = (IconFrameConfig)configList.get(i);
                            HonorInfo honorInfo = new HonorInfo();
                            honorInfo.setId((long)configRes.title_id.intValue());
                            honorInfo.setName(configRes.name);
                            honorInfo.setDesc(configRes.desc);
                            honorInfo.setSicon(configRes.sicon);
                            honorInfo.setBicon(configRes.bicon);
                            if (dataList == null) continue;
                            dataList.add(honorInfo);
                        }
                    }
                    List i = UserInfoModel.this.mHonorInfoList;
                    synchronized (i) {
                        if (UserInfoModel.this.mHonorInfoList != null && dataList != null && dataList.size() > 0) {
                            UserInfoModel.this.mHonorInfoList.clear();
                            UserInfoModel.this.mHonorInfoList.addAll(dataList);
                        }
                    }
                    if (callback != null) {
                        ArrayList data = null;
                        List list = UserInfoModel.this.mHonorInfoList;
                        synchronized (list) {
                            if (!UserInfoModel.this.mHonorInfoList.isEmpty()) {
                                data = new ArrayList(UserInfoModel.this.mHonorInfoList);
                            }
                        }
                        callback.onGetHonorCofigSuccess(data);
                    }
                    UserInfoModel.this.saveHonorConfigToLocal(dataList);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)UserInfoModel.TAG, (String)" getconfig timeout retryWhenTimeout", (Object[])new Object[0]);
                if (callback != null) {
                    callback.onLatestHonorError();
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)UserInfoModel.TAG, (String)"getconfig  err  retryWhenError", (Object[])new Object[0]);
                if (callback != null) {
                    callback.onLatestHonorError();
                }
                return false;
            }
        });
    }

    private synchronized void saveHonorConfigToLocal(final List<HonorInfo> list) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (list != null) {
                    try {
                        MLog.info((Object)UserInfoModel.TAG, (String)"start saveHonorConfigToLocal", (Object[])new Object[0]);
                        String honorConfig = new Gson().toJson((Object)list);
                        File file = FileStorageUtils.getInstance().getDirAndCreate(true, UserInfoModel.DIR);
                        File configFile = new File(file, UserInfoModel.this.getHonorConfigCacheFileName());
                        YYFileUtils.writeBytesToFile((File)configFile, (byte[])honorConfig.getBytes(), (boolean)false);
                    }
                    catch (Exception e) {
                        MLog.error((Object)UserInfoModel.TAG, (String)("save honor Cofig err\uff1a" + e), (Object[])new Object[0]);
                    }
                }
            }
        });
    }

    private synchronized void saveMedalConfig(final List<MedalInfo> list) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (list != null) {
                    try {
                        String medalConfig = new Gson().toJson((Object)list);
                        File file = FileStorageUtils.getInstance().getDirAndCreate(true, UserInfoModel.DIR);
                        File configFile = new File(file, UserInfoModel.this.getMedalConfigFileName());
                        YYFileUtils.writeBytesToFile((File)configFile, (byte[])medalConfig.getBytes(), (boolean)false);
                    }
                    catch (Exception e) {
                        MLog.error((Object)UserInfoModel.TAG, (String)"saveMedalConfig failed:%s", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
        });
    }

    private synchronized List<HonorInfo> getConfigFromFile() {
        File file = FileStorageUtils.getInstance().getDirAndCreate(true, DIR);
        File configFile = new File(file, this.getHonorConfigCacheFileName());
        String result = "";
        List list = null;
        if (configFile.exists()) {
            try {
                MLog.info((Object)TAG, (String)"start getConfigFromFile", (Object[])new Object[0]);
                result = new String(YYFileUtils.getBytesFromFile((File)configFile));
                Gson gson = new Gson();
                TypeToken<List<HonorInfo>> token = new TypeToken<List<HonorInfo>>(){};
                list = (List)gson.fromJson(result, token.getType());
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)("get honor Cofig err\uff1a" + e), (Object[])new Object[0]);
            }
        }
        return list;
    }

    private synchronized List<MedalInfo> getMedalConfigFromFile() {
        File file = FileStorageUtils.getInstance().getDirAndCreate(true, DIR);
        File configFile = new File(file, this.getMedalConfigFileName());
        String result = "";
        List list = null;
        if (configFile.exists()) {
            try {
                result = new String(YYFileUtils.getBytesFromFile((File)configFile));
                Gson gson = new Gson();
                TypeToken<List<MedalInfo>> token = new TypeToken<List<MedalInfo>>(){};
                list = (List)gson.fromJson(result, token.getType());
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)("getMedalConfigFromFile failed:" + e), (Object[])new Object[0]);
            }
        }
        return list;
    }

    public void getInviteFriendState(final OnGetInviteFriendStateCallback callback) {
        GetInviteFriendTipsReq req = new GetInviteFriendTipsReq.Builder().build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_activity_d");
        Activity activity = new Activity.Builder().header(header).uri(Uri.kUriActivityGetInviteFriendTipsReq).invite_friend_tips_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)activity, (IProtoCallback)new IProtoCallback<Activity>(){

            public void onResponse(Activity data) {
                try {
                    final Activity result = data;
                    if (result != null && result.uri == Uri.kUriActivityGetInviteFriendTipsRes) {
                        MLog.info((Object)UserInfoModel.TAG, (String)"get invite friend tip state success", (Object[])new Object[0]);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                boolean activityFlag = result.invite_friend_tips_res.activity;
                                boolean rewardFlag = result.invite_friend_tips_res.reward;
                                int n = UserInfoModel.this.mIsInviteFriendActive = activityFlag ? 2 : 1;
                                if (callback != null) {
                                    callback.onGetStateSuccess(activityFlag, rewardFlag);
                                }
                                MLog.info((Object)UserInfoModel.TAG, (String)("get invite friend tip state success\uff1a" + activityFlag + "--" + rewardFlag), (Object[])new Object[0]);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    MLog.info((Object)UserInfoModel.TAG, (String)("getInviteFriendState onError" + e.toString()), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)UserInfoModel.TAG, (String)"getInviteFriendState retryWhenTimeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)UserInfoModel.TAG, (String)"getInviteFriendState retryWhenError", (Object[])new Object[0]);
                return false;
            }
        });
    }

    public int getInviteFriendIsActive() {
        return this.mIsInviteFriendActive;
    }

    private String getHonorConfigCacheFileName() {
        return CONFIG_FILE_NAME + SystemUtils.getLang();
    }

    private String getMedalConfigFileName() {
        return MEDAL_CONFIG_FILE_NAME + SystemUtils.getLang();
    }

    private String getHonorConfigVersionKey() {
        return "honor_config_res" + SystemUtils.getLang();
    }

    private String getMedalConfigVersionKey() {
        return "key_medal_config_version" + SystemUtils.getLang();
    }

    public static <T> void httpReqEx(String url, Object data, Map<String, String> params, INetRespCallback<T> callback, int type) {
        if (data != null) {
            YYTaskExecutor.execute(() -> {
                String jsonStr = JsonParser.toJson((Object)data);
                HashMap<String, String> paramTemp = params;
                if (paramTemp == null) {
                    paramTemp = new HashMap<String, String>();
                }
                paramTemp.put("data", jsonStr);
                UserInfoModel.httpReq(url, jsonStr, paramTemp, callback, type);
            });
        } else {
            UserInfoModel.httpReq(url, "", params, callback, type);
        }
    }

    public static <T> void httpReq(String url, String body, Map<String, String> param, INetRespCallback<T> callback, int type) {
        switch (type) {
            case 1: {
                HttpUtil.httpReq((String)url, param, (int)1, callback);
                break;
            }
            case 2: {
                HttpUtil.httpReqPostString((String)url, (String)body, null, callback);
                break;
            }
        }
    }

    public void requestCharismaData(long uid, long seqid, int giftNum, final IGetCharismaCallback callback) {
        GetCharmPropRankReq req = new GetCharmPropRankReq.Builder().uid(Long.valueOf(uid)).prop_num(Integer.valueOf(giftNum)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetCharmPropRankRes>(){

            public void onResponse(@Nullable GetCharmPropRankRes message) {
                MLog.info((Object)UserInfoModel.TAG, (String)"onResponse not used", (Object[])new Object[0]);
            }

            public void onResponse(@NonNull GetCharmPropRankRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    final CharismaBean charismaBean = new CharismaBean();
                    ArrayList<GiftRank> list = new ArrayList<GiftRank>();
                    for (PropRank propRank : message.prop_ranks) {
                        list.add(new GiftRank(propRank.prop_id, propRank.prop_url, propRank.prop_num));
                    }
                    charismaBean.setList(list);
                    charismaBean.setCharmValue(message.charm_value);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onSucceed((Object)charismaBean);
                            }
                        }
                    });
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                MLog.info((Object)UserInfoModel.TAG, (String)"requestCharismaData retryWhenError reason=%s, code=%s", (Object[])new Object[]{reason, code});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailed(code, reason);
                    }
                });
                return false;
            }
        });
    }
}

