/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnAlbumCallback;
import com.yy.appbase.service.callback.OnUpdateCallback;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.hiyo.user.profile.bean.AlbumParamBean;
import com.yy.hiyo.user.profile.bean.AvatarParamBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

@DontProguardClass
public class PhotoModel
extends DefaultController {
    private static final String TAG = "PhotoModel";
    private static final int HTTP_GET = 1;
    private static final int HTTP_POST = 2;
    private static final int HTTP_POST_AVATER = 3;
    public static final int RESPONSE_PARSE_ERROR = 0;
    public static final int METHODE_UPDATE_ALBUM = 1;
    public static final int METHODE_UPDATE_AVATAR = 2;
    private static final String TOKEN_EXPIRED_TIME = "token_expired_time";
    private static final String GET_ALIYUN_STS = "ualbum/alioss/uploadToken";
    private static final String UPDATE_AVATAR = "uinfo/update_avatar?data=";
    private static final String UPDATE_ALBUM = "ualbum/user_album/insertIfNewUserNotExist";
    private static final String GET_ALBUM = "ualbum/user_album/get?data=";

    public PhotoModel(Environment env) {
        super(env);
    }

    private void replaceInCache(long uid, List<String> list) {
        UserInfoKS userInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(uid);
        if (userInfo != null) {
            userInfo.setValue("album", list);
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).saveUserInfo(userInfo);
    }

    public List<String> getAlbumFromCache(long uid) {
        List list = null;
        UserInfoKS userInfo = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(uid);
        if (userInfo != null) {
            list = userInfo.album;
        }
        return list;
    }

    public void putPhoto(String path, final int methode, final OnUpdateCallback callbak) {
        String ext = YYFileUtils.getFileExtension((String)path);
        String keyTmp = "";
        switch (methode) {
            case 2: {
                keyTmp = "uurl/" + AccountUtil.getUid() + "_" + System.currentTimeMillis() / 1000L + ext;
                break;
            }
            case 1: {
                keyTmp = "album/" + ext;
                break;
            }
        }
        String objectKey = keyTmp;
        ((IOOSService)this.getServiceManager().getService(IOOSService.class)).uploadFile(objectKey, path, new IUploadObjectCallBack(){

            public void onSuccess(UploadObjectRequest request) {
                String imageUrl = request.mUrl;
                switch (methode) {
                    case 2: {
                        PhotoModel.this.updateAvatar(imageUrl, callbak);
                        break;
                    }
                    case 1: {
                        PhotoModel.this.addPhotoToAlbum(imageUrl, callbak);
                        break;
                    }
                }
            }

            public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                MLog.info((Object)PhotoModel.TAG, (String)("upload img onFailure\uff1a" + exception.toString()), (Object[])new Object[0]);
                callbak.onError(null, exception, 123456);
            }
        });
    }

    public void updateAvatar(final String imageUrl, final OnUpdateCallback callback) {
        MLog.info((Object)TAG, (String)"start uploading avatar url to server", (Object[])new Object[0]);
        AvatarParamBean bean = new AvatarParamBean();
        bean.avatarUrl = imageUrl;
        if (callback == null) {
            return;
        }
        this.httpReqEx(UriProvider.UPDATE_AVATAR, bean, null, new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
                callback.onError(call, e, id2);
                MLog.error((Object)PhotoModel.TAG, (Throwable)e);
            }

            public void onResponse(String response, BaseResponseBean<Object> parseData, int id2) {
                if (parseData.code == 1) {
                    MLog.info((Object)PhotoModel.TAG, (String)"uploading avatar url successfully", (Object[])new Object[0]);
                    callback.onUISuccess(imageUrl, parseData.code);
                    YYTaskExecutor.execute(() -> {
                        UserInfoKS userInfo = ((IUserInfoService)PhotoModel.this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
                        userInfo.setValue("avatar", (Object)imageUrl);
                        ((IUserInfoService)PhotoModel.this.getServiceManager().getService(IUserInfoService.class)).saveUserInfo(userInfo);
                    });
                } else {
                    MLog.error((Object)PhotoModel.TAG, (String)response, (Object[])new Object[0]);
                    callback.onResponseError(parseData.code, parseData.message, response);
                }
            }
        }, 3);
    }

    public void requestAlbum(final long uid, final @Nullable OnAlbumCallback callback) {
        UidBean bean = new UidBean();
        bean.uid = uid;
        this.httpReqEx(UriProvider.GET_ALBUM, bean, null, new INetRespCallback<AlbumParamBean>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)PhotoModel.TAG, (String)("get album err\uff1a" + e.toString()), (Object[])new Object[0]);
                if (callback != null) {
                    callback.onError(call, e, id2);
                }
            }

            public void onResponse(String response, BaseResponseBean<AlbumParamBean> parseData, int id2) {
                MLog.debug((Object)PhotoModel.TAG, (String)("get album success\uff1a" + response), (Object[])new Object[0]);
                if (parseData.data != null) {
                    List<AlbumParamBean.Url> obList = ((AlbumParamBean)parseData.data).photos;
                    ArrayList<String> list = new ArrayList<String>();
                    if (obList != null && obList.size() > 0) {
                        for (AlbumParamBean.Url ob : obList) {
                            list.add(ob.url);
                        }
                    }
                    UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid);
                    userInfoKS.setValue("album", list);
                    ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).saveUserInfo(userInfoKS);
                    if (callback != null) {
                        callback.onUISuccess(list, uid);
                    }
                } else if (callback != null) {
                    callback.onResponseError(parseData.code, parseData.message, response);
                }
            }
        }, 1);
    }

    public void addPhotoToAlbum(String addImageUrl, OnUpdateCallback callback) {
        this.updateAlbum(addImageUrl, "", -1, null, callback);
    }

    public void deletePhotoFromAlbum(String delImageUrl, OnUpdateCallback callback) {
        this.updateAlbum("", delImageUrl, -1, null, callback);
    }

    public void replaceAllAlbum(List<String> newList, OnUpdateCallback callback) {
        this.updateAlbum("", "", -1, newList, callback);
    }

    public void replacePhotoFromAlbum(String addImageUrl, String delImageUrl, int delPosition, OnUpdateCallback callback) {
        this.updateAlbum(addImageUrl, delImageUrl, delPosition, null, callback);
    }

    private void updateAlbum(final String addImageUro, String delImageUrl, int delPosition, List<String> newList, final OnUpdateCallback callback) {
        AlbumParamBean.Url oUrl;
        AlbumParamBean.Url ob;
        AlbumParamBean bean = new AlbumParamBean();
        List<String> list = newList == null || newList.isEmpty() ? this.getAlbumFromCache(AccountUtil.getUid()) : newList;
        if (list != null && list.size() > 0) {
            for (String url : list) {
                if (url.equals(delImageUrl)) continue;
                AlbumParamBean.Url ob2 = new AlbumParamBean.Url();
                ob2.url = url;
                bean.photos.add(ob2);
            }
            if (!TextUtils.isEmpty((CharSequence)addImageUro)) {
                ob = new AlbumParamBean.Url();
                ob.url = addImageUro;
                if (delPosition <= list.size() && delPosition >= 0) {
                    Collections.reverse(bean.photos);
                    bean.photos.add(delPosition, ob);
                    Collections.reverse(bean.photos);
                } else {
                    bean.photos.add(ob);
                }
            }
        } else if (!TextUtils.isEmpty((CharSequence)addImageUro)) {
            ob = new AlbumParamBean.Url();
            ob.url = addImageUro;
            bean.photos.add(ob);
        }
        if (!TextUtils.isEmpty((CharSequence)delImageUrl)) {
            oUrl = new AlbumParamBean.Url();
            oUrl.url = delImageUrl;
            bean.deletedPhotos.add(oUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)addImageUro)) {
            oUrl = new AlbumParamBean.Url();
            oUrl.url = addImageUro;
            bean.addPhotos.add(oUrl);
        }
        ArrayList<String> listTmp = new ArrayList<String>();
        for (int i = 0; i < bean.photos.size(); ++i) {
            listTmp.add(bean.photos.get((int)i).url);
        }
        final ArrayList<String> lastestList = listTmp;
        if (callback == null) {
            return;
        }
        this.httpReqEx(UriProvider.UPDATE_ALBUM, bean, null, new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
                callback.onError(call, e, id2);
            }

            public void onResponse(String response, BaseResponseBean<Object> parseData, int id2) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)PhotoModel.TAG, (String)("updateAlbum  response = " + response), (Object[])new Object[0]);
                }
                if (parseData.code == 1) {
                    YYTaskExecutor.execute(() -> PhotoModel.this.replaceInCache(AccountUtil.getUid(), lastestList), () -> callback.onUISuccess(addImageUro, parseData.code));
                } else {
                    callback.onResponseError(parseData.code, parseData.message, response);
                }
            }
        }, 2);
    }

    private <T> void httpReq(String url, String body, Map<String, String> param, INetRespCallback<T> callback, int type) {
        switch (type) {
            case 1: {
                HttpUtil.httpReq((String)url, param, (int)1, callback);
                break;
            }
            case 2: {
                HttpUtil.httpReqPostString((String)url, (String)body, null, callback);
                break;
            }
            case 3: {
                HttpUtil.httpReq((String)url, param, (int)2, callback);
                break;
            }
        }
    }

    private <T> void httpReqEx(final String url, final Object data, final Map<String, String> params, final INetRespCallback<T> callback, final int type) {
        if (data != null) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    String jsonStr = JsonParser.toJson((Object)data);
                    HashMap<String, String> paramTemp = params;
                    if (paramTemp == null) {
                        paramTemp = new HashMap<String, String>();
                    }
                    paramTemp.put("data", jsonStr);
                    PhotoModel.this.httpReq(url, jsonStr, paramTemp, callback, type);
                }
            });
        } else {
            this.httpReq(url, "", params, callback, type);
        }
    }

    @DontProguardClass
    public static class UidBean {
        public long uid;
    }
}

