/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import biz.UserInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.db.orm.JTableInfo;
import com.yy.appbase.db.orm.bean.KvoDbBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvo.UserInfoKS_;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IUserDistanceInfoCallback;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.service.callback.OnKSProfileSingleCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.thread.ThreadBus;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.profile.UserInfoKSConverter;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.ihago.uinfo.api.uinfo.ERet;
import net.ihago.uinfo.api.uinfo.GetUinfoByVerReq;
import net.ihago.uinfo.api.uinfo.GetUinfoByVerRes;
import net.ihago.uinfo.api.uinfo.UIDVer;
import net.ihago.uinfo.api.uinfo.UpdateUinfoReq;
import net.ihago.uinfo.api.uinfo.UpdateUinfoRes;

public class NewUserInfoModel {
    public static final String TAG = "NewUserInfoModel";
    private static final int ERROR_USERINFO_UPDATE_VIOLATIONS = 361;
    private static final int USERINFO_NAME_VIOLATIONS = 1;
    private static final int USERINFO_SIGN_VIOLATIONS = 2;
    private static final int USERINFO_HOME_VIOLATIONS = 3;
    private static final int USERINFO_WORK_VIOLATIONS = 4;
    private JTableInfo<UserInfoKS> mUserInfoTable;
    private volatile boolean mIsWaiting = false;
    private final Map<Long, Long> mToGetUinfos = new HashMap<Long, Long>();
    private final List<BatchGetUinfoRequest> mBatchGetUinfoCallbacks = new ArrayList<BatchGetUinfoRequest>();
    private final Object mBatchGetUinfoLock = new byte[0];
    private final UserInfo mGetAllFieldSelector = new UserInfo.Builder().uid(Long.valueOf(1L)).hide_recomm(Long.valueOf(1L)).on_micro(Long.valueOf(1L)).hn(Long.valueOf(1L)).hide_location(Long.valueOf(1L)).flag_bit(Long.valueOf(1L)).sex(Long.valueOf(1L)).avatar("1").sign("1").nick("1").birthday("1").region("1").country("1").update_type(Long.valueOf(1L)).last_last_login_time(Long.valueOf(1L)).hometown("1").last_login_location("1").ver(Long.valueOf(1L)).vlv(Long.valueOf(1L)).vid(Long.valueOf(1L)).first_login_time(Long.valueOf(1L)).atype(Long.valueOf(1L)).job("1").label_ids(Collections.singletonList(1)).ovid(Long.valueOf(1L)).certifications(Collections.singletonList("1")).build();

    public NewUserInfoModel() {
        IDBService idbService = (IDBService)ServiceManagerProxy.getService(IDBService.class);
        if (idbService == null) {
            ServiceManagerProxy.getServiceManager().observeService(IDBService.class, (Callback)new Callback<IDBService>(){

                public void onResponse(IDBService data) {
                    NewUserInfoModel.this.mUserInfoTable = data.appTable(UserInfoKS.class);
                }
            });
        } else {
            this.mUserInfoTable = idbService.appTable(UserInfoKS.class);
        }
    }

    void trimTable() {
        long count = this.mUserInfoTable.query().build().count();
        MLog.info((Object)TAG, (String)("trimTable UserInfoKS has " + count + " items"), (Object[])new Object[0]);
        if (count > 1000L) {
            long uid = AccountUtil.getUid();
            MLog.info((Object)TAG, (String)("trimTable current uid: " + uid), (Object[])new Object[0]);
            long start = System.currentTimeMillis();
            List userInfoKSList = this.mUserInfoTable.query().notEqual(UserInfoKS_.uid, (Object)uid).build().find(0L, count - 1000L);
            if (!FP.empty((Collection)userInfoKSList)) {
                MLog.info((Object)TAG, (String)("trimTable size: " + userInfoKSList.size()), (Object[])new Object[0]);
                this.mUserInfoTable.delete((Collection)userInfoKSList);
            }
            MLog.info((Object)TAG, (String)("trimTable cost: " + (System.currentTimeMillis() - start)), (Object[])new Object[0]);
        }
    }

    @NonNull
    List<UserInfoKS> getRandomTenUser() {
        return this.mUserInfoTable.query().build().find(0L, 10L);
    }

    public void requestUserDistancesWithMe(double latitude, double longitude, @NonNull List<Long> uids, final @Nullable IUserDistanceInfoCallback callback) {
        ArrayList<UIDVer> uidVerList = new ArrayList<UIDVer>(uids.size());
        for (Long uid : uids) {
            UIDVer ver = new UIDVer.Builder().uid(uid).ver(Long.valueOf(0L)).build();
            uidVerList.add(ver);
        }
        UserInfo userInfo = new UserInfo.Builder().uid(Long.valueOf(1L)).location_tude("1").ext(Collections.singletonMap("uinfo.geo_distance", longitude + "_" + latitude)).build();
        GetUinfoByVerReq req = new GetUinfoByVerReq.Builder().uids(uidVerList).selector(userInfo).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetUinfoByVerRes>(){

            public void onResponse(@NonNull GetUinfoByVerRes message, long code, String msgTip) {
                super.onResponse((AndroidMessage)message, code, msgTip);
                MLog.info((Object)NewUserInfoModel.TAG, (String)"getUserDistance onResponse, code=%s, msg=%s", (Object[])new Object[]{code, msgTip});
                if (ProtoManager.isSuccessCode((long)code)) {
                    ArrayList<Pair> distanceList = new ArrayList<Pair>(message.infos.size());
                    for (UserInfo info : message.infos) {
                        if (info.uid == null) continue;
                        double distance = -1.0;
                        String distanceStr = (String)info.ext.get("uinfo.geo_distance");
                        if (distanceStr != null) {
                            try {
                                distance = Double.parseDouble(distanceStr);
                            }
                            catch (Exception e) {
                                MLog.warn((Object)NewUserInfoModel.TAG, (String)"parse distance error", (Object[])new Object[]{e});
                            }
                        }
                        distanceList.add(Pair.create((Object)info.uid, (Object)distance));
                    }
                    if (callback != null) {
                        callback.onSuccess(distanceList);
                    }
                } else if (callback != null) {
                    callback.onFailed((int)code, msgTip);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback != null) {
                    callback.onFailed(99, ResourceUtils.getString((int)R.string.title_net_work_error_tips));
                }
                MLog.info((Object)NewUserInfoModel.TAG, (String)"requestUserDistance, retryWhenTimeout canRetry=%s", (Object[])new Object[]{canRetry});
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (callback != null) {
                    callback.onFailed(code, reason);
                }
                MLog.info((Object)NewUserInfoModel.TAG, (String)"requestUserDistance, retryWhenError  code=, reason=%s", (Object[])new Object[]{code, reason});
                return false;
            }
        });
    }

    @NonNull
    public UserInfoKS getUserInfo(long uid) {
        return (UserInfoKS)this.mUserInfoTable.get((Object)uid);
    }

    public void saveUserInfo(@NonNull UserInfoKS userInfoKS) {
        MLog.info((Object)TAG, (String)("saveUserInfo : " + (userInfoKS == null ? -1L : userInfoKS.uid)), (Object[])new Object[0]);
        this.mUserInfoTable.save((KvoDbBean)userInfoKS);
    }

    public void batchSave(@NonNull List<UserInfoKS> userInfoKSList) {
        MLog.info((Object)TAG, (String)("batchSave : " + (userInfoKSList == null ? -1 : userInfoKSList.size())), (Object[])new Object[0]);
        this.mUserInfoTable.save(userInfoKSList);
    }

    public void updateInfo(@Nullable UserInfo selector, @NonNull UserInfo toUpdateInfo, final @Nullable OnKSProfileSingleCallback callback) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)"updateInfo selector %s, user %s", (Object[])new Object[]{JsonParser.toJson((Object)selector), JsonParser.toJson((Object)toUpdateInfo)});
        }
        UpdateUinfoReq req = new UpdateUinfoReq.Builder().selector(selector).info(toUpdateInfo).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<UpdateUinfoRes>("NewUserInfoModel.updateInfo"){

            public void onResponse(@NonNull UpdateUinfoRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                MLog.info((Object)NewUserInfoModel.TAG, (String)"updateInfo onResponse code %d, msg %s", (Object[])new Object[]{code, msgTip});
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)NewUserInfoModel.TAG, (String)("updateInfo res: " + JsonParser.toJson((Object)res)), (Object[])new Object[0]);
                }
                if (this.isSuccess(code) && !res.info.__isDefaultInstance()) {
                    UserInfoKS toUpdate = UserInfoKSConverter.convertFrom(res.info, NewUserInfoModel.this.getUserInfo(res.info.uid));
                    if (callback != null) {
                        callback.onUISuccess(toUpdate);
                    }
                    NewUserInfoModel.this.requestUserInfo(res.info.uid, 0L, null);
                    NewUserInfoModel.statUserinfoServer(1, true, 0, msgTip, SystemClock.uptimeMillis() - startTime);
                } else {
                    NewUserInfoModel.this.handleUpdateInfoError(startTime, res, code, msgTip, callback);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.info((Object)NewUserInfoModel.TAG, (String)"updateInfo onError code %d, msg %s", (Object[])new Object[]{code, reason});
                NewUserInfoModel.this.handleUpdateInfoError(startTime, null, code, reason, callback);
            }
        });
    }

    private void handleUpdateInfoError(long startTime, @Nullable UpdateUinfoRes res, long code, String msgTip, @Nullable OnKSProfileSingleCallback callback) {
        MLog.error((Object)TAG, (String)"handleUpdateInfoError res %s, code %d, msg %s, startTime %d", (Object[])new Object[]{res, code, msgTip, startTime});
        String errorTips = code == (long)ERet.kRetUserInfoInvalid.getValue() || code == 361L ? ResourceUtils.getString((int)R.string.userinfo_update_violations) : (code == 1L ? ResourceUtils.getString((int)R.string.userinfo_update_name_violations) : (code == 2L ? ResourceUtils.getString((int)R.string.userinfo_update_sign_violations) : (code == 3L ? ResourceUtils.getString((int)R.string.userinfo_update_home_violations) : (code == 4L ? ResourceUtils.getString((int)R.string.userinfo_update_work_violations) : msgTip))));
        if (callback != null) {
            callback.onError(errorTips, code);
        }
        String errorInfo = "UpdateUinfo Error, code " + code + ", msgTip " + msgTip + ", res == null: " + (res == null) + ", userTime: " + (SystemClock.uptimeMillis() - startTime);
        NewUserInfoModel.statUserinfoServer(1, false, (int)code, errorInfo, SystemClock.uptimeMillis() - startTime);
        MLog.error((Object)TAG, (String)"handleUpdateInfoError :%s", (Object[])new Object[]{errorInfo});
    }

    public void requestUserInfos(@NonNull List<Long> uids, final @Nullable OnKSProfileListCallback callback) {
        final ArrayList<UIDVer> uidVersToRequest = new ArrayList<UIDVer>(uids.size());
        ArrayList<UserInfoKS> usersNotNeedRequest = null;
        UserInfoKS userInfoKS = null;
        for (Long uid : uids) {
            userInfoKS = this.getUserInfo(uid);
            if (userInfoKS.hasUpdatedFromServer) {
                if (usersNotNeedRequest == null) {
                    usersNotNeedRequest = new ArrayList<UserInfoKS>();
                }
                usersNotNeedRequest.add(userInfoKS);
                continue;
            }
            uidVersToRequest.add(new UIDVer.Builder().uid(uid).ver(Long.valueOf(userInfoKS.ver)).build());
        }
        final ArrayList<UserInfoKS> finalUsersNotNeedRequest = usersNotNeedRequest;
        if (uidVersToRequest.isEmpty()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onUISuccess(finalUsersNotNeedRequest == null ? new ArrayList(0) : finalUsersNotNeedRequest);
                    }
                }
            });
            return;
        }
        int size = uidVersToRequest.size();
        final ArrayList userInfosToRequest = new ArrayList();
        int count = size / 100 + (size % 100 == 0 ? 0 : 1);
        final AtomicBoolean hasError = new AtomicBoolean(false);
        for (int i = 0; i < count; ++i) {
            List<UIDVer> toSendUidVers = uidVersToRequest.subList(i * 100, Math.min(size, (i + 1) * 100));
            this.scheduleRequestUserInfos(toSendUidVers, new OnKSProfileListCallback(){

                public void onUISuccess(@NonNull List<UserInfoKS> userInfo) {
                    if (hasError.get()) {
                        return;
                    }
                    userInfosToRequest.addAll(userInfo);
                    if (userInfosToRequest.size() == uidVersToRequest.size() && callback != null) {
                        if (finalUsersNotNeedRequest != null) {
                            finalUsersNotNeedRequest.addAll(userInfosToRequest);
                            callback.onUISuccess(finalUsersNotNeedRequest);
                        } else {
                            callback.onUISuccess(userInfosToRequest);
                        }
                    }
                }

                public void onError(String reason, long code) {
                    if (hasError.get()) {
                        return;
                    }
                    hasError.set(true);
                    if (callback != null) {
                        callback.onError(reason, code);
                    }
                }
            });
        }
    }

    public void requestUserInfo(long uid, final @Nullable OnKSProfileListCallback callback) {
        final UserInfoKS userInfoKS = this.getUserInfo(uid);
        if (userInfoKS.hasUpdatedFromServer) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onUISuccess(Collections.singletonList(userInfoKS));
                    }
                }
            });
            return;
        }
        this.scheduleRequestUserInfos(Collections.singletonList(new UIDVer.Builder().uid(Long.valueOf(uid)).ver(Long.valueOf(userInfoKS.ver)).build()), callback);
    }

    public void requestUserInfo(long uid, long ver, @Nullable OnKSProfileListCallback callback) {
        this.scheduleRequestUserInfos(Collections.singletonList(new UIDVer.Builder().uid(Long.valueOf(uid)).ver(Long.valueOf(ver)).build()), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRequestUserInfos(@NonNull List<UIDVer> uids, @Nullable OnKSProfileListCallback callback) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)("scheduleRequestUserInfos: " + TextUtils.join((CharSequence)",", uids)), (Object[])new Object[0]);
        }
        MLog.info((Object)TAG, (String)("scheduleRequestUserInfos req size: " + uids.size()), (Object[])new Object[0]);
        Object object = this.mBatchGetUinfoLock;
        synchronized (object) {
            if (this.mToGetUinfos.size() + uids.size() >= 100) {
                this.doRequestUserInfo(uids, callback == null ? null : Collections.singletonList(new BatchGetUinfoRequest(uids, callback)));
                return;
            }
            for (UIDVer uidVer : uids) {
                Long ver = this.mToGetUinfos.get(uidVer.uid);
                this.mToGetUinfos.put(uidVer.uid, ver == null ? uidVer.ver : Math.min(uidVer.ver, ver));
            }
            if (callback != null) {
                this.mBatchGetUinfoCallbacks.add(new BatchGetUinfoRequest(uids, callback));
            }
            if (this.mIsWaiting) {
                return;
            }
            this.mIsWaiting = true;
        }
        YYTaskExecutor.execute(() -> {
            ArrayList<BatchGetUinfoRequest> batchCallbacks;
            ArrayList<UIDVer> toSendList;
            Object object = this.mBatchGetUinfoLock;
            synchronized (object) {
                toSendList = new ArrayList<UIDVer>();
                for (Map.Entry<Long, Long> entry : this.mToGetUinfos.entrySet()) {
                    toSendList.add(new UIDVer.Builder().uid(entry.getKey()).ver(entry.getValue()).build());
                }
                this.mToGetUinfos.clear();
                batchCallbacks = new ArrayList<BatchGetUinfoRequest>(this.mBatchGetUinfoCallbacks);
                this.mBatchGetUinfoCallbacks.clear();
                this.mIsWaiting = false;
            }
            this.doRequestUserInfo(toSendList, batchCallbacks);
        }, (long)40L);
    }

    private void doRequestUserInfo(final @NonNull List<UIDVer> uidVers, final @Nullable List<BatchGetUinfoRequest> batchCallbacks) {
        final long requestTime = System.currentTimeMillis();
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)("doRequestUserInfo uid size: " + uidVers.size() + ", uids: " + TextUtils.join((CharSequence)",", uidVers)), (Object[])new Object[0]);
        }
        GetUinfoByVerReq req = new GetUinfoByVerReq.Builder().selector(this.mGetAllFieldSelector).uids(uidVers).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetUinfoByVerRes>(){

            public void onResponse(@NonNull GetUinfoByVerRes message, long code, String msgTip) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    ArrayList<UserInfoKS> list = new ArrayList<UserInfoKS>(uidVers.size());
                    for (UserInfo userInfo : message.infos) {
                        UserInfoKS userInfoKS = NewUserInfoModel.this.getUserInfo(userInfo.uid);
                        if (userInfoKS.ver > userInfo.ver) continue;
                        if (userInfoKS.shadowUid != 0L) {
                            userInfoKS.setValue("ver", (Object)userInfo.ver);
                            list.add(userInfoKS);
                            MLog.error((Object)NewUserInfoModel.TAG, (String)("doRequestUserInfo request a AI uid: " + userInfoKS.uid + ", shadowUid: " + userInfoKS.shadowUid), (Object[])new Object[0]);
                            continue;
                        }
                        list.add(UserInfoKSConverter.convertFrom(userInfo, userInfoKS));
                        if (userInfoKS.uid <= 0L || userInfoKS.vid <= 0L) continue;
                        userInfoKS.hasUpdatedFromServer = true;
                    }
                    NewUserInfoModel.this.mUserInfoTable.save(list);
                    MLog.info((Object)NewUserInfoModel.TAG, (String)"doRequestUserInfo onResponse size %d , req list %d", (Object[])new Object[]{message.infos.size(), uidVers.size()});
                    if (batchCallbacks != null) {
                        for (BatchGetUinfoRequest request : batchCallbacks) {
                            ArrayList<UserInfoKS> resList = new ArrayList<UserInfoKS>();
                            for (UIDVer uidVer : request.uidVers) {
                                resList.add(NewUserInfoModel.this.getUserInfo(uidVer.uid));
                            }
                            ThreadBus.post((int)1, () -> request.callback.onUISuccess(resList));
                        }
                    }
                    NewUserInfoModel.statUserinfoServer(2, true, 0, "", SystemClock.uptimeMillis() - requestTime);
                } else {
                    if (batchCallbacks != null) {
                        for (BatchGetUinfoRequest request : batchCallbacks) {
                            ThreadBus.post((int)1, () -> request.callback.onError(msgTip, code));
                        }
                    }
                    NewUserInfoModel.statUserinfoServer(2, false, (int)code, "code " + code + ", msg " + msgTip, SystemClock.uptimeMillis() - requestTime);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (batchCallbacks != null) {
                    for (BatchGetUinfoRequest request : batchCallbacks) {
                        ThreadBus.post((int)1, () -> request.callback.onError(ResourceUtils.getString((int)R.string.title_net_work_error_tips), 99L));
                    }
                }
                NewUserInfoModel.statUserinfoServer(2, false, 99, "retryWhenTimeout", SystemClock.uptimeMillis() - requestTime);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (batchCallbacks != null) {
                    for (BatchGetUinfoRequest request : batchCallbacks) {
                        ThreadBus.post((int)1, () -> request.callback.onError(reason, (long)code));
                    }
                }
                NewUserInfoModel.statUserinfoServer(2, false, code, "retryWhenError reason " + reason + ", code " + code, SystemClock.uptimeMillis() - requestTime);
                return false;
            }
        });
    }

    private static void statUserinfoServer(final int actionType, final boolean success, final int errorCode, final String errorInfo, final long useTime) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (!success && StringUtils.isNotEmpty((String)errorInfo) && NetworkUtils.isNetworkStrictlyAvailable((Context)RuntimeContext.sApplicationContext)) {
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("ifield", actionType);
                    statContent.put("ifieldtwo", success ? 1 : 0);
                    statContent.put("ifieldthree", NetworkUtils.isNetworkStrictlyAvailable((Context)RuntimeContext.sApplicationContext) ? 1 : 0);
                    if (StringUtils.isNotEmpty((String)errorInfo)) {
                        statContent.put("sfield", errorInfo);
                    }
                    statContent.put("ifieldfive", RuntimeContext.isStartAtFirstInstalled() ? 1 : 0);
                    statContent.put("perftype", "userinfo");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }
                if (actionType == 2) {
                    if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
                        HiidoStatis.reportAppMonitorReturnCode((String)("hyuserinfo/" + actionType), (long)useTime, (String)(success ? "0" : String.valueOf(errorCode)));
                    }
                } else {
                    HiidoStatis.reportAppMonitorReturnCode((String)("hyuserinfo/" + actionType), (long)useTime, (String)(success ? "0" : String.valueOf(errorCode)));
                }
            }
        };
        YYTaskExecutor.execute((Runnable)command, (long)2000L);
    }

    private static class BatchGetUinfoRequest {
        @NonNull
        public List<UIDVer> uidVers;
        @NonNull
        public OnKSProfileListCallback callback;

        public BatchGetUinfoRequest(@NonNull List<UIDVer> uidVers, @NonNull OnKSProfileListCallback callback) {
            this.uidVers = uidVers;
            this.callback = callback;
        }
    }
}

