/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.data.Like.LikeInfo;
import com.yy.appbase.data.Like.LikeListBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.data.ViewDimension;
import com.yy.appbase.honor.HonorInfo;
import com.yy.appbase.honor.MedalInfo;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.screenshot.ScreenShotManager;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IGetCharismaCallback;
import com.yy.appbase.service.callback.IGetMedalListCallback;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.appbase.service.callback.OnGetAllHonorTitlesCallback;
import com.yy.appbase.service.callback.OnGetInsPhotosCallback;
import com.yy.appbase.service.callback.OnGetInsStatusCallback;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.service.callback.OnLikeClickCallback;
import com.yy.appbase.service.callback.OnLikeListCallback;
import com.yy.appbase.util.RemoveViewUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.event.kvo.list.KvoList;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.bbs.BBSNotificationDef;
import com.yy.hiyo.bbs.base.BBSReportUtils;
import com.yy.hiyo.bbs.base.bean.InterProfilePost;
import com.yy.hiyo.bbs.base.callback.IGetBbsTagCallback;
import com.yy.hiyo.bbs.base.service.IBbsService;
import com.yy.hiyo.bbs.base.service.IPostService;
import com.yy.hiyo.camera.base.ImageOpenLargeHelper;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.UserTagInfo;
import com.yy.hiyo.channel.base.bean.UserTagLocation;
import com.yy.hiyo.channel.base.hiido.ChannelBaseTrack;
import com.yy.hiyo.channel.base.hiido.FollowStatisHelper;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.im.IAddFriendService;
import com.yy.hiyo.im.ImNotificationBaseDef;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.OpenUserData;
import com.yy.hiyo.im.base.FriendRedPointBean;
import com.yy.hiyo.im.base.INewFriendListener;
import com.yy.hiyo.login.base.ILoginWindowFinish;
import com.yy.hiyo.login.base.LoginBaseMsgDef;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.hiyo.mvp.base.PageMvpContext;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.relation.base.blacklist.data.BlacklistInfo;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import com.yy.hiyo.report.base.ReportModuleMsgDef;
import com.yy.hiyo.report.base.ReportOpenEvent;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.base.OpenProfileStatistic;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.base.UserNotifyDef;
import com.yy.hiyo.user.base.moduledata.UserProfileData;
import com.yy.hiyo.user.base.moduledata.UserProfilePostInfo;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.hiyo.user.base.service.IProfileService;
import com.yy.hiyo.user.profile.EnterProfileEntity;
import com.yy.hiyo.user.profile.IProfileCallback;
import com.yy.hiyo.user.profile.NewProfileInfoPageV2;
import com.yy.hiyo.user.profile.NewProfilePresenter;
import com.yy.hiyo.user.profile.NewProfileWindow;
import com.yy.hiyo.user.profile.ProfileChannelModel;
import com.yy.hiyo.user.profile.ProfileMusicPresenterVM;
import com.yy.hiyo.user.profile.base.UserInfoSP;
import com.yy.hiyo.user.profile.bbs.NewProfileBbsPresenter;
import com.yy.hiyo.user.profile.bean.ChannelItemWrap;
import com.yy.hiyo.user.profile.bean.CharismaBean;
import com.yy.hiyo.user.profile.bean.ModelData;
import com.yy.hiyo.user.profile.leaderboard.bean.NewGameHistoryBean;
import com.yy.hiyo.user.profile.utils.CollectionUtils;
import com.yy.hiyo.user.profile.utils.ProfilePagePerfMetrics;
import com.yy.hiyo.wallet.base.IPayLevelService;
import com.yy.hiyo.wallet.base.revenue.IGetPayLevelCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.ihago.achievement.srv.mgr.MedalID;
import net.ihago.channel.srv.mgr.GetCurrentRoomInfoRes;
import net.ihago.room.srv.follow.GetSecondaryRelationRes;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

public class NewProfileController
extends DefaultController
implements IProfileCallback,
INewFriendListener {
    private static final String TAG = "NewProfileController";
    private static int[] mZodiacTexts;
    private static int[] mZodiacIcons;
    private static int[] mCellIcons;
    private static final int GIFT_NUM = 3;
    private NewProfileWindow mWindow;
    @Nullable
    private NewProfileInfoPageV2 mPage;
    private long uid;
    private boolean mIsLiked;
    private UserInfoKS mUserInfo;
    private UserInfoKS mSelf;
    private List<String> mAlbum;
    private KvoBinder mBinder;
    private BlacklistInfo mBlacklistInfo;
    private int mFrom;
    private boolean isFromIm = false;
    private boolean hadAddPhoto;
    private boolean isWindowShown;
    private long hidLocation;
    private String openFromRoomId;
    private String userCurInRoomId;
    private ScreenShotManager mScreenShotHelper;
    private Message mCurrentMsg;
    private Message mOpenWindowMsg;
    private NewProfileBbsPresenter mBbsPostPresenter;
    private ProfileMusicPresenterVM mProfileMusicPresenterVM;
    private List<GameHistoryBean> mLikeGameList = new ArrayList<GameHistoryBean>();
    private int mSource = 0;
    private List<MedalInfo> mMedalInfoList = new ArrayList<MedalInfo>();
    private ProfileReportBean mProfileReportBean;
    private NewProfilePresenter mProfilePresenter;
    private LinkedList<Long> mUidList = new LinkedList();
    private long mLastUid;
    private boolean isEnterOver;
    private IAddFriendService mAddFriendService;
    private final int mAvatarSize;
    private ProfileChannelModel mProfileChannelModel;
    private ILoginWindowFinish loginWindowFinishCallback = new ILoginWindowFinish(){

        public void onLoginWindowFinish() {
            MLog.info((Object)NewProfileController.TAG, (String)"loginWindowFinishCallback onSelected", (Object[])new Object[0]);
            NewProfileController.this.sendMessage(UserMsgDef.CLOSE_WINDOW_NEW_PROFILE);
        }

        public void onLoginWindowClosed() {
        }
    };
    IMatchGameLifecycle iMatchGameLifecycle = new IMatchGameLifecycle(){

        public void prepareGameMatch(GameInfo ginfo, @Nonnull GameMatchContext matchConfig) {
        }

        public void onGameMatchStart(GameInfo info, @Nonnull GameMatchContext matchConfig) {
        }

        public void onMatchFinish(GameInfo gameInfo, @Nonnull GameMatchContext matchContext, int matchType) {
            if (0 == matchType) {
                NewProfileController.this.handleGameMatchSuccess(matchContext.update2GameModel(gameInfo));
            }
        }
    };
    private List<Integer> bbsEntrys = Arrays.asList(ProfileReportBean.ShowSource.getDefault(), ProfileReportBean.ShowSource.getBbs(), ProfileReportBean.ShowSource.getActivity(), ProfileReportBean.ShowSource.getBbsNearBy(), ProfileReportBean.ShowSource.getBbsLike(), ProfileReportBean.ShowSource.getBbsPostDetail(), ProfileReportBean.ShowSource.getWhoHasSeenMe(), ProfileReportBean.ShowSource.getRoomGameMatch(), ProfileReportBean.ShowSource.getPostDetailLeftSwipe());

    public NewProfileController(Environment env) {
        super(env);
        this.mBinder = new KvoBinder((Object)this);
        this.mAvatarSize = ResolutionUtils.dip2Px((float)90.0f);
    }

    private void updateCurUserInfo(final boolean notify2) {
        if (AccountUtil.getUid() > 0L) {
            ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).requestUserInfoFromServerWithVer(AccountUtil.getUid(), 0L, new OnKSProfileListCallback(){

                public void onUISuccess(List<UserInfoKS> userInfo) {
                    if (notify2) {
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_USER_INFO_UPDATED));
                    }
                    NewProfileController.this.sendMessage(LoginBaseMsgDef.MSG_UPDATE_LOGINED_ACCOUNT_USERINFO, -1, -1, userInfo);
                }

                public void onError(String reason, long code) {
                }
            });
        }
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.UPDATE_ALBUM) {
            if (notification.extObj instanceof Boolean) {
                this.hadAddPhoto = (Boolean)notification.extObj;
            }
            ((IProfileService)this.getServiceManager().getService(IProfileService.class)).updateAlbum(this.uid);
        } else if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            this.updateCurUserInfo(true);
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameMatchEvent(this.iMatchGameLifecycle);
            this.updateCurUserInfo(true);
        } else if (notification.id == NotificationDef.INSTAGRAM_AUTH_STATUS_CHANGE) {
            if (notification.extObj != null && notification.extObj instanceof Boolean && this.mWindow != null) {
                this.mWindow.getPager().updateMyselfInstagramStatus((Boolean)notification.extObj);
            }
            this.checkInstagramBindStatus();
        } else if (notification.id == NotificationDef.UPLODA_INSTAGRAM_PHOTOS_SUCCESS) {
            this.getInstagramPhotos();
        } else if (notification.id == NotificationDef.OPEN_USER_NEW_PROFILE) {
            int from = 0;
            this.isFromIm = false;
            if (notification.extObj instanceof ProfileReportBean) {
                ProfileReportBean bean = (ProfileReportBean)notification.extObj;
                OpenUserData openUserData = ((ImService)ServiceManagerProxy.getService(ImService.class)).getOpenUserData(bean.getExtObject());
                if (openUserData != null) {
                    this.isFromIm = openUserData.isFromIm;
                    from = openUserData.from;
                }
                this.sendMessage(UserMsgDef.OPEN_WINDOW_NEW_PROFILE, from, 1, notification.extObj);
            }
        } else if (notification.id == NotificationDef.UPDATE_LABEL) {
            List dataList = (List)notification.extObj;
            if (this.mPage != null) {
                this.mPage.updateLabel(dataList);
            }
        } else if (notification.id == NotificationDef.USER_NEW_PROFILE_HAS_POSTS) {
            if (notification.extObj instanceof Boolean) {
                boolean hasData = (Boolean)notification.extObj;
                if (null != this.mWindow && null != this.mWindow.getPager() && AccountUtil.getUid() != this.uid && hasData) {
                    this.mWindow.getPager().openPostTab();
                }
            }
            NotificationCenter.getGlobalInstance().unregister(NotificationDef.USER_NEW_PROFILE_HAS_POSTS, (INotify)this);
        } else if (notification.id == NotificationDef.PROFILE_SEX_CHANGE) {
            if (notification.extObj instanceof Integer && this.mPage != null) {
                this.mPage.updateSex((Integer)notification.extObj);
            }
        } else if (notification.id == NotificationDef.N_ON_TRIM_MEMORY || notification.id == NotificationDef.N_ON_LOW_MEMORY) {
            this.handleTrimMemory();
        } else if (notification.id == BBSNotificationDef.INSTANCE.getBBS_POST_DELETE() && this.mPage != null) {
            --this.mPage.postTotalNum;
            this.mPage.updatePostTotalCount();
        }
    }

    private void handleTrimMemory() {
        if (!NAB.A.equals((Object)NewABDefine.PROFILE_RECYCLE.getTest())) {
            MLog.info((Object)TAG, (String)("not handleTrimMemory because ab test is " + NewABDefine.PROFILE_RECYCLE.getTest()), (Object[])new Object[0]);
            return;
        }
        if (!RuntimeContext.sIsAppStartFinishAfterFiveSecond || !RuntimeContext.sHappenLowMemWarn) {
            return;
        }
        MLog.info((Object)TAG, (String)"handleTrimMemory()", (Object[])new Object[0]);
        if (this.mPage != null && !this.isWindowShown()) {
            MLog.info((Object)TAG, (String)"handleTrimMemory() remove views", (Object[])new Object[0]);
            this.mPage.onDetach();
            RemoveViewUtils.INSTANCE.removeAllViews((ViewGroup)this.mPage, true);
            this.mPage = null;
        }
    }

    private void openPreviousWindow(boolean enableBack) {
        if (this.mUidList.size() > 0) {
            this.mUidList.removeLast();
        }
        if (this.mUidList.size() > 0) {
            ProfileReportBean bean = new ProfileReportBean();
            bean.setUid(this.mUidList.removeLast());
            bean.setHadShowTip(Boolean.valueOf(true));
            bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getDefault()));
            bean.setSource(0);
            MLog.info((Object)TAG, (String)"openPreviousWindow uid:%d", (Object[])new Object[]{bean.getUid()});
            this.sendMessage(UserMsgDef.OPEN_WINDOW_NEW_PROFILE, 0, -1, bean);
        } else if (enableBack) {
            this.sendMessage(UserMsgDef.CLOSE_WINDOW_NEW_PROFILE, -1, -1, new Boolean(true));
        }
    }

    private void handleGameMatchSuccess(Object object) {
        GameModel event;
        if (object != null && object instanceof GameModel && (event = (GameModel)object).getOtherInfo() != null) {
            ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(event.getOtherInfo().uid);
        }
    }

    private void restoreWindow() {
        this.mWindow.initPage(this.mContext, this);
        this.mPage = this.mWindow.getPager();
        if (this.mProfileReportBean != null) {
            this.mPage.setHadShowCompleteTip(this.mProfileReportBean.getHadShowTip());
        } else {
            MLog.info((Object)TAG, (String)"mProfileReportBean is null", (Object[])new Object[0]);
        }
        MLog.info((Object)TAG, (String)"openWindow mLastUid=%d", (Object[])new Object[]{this.mLastUid});
        this.preloadUserInfoAndPostInfo();
        this.initPresenter();
        this.updateViewByLoginType();
        this.getUserInfo();
        this.getUserChannelInfos();
        this.getLikeCountAndStatus();
        this.getUserTags(this.uid);
        this.mPage.updateProfileContent();
    }

    private void openWindow(Message msg) {
        boolean hadShowTip = false;
        this.mLastUid = this.uid;
        if (msg.obj instanceof ProfileReportBean) {
            ProfileReportBean bean = (ProfileReportBean)msg.obj;
            hadShowTip = bean.getHadShowTip();
            this.uid = bean.getUid();
            this.hidLocation = bean.getHidLocation();
            this.mSource = bean.getSource();
            if (bean.getShowSource().intValue() != ProfileReportBean.ShowSource.getPostDetailLeftSwipe() && !this.mUidList.contains(this.uid)) {
                this.mUidList.add(this.uid);
            }
        }
        boolean isLikeSvgaAnim = false;
        if (msg.getData() != null) {
            Bundle bundle = msg.getData();
            isLikeSvgaAnim = bundle.getBoolean("like_animation", false);
        }
        if (this.uid <= 0L) {
            if (RuntimeContext.sIsDebuggable && !RuntimeContext.sIsAutoTesting) {
                throw new IllegalArgumentException("uid is illegal can not open profile");
            }
            MLog.error((Object)TAG, (String)"uid is illegal can not open profile", (Object[])new Object[0]);
            return;
        }
        this.preloadUserInfoAndPostInfo();
        ProfilePagePerfMetrics.INSTANCE.onPageCreate();
        this.mFrom = msg.arg1;
        if (msg.arg2 == -1) {
            this.isFromIm = false;
        }
        this.mWindow = new NewProfileWindow(this.mContext, this);
        this.mWindow.setFrom(this.mFrom);
        this.mPage = this.mWindow.getPager();
        this.mPage.setHadShowCompleteTip(hadShowTip);
        this.mPage.playLikeSvga(isLikeSvgaAnim);
        MLog.info((Object)TAG, (String)"openWindow mLastUid=%d", (Object[])new Object[]{this.mLastUid});
        this.initPresenter();
        this.updateViewByLoginType();
        this.getUserInfo();
        this.getUserChannelInfos();
        this.getLikeCountAndStatus();
        this.getUserTags(this.uid);
        if (msg.arg1 == 13 && msg.obj instanceof Long) {
            long userUid = (Long)msg.obj;
            if (this.mPage != null && userUid != AccountUtil.getUid()) {
                this.mPage.showFollowStatus();
                Bundle bundle = msg.getData();
                if (bundle != null) {
                    this.openFromRoomId = bundle.getString("room_id");
                }
            }
        }
        if (this.mFrom == 15) {
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, false, true);
            int width = ScreenUtils.getInstance().getWidthPixels();
            this.mWindow.scrollTo(-width, 0);
        } else {
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, !hadShowTip);
        }
        AbstractWindow behind = this.mWindowMgr.getWindowBehind((AbstractWindow)this.mWindow);
        if (behind != null && TextUtils.equals((CharSequence)behind.getName(), (CharSequence)"ChannelWindow")) {
            this.mWindow.checkHIdeNavBar();
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "show").put("act_uid", String.valueOf(this.uid)));
        if (this.uid == AccountUtil.getUid()) {
            ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("Visit_My_Profile"));
        } else {
            ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("Visit_Other_Profile"));
        }
        this.mPage.updateProfileContent();
        if (this.uid == AccountUtil.getUid()) {
            this.mAddFriendService = (IAddFriendService)this.getServiceManager().getService(IAddFriendService.class);
            if (this.mAddFriendService != null) {
                this.mAddFriendService.addNewFriendNotifyListener((INewFriendListener)this);
                this.mAddFriendService.getConcatRedPoint();
            }
        }
    }

    private void getUserChannelInfos() {
        if (this.mProfileChannelModel != null && this.mProfileChannelModel.getUid() != this.uid) {
            this.mProfileChannelModel.destroy();
            this.mProfileChannelModel = null;
        }
        if (this.mProfileChannelModel == null) {
            this.mProfileChannelModel = ProfileChannelModel.Companion.of(this.uid);
        }
        ModelData modelData = this.mProfileChannelModel.requestDatas(new ICommonCallback<ModelData>(){

            public void onSuccess(ModelData modelData, Object ... ext) {
            }

            public void onFail(int errCode, String msg, Object ... ext) {
            }
        });
        this.mWindow.getPager().bindChannelData(modelData);
    }

    @Override
    public void updateContent() {
        this.checkOpenPostTab();
        this.switchInstagramFunction();
        if (RuntimeContext.isHagoPartySdk()) {
            this.getGameHistory();
            this.getMedalList();
        }
        this.getHonorTitles();
        this.updateLikeStatus(this.mIsLiked);
        this.getUserFollowStatus();
        this.queryCharmis();
        this.queryWealth();
        this.queryKtvMusic();
    }

    private void queryKtvMusic() {
        ((IPostService)ServiceManagerProxy.getService(IPostService.class)).getBbsFlag(this.uid, new IGetBbsTagCallback(){

            public void onSuccess(long uid, final boolean visible) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NewProfileController.this.mWindow != null) {
                            NewProfileController.this.mWindow.getPager().updateMusicMasterStatus(visible);
                        }
                    }
                });
            }

            public void onFail(int code, @org.jetbrains.annotations.Nullable String reason) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NewProfileController.this.mWindow != null) {
                            NewProfileController.this.mWindow.getPager().updateMusicMasterStatus(false);
                        }
                    }
                });
            }
        });
    }

    private void getUserTags(final long uid) {
        ((IChannelHonorService)ServiceManagerProxy.getServiceManager().getService(IChannelHonorService.class)).reqUserTags(uid, UserTagLocation.LOCATION_BIG_CARD.getLocation(), (ICommonCallback)new ICommonCallback<List<UserTagInfo>>(){

            public void onSuccess(List<UserTagInfo> userTagInfos, Object ... ext) {
                if (NewProfileController.this.mWindow != null && NewProfileController.this.mWindow.getPager() != null) {
                    NewProfileController.this.mWindow.getPager().setUserTags(userTagInfos, uid);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
            }
        });
    }

    private void checkOpenPostTab() {
        ProfileReportBean bean;
        if (null != this.mCurrentMsg && this.mCurrentMsg.obj instanceof ProfileReportBean && (bean = (ProfileReportBean)this.mCurrentMsg.obj).getPostTab() && null != this.mWindow && null != this.mWindow.getPager()) {
            this.mWindow.getPager().openPostTab();
        }
    }

    @Override
    public int getSource() {
        return this.mSource;
    }

    private String getPostToken() {
        if (null == this.mProfileReportBean || null == this.mProfileReportBean.getPostInfo()) {
            return "";
        }
        return this.mProfileReportBean.getPostInfo().getToken();
    }

    private Long getPosterUid() {
        if (null == this.mProfileReportBean || null == this.mProfileReportBean.getPostInfo()) {
            return 0L;
        }
        return this.mProfileReportBean.getPostInfo().getCreatorUid();
    }

    private String getPostId() {
        if (null == this.mProfileReportBean || null == this.mProfileReportBean.getPostInfo()) {
            return "";
        }
        return this.mProfileReportBean.getPostInfo().getPostId();
    }

    private String getPostPageSource() {
        return BBSReportUtils.INSTANCE.getPostPgSource(10);
    }

    private void queryWealth() {
        ((IPayLevelService)ServiceManagerProxy.getService(IPayLevelService.class)).getPayLevel(this.uid, new IGetPayLevelCallback(){

            public void onSuccess(final int level) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NewProfileController.this.mPage != null) {
                            NewProfileController.this.mPage.updateWealth(level);
                        }
                    }
                });
            }

            public void onFail(long code, @NotNull String msg) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NewProfileController.this.mPage != null) {
                            NewProfileController.this.mPage.updateWealth(0);
                        }
                    }
                });
            }
        });
    }

    private void queryCharmis() {
        ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getCharisma(this.uid, 0L, 3, (IGetCharismaCallback)new IGetCharismaCallback<CharismaBean>(){

            public void onSucceed(final @Nullable CharismaBean data) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NewProfileController.this.mPage != null) {
                            NewProfileController.this.mPage.updateCharmis(data);
                        }
                    }
                });
            }

            public void onFailed(int code, String msg) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NewProfileController.this.mPage != null) {
                            NewProfileController.this.mPage.updateCharmis(null);
                        }
                    }
                });
            }
        });
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        this.mCurrentMsg = msg;
        if (msg.what == UserMsgDef.OPEN_WINDOW_NEW_PROFILE || msg.what == BaseMsgDef.MSG_OPEN_PROFILE_NEW_WINDOW) {
            this.mOpenWindowMsg = msg;
            if (msg.obj instanceof ProfileReportBean) {
                this.mProfileReportBean = (ProfileReportBean)msg.obj;
                String roomModel = "2";
                if (this.mProfileReportBean.isVideoMode()) {
                    roomModel = "1";
                }
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "show").put("show_source", this.mProfileReportBean.getShowSource() + "").put("other_uid", this.mProfileReportBean.getUid() + "").put("gid", this.mProfileReportBean.getGid()).put("act_id", this.mProfileReportBean.getActId()).put("room_model", roomModel).put("subject_object_status", AccountUtil.getUid() == this.mProfileReportBean.getUid() ? "1" : "2"));
                OpenProfileStatistic.INSTANCE.reportFrom(this.mProfileReportBean.getSource(), this.mProfileReportBean.getUid().longValue());
            }
            this.isEnterOver = false;
            if (this.mWindow != null) {
                this.isEnterOver = true;
                this.mLikeGameList.clear();
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.openWindow(msg);
        } else if (msg.what == UserMsgDef.CLOSE_WINDOW_NEW_PROFILE) {
            MLog.info((Object)TAG, (String)"close window new profile", (Object[])new Object[0]);
            this.mLikeGameList.clear();
            if (msg.obj instanceof Boolean && ((Boolean)msg.obj).booleanValue()) {
                this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            } else {
                this.mLikeGameList.clear();
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
        } else if (msg.what == UserMsgDef.ALBUM_UPDATE_POST) {
            if (this.mBbsPostPresenter != null) {
                this.mBbsPostPresenter.onRefresh();
            }
            if (this.mProfileMusicPresenterVM != null) {
                this.mProfileMusicPresenterVM.getMusicMasterPostList(this.mProfileMusicPresenterVM.getCurUid());
            }
        }
    }

    private void preloadUserInfoAndPostInfo() {
        this.getProfileBbsPresenter();
        if (this.mBbsPostPresenter != null) {
            this.mBbsPostPresenter.queryPostInfoDb(this.uid);
        }
        this.mUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(this.uid, null);
        ((IProfileService)this.getServiceManager().getService(IProfileService.class)).preload(this.uid);
        String avatar = this.mUserInfo.avatar;
        if (StringUtils.isNotEmpty((String)avatar)) {
            String webpUrl = avatar + YYImageUtils.getThumbnailPostfix((int)this.mAvatarSize);
            ImageLoader.preloadImage((Context)RuntimeContext.sApplicationContext, (String)webpUrl);
        }
    }

    private void initPresenter() {
        MLog.debug((Object)TAG, (String)"initPresenter", (Object[])new Object[0]);
        this.personalService();
    }

    @Override
    public void personalService() {
        if (this.getUid() != AccountUtil.getUid()) {
            this.getProfilePresenter().getRelationRes().observe((LifecycleOwner)PageMvpContext.of((View)this.mPage).getLifecycleOwner(), res -> {
                if (this.mPage != null) {
                    this.mPage.getRelation((GetSecondaryRelationRes)res);
                }
            });
            this.getProfilePresenter().getRelation(AccountUtil.getUid(), this.getUid());
            this.getProfilePresenter().getChannelMessage(this.uid).observe((LifecycleOwner)PageMvpContext.of((View)this.mPage).getLifecycleOwner(), res -> {
                if (this.mPage != null) {
                    this.mPage.updateRoomInfoData((GetCurrentRoomInfoRes)res);
                }
            });
        }
    }

    private NewProfilePresenter getProfilePresenter() {
        if (this.mProfilePresenter == null) {
            this.mProfilePresenter = new NewProfilePresenter();
        }
        return this.mProfilePresenter;
    }

    private void switchInstagramFunction() {
        boolean showIns = SettingFlags.getBoolean((String)"instagram", (boolean)false);
        if (showIns) {
            this.checkInstagramBindStatus();
            if (AccountUtil.getUid() != this.uid) {
                this.getInstagramPhotos();
            }
        } else if (this.mPage != null) {
            this.mPage.showInstagramItem(false);
        }
    }

    private void getHonorTitles() {
        MLog.error((Object)TAG, (String)"start to get honor titles", (Object[])new Object[0]);
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getAllHonorTitles(this.uid, new OnGetAllHonorTitlesCallback(){

            public void onGetHonorTitlesSuccess(final List<HonorInfo> titleIds) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HiidoEvent event = HiidoEvent.obtain().eventId("20027251").put("event", "show").put("element_id", "10007 ");
                        if (!FP.empty((Collection)titleIds)) {
                            StringBuilder honorIds = new StringBuilder();
                            int i = 0;
                            for (HonorInfo honorInfo : titleIds) {
                                if (i++ == 0) {
                                    honorIds.append(honorInfo.getId());
                                    continue;
                                }
                                honorIds.append(";").append(honorInfo.getId());
                            }
                            event.put("title_id", honorIds.toString());
                        }
                        HiidoStatis.reportEvent((HiidoEvent)event);
                    }
                });
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
                MLog.error((Object)NewProfileController.TAG, (String)("getHonorTitles onResponseError : " + message), (Object[])new Object[0]);
            }
        });
    }

    private void getMedalList() {
        MLog.info((Object)TAG, (String)"start to get medal list", (Object[])new Object[0]);
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getMedalList(this.uid, new IGetMedalListCallback(){

            public void onSuccess(@NotNull List<MedalInfo> medalList) {
                NewProfileController.this.mMedalInfoList.clear();
                NewProfileController.this.mMedalInfoList.addAll(medalList);
                if (NewProfileController.this.mWindow != null && NewProfileController.this.mWindow.getPager() != null) {
                    NewProfileController.this.mWindow.getPager().setMedalList(NewProfileController.this.sortMedalList(medalList));
                }
                HiidoEvent event = HiidoEvent.obtain().eventId("20027251").put("event", "show").put("element_id", "10007 ");
                if (!FP.empty(medalList)) {
                    StringBuilder honorIds = new StringBuilder();
                    int i = 0;
                    for (MedalInfo honorInfo : medalList) {
                        if (i++ == 0) {
                            honorIds.append(honorInfo.getId());
                            continue;
                        }
                        honorIds.append(";").append(honorInfo.getId());
                    }
                    event.put("title_id", honorIds.toString());
                }
                HiidoStatis.reportEvent((HiidoEvent)event);
            }

            public void onError(int code, @org.jetbrains.annotations.Nullable String msg) {
                MLog.error((Object)NewProfileController.TAG, (String)("getHonorTitles failed: " + msg), (Object[])new Object[0]);
                if (NewProfileController.this.mWindow != null && NewProfileController.this.mWindow.getPager() != null) {
                    NewProfileController.this.mWindow.getPager().setMedalList(new ArrayList<MedalInfo>());
                }
            }
        });
    }

    @Override
    public void showMedalGuide() {
        boolean hasShown = UserInfoSP.INSTANCE.obtain().getBoolean("key_has_shown_medal_guide", false);
        if (!hasShown && this.uid == AccountUtil.getUid()) {
            UserInfoSP.INSTANCE.obtain().edit().putBoolean("key_has_shown_medal_guide", true).commit();
            MedalInfo medalInfo = null;
            long obtainTime = 0L;
            if (!FP.empty(this.mMedalInfoList)) {
                for (int i = 0; i < this.mMedalInfoList.size(); ++i) {
                    MedalInfo info = this.mMedalInfoList.get(i);
                    if (info.getObtainTime() < obtainTime || !info.isValid()) continue;
                    obtainTime = info.getObtainTime();
                    medalInfo = info;
                }
            }
            this.sendMessage(UserMsgDef.SHOW_MEDAL_GUIDE_DIALOG, 0, 0, medalInfo);
        }
    }

    @Override
    public void setUserCurInRoomId(String roomId) {
        this.userCurInRoomId = roomId;
    }

    @Override
    public NewProfileBbsPresenter getProfileBbsPresenter() {
        if (this.mBbsPostPresenter == null) {
            this.mBbsPostPresenter = new NewProfileBbsPresenter(this.mContext, this.uid);
        }
        return this.mBbsPostPresenter;
    }

    @Override
    public ProfileMusicPresenterVM getProfileMusicPresenterVM() {
        if (this.mProfileMusicPresenterVM == null) {
            this.mProfileMusicPresenterVM = new ProfileMusicPresenterVM(this.mContext, this.uid);
        }
        return this.mProfileMusicPresenterVM;
    }

    private List<MedalInfo> sortMedalList(List<MedalInfo> medalInfoList) {
        if (!FP.empty(medalInfoList)) {
            MedalInfo info;
            int i;
            ArrayList<MedalInfo> sortedList = new ArrayList<MedalInfo>();
            int countBeforeGame = 0;
            int gameIndex = -1;
            for (i = 0; i < medalInfoList.size(); ++i) {
                info = medalInfoList.get(i);
                if (info.getId() != (long)MedalID.HEADER_PLAYER.getValue() || info.isValid()) continue;
                gameIndex = i;
                break;
            }
            if (gameIndex != -1) {
                for (i = 0; i < medalInfoList.size(); ++i) {
                    info = medalInfoList.get(i);
                    if (i > gameIndex && countBeforeGame % 2 != 0) {
                        sortedList.add(countBeforeGame, info);
                        ++countBeforeGame;
                    } else {
                        sortedList.add(info);
                    }
                    if (i >= gameIndex) continue;
                    ++countBeforeGame;
                }
                return sortedList;
            }
            return medalInfoList;
        }
        return medalInfoList;
    }

    private void getInstagramPhotos() {
        MLog.error((Object)TAG, (String)"start to get instagram photoes", (Object[])new Object[0]);
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getInstagramPhotos(this.uid, new OnGetInsPhotosCallback(){

            public void onGetInsStatusSuccess(List<String> thumbnail, List<String> standard) {
                if (NewProfileController.this.mPage == null) {
                    return;
                }
                if (AccountUtil.getUid() != NewProfileController.this.uid) {
                    NewProfileController.this.mPage.showInstagramItem(thumbnail != null && !thumbnail.isEmpty());
                    if (thumbnail != null && !thumbnail.isEmpty()) {
                        NewProfileController.this.mPage.setInstagramPhotosAdapter(thumbnail, standard, false);
                    }
                } else {
                    NewProfileController.this.mPage.setInstagramPhotosAdapter(thumbnail, standard, true);
                }
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "show").put("element_id", "10005").put("ins_photo_num", String.valueOf(standard != null ? standard.size() : 0)));
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    private void checkInstagramBindStatus() {
        if (this.uid != AccountUtil.getUid()) {
            return;
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getInstagramBindStatus(new OnGetInsStatusCallback(){

            public void onGetInsStatusSuccess(String insToken, String insNickname, boolean isBind) {
                if (NewProfileController.this.mPage != null) {
                    NewProfileController.this.mPage.updateMyselfInstagramStatus(isBind);
                }
                if (isBind) {
                    long updateTimeValue = SettingFlags.getLongValue((String)("update_instagram_photos_time" + NewProfileController.this.uid));
                    if (System.currentTimeMillis() - updateTimeValue > 86400000L) {
                        NewProfileController.this.sendMessage(UserMsgDef.UPDATE_INS_PHOTOS, -1, -1, insToken);
                        SettingFlags.setLongValue((String)("update_instagram_photos_time" + NewProfileController.this.uid), (long)System.currentTimeMillis());
                    }
                    NewProfileController.this.getInstagramPhotos();
                }
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "show").put("bind_ins", isBind ? "1" : "0"));
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        NotificationCenter.getGlobalInstance().register(NotificationDef.INSTAGRAM_AUTH_STATUS_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.UPLODA_INSTAGRAM_PHOTOS_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.UPDATE_LABEL, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.USER_NEW_PROFILE_HAS_POSTS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.PROFILE_SEX_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_LOW_MEMORY, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, (INotify)this);
        NotificationCenter.getGlobalInstance().register(BBSNotificationDef.INSTANCE.getBBS_POST_DELETE(), (INotify)this);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            if (this.mPage != null) {
                this.mPage.onDetach();
            }
            NewProfileWindow window = this.mWindow;
            this.mWindow = null;
            if (window != null && window.getPager() == this.mPage) {
                this.mPage = null;
            }
            this.userCurInRoomId = null;
        }
        this.mBinder.clearAllKvoConnections();
        this.mIsLiked = false;
        this.mBbsPostPresenter = null;
        this.mProfileMusicPresenterVM = null;
        this.mProfilePresenter = null;
        if (this.mAddFriendService != null) {
            this.mAddFriendService.removeNewFriendNotifyListener((INewFriendListener)this);
            this.mAddFriendService = null;
        }
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.INSTAGRAM_AUTH_STATUS_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.UPLODA_INSTAGRAM_PHOTOS_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.UPDATE_LABEL, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.USER_NEW_PROFILE_HAS_POSTS, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.PROFILE_SEX_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_ON_LOW_MEMORY, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_ON_TRIM_MEMORY, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(BBSNotificationDef.INSTANCE.getBBS_POST_DELETE(), (INotify)this);
        IBbsService service = (IBbsService)ServiceManagerProxy.getService(IBbsService.class);
        if (service != null) {
            service.setInterProfilePost(null);
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)UserNotifyDef.INSTANCE.getPROFILE_WINDOW_DESTROY()));
        if (!this.isEnterOver) {
            this.mUidList.clear();
        }
    }

    private void updateViewByLoginType() {
        if (this.uid != AccountUtil.getUid()) {
            return;
        }
        if (AccountUtil.isLoginByGuest()) {
            if (this.mPage != null) {
                this.mPage.updateViewByLoginType(true);
            }
        } else if (this.mPage != null) {
            this.mPage.updateViewByLoginType(false);
        }
    }

    private void updateLikeStatus(boolean isLiked) {
        if (this.mPage != null) {
            this.mPage.updateLikeStatus(isLiked);
        }
    }

    @Override
    public void getUserInfo() {
        String sex = this.mUserInfo == null ? "" : (this.mUserInfo.sex == 0 ? "F" : "M");
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "show").put("element_id", "10006").put("gender", sex));
        this.mBinder.clearAllKvoConnections();
        this.mBinder.singleBindSourceTo((KvoSource)this.mUserInfo);
        UserProfileData profileData = ((IProfileService)this.getServiceManager().getService(IProfileService.class)).getUserProfile(this.uid);
        this.mBinder.singleBindSourceTo((KvoSource)profileData);
        if (this.mUserInfo != null && this.mPage != null) {
            this.mPage.updateUserInfo(this.mUserInfo);
            MLog.debug((Object)TAG, (String)"updateUserInfo UserInfo %s", (Object[])new Object[]{this.mUserInfo});
        } else {
            MLog.warn((Object)TAG, (String)"UserInfo %s, mPage %s", (Object[])new Object[]{this.mUserInfo, this.mPage});
        }
        if (this.uid != AccountUtil.getUid() && this.mPage != null) {
            this.mBlacklistInfo = ((IBlacklistService)ServiceManagerProxy.getService(IBlacklistService.class)).isInBlacklist(this.uid);
            this.mPage.updateRelationShip(this.mBlacklistInfo);
            LiveData onlineStatus = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getOnlineStatus(this.uid, true);
            if (onlineStatus != null) {
                onlineStatus.observe((LifecycleOwner)PageMvpContext.of((View)this.mPage).getLifecycleOwner(), userOnlineDBBean -> {
                    if (this.mPage != null) {
                        this.mPage.updateOnlineStatus((UserOnlineDBBean)userOnlineDBBean);
                    }
                });
            }
        }
    }

    @Override
    public void getLikeCountAndStatus() {
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getLikeStatus(this.uid, new OnLikeListCallback(){

            public void onUISuccess(List<LikeListBean.Uid> likeList, int id2) {
                MLog.error((Object)NewProfileController.TAG, (String)(Thread.currentThread().getName() + ":getLikeStatus onUISuccess"), (Object[])new Object[0]);
                NewProfileController.this.mIsLiked = !FP.empty(likeList) && likeList.get((int)0).stat == 1;
                NewProfileController.this.updateLikeStatus(NewProfileController.this.mIsLiked);
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
        MLog.info((Object)TAG, (String)"start to get like count", (Object[])new Object[0]);
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getLikeCount(this.uid, new OnLikeListCallback(){

            public void onUISuccess(List<LikeListBean.Uid> likeList, int id2) {
                if (likeList != null && likeList.size() > 0 && NewProfileController.this.mPage != null) {
                    NewProfileController.this.mPage.updateLikeCount(likeList.get((int)0).mLikeNum, likeList.get((int)0).newLikeNum);
                }
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    @Override
    public void onInstagramPhotosMoreClick() {
        this.sendMessage(UserMsgDef.OPEN_WINDOW_INSTAGRAM_PHOTOS, -1, -1, this.uid);
    }

    @Override
    public void getGameHistory() {
        MLog.info((Object)TAG, (String)"start to get game history", (Object[])new Object[0]);
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getGameHistory(this.uid, new OnGameHistoryCallback(){

            public void onUISuccess(final List<GameHistoryBean> list, int id2) {
                if (NewProfileController.this.mPage != null) {
                    if (LanguageUtils.isRtl()) {
                        Collections.reverse(list);
                    }
                    NewProfileController.this.mPage.updateGameHistory(NewProfileController.this.filterGameHistory(NewProfileController.this.uid, list));
                    if (NewProfileController.this.uid == AccountUtil.getUid()) {
                        return;
                    }
                    ((IUserInfoService)NewProfileController.this.getServiceManager().getService(IUserInfoService.class)).getMineGameHistoryCacheFirst(new OnGameHistoryCallback(){

                        public void onUISuccess(List<GameHistoryBean> gameList, int id2) {
                            if (NewProfileController.this.mPage != null && gameList != null && list != null) {
                                NewProfileController.this.mLikeGameList = CollectionUtils.getTheSameSection(gameList, list);
                            }
                        }

                        public void onError(Call call, Exception e, int id2) {
                        }

                        public void onResponseError(int id2, String message, String response) {
                        }
                    });
                }
            }

            public void onError(Call call, Exception e, int id2) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NewProfileController.this.mPage != null) {
                            NewProfileController.this.mPage.updateGameHistory(new ArrayList<GameHistoryBean>());
                        }
                    }
                });
            }

            public void onResponseError(int id2, String message, String response) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (NewProfileController.this.mPage != null) {
                            NewProfileController.this.mPage.updateGameHistory(new ArrayList<GameHistoryBean>());
                        }
                    }
                });
            }
        });
    }

    private List<GameHistoryBean> filterGameHistory(long uid, List<GameHistoryBean> originGameHistory) {
        ArrayList<GameHistoryBean> gameHistoryBeans = new ArrayList<GameHistoryBean>();
        if (originGameHistory != null && originGameHistory.size() > 0) {
            for (GameHistoryBean bean : originGameHistory) {
                if (((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(bean.gameId) == null) continue;
                gameHistoryBeans.add(bean);
            }
        }
        return gameHistoryBeans;
    }

    @Override
    public List<GameHistoryBean> deduplicate(List<GameHistoryBean> gameHistoryBeans) {
        if (FP.empty(gameHistoryBeans)) {
            return null;
        }
        ArrayList<GameHistoryBean> list = new ArrayList<GameHistoryBean>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            for (int i = 0; i < gameHistoryBeans.size(); ++i) {
                GameHistoryBean bean = gameHistoryBeans.get(i);
                if (bean == null) continue;
                if (map.containsKey(bean.gameId)) {
                    int pos = (Integer)map.get(bean.gameId);
                    ((GameHistoryBean)list.get((int)pos)).totalCount += bean.totalCount;
                    continue;
                }
                map.put(bean.gameId, i);
                list.add((GameHistoryBean)bean.clone());
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)"deduplicate error", (Throwable)ex, (Object[])new Object[0]);
        }
        return list;
    }

    @Override
    public void onFollowViewClick(RelationInfo followStatus) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "follow_click").put("other_uid", this.uid + "").put("profile_pg_source", this.getSource() + "").put("show_source", this.mProfileReportBean.getShowSource() + ""));
        if (!followStatus.isFollow()) {
            int enterType = 2;
            if (this.mPage != null) {
                this.mPage.follow(FollowerUtils.INSTANCE.enterType2ePath(enterType + ""));
            }
            LinkedHashMap<String, String> ext = new LinkedHashMap<String, String>();
            ext.put("profile_pg_source", this.getSource() + "");
            ext.put("token", this.getPostToken());
            ext.put("post_pg_source", this.getPostPageSource());
            ext.put("send_post_uid", this.getPosterUid() + "");
            ext.put("post_id", this.getPostId());
            ext.put("post_detail_pg_source", this.getPostDetailPageSource());
            FollowStatisHelper.reportFollowClickWithExt((long)this.uid, (String)this.openFromRoomId, (int)enterType, ext);
        } else if (this.mUserInfo != null) {
            FollowStatisHelper.reportUnfollowClickWithToken((long)this.uid, (String)this.openFromRoomId, (int)2, (String)this.getPostToken(), (String)this.getPostPageSource());
            if (this.mPage != null) {
                this.mPage.unFollow();
            }
            FollowStatisHelper.reportUnfollowOkClickWithToken((long)this.uid, (String)this.openFromRoomId, (int)2, (String)this.getPostToken(), (String)this.getPostPageSource());
        }
    }

    private String getPostDetailPageSource() {
        InterProfilePost post;
        IBbsService service = (IBbsService)ServiceManagerProxy.getService(IBbsService.class);
        if (service != null && (post = service.getInterProfilePost()) != null) {
            return BBSReportUtils.INSTANCE.getPostDetailPgSource(post.interProfileFrom);
        }
        return "";
    }

    @Override
    public void onInChatRoomViewClick() {
        if (FP.empty((CharSequence)this.userCurInRoomId)) {
            return;
        }
        EnterParam param = EnterParam.of((String)this.userCurInRoomId).entry(13).joinMemberFrom("68").isBackToList(false).preSource(this.mProfileReportBean.getShowSource().toString()).entryInfo(new EntryInfo(FirstEntType.BIG_PROFILE_CARD, "1", "")).build();
        param.setExtra("follow_uid", (Object)String.valueOf(this.uid));
        param.enterUid = this.uid;
        ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param);
        ChannelBaseTrack.INSTANCE.reportGreenRoomClick();
    }

    @Override
    public void onMoreClick(List<ButtonItem> list) {
        this.mDialogLinkManager.showCommonPopupDialog(list, true, true);
    }

    @KvoMethodAnnotation(name="postInfo", sourceClass=UserProfileData.class, thread=1)
    public void onPostInfoUpdate(KvoEventIntent event) {
        UserProfilePostInfo postInfo = (UserProfilePostInfo)event.newValue();
        if (postInfo == null || this.mBbsPostPresenter == null) {
            return;
        }
        if (postInfo.getRequestFailed() || postInfo.getPostInfo() == null) {
            this.mBbsPostPresenter.getUserPostList();
        } else {
            this.mBbsPostPresenter.setPostData(postInfo.getPostInfo());
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        this.isWindowShown = true;
        this.mSelf = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        if (this.hadAddPhoto && this.mPage != null) {
            this.mPage.smoothToLatestPhoto();
            this.hadAddPhoto = false;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IHonorService)NewProfileController.this.getServiceManager().getService(IHonorService.class)).enterFocusWindow();
            }
        }, (long)500L);
        this.initScreenShot();
        this.onWindowShow();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)UserNotifyDef.INSTANCE.getPROFILE_WINDOW_CREATE()));
    }

    private void initScreenShot() {
        if (this.getUid() != AccountUtil.getUid() && this.mWindowMgr != null) {
            this.mScreenShotHelper = new ScreenShotManager(this.mContext, this.getUid(), 1, "");
            this.mScreenShotHelper.start(this.mWindowMgr);
        } else if (this.getUid() == AccountUtil.getUid()) {
            FeatureLog.d((String)"FTScreenShot", (String)" self profile", (Object[])new Object[0]);
        }
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        this.isWindowShown = false;
        if (this.mScreenShotHelper != null) {
            this.mScreenShotHelper.stop();
            this.mScreenShotHelper.setScreenShotListener(null);
        }
        this.onWindowHide();
    }

    @Override
    public void onGameMoreClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "click").put("element_id", "10008"));
        if (this.mPage != null) {
            NewGameHistoryBean newGameHistoryBean = new NewGameHistoryBean();
            newGameHistoryBean.likeGame = this.mLikeGameList;
            if (this.mPage.getGameHistoryList() != null) {
                List<GameHistoryBean> otherGame = this.mPage.getGameHistoryList();
                otherGame.removeAll(this.mLikeGameList);
                newGameHistoryBean.otherGame = otherGame;
            }
            this.sendMessage(UserMsgDef.OPEN_WINDOW_NEW_LEADERBOARD, -1, -1, newGameHistoryBean);
        }
    }

    @Override
    public void onShareBtnClick() {
        Message message = Message.obtain();
        message.what = BaseMsgDef.MSG_SHOW_PROFILE_SHARE;
        message.arg1 = 11;
        message.arg2 = -1;
        message.obj = "profile";
        if (this.mUserInfo != null) {
            Bundle bundle = new Bundle();
            bundle.putLong("uid", this.mUserInfo.uid);
            message.setData(bundle);
        }
        this.sendMessage(message);
    }

    @Override
    public void onBlockClick() {
        if (this.mUserInfo != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023793").put("function_id", "block").put("act_uid", String.valueOf(this.mUserInfo.uid)));
        }
        ((IBlacklistService)this.getServiceManager().getService(IBlacklistService.class)).blackUid(this.mUserInfo.uid, (INetRespCallback)new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
                NewProfileController.this.showInternetError();
            }

            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
                if (res != null && res.isSuccess()) {
                    ToastUtils.showToast((Context)NewProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_block_successful), (int)0);
                }
            }
        });
    }

    private void showInternetError() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast((Context)NewProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
        });
    }

    @Override
    public void onUnblockClick() {
        ((IBlacklistService)this.getServiceManager().getService(IBlacklistService.class)).unBlackUid(this.uid, new INetRespCallback(){

            public void onError(Call call, Exception e, int id2) {
                NewProfileController.this.showInternetError();
            }

            public void onResponse(String response, BaseResponseBean res, int id2) {
                if (res != null && res.isSuccess()) {
                    ToastUtils.showToast((Context)NewProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_unblock_successful), (int)0);
                } else {
                    NewProfileController.this.showInternetError();
                }
            }
        });
    }

    @Override
    public void onEditClick() {
        if (this.checkIsLoginByGuest()) {
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "edit_click").put("other_uid", this.uid + ""));
        this.sendMessage(UserMsgDef.OPEN_WINDOW_EDIT_PROFILE);
    }

    private boolean checkIsLoginByGuest() {
        return GuestLoginUtils.checkAndShowGuide((int)0);
    }

    @Override
    public void onLikeClick(boolean isLiked) {
        if (!isLiked) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "like_click").put("other_uid", this.uid + ""));
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023793").put("function_id", "like_click"));
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "click").put("element_id", "10003 "));
            ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).updateLikeInfo(this.uid, new OnLikeClickCallback(){

                public void onUISuccess(LikeInfo info, int id2) {
                    if (NewProfileController.this.mUserInfo != null && NewProfileController.this.mSelf != null) {
                        if (NewProfileController.this.mPage != null) {
                            NewProfileController.this.mPage.updateLikeStatus(true);
                            NewProfileController.this.mPage.updateLikeCount(info.mLikeNum, 0);
                            NewProfileController.this.mPage.playLikeAnimation();
                        }
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationBaseDef.IM_LIKE_PROFILE, (Object)((NewProfileController)NewProfileController.this).mUserInfo.uid));
                    }
                }

                public void onIsBlock() {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToastUtils.showToast((Context)NewProfileController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_block_already), (int)0);
                        }
                    });
                }

                public void onError(Call call, Exception e, int id2) {
                    NewProfileController.this.showInternetError();
                }

                public void onResponseError(int id2, String message, String response) {
                    NewProfileController.this.showInternetError();
                }
            });
        }
    }

    @Override
    public void onBack() {
        MLog.info((Object)TAG, (String)"onBack", (Object[])new Object[0]);
        this.openPreviousWindow(true);
    }

    protected boolean onWindowBackKeyEvent() {
        this.openPreviousWindow(false);
        return super.onWindowBackKeyEvent();
    }

    @Override
    public void onChatClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "click").put("element_id", "10009"));
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "chat_click").put("other_uid", this.uid + "").put("show_source", this.mProfileReportBean.getShowSource() + ""));
        if (this.mBlacklistInfo.getInBlacklist()) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.toast_block_already), (int)0);
        } else {
            this.toChat();
        }
    }

    private void toChat() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Bundle bundle = new Bundle();
                Message message = Message.obtain();
                message.what = BaseMsgDef.IM_ROOM_SHOW;
                bundle.putLong("target_uid", NewProfileController.this.uid);
                bundle.putInt("bundle_im_from", NewProfileController.this.mFrom);
                bundle.putInt("im_page_source", 6);
                if (null != NewProfileController.this.mProfileReportBean) {
                    if (null != NewProfileController.this.mProfileReportBean.getPostInfo()) {
                        bundle.putSerializable("im_post", (Serializable)NewProfileController.this.mProfileReportBean.getPostInfo());
                    }
                    if (NewProfileController.this.mProfileReportBean.fromBBS()) {
                        bundle.putInt("im_page_scene", 3);
                    } else if (NewProfileController.this.mProfileReportBean.fromChannel()) {
                        bundle.putInt("im_page_scene", 2);
                    } else if (NewProfileController.this.mProfileReportBean.fromGame()) {
                        bundle.putInt("im_page_scene", 1);
                    }
                }
                message.setData(bundle);
                NewProfileController.this.sendMessageSync(message);
                if (NewProfileController.this.mProfileReportBean != null && NewProfileController.this.mProfileReportBean.getShowSource() != null && NewProfileController.this.mProfileReportBean.getShowSource().intValue() == ProfileReportBean.ShowSource.getBbs()) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "show").put("last_1_source", "1").put("last_2_source", "1").put("act_uid", NewProfileController.this.uid + ""));
                } else {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "show").put("last_1_source", "1").put("act_uid", NewProfileController.this.uid + ""));
                }
            }
        });
    }

    @Override
    public void onReportClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023793").put("function_id", "report").put("act_uid", String.valueOf(this.mUserInfo.uid)));
        if (this.mUserInfo == null || this.mSelf == null) {
            return;
        }
        KvoList albumList = ((IProfileService)this.getServiceManager().getService(IProfileService.class)).getUserProfile(this.uid).getAlbumList();
        ReportOpenEvent reportOpenEvent = new ReportOpenEvent(this.mSelf.nick, (List)albumList, this.mUserInfo);
        Bundle bundle = new Bundle();
        Message message = Message.obtain();
        message.what = ReportModuleMsgDef.OPEN_NEW_WINDOW_REPORT;
        bundle.putSerializable("data", (Serializable)reportOpenEvent);
        message.setData(bundle);
        this.sendMessage(message);
    }

    @Override
    public void insConnect() {
        if (this.checkIsLoginByGuest()) {
            return;
        }
        this.sendMessage(UserMsgDef.CONNECT_INS_AUTH);
    }

    @Override
    public void displayLargePhoto(View v, List<String> photoUrls, int index, int from) {
        if (photoUrls == null || photoUrls.size() < 1) {
            return;
        }
        Message message = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putLong("uid", this.uid);
        bundle.putInt("index", index);
        bundle.putStringArrayList("photo_list", new ArrayList<String>(photoUrls));
        if (v != null) {
            ImageOpenLargeHelper.INSTANCE.setFromDrawable(v);
            bundle.putParcelable("view_dimension", (Parcelable)new ViewDimension(v));
        }
        bundle.putBoolean("add_water_mark", true);
        bundle.putInt("from_entrance", from);
        message.what = BaseMsgDef.OPEN_WINDOW_PHOTO;
        message.setData(bundle);
        this.sendMessage(message);
    }

    @Override
    public void onLoadFailed() {
    }

    @Override
    public void onLoadSuccess() {
    }

    @Override
    public int getFrom() {
        return this.mFrom;
    }

    @Override
    public boolean isFromIm() {
        return this.isFromIm;
    }

    @Override
    public boolean isWindowShown() {
        return this.isWindowShown;
    }

    public static int getZodiacIcon(int index) {
        if (index < 0 || index > 12) {
            return 0;
        }
        if (mZodiacIcons == null) {
            mZodiacIcons = new int[]{R.drawable.icon_capricorn, R.drawable.icon_aquarius, R.drawable.icon_pisces, R.drawable.icon_aries, R.drawable.icon_taurus, R.drawable.icon_gemini, R.drawable.icon_cancer, R.drawable.icon_leo, R.drawable.icon_virgo, R.drawable.icon_libra, R.drawable.icon_scorpio, R.drawable.icon_sagittarius, R.drawable.icon_capricorn};
        }
        return mZodiacIcons[index];
    }

    public static int getZodiacText(int index) {
        if (index < 0 || index > 12) {
            return 0;
        }
        if (mZodiacTexts == null) {
            mZodiacTexts = new int[]{R.string.capricorn, R.string.aquarius, R.string.pisces, R.string.aries, R.string.taurus, R.string.gemini, R.string.cancer, R.string.leo, R.string.virgo, R.string.libra, R.string.scorpio, R.string.sagittarius, R.string.capricorn};
        }
        return mZodiacTexts[index];
    }

    public static int getCellIcon(int index) {
        if (index < 0 || index > 12) {
            return 0;
        }
        if (mCellIcons == null) {
            mCellIcons = new int[]{R.drawable.profile_person_cell_capricorn, R.drawable.profile_person_cell_aquarius, R.drawable.profile_person_cell_pisces, R.drawable.profile_person_cell_aries, R.drawable.profile_person_cell_taurus, R.drawable.profile_person_cell_gemini, R.drawable.profile_person_cell_cancer, R.drawable.profile_person_cell_leo, R.drawable.profile_person_cell_virgo, R.drawable.profile_person_cell_libra, R.drawable.profile_person_cell_scorpio, R.drawable.profile_person_cell_sagittarius, R.drawable.profile_person_cell_capricorn};
        }
        return mCellIcons[index];
    }

    private void getUserFollowStatus() {
        if (this.mPage != null) {
            this.mPage.bindFollowStatus(this.uid);
        }
    }

    private void onWindowShow() {
        if (this.mPage != null) {
            this.mPage.onShown();
            this.getUserChannelInfos();
        } else if (NAB.A.equals((Object)NewABDefine.PROFILE_RECYCLE.getTest()) && this.mOpenWindowMsg != null) {
            this.restoreWindow();
        }
    }

    private void onWindowHide() {
        if (this.mPage != null) {
            this.mPage.onHiden();
        }
    }

    @Override
    public void setDarkBar(boolean isDark, int color2, View offsetView) {
        if (Build.VERSION.SDK_INT < 23) {
            MLog.error((Object)TAG, (String)"setDarkBar android < 6.0", (Object[])new Object[0]);
            return;
        }
        if (this.isWindowShown) {
            MLog.info((Object)TAG, (String)"setDarkBar color:%d", (Object[])new Object[]{color2});
            StatusBarManager.INSTANCE.setTranslucent((Activity)this.getActivity(), isDark, color2, offsetView);
            if (this.mWindow != null) {
                this.mWindow.hideNavBar((Activity)this.getActivity());
            }
        }
    }

    @Override
    public void enterMoreChannels() {
        this.sendMessage(UserMsgDef.MSG_OPEN_PROFILE_CHANNELS, -1, -1, new EnterProfileEntity(this.mProfileChannelModel, this.uid));
    }

    @Override
    public void enterChannelPage(ChannelItemWrap channel) {
        if (channel == null) {
            MLog.error((Object)TAG, (String)"enterChannelPage error", (Object[])new Object[0]);
            return;
        }
        EnterParam enterParam = EnterParam.obtain((String)channel.getCid(), (int)0);
        enterParam.forceShowHomePage = true;
        enterParam.entryInfo = new EntryInfo(FirstEntType.BIG_PROFILE_CARD, "2", "");
        Message msg = Message.obtain();
        msg.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        msg.obj = enterParam;
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    @Override
    public boolean isBBsEntry() {
        if (this.mProfileReportBean != null) {
            Integer showSource = this.mProfileReportBean.getShowSource();
            boolean isBBsEntry = this.bbsEntrys.contains(showSource);
            MLog.info((Object)TAG, (String)"isBBsEntry showSource:%s", (Object[])new Object[]{showSource, isBBsEntry});
            return isBBsEntry;
        }
        MLog.error((Object)TAG, (String)"isBBsEntry without mProfileReportBean!!!!", (Object[])new Object[0]);
        return false;
    }

    public void onNewFriend(@NotNull FriendRedPointBean bean) {
        if (this.uid == AccountUtil.getUid() && this.mPage != null) {
            this.mPage.setFriendRedDot(bean);
        }
    }
}

