/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile;

import android.util.LruCache;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetOriginRespStringCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.callback.OnGetInsPhotosCallback;
import com.yy.appbase.service.callback.OnGetInsStatusCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.user.profile.bean.InstagramPhotosBean;
import com.yy.hiyo.user.profile.instagram.InstagramMeidaBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.json.JSONException;
import org.json.JSONObject;

public class InstagramPhotoModel {
    private static final String TAG = "InstagramPhotoModel";
    private static LruCache<Long, List<InstagramPhotosBean.InstagramPhotoItemBean>> sPhotMap = new LruCache(1000);
    List<InstagramPhotosBean.InstagramPhotoItemBean> photoItemBeans;

    public void getInstagramPhotos(final long uid, final OnGetInsPhotosCallback callback) {
        List<InstagramPhotosBean.InstagramPhotoItemBean> dataFromCache = this.getDataFromCache(uid);
        if (dataFromCache != null) {
            this.changeList(dataFromCache, callback);
            return;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("uid", (Number)uid);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("data", jsonObject.toString());
        HttpUtil.httpReq((String)(UriProvider.getIkxdSvrHost() + "/ualbum/ins_album/get"), data, (int)1, (INetRespCallback)new INetRespCallback<InstagramPhotosBean>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)InstagramPhotoModel.TAG, (String)("get Instagram photos err:" + e.getMessage()), (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<InstagramPhotosBean> res, int id2) {
                MLog.info((Object)InstagramPhotoModel.TAG, (String)("get Instagram Photos resp:" + response), (Object[])new Object[0]);
                if (callback != null) {
                    InstagramPhotosBean instagramPhotosBean = (InstagramPhotosBean)res.data;
                    if (instagramPhotosBean == null || instagramPhotosBean.photos == null || instagramPhotosBean.photos.isEmpty()) {
                        callback.onGetInsStatusSuccess(new ArrayList(), new ArrayList());
                        return;
                    }
                    InstagramPhotoModel.this.replaceInCache(uid, instagramPhotosBean.photos);
                    InstagramPhotoModel.this.changeList(instagramPhotosBean.photos, callback);
                }
            }
        });
    }

    private void changeList(List<InstagramPhotosBean.InstagramPhotoItemBean> photos, OnGetInsPhotosCallback callback) {
        ArrayList<String> thumbnail = new ArrayList<String>();
        ArrayList<String> standard = new ArrayList<String>();
        for (int i = 0; i < photos.size(); ++i) {
            InstagramPhotosBean.InstagramPhotoItemBean instagramPhotoItemBean = photos.get(i);
            thumbnail.add(instagramPhotoItemBean.thumbnail.url);
            standard.add(instagramPhotoItemBean.standard.url);
        }
        callback.onGetInsStatusSuccess(thumbnail, standard);
    }

    private List<InstagramPhotosBean.InstagramPhotoItemBean> getDataFromCache(long uid) {
        return (List)sPhotMap.get((Object)uid);
    }

    private void replaceInCache(long uid, List<InstagramPhotosBean.InstagramPhotoItemBean> list) {
        if (list == null) {
            list = new ArrayList<InstagramPhotosBean.InstagramPhotoItemBean>();
        }
        sPhotMap.put((Object)uid, list);
    }

    public void deleteInstagramPhotosFromCache(long uid) {
        sPhotMap.remove((Object)uid);
    }

    public void getInstagramBindStatus(final OnGetInsStatusCallback callback) {
        HttpUtil.httpReq((String)(UriProvider.getIkxdSvrHost() + "/ualbum/ins_album/get_ins_status"), null, (int)1, (INetRespCallback)new INetOriginRespStringCallback(){

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)InstagramPhotoModel.TAG, (String)("get Instagram bind status err:" + e.getMessage()), (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                MLog.info((Object)InstagramPhotoModel.TAG, (String)("get Instagram bind status resp:" + response), (Object[])new Object[0]);
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)response);
                    JSONObject data = jsonObject.getJSONObject("data");
                    boolean isBind = data.getBoolean("is_bind");
                    String nickname = data.getString("nick");
                    String token = data.getString("token");
                    if (callback != null) {
                        callback.onGetInsStatusSuccess(token, nickname, isBind);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void uploadInsPhotos(final List<InstagramMeidaBean.InstagramMediaDataItem> imgList, final INetRespCallback callback) {
        if (imgList != null && !imgList.isEmpty()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    List listTemp = imgList;
                    if (listTemp.size() > 50) {
                        listTemp = listTemp.subList(0, 50);
                    }
                    InstagramPhotoModel.this.photoItemBeans = new ArrayList<InstagramPhotosBean.InstagramPhotoItemBean>();
                    JsonObject jsonObject = new JsonObject();
                    JsonArray list = new JsonArray();
                    jsonObject.add("photos", (JsonElement)list);
                    for (InstagramMeidaBean.InstagramMediaDataItem bean : listTemp) {
                        String url;
                        int height;
                        int width;
                        if (bean == null || bean.images == null) continue;
                        InstagramPhotosBean.InstagramPhotoItemBean itemBean = new InstagramPhotosBean.InstagramPhotoItemBean();
                        JsonObject item = new JsonObject();
                        if (bean.images != null && bean.images.lowResolution != null) {
                            width = bean.images.lowResolution.width;
                            height = bean.images.lowResolution.height;
                            url = bean.images.lowResolution.url;
                            InstagramPhotosBean.InstagramPhotoItem lowBean = new InstagramPhotosBean.InstagramPhotoItem();
                            lowBean.height = height;
                            lowBean.width = width;
                            lowBean.url = url;
                            itemBean.low = lowBean;
                            JsonObject low = new JsonObject();
                            low.addProperty("width", (Number)width);
                            low.addProperty("height", (Number)height);
                            low.addProperty("url", url);
                            item.add("low", (JsonElement)low);
                        } else {
                            JsonObject low = new JsonObject();
                            low.addProperty("width", (Number)0);
                            low.addProperty("height", (Number)0);
                            low.addProperty("url", "");
                            item.add("low", (JsonElement)low);
                        }
                        if (bean.images != null && bean.images.standardResolution != null) {
                            width = bean.images.standardResolution.width;
                            height = bean.images.standardResolution.height;
                            url = bean.images.standardResolution.url;
                            InstagramPhotosBean.InstagramPhotoItem standardBean = new InstagramPhotosBean.InstagramPhotoItem();
                            standardBean.height = height;
                            standardBean.width = width;
                            standardBean.url = url;
                            itemBean.standard = standardBean;
                            JsonObject standard = new JsonObject();
                            standard.addProperty("width", (Number)width);
                            standard.addProperty("height", (Number)height);
                            standard.addProperty("url", url);
                            item.add("standard", (JsonElement)standard);
                        } else {
                            JsonObject standard = new JsonObject();
                            standard.addProperty("width", (Number)0);
                            standard.addProperty("height", (Number)0);
                            standard.addProperty("url", "");
                            item.add("standard", (JsonElement)standard);
                        }
                        if (bean.images != null && bean.images.standardResolution != null) {
                            int width2 = bean.images.thumbnail.width;
                            height = bean.images.thumbnail.height;
                            url = bean.images.thumbnail.url;
                            InstagramPhotosBean.InstagramPhotoItem thumbnailBean = new InstagramPhotosBean.InstagramPhotoItem();
                            thumbnailBean.height = height;
                            thumbnailBean.width = width2;
                            thumbnailBean.url = url;
                            itemBean.thumbnail = thumbnailBean;
                            JsonObject thumbnail = new JsonObject();
                            thumbnail.addProperty("width", (Number)width2);
                            thumbnail.addProperty("height", (Number)height);
                            thumbnail.addProperty("url", url);
                            item.add("thumbnail", (JsonElement)thumbnail);
                        } else {
                            JsonObject thumbnail = new JsonObject();
                            thumbnail.addProperty("width", (Number)0);
                            thumbnail.addProperty("height", (Number)0);
                            thumbnail.addProperty("url", "");
                            item.add("thumbnail", (JsonElement)thumbnail);
                        }
                        list.add((JsonElement)item);
                        InstagramPhotoModel.this.photoItemBeans.add(itemBean);
                    }
                    String url = UriProvider.getIkxdSvrHost() + "/ualbum/ins_album/update";
                    HttpUtil.httpReqPostString((String)url, (String)jsonObject.toString(), null, (INetRespCallback)new INetOriginRespStringCallback(){

                        public void onError(Call call, Exception e, int id2) {
                            MLog.info((Object)InstagramPhotoModel.TAG, (String)("Instagram bind err:" + e.getMessage()), (Object[])new Object[0]);
                            if (callback != null) {
                                callback.onError(call, e, id2);
                            }
                        }

                        public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                            MLog.info((Object)InstagramPhotoModel.TAG, (String)("Instagram bind resp:" + response), (Object[])new Object[0]);
                            InstagramPhotoModel.this.replaceInCache(AccountUtil.getUid(), InstagramPhotoModel.this.photoItemBeans);
                            if (callback != null) {
                                callback.onResponse(response, null, id2);
                            }
                        }
                    });
                }
            });
        }
    }
}

