/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import androidx.viewpager.widget.ViewPager;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.user.R;

public class GuideScrollPhotoAnimator {
    private static final String TAG = "GuideScrollPhotoAnimator";
    private ViewGroup mRootView;
    private View mGuideView;
    private RecycleImageView mFingerView;
    private ObjectAnimator mAnimator;
    private ViewPager mViewPager;
    private int mVpSize;
    int scrollX;
    private Animator.AnimatorListener mSimpleAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            YYTaskExecutor.postToMainThread(() -> GuideScrollPhotoAnimator.this.removeGuideAndStopAnim());
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public GuideScrollPhotoAnimator(View rootView, ViewPager viewPager, int size) {
        this.mViewPager = viewPager;
        this.mVpSize = size;
        this.createGuideLayout(rootView);
    }

    private void createGuideLayout(View rootView) {
        if (rootView == null) {
            return;
        }
        this.mRootView = (ViewGroup)rootView;
        this.mGuideView = LayoutInflater.from((Context)this.mRootView.getContext()).inflate(R.layout.layout_single_game_new_guide, null, false);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mRootView.addView(this.mGuideView, params);
        this.mGuideView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GuideScrollPhotoAnimator.this.removeGuideAndStopAnim();
            }
        });
        this.mFingerView = (RecycleImageView)this.mGuideView.findViewById(R.id.single_game_guide_finger);
        ((YYTextView)this.mGuideView.findViewById(R.id.single_game_guide_tip)).setText(R.string.slide_to_switch_photoes);
    }

    public void playGuideAnim() {
        if (this.mFingerView == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"show scroll photoes animator", (Object[])new Object[0]);
        this.mFingerView.post(new Runnable(){

            @Override
            public void run() {
                int moveDistance = ResolutionUtils.dip2Px((float)30.0f);
                if (LanguageUtils.isRtl()) {
                    GuideScrollPhotoAnimator.this.mAnimator = ObjectAnimator.ofFloat((Object)GuideScrollPhotoAnimator.this.mFingerView, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f, moveDistance, 0.0f, moveDistance, 0.0f});
                } else {
                    GuideScrollPhotoAnimator.this.mAnimator = ObjectAnimator.ofFloat((Object)GuideScrollPhotoAnimator.this.mFingerView, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f, -moveDistance, 0.0f, -moveDistance, 0.0f});
                }
                GuideScrollPhotoAnimator.this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                GuideScrollPhotoAnimator.this.mAnimator.setDuration(3000L);
                GuideScrollPhotoAnimator.this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        float curValue = ((Float)animation.getAnimatedValue()).floatValue();
                        int dix = (int)curValue;
                        GuideScrollPhotoAnimator.this.mViewPager.scrollTo(GuideScrollPhotoAnimator.this.scrollX - dix, 0);
                    }
                });
                GuideScrollPhotoAnimator.this.scrollX = GuideScrollPhotoAnimator.this.mViewPager.getScrollX();
                GuideScrollPhotoAnimator.this.mAnimator.addListener(GuideScrollPhotoAnimator.this.mSimpleAnimatorListener);
                GuideScrollPhotoAnimator.this.mAnimator.start();
            }
        });
    }

    private void removeGuideAndStopAnim() {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        if (this.mGuideView != null && this.mRootView != null) {
            this.mGuideView.setVisibility(8);
            if (LanguageUtils.isRtl()) {
                this.mViewPager.setCurrentItem(this.mVpSize - 2, false);
                this.mViewPager.setCurrentItem(this.mVpSize - 1, false);
            } else {
                this.mViewPager.setCurrentItem(1, false);
                this.mViewPager.setCurrentItem(0, false);
            }
            this.mRootView.removeView(this.mGuideView);
        }
    }
}

