/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.honor.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.honor.HonorInfo;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.honor.IUserHonorUiCallbacks;
import com.yy.hiyo.user.honor.ui.HonorShareView;
import java.util.List;

public class HonorShowWindow
extends DefaultWindow
implements View.OnClickListener {
    private LinearLayout mShareContainer;
    private RecycleImageView mHonorImg;
    private TextView mHonorName;
    private TextView mHonorDesc;
    private HonorShareView mShareView;
    private ImageView mSaveAlbumBtn;
    private ImageView mSaveAlbumDecoration;
    private TextView mCountDown;
    private Runnable mRunnableCountDown;
    private int mCurCountDownValue;
    private Animation saveAlbumAnim;
    private IUserHonorUiCallbacks mUserHonorUiCallbacks;
    private boolean mCountDownClosed = false;

    public HonorShowWindow(Context context, IUserHonorUiCallbacks callBacks, String name) {
        super(context, (UICallBacks)callBacks, name);
        this.mUserHonorUiCallbacks = callBacks;
        this.createViews();
    }

    private void createViews() {
        HonorShowWindow.inflate((Context)this.getContext(), (int)R.layout.user_honor_layout, (ViewGroup)this.getBaseLayer());
        this.mShareContainer = (LinearLayout)this.findViewById(R.id.ll_share_container);
        this.mHonorName = (TextView)this.findViewById(R.id.honor_name);
        this.mHonorDesc = (TextView)this.findViewById(R.id.honor_desc);
        this.mHonorImg = (RecycleImageView)this.findViewById(R.id.honor_img);
        this.mShareView = (HonorShareView)this.findViewById(R.id.share_view);
        this.mCountDown = (TextView)this.findViewById(R.id.count_down_second);
        this.mSaveAlbumBtn = (ImageView)this.findViewById(R.id.iv_save_album_btn);
        this.mSaveAlbumDecoration = (ImageView)this.findViewById(R.id.iv_save_album_decoration);
        this.initChannels();
        this.mSaveAlbumBtn.setOnClickListener((View.OnClickListener)this);
        this.mCountDown.setOnClickListener((View.OnClickListener)this);
    }

    private void initChannels() {
        List<BaseShareChannel> shareChannelList = this.mUserHonorUiCallbacks.getShareChannels();
        if (shareChannelList == null) {
            return;
        }
        for (BaseShareChannel shareChannel : shareChannelList) {
            int marginValue;
            YYImageView ivIcon = new YYImageView(this.getContext());
            int iconSize = ResourceUtils.getDimen((int)R.dimen.winning_streak_share_icon_size);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(iconSize, iconSize);
            lp.leftMargin = marginValue = ResolutionUtils.dip2Px((float)12.0f);
            lp.rightMargin = marginValue;
            int idResId = 0;
            int iconResId = 0;
            switch (shareChannel.getId()) {
                case 5: {
                    idResId = R.id.share_platform_facebook;
                    iconResId = R.drawable.ico_share_facebook;
                    break;
                }
                case 2: {
                    idResId = R.id.share_platform_whatsapp;
                    iconResId = R.drawable.ico_share_whatsapp;
                    break;
                }
                case 1: {
                    idResId = R.id.share_platform_line;
                    iconResId = R.drawable.ico_share_line;
                    break;
                }
                case 3: {
                    idResId = R.id.share_platform_instagram;
                    iconResId = R.drawable.ico_share_ins;
                    break;
                }
                case 6: {
                    idResId = R.id.share_platform_messenger;
                    iconResId = R.drawable.ico_share_messenger;
                    break;
                }
                case 9: {
                    idResId = R.id.share_platform_vk;
                    iconResId = R.drawable.ico_share_vk;
                    break;
                }
            }
            ivIcon.setId(idResId);
            ivIcon.setImageResource(iconResId);
            this.mShareContainer.addView((View)ivIcon, (ViewGroup.LayoutParams)lp);
            ivIcon.setOnClickListener((View.OnClickListener)this);
        }
    }

    public View getShareView() {
        return this.mShareView;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_save_album_btn) {
            this.stopSaveAlbumAnim();
            if (this.mUserHonorUiCallbacks != null) {
                this.mUserHonorUiCallbacks.onSaveToAlbumClicked();
            }
        } else if (id2 == R.id.count_down_second) {
            this.mUserHonorUiCallbacks.closeHonorShowWindow();
        } else {
            int channelId = ShareChannelIdDef.getChannelIdByViewId((int)id2);
            if (channelId != -1) {
                this.share(channelId);
            }
        }
        this.stopCountDown();
        this.mCountDownClosed = true;
    }

    private void share(int channelId) {
        if (this.mUserHonorUiCallbacks != null) {
            this.mUserHonorUiCallbacks.onShareClicked(channelId);
        }
    }

    public void updateHonor() {
        HonorInfo honorInfo = null;
        if (this.mUserHonorUiCallbacks != null) {
            honorInfo = this.mUserHonorUiCallbacks.getCurrentHonor();
        }
        if (honorInfo == null) {
            return;
        }
        this.mHonorName.setText((CharSequence)honorInfo.getName());
        this.mHonorDesc.setText((CharSequence)honorInfo.getDesc());
        ImageLoader.loadImage((ImageView)this.mHonorImg, (String)honorInfo.getBicon(), (int)0, (int)0, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                HonorShowWindow.this.stratCountDown();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                HonorShowWindow.this.stratCountDown();
            }
        });
        this.mShareView.updateHonorInfo(honorInfo);
    }

    public void onAttach() {
        super.onAttach();
        this.mCountDownClosed = false;
        this.startSaveAlbumAnim();
        this.updateHonor();
    }

    public void onDetached() {
        super.onDetached();
        this.stopCountDown();
        this.stopSaveAlbumAnim();
    }

    private void stratCountDown() {
        if (this.mCountDownClosed) {
            return;
        }
        this.mCurCountDownValue = 10;
        if (this.mRunnableCountDown == null) {
            this.mRunnableCountDown = new Runnable(){

                @Override
                public void run() {
                    if (HonorShowWindow.this.mCountDown == null) {
                        return;
                    }
                    HonorShowWindow.this.mCurCountDownValue--;
                    if (HonorShowWindow.this.mCurCountDownValue <= 0) {
                        HonorShowWindow.this.mUserHonorUiCallbacks.closeHonorShowWindow();
                    } else {
                        HonorShowWindow.this.mCountDown.setText((CharSequence)ResourceUtils.getString((int)R.string.tap_to_continue, (Object[])new Object[]{HonorShowWindow.this.mCurCountDownValue}));
                        YYTaskExecutor.postToMainThread((Runnable)HonorShowWindow.this.mRunnableCountDown, (long)1000L);
                    }
                }
            };
        }
        this.mCountDown.setText((CharSequence)ResourceUtils.getString((int)R.string.tap_to_continue, (Object[])new Object[]{this.mCurCountDownValue}));
        YYTaskExecutor.postToMainThread((Runnable)this.mRunnableCountDown, (long)1000L);
    }

    private void stopCountDown() {
        if (this.mRunnableCountDown != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRunnableCountDown);
        }
        this.mCountDown.setText((CharSequence)ResourceUtils.getString((int)R.string.tap_to_continue_no_timer));
    }

    private void startSaveAlbumAnim() {
        this.saveAlbumAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        this.saveAlbumAnim.setDuration(8000L);
        this.saveAlbumAnim.setFillAfter(true);
        this.saveAlbumAnim.setInterpolator((Interpolator)new LinearInterpolator());
        this.saveAlbumAnim.setRepeatMode(1);
        this.saveAlbumAnim.setRepeatCount(-1);
        this.mSaveAlbumDecoration.setVisibility(0);
        this.mSaveAlbumDecoration.startAnimation(this.saveAlbumAnim);
    }

    private void stopSaveAlbumAnim() {
        if (this.saveAlbumAnim != null) {
            this.saveAlbumAnim.cancel();
            this.saveAlbumAnim = null;
        }
        this.mSaveAlbumDecoration.setVisibility(8);
    }
}

