/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.honor.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.appbase.honor.HonorInfo;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.user.DR;
import com.yy.hiyo.user.R;

public class HonorShareView
extends YYLinearLayout {
    private static final String TAG = "HonorShareView";
    private RecycleImageView mBg;
    private TextView mName;
    private TextView mDesc;
    private RecycleImageView mImg;

    public HonorShareView(Context context) {
        super(context);
        this.createViews();
    }

    public HonorShareView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createViews();
    }

    public HonorShareView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createViews();
    }

    private void createViews() {
        this.setOrientation(1);
        HonorShareView.inflate((Context)this.getContext(), (int)R.layout.honor_share_view_layout, (ViewGroup)this);
        this.mBg = (RecycleImageView)this.findViewById(R.id.bg_honor_share);
        this.mName = (TextView)this.findViewById(R.id.tv_honor_name);
        this.mDesc = (TextView)this.findViewById(R.id.tv_honor_desc);
        this.mImg = (RecycleImageView)this.findViewById(R.id.iv_honor_img);
        this.setBgImg();
    }

    private void setBgImg() {
        DyResLoader.INSTANCE.loadImage(this.mBg, DR.bg_honor_share);
    }

    public void updateHonorInfo(HonorInfo honorInfo) {
        if (honorInfo == null) {
            return;
        }
        this.mName.setText((CharSequence)honorInfo.getName());
        this.mDesc.setText((CharSequence)honorInfo.getDesc());
        ImageLoader.loadImage((ImageView)this.mImg, (String)honorInfo.getBicon());
    }
}

