/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.honor;

import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.honor.HonorInfo;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.callback.OnGetLatestHonorCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import common.Header;
import ikxd.task.GetIconFrameNotify;
import ikxd.task.GetIconFrameReq;
import ikxd.task.GetIconFrameRes;
import ikxd.task.GetLatestIconFrameConfReq;
import ikxd.task.GetLatestIconFrameConfRes;
import ikxd.task.GetTitleNotify;
import ikxd.task.IconFrame;
import ikxd.task.LatestIconFrame;
import ikxd.task.ReportTitleTaskReq;
import ikxd.task.Task;
import ikxd.task.TaskUri;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Call;

public class UserHonorService
extends DefaultController
implements IHonorService,
INotify,
IProtoNotify<Task> {
    private static final String TAG = "UserHonorService";
    private static final int HONOR_NONE = 0;
    private static final String HONOR_SAVED_SEPARATOR = "-";
    private static final int HAD_USE_EMOJI = 6;
    private static final int HAD_SOUNDED = 7;
    private static final int NIGHT_CAT = 8;
    private static final int FRAME_ICON_EXPIRE_TIME = 300000;
    private int currentHonorId;
    private long reportEmojTime;
    private long version = 0L;
    private long mHeadFrameConfigRequestTime = 0L;
    private final Map<Long, FrameIdWithUpdateTime> mHonorItemCacheMap = new HashMap<Long, FrameIdWithUpdateTime>();
    private final Map<Integer, IHonorService.HeadFrame> mHeadFrameUrlCacheMap = new HashMap<Integer, IHonorService.HeadFrame>();
    private final IFrequencyLimitExecutor mFrequencyLimitExecutor;
    private static final long TIME_GAPE = 50L;
    private ArrayList<Long> uidsToRequest = null;
    private ArrayList<GetHeadFrameItem> mGetHeadFrameItems = null;
    private boolean waitingToRun = false;
    private ArrayList<GetHeadFrameItem> mGetHeadFrameItemsWaitForRequesting = null;
    private final ArrayList<Long> mUidsRequesting = new ArrayList();

    public UserHonorService(Environment env) {
        super(env);
        this.mFrequencyLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)300000L, (boolean)true);
        this.mFrequencyLimitExecutor.execute(this.createClearExpireItems());
    }

    private Runnable createClearExpireItems() {
        return new Runnable(){

            @Override
            public void run() {
                Set keys = UserHonorService.this.mHonorItemCacheMap.keySet();
                if (keys == null || keys.size() > 0) {
                    UserHonorService.this.mFrequencyLimitExecutor.execute(UserHonorService.this.createClearExpireItems());
                    return;
                }
                FrameIdWithUpdateTime frameIdWithUpdateTime = null;
                long curTime = SystemClock.elapsedRealtime();
                for (Long key : keys) {
                    frameIdWithUpdateTime = (FrameIdWithUpdateTime)UserHonorService.this.mHonorItemCacheMap.get(key);
                    if (frameIdWithUpdateTime == null || curTime - frameIdWithUpdateTime.lastUpdateTime <= 300000L) continue;
                    UserHonorService.this.mHonorItemCacheMap.remove(key);
                }
                UserHonorService.this.mFrequencyLimitExecutor.execute(UserHonorService.this.createClearExpireItems());
            }
        };
    }

    public String serviceName() {
        return "ikxd_task_d";
    }

    public void onNotify(@NonNull Task task) {
        GetIconFrameNotify getIconFrameNotify;
        if (task.uri == TaskUri.kUriTaskGetTitleNotify) {
            GetTitleNotify notify2 = task.get_title_notify;
            if (notify2 != null) {
                int honorId = notify2.title_id.intValue();
                this.onHonorGet(honorId);
            }
        } else if (task.uri == TaskUri.kUriTaskGetIconFrameNotify && (getIconFrameNotify = task.get_icon_frame_notify) != null) {
            long frame = getIconFrameNotify.frame;
            if (!this.hasFrame((int)frame)) {
                FeatureLog.i((String)"FTHeadFrame", (String)"receive headFrame new:%s", (Object[])new Object[]{frame});
                this.requestHeadFrameConfig();
            }
            this.mHeadFrameUrlCacheMap.put((int)frame, new IHonorService.HeadFrame(getIconFrameNotify.url, getIconFrameNotify.onlyBBS.booleanValue()));
            this.mHonorItemCacheMap.put(AccountUtil.getUid(), new FrameIdWithUpdateTime((int)frame, SystemClock.elapsedRealtime()));
            FeatureLog.i((String)"FTHeadFrame", (String)"head frame:%s, url:%s", (Object[])new Object[]{frame, getIconFrameNotify.url});
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).setHeadFrameType(frame);
        }
    }

    private void preLoadConfig() {
        if (AccountUtil.getUid() > 0L) {
            this.requestHeadFrameConfig();
            this.getHeadFrameMyself();
        }
    }

    private void onHonorGet(final int honorId) {
        FeatureLog.i((String)"FTHeadFrame", (String)("onHonorGet, id = " + honorId), (Object[])new Object[0]);
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getHonorByTitleId((long)honorId, new OnGetLatestHonorCallback(){

            public void onLatestHonorSuccess(HonorInfo honorInfo) {
                if (UserHonorService.this.canShowHonorOnCurrentWindow(honorId)) {
                    UserHonorService.this.showHonorWindow(honorInfo);
                    UserHonorService.this.currentHonorId = 0;
                    UserHonorService.this.saveCurrentHonor(0);
                    FeatureLog.i((String)"FTHeadFrame", (String)"honor can show", (Object[])new Object[0]);
                } else {
                    UserHonorService.this.currentHonorId = honorId;
                    UserHonorService.this.saveCurrentHonor(UserHonorService.this.currentHonorId);
                    FeatureLog.i((String)"FTHeadFrame", (String)"honor can not show", (Object[])new Object[0]);
                }
            }

            public void onLatestHonorError() {
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    public void enterFocusWindow() {
        if (this.currentHonorId == 0) {
            return;
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getHonorByTitleId((long)this.currentHonorId, new OnGetLatestHonorCallback(){

            public void onLatestHonorSuccess(HonorInfo honorInfo) {
                if (UserHonorService.this.canShowHonorOnCurrentWindow(UserHonorService.this.currentHonorId)) {
                    UserHonorService.this.showHonorWindow(honorInfo);
                    UserHonorService.this.currentHonorId = 0;
                    UserHonorService.this.saveCurrentHonor(0);
                }
            }

            public void onLatestHonorError() {
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    public void getHeadFrame(List<Long> uids, OnGetHeadFrameCallback callback) {
        this.getHeadFrame(uids, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHeadFrame(List<Long> uids, final OnGetHeadFrameCallback callback, boolean notUseAggregate) {
        if (RuntimeContext.sIsDebuggable) {
            FeatureLog.i((String)"FTHeadFrame", (String)"get head frame", (Object[])new Object[0]);
        }
        ArrayList<Long> usersNeedRequestUpdate = new ArrayList<Long>();
        final List<Integer> honorList = this.getUserHonorFromCache(uids, usersNeedRequestUpdate);
        if (usersNeedRequestUpdate.size() <= 0) {
            if (RuntimeContext.sIsDebuggable) {
                FeatureLog.i((String)"FTHeadFrame", (String)"get head frame from cache", (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onGetHeadFrameSuccess(honorList);
                    }
                }
            });
        } else if (notUseAggregate) {
            if (RuntimeContext.sIsDebuggable) {
                FeatureLog.i((String)"FTHeadFrame", (String)"get head frame from server now!", (Object[])new Object[0]);
            }
            this.getHeadFrameFromServer(usersNeedRequestUpdate, callback);
        } else {
            if (RuntimeContext.sIsDebuggable) {
                FeatureLog.i((String)"FTHeadFrame", (String)"get head frame from server wait for Aggregate!", (Object[])new Object[0]);
            }
            UserHonorService userHonorService = this;
            synchronized (userHonorService) {
                if (this.mUidsRequesting != null && this.mUidsRequesting.size() >= usersNeedRequestUpdate.size()) {
                    boolean allIn = true;
                    Iterator iterator = usersNeedRequestUpdate.iterator();
                    while (iterator.hasNext()) {
                        long uid = (Long)iterator.next();
                        if (this.mUidsRequesting.contains(uid)) continue;
                        allIn = false;
                    }
                    if (allIn) {
                        if (this.mGetHeadFrameItemsWaitForRequesting == null) {
                            this.mGetHeadFrameItemsWaitForRequesting = new ArrayList();
                        }
                        GetHeadFrameItem item = new GetHeadFrameItem(usersNeedRequestUpdate, callback);
                        if (RuntimeContext.sIsDebuggable) {
                            FeatureLog.i((String)"FTHeadFrame", (String)"GetHeadFrameItems is in requesting uids:%s!", (Object[])new Object[]{item});
                        }
                        this.mGetHeadFrameItemsWaitForRequesting.add(item);
                        return;
                    }
                }
                if (this.uidsToRequest == null) {
                    this.uidsToRequest = new ArrayList();
                }
                this.uidsToRequest.addAll(usersNeedRequestUpdate);
                if (this.mGetHeadFrameItems == null) {
                    this.mGetHeadFrameItems = new ArrayList();
                }
                this.mGetHeadFrameItems.add(new GetHeadFrameItem(uids, callback));
                if (!this.waitingToRun) {
                    this.waitingToRun = true;
                    YYTaskExecutor.postToMainThread((Runnable)this.getRequestUserHonorRunnable(), (long)50L);
                }
            }
        }
    }

    private Runnable getRequestUserHonorRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UserHonorService userHonorService = UserHonorService.this;
                synchronized (userHonorService) {
                    UserHonorService.this.waitingToRun = false;
                    final ArrayList uidsToRequestCopy = UserHonorService.this.uidsToRequest;
                    final ArrayList getHeadFrameItemsCopy = UserHonorService.this.mGetHeadFrameItems;
                    UserHonorService.this.uidsToRequest = null;
                    UserHonorService.this.mGetHeadFrameItems = null;
                    if (RuntimeContext.sIsDebuggable) {
                        FeatureLog.i((String)"FTHeadFrame", (String)"get head frame from server Aggregate!", (Object[])new Object[0]);
                    }
                    if (uidsToRequestCopy == null || getHeadFrameItemsCopy == null) {
                        if (RuntimeContext.isInGray()) {
                            throw new RuntimeException("\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u7406\u8bba\u4e0a\u4e0d\u5e94\u8be5\u7684\uff01");
                        }
                        return;
                    }
                    UserHonorService.this.getHeadFrameFromServer(uidsToRequestCopy, new OnGetHeadFrameCallback(){

                        public void onGetHeadFrameSuccess(List<Integer> list) {
                            long curTime = -1L;
                            for (Long uidItem : uidsToRequestCopy) {
                                if (UserHonorService.this.mHonorItemCacheMap.containsKey(uidItem)) continue;
                                if (curTime == -1L) {
                                    curTime = SystemClock.elapsedRealtime();
                                }
                                UserHonorService.this.mHonorItemCacheMap.put(uidItem, new FrameIdWithUpdateTime(0, curTime));
                            }
                            if (getHeadFrameItemsCopy.size() <= 0) {
                                return;
                            }
                            for (GetHeadFrameItem item : getHeadFrameItemsCopy) {
                                if (item == null || item.callback == null) continue;
                                UserHonorService.this.getHeadFrame(item.uids, item.callback, true);
                            }
                        }

                        public void onError(Call call, Exception e, int id2) {
                            if (getHeadFrameItemsCopy.size() <= 0) {
                                return;
                            }
                            for (GetHeadFrameItem item : getHeadFrameItemsCopy) {
                                if (item == null || item.callback == null) continue;
                                item.callback.onError(call, e, id2);
                            }
                        }

                        public void onResponseError(int id2, String message, String response) {
                            if (getHeadFrameItemsCopy.size() <= 0) {
                                return;
                            }
                            for (GetHeadFrameItem item : getHeadFrameItemsCopy) {
                                if (item == null || item.callback == null) continue;
                                item.callback.onResponseError(id2, message, response);
                            }
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getUserHonorFromCache(List<Long> uids, List<Long> needRequestUpdateList) {
        ArrayList<Integer> honorList = new ArrayList<Integer>();
        FrameIdWithUpdateTime item = null;
        Map<Long, FrameIdWithUpdateTime> map = this.mHonorItemCacheMap;
        synchronized (map) {
            for (Long uid : uids) {
                if (this.mHonorItemCacheMap.containsKey(uid)) {
                    item = this.mHonorItemCacheMap.get(uid);
                    if (item != null) {
                        honorList.add(item.frameId);
                        continue;
                    }
                    needRequestUpdateList.add(uid);
                    continue;
                }
                needRequestUpdateList.add(uid);
            }
        }
        return honorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHeadFrameFromServer(final List<Long> uids, final OnGetHeadFrameCallback callback) {
        Class<UserHonorService> clazz = UserHonorService.class;
        synchronized (UserHonorService.class) {
            this.mUidsRequesting.addAll(uids);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            final Runnable notifyWaitingRequest = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList items = null;
                    Class<UserHonorService> clazz = UserHonorService.class;
                    synchronized (UserHonorService.class) {
                        UserHonorService.this.mUidsRequesting.removeAll(uids);
                        if (UserHonorService.this.mGetHeadFrameItemsWaitForRequesting != null) {
                            items = new ArrayList(UserHonorService.this.mGetHeadFrameItemsWaitForRequesting);
                            UserHonorService.this.mGetHeadFrameItemsWaitForRequesting.clear();
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        if (items != null) {
                            for (GetHeadFrameItem item : items) {
                                if (item != null) {
                                    UserHonorService.this.getHeadFrame(item.uids, item.callback);
                                }
                                if (!RuntimeContext.sIsDebuggable) continue;
                                FeatureLog.i((String)"FTHeadFrame", (String)"GetHeadFrameItems notify by request end:%s!", (Object[])new Object[]{item});
                            }
                        }
                        return;
                    }
                }
            };
            GetIconFrameReq req = new GetIconFrameReq.Builder().uids(uids).build();
            Header header = ProtoManager.getInstance().getHeader("ikxd_task_d");
            Task unifo = new Task.Builder().header(header).uri(TaskUri.kUriTaskGetIconFrameReq).get_icon_frame_req(req).build();
            ProtoManager.getInstance().send((AndroidMessage)unifo, (IProtoCallback)new IProtoCallback<Task>(){

                public void onResponse(@Nullable Task result) {
                    if (result != null && result.uri == TaskUri.kUriTaskGetIconFrameRes) {
                        GetIconFrameRes getIconFrameRes = result.get_icon_frame_res;
                        List framesList = getIconFrameRes.frames;
                        FeatureLog.i((String)"FTHeadFrame", (String)"get head frame success", (Object[])new Object[0]);
                        if (callback != null) {
                            ArrayList<Integer> tempList = new ArrayList<Integer>();
                            long curTime = SystemClock.elapsedRealtime();
                            for (int i = 0; i < framesList.size(); ++i) {
                                IconFrame iconFrame = (IconFrame)framesList.get(i);
                                String headFrameUrl = iconFrame.url;
                                int frame = FP.orInt((Long)iconFrame.frame);
                                boolean onlyBBS = iconFrame.onlyBBS;
                                tempList.add(frame);
                                UserHonorService.this.mHeadFrameUrlCacheMap.put(frame, new IHonorService.HeadFrame(headFrameUrl, onlyBBS));
                                UserHonorService.this.mHonorItemCacheMap.put(iconFrame.uid, new FrameIdWithUpdateTime(frame, curTime));
                                if (iconFrame.uid == AccountUtil.getUid()) {
                                    ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).setHeadFrameType((long)frame);
                                }
                                FeatureLog.i((String)"FTHeadFrame", (String)"getHeadFrameFromServer uid: %d, frame: %d, url: %s, onlyBBS:%b", (Object[])new Object[]{iconFrame.uid, frame, headFrameUrl, onlyBBS});
                            }
                            callback.onGetHeadFrameSuccess(tempList);
                        }
                    }
                    notifyWaitingRequest.run();
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    notifyWaitingRequest.run();
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    notifyWaitingRequest.run();
                    return false;
                }
            });
            return;
        }
    }

    private void onHeadFrameSuccess(GetIconFrameRes result, OnGetHeadFrameCallback callback) {
        if (result != null) {
            GetIconFrameRes getIconFrameRes = result;
            List framesList = getIconFrameRes.frames;
            FeatureLog.i((String)"FTHeadFrame", (String)"get head frame success", (Object[])new Object[0]);
            if (callback != null) {
                ArrayList<Integer> tempList = new ArrayList<Integer>();
                long curTime = SystemClock.elapsedRealtime();
                for (int i = 0; i < framesList.size(); ++i) {
                    IconFrame iconFrame = (IconFrame)framesList.get(i);
                    String headFrameUrl = iconFrame.url;
                    int frame = FP.orInt((Long)iconFrame.frame);
                    boolean onlyBBS = iconFrame.onlyBBS;
                    tempList.add(frame);
                    this.mHeadFrameUrlCacheMap.put(frame, new IHonorService.HeadFrame(headFrameUrl, onlyBBS));
                    this.mHonorItemCacheMap.put(iconFrame.uid, new FrameIdWithUpdateTime(frame, curTime));
                    FeatureLog.i((String)"FTHeadFrame", (String)"getHeadFrameFromServer uid: %d, frame: %d, url: %s, onlyBBS:%b", (Object[])new Object[]{iconFrame.uid, frame, headFrameUrl, onlyBBS});
                }
                callback.onGetHeadFrameSuccess(tempList);
            }
        } else {
            callback.onResponseError(-1, "", "");
        }
    }

    public void getSingleHeadFrame(long uid, OnGetHeadFrameCallback callback) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(uid);
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"getSingleHeadFrame:%s", (Object[])new Object[]{String.valueOf(uid)});
        }
        this.getHeadFrame(list, callback);
    }

    public void getHeadFrameMyself() {
        long uid = AccountUtil.getUid();
        if (uid == 0L) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(uid);
        this.getHeadFrame(list, new OnGetHeadFrameCallback(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }

            public void onGetHeadFrameSuccess(List<Integer> list) {
                if (list != null && !list.isEmpty()) {
                    ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).setHeadFrameType((long)list.get(0).intValue());
                }
            }
        });
    }

    public String getHeadFrameUrlFromCache(int frame) {
        if (this.mHeadFrameUrlCacheMap == null) {
            return "";
        }
        if (this.mHeadFrameUrlCacheMap.containsKey(frame)) {
            IHonorService.HeadFrame headFrame = this.mHeadFrameUrlCacheMap.get(frame);
            if (headFrame != null && StringUtils.isNotEmpty((String)headFrame.url)) {
                return headFrame.url;
            }
            return "";
        }
        return "";
    }

    public IHonorService.HeadFrame getHeadFrameFromCache(int frame) {
        return this.mHeadFrameUrlCacheMap.get(frame);
    }

    public void requestHeadFrameConfig() {
        if (RuntimeContext.sIsDebuggable) {
            FeatureLog.d((String)"FTHeadFrame", (String)"requestHeadFrameConfig version:%s", (Object[])new Object[]{this.version});
        }
        if (this.isHeadFrameConfigRequestQuick()) {
            FeatureLog.i((String)"FTHeadFrame", (String)"requestHeadFrameConfig quick", (Object[])new Object[0]);
            return;
        }
        GetLatestIconFrameConfReq req = new GetLatestIconFrameConfReq.Builder().version(Long.valueOf(this.version)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_task_d");
        Task unifo = new Task.Builder().header(header).uri(TaskUri.kUriTaskGetLatestIconFrameConfReq).get_latest_icon_frame_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)unifo, (IProtoCallback)new IProtoCallback<Task>(){

            public void onResponse(@Nullable Task message) {
                if (message == null) {
                    FeatureLog.i((String)"FTHeadFrame", (String)"requestHeadFrameConfig message null", (Object[])new Object[0]);
                    return;
                }
                if (message.uri != null && message.uri != TaskUri.kUriTaskGetLatestIconFrameConfRes) {
                    FeatureLog.i((String)"FTHeadFrame", (String)"requestHeadFrameConfig uri not right:%s", (Object[])new Object[]{message.uri});
                    return;
                }
                GetLatestIconFrameConfRes res = message.get_latest_icon_frame_res;
                if (res == null) {
                    FeatureLog.i((String)"FTHeadFrame", (String)"requestHeadFrameConfig res null", (Object[])new Object[0]);
                    return;
                }
                if (RuntimeContext.isInGray()) {
                    FeatureLog.i((String)"FTHeadFrame", (String)"requestHeadFrameConfig version:%s, result:%s", (Object[])new Object[]{res.version, res.config});
                } else {
                    FeatureLog.i((String)"FTHeadFrame", (String)"requestHeadFrameConfig version:%s", (Object[])new Object[]{res.version});
                }
                UserHonorService.this.version = res.version;
                List iconFrameList = res.config;
                if (iconFrameList != null) {
                    for (LatestIconFrame frame : iconFrameList) {
                        int id2 = frame.frame.intValue();
                        if (id2 == 0) {
                            String msg = "frame id is 0, " + frame.url;
                            if (SystemUtils.isShowEnvSetting()) {
                                throw new IllegalStateException(msg);
                            }
                            MLog.error((Object)"FTHeadFrame", (String)msg, (Object[])new Object[0]);
                            continue;
                        }
                        UserHonorService.this.mHeadFrameUrlCacheMap.put(id2, new IHonorService.HeadFrame(frame.url, frame.onlyBBS.booleanValue()));
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.e((String)"FTHeadFrame", (String)"requestHeadFrameConfig timeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.e((String)"FTHeadFrame", (String)"requestHeadFrameConfig errorCode:%s, errorMsg:%s", (Object[])new Object[]{code, reason});
                return false;
            }
        });
    }

    public boolean hasCache() {
        if (this.mHeadFrameUrlCacheMap == null) {
            return false;
        }
        return this.mHeadFrameUrlCacheMap.size() != 0;
    }

    public long getSelfHeadFrameFromCache() {
        if (this.mHonorItemCacheMap == null) {
            return 0L;
        }
        FrameIdWithUpdateTime item = null;
        if (!this.mHonorItemCacheMap.containsKey(AccountUtil.getUid())) {
            return 0L;
        }
        item = this.mHonorItemCacheMap.get(AccountUtil.getUid());
        if (item == null) {
            return 0L;
        }
        return item.frameId;
    }

    public boolean hasFrame(int frame) {
        if (this.mHeadFrameUrlCacheMap == null) {
            return false;
        }
        return this.mHeadFrameUrlCacheMap.containsKey(frame);
    }

    public void addHeadFrameIntoCache(long uid, int iconFrame) {
        if (this.mHonorItemCacheMap != null) {
            FeatureLog.i((String)"FTHeadFrame", (String)"addHeadFrameIntoCache uid: %d, frame: %d", (Object[])new Object[]{uid, iconFrame});
            this.mHonorItemCacheMap.put(uid, new FrameIdWithUpdateTime(iconFrame, SystemClock.elapsedRealtime()));
        }
    }

    private void showHonorWindow(HonorInfo honorInfo) {
        Message message = Message.obtain();
        message.what = BaseMsgDef.MSG_SHOW_HONOR_GET;
        message.obj = honorInfo;
        this.sendMessage(message);
    }

    private int recoverFromSaved() {
        int honorId = 0;
        try {
            String[] str;
            String savedStr = SettingFlags.getStringValue((String)"honor_to_show");
            if (!TextUtils.isEmpty((CharSequence)savedStr) && (str = savedStr.split(HONOR_SAVED_SEPARATOR)) != null && str.length == 2) {
                long honorUid = Long.valueOf(str[0]);
                int id2 = Integer.valueOf(str[1]);
                if (honorUid == AccountUtil.getUid()) {
                    honorId = id2;
                }
            }
        }
        catch (Exception e) {
            honorId = 0;
            FeatureLog.i((String)"FTHeadFrame", (String)"recoverFromSaved error", (Object[])new Object[0]);
        }
        FeatureLog.i((String)"FTHeadFrame", (String)"recoverFromSaved, id %d", (Object[])new Object[]{honorId});
        return honorId;
    }

    private void saveCurrentHonor(int honorId) {
        long uid = AccountUtil.getUid();
        String saveStr = "" + uid + HONOR_SAVED_SEPARATOR + honorId;
        SettingFlags.setStringValue((String)"honor_to_show", (String)saveStr);
        FeatureLog.i((String)"FTHeadFrame", (String)("saveCurrentHonor, id = " + honorId), (Object[])new Object[0]);
    }

    public synchronized void reportSendEmojHonorTask() {
        FeatureLog.i((String)"FTHeadFrame", (String)"report honor reportSendEmojHonorTask", (Object[])new Object[0]);
        long currentTimeMillis = System.currentTimeMillis();
        long dif = currentTimeMillis - this.reportEmojTime;
        if (dif > 10000L) {
            this.reportHonorTask(6);
            this.reportEmojTime = currentTimeMillis;
        }
    }

    public void reportOpenSoundHonorTask() {
        FeatureLog.i((String)"FTHeadFrame", (String)"report honor reportOpenSoundHonorTask", (Object[])new Object[0]);
        this.reportHonorTask(7);
    }

    public void reportNightCatHonorTask() {
        FeatureLog.i((String)"FTHeadFrame", (String)"report honor reportNightCatHonorTask", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TimeUtils.isCurrentInTimeScope()) {
                    long currentTime = System.currentTimeMillis();
                    long saveTime = SettingFlags.getLongValue((String)("curr_time_of_night_cat" + AccountUtil.getUid()));
                    long foreGroundRUnTime = RuntimeContext.getForeGroundRunTime();
                    if (foreGroundRUnTime > 900000L && currentTime - saveTime > 25200000L) {
                        SettingFlags.setLongValue((String)("curr_time_of_night_cat" + AccountUtil.getUid()), (long)System.currentTimeMillis());
                        UserHonorService.this.reportHonorTask(8);
                        MLog.info((Object)UserHonorService.TAG, (String)"report honor reportNightCatHonorTask Success", (Object[])new Object[0]);
                    }
                }
            }
        });
    }

    public boolean canShowHonorOnCurrentWindow(int titleId) {
        if (this.mDialogLinkManager != null && this.mDialogLinkManager.isDialogShowing()) {
            FeatureLog.i((String)"FTHeadFrame", (String)"dialog showing", (Object[])new Object[0]);
            return false;
        }
        switch (titleId) {
            case 1: {
                return this.onGameResultWindow();
            }
            case 2: {
                return this.onGameResultWindow();
            }
            case 3: {
                return this.onGameResultWindow() || this.onProfileWindow();
            }
            case 4: {
                return this.onGameResultWindow() || this.onHomePageWindow();
            }
            case 5: {
                return this.onGameResultWindow() || this.onHomePageWindow();
            }
            case 6: {
                return this.onHomePageWindow();
            }
            case 7: {
                return this.onGameResultWindow();
            }
            case 8: {
                return this.onGameResultWindow();
            }
            case 9: {
                return this.onGameResultWindow() || this.onHomePageWindow();
            }
        }
        return this.onHomePageWindow();
    }

    private boolean onGameResultWindow() {
        FeatureLog.i((String)"FTHeadFrame", (String)"is  onGameResultWindow", (Object[])new Object[0]);
        AbstractWindow currentWindow = this.getCurrentWindow();
        return this.getCurrentWindow() != null && StringUtils.equal((String)this.getCurrentWindow().getName(), (String)"GameResult");
    }

    private boolean onProfileWindow() {
        FeatureLog.i((String)"FTHeadFrame", (String)"is  onProfileWindow", (Object[])new Object[0]);
        return this.getCurrentWindow() != null && StringUtils.equal((String)this.getCurrentWindow().getName(), (String)"Profile");
    }

    private boolean onHomePageWindow() {
        FeatureLog.i((String)"FTHeadFrame", (String)"is  onHomePageWindow", (Object[])new Object[0]);
        return this.getCurrentWindow() != null && (StringUtils.equal((String)this.getCurrentWindow().getName(), (String)"HomePage") || StringUtils.equal((String)this.getCurrentWindow().getName(), (String)"HomePageNew"));
    }

    private boolean isHeadFrameConfigRequestQuick() {
        if (this.mHeadFrameConfigRequestTime == 0L) {
            this.mHeadFrameConfigRequestTime = SystemClock.uptimeMillis();
            return false;
        }
        if (SystemClock.uptimeMillis() - this.mHeadFrameConfigRequestTime < 100L) {
            return true;
        }
        this.mHeadFrameConfigRequestTime = SystemClock.uptimeMillis();
        return false;
    }

    private void reportHonorTask(int taskType) {
        ReportTitleTaskReq req = new ReportTitleTaskReq.Builder().task_type(Long.valueOf(taskType)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_task_d");
        Task unifo = new Task.Builder().header(header).uri(TaskUri.kUriTaskReportTitleTaskReq).report_title_task_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)unifo, (IProtoCallback)new IProtoCallback<Task>(){

            public void onResponse(@NonNull Task message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message != null && message.uri == TaskUri.kUriTaskReportTitleTaskRes) {
                    FeatureLog.i((String)"FTHeadFrame", (String)"report honor success", (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.e((String)"FTHeadFrame", (String)"report honor retryWhenTimeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.e((String)"FTHeadFrame", (String)"report honor retryWhenError", (Object[])new Object[0]);
                return false;
            }
        });
    }

    public void registerNotify() {
        ProtoManager.getInstance().registerNotify((IProtoNotify)this);
        this.currentHonorId = this.recoverFromSaved();
    }

    static class FrameIdWithUpdateTime {
        long lastUpdateTime = 0L;
        int frameId;

        FrameIdWithUpdateTime(int frameId, long lastUpdateTime) {
            this.frameId = frameId;
            this.lastUpdateTime = lastUpdateTime;
        }
    }

    private static class GetHeadFrameItem {
        public List<Long> uids;
        public OnGetHeadFrameCallback callback;

        public GetHeadFrameItem(List<Long> uids, OnGetHeadFrameCallback callback) {
            this.uids = uids;
            this.callback = callback;
        }
    }
}

