/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.honor;

import android.os.Message;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.honor.HonorInfo;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.user.R;
import com.yy.hiyo.user.honor.HonorShareHelper;
import com.yy.hiyo.user.honor.IUserHonorUiCallbacks;
import com.yy.hiyo.user.honor.ui.HonorShowWindow;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class HonorShowWindowController
extends DefaultWindowController
implements IUserHonorUiCallbacks,
ISharePage {
    private HonorShowWindow mHonorShowWindow;
    private HonorInfo mHonorInfo;
    private HonorShareHelper honorShareHelper;

    public HonorShowWindowController(Environment env) {
        super(env);
    }

    @Override
    public void closeHonorShowWindow() {
        if (this.mHonorShowWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mHonorShowWindow);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026535").put("function_id", "click"));
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026535").put("function_id", "show").put("title_id", String.valueOf(this.mHonorInfo.getId())));
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (abstractWindow == this.mHonorShowWindow) {
            this.mHonorShowWindow = null;
        }
    }

    @Override
    public List<BaseShareChannel> getShareChannels() {
        return ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).getChannelsByPage((ISharePage)this);
    }

    @Override
    public HonorInfo getCurrentHonor() {
        return this.mHonorInfo;
    }

    @Override
    public void onShareClicked(int channelId) {
        if (this.mHonorInfo == null) {
            return;
        }
        int shareId = 0;
        long honorId = this.mHonorInfo.getId();
        switch (channelId) {
            case 5: {
                this.honorShareHelper.shareFacebook(honorId);
                shareId = 1;
                break;
            }
            case 1: {
                this.honorShareHelper.shareLine(honorId, this.mHonorShowWindow.getShareView());
                shareId = 2;
                break;
            }
            case 2: {
                this.honorShareHelper.shareWhatsapp(honorId, this.mHonorShowWindow.getShareView());
                shareId = 3;
                break;
            }
            case 6: {
                this.honorShareHelper.shareMessenger(honorId);
                shareId = 7;
                break;
            }
            case 3: {
                this.honorShareHelper.shareInstagram(honorId, this.mHonorShowWindow.getShareView());
                shareId = 4;
                break;
            }
            case 9: {
                this.honorShareHelper.shareVK(honorId);
                shareId = 6;
                break;
            }
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "9").put("share_channel", String.valueOf(shareId)));
    }

    @Override
    public void onSaveToAlbumClicked() {
        this.honorShareHelper.genImageAndSaveToAlbum(this.mHonorShowWindow.getShareView(), new HonorShareHelper.HelperListener(){

            @Override
            public void onSuccess() {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "9").put("share_channel", String.valueOf("8")));
                TopToastUtils.showSucceedToast((CharSequence)ResourceUtils.getString((int)R.string.saved_to_album_tips), (int)0);
            }

            @Override
            public void onFailed() {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.save_to_album_failed_tips), (int)0);
            }
        });
    }

    public void handleMessage(Message msg) {
        if (msg.what == BaseMsgDef.MSG_SHOW_HONOR_GET && msg.obj instanceof HonorInfo) {
            this.mHonorInfo = (HonorInfo)msg.obj;
            this.showHonorShowWindow();
        }
    }

    private void showHonorShowWindow() {
        if (this.mHonorShowWindow == null) {
            this.mHonorShowWindow = new HonorShowWindow(this.mContext, this, "HonorShowWindow");
        }
        if (this.honorShareHelper == null) {
            this.honorShareHelper = new HonorShareHelper((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class));
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mHonorShowWindow, false);
    }

    public String getPageName() {
        return "honor_show_page";
    }
}

